/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.DynamicOps;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.forge.NBTConverter;
import com.sk89q.worldedit.world.DataFixer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ForgeDataFixer
extends DataFixerBuilder
implements com.sk89q.worldedit.world.DataFixer {
    private static final NBTDynamicOps OPS_NBT = NBTDynamicOps.field_210820_a;
    private static final int LEGACY_VERSION = 1343;
    private static int DATA_VERSION;
    private static ForgeDataFixer INSTANCE;
    private final Map<LegacyType, List<DataConverter>> converters = new EnumMap<LegacyType, List<DataConverter>>(LegacyType.class);
    private final Map<LegacyType, List<DataInspector>> inspectors = new EnumMap<LegacyType, List<DataInspector>>(LegacyType.class);
    private DataFixer fixer;
    private static final Map<String, LegacyType> DFU_TO_LEGACY;
    private static final Map<String, ResourceLocation> OLD_ID_TO_KEY_MAP;

    @Override
    public <T> T fixUp(DataFixer.FixType<T> type, T original, int srcVer) {
        if (type == DataFixer.FixTypes.CHUNK) {
            return (T)this.fixChunk((CompoundTag)original, srcVer);
        }
        if (type == DataFixer.FixTypes.BLOCK_ENTITY) {
            return (T)this.fixBlockEntity((CompoundTag)original, srcVer);
        }
        if (type == DataFixer.FixTypes.ENTITY) {
            return (T)this.fixEntity((CompoundTag)original, srcVer);
        }
        if (type == DataFixer.FixTypes.BLOCK_STATE) {
            return (T)this.fixBlockState((String)original, srcVer);
        }
        if (type == DataFixer.FixTypes.ITEM_TYPE) {
            return (T)this.fixItemType((String)original, srcVer);
        }
        if (type == DataFixer.FixTypes.BIOME) {
            return (T)this.fixBiome((String)original, srcVer);
        }
        return original;
    }

    private CompoundTag fixChunk(CompoundTag originalChunk, int srcVer) {
        CompoundNBT tag = NBTConverter.toNative(originalChunk);
        CompoundNBT fixed = ForgeDataFixer.convert(LegacyType.CHUNK, tag, srcVer);
        return NBTConverter.fromNative(fixed);
    }

    private CompoundTag fixBlockEntity(CompoundTag origTileEnt, int srcVer) {
        CompoundNBT tag = NBTConverter.toNative(origTileEnt);
        CompoundNBT fixed = ForgeDataFixer.convert(LegacyType.BLOCK_ENTITY, tag, srcVer);
        return NBTConverter.fromNative(fixed);
    }

    private CompoundTag fixEntity(CompoundTag origEnt, int srcVer) {
        CompoundNBT tag = NBTConverter.toNative(origEnt);
        CompoundNBT fixed = ForgeDataFixer.convert(LegacyType.ENTITY, tag, srcVer);
        return NBTConverter.fromNative(fixed);
    }

    private String fixBlockState(String blockState, int srcVer) {
        CompoundNBT stateNBT = ForgeDataFixer.stateToNBT(blockState);
        Dynamic dynamic = new Dynamic((DynamicOps)OPS_NBT, (Object)stateNBT);
        CompoundNBT fixed = (CompoundNBT)ForgeDataFixer.INSTANCE.fixer.update(TypeReferences.field_211296_l, dynamic, srcVer, DATA_VERSION).getValue();
        return this.nbtToState(fixed);
    }

    private String nbtToState(CompoundNBT tagCompound) {
        StringBuilder sb = new StringBuilder();
        sb.append(tagCompound.func_74779_i("Name"));
        if (tagCompound.func_150297_b("Properties", 10)) {
            sb.append('[');
            CompoundNBT props = tagCompound.func_74775_l("Properties");
            sb.append(props.func_150296_c().stream().map(k -> k + "=" + props.func_74779_i(k).replace("\"", "")).collect(Collectors.joining(",")));
            sb.append(']');
        }
        return sb.toString();
    }

    private static CompoundNBT stateToNBT(String blockState) {
        int propIdx = blockState.indexOf(91);
        CompoundNBT tag = new CompoundNBT();
        if (propIdx < 0) {
            tag.func_74778_a("Name", blockState);
        } else {
            String[] propArr;
            tag.func_74778_a("Name", blockState.substring(0, propIdx));
            CompoundNBT propTag = new CompoundNBT();
            String props = blockState.substring(propIdx + 1, blockState.length() - 1);
            for (String pair : propArr = props.split(",")) {
                String[] split = pair.split("=");
                propTag.func_74778_a(split[0], split[1]);
            }
            tag.func_218657_a("Properties", (INBT)propTag);
        }
        return tag;
    }

    private String fixBiome(String key, int srcVer) {
        return ForgeDataFixer.fixName(key, srcVer, TypeReferences.field_211305_u);
    }

    private String fixItemType(String key, int srcVer) {
        return ForgeDataFixer.fixName(key, srcVer, TypeReferences.field_211301_q);
    }

    private static String fixName(String key, int srcVer, DSL.TypeReference type) {
        return ForgeDataFixer.INSTANCE.fixer.update(type, new Dynamic((DynamicOps)OPS_NBT, (Object)new StringNBT(key)), srcVer, DATA_VERSION).asString().orElse(key);
    }

    ForgeDataFixer(int dataVersion) {
        super(dataVersion);
        DATA_VERSION = dataVersion;
        INSTANCE = this;
        this.registerConverters();
        this.registerInspectors();
        this.fixer = new WrappedDataFixer(DataFixesManager.func_210901_a());
    }

    public DataFixer build(Executor executor) {
        return this.fixer;
    }

    public static CompoundNBT convert(LegacyType type, CompoundNBT cmp) {
        return ForgeDataFixer.convert(type.getDFUType(), cmp);
    }

    public static CompoundNBT convert(LegacyType type, CompoundNBT cmp, int sourceVer) {
        return ForgeDataFixer.convert(type.getDFUType(), cmp, sourceVer);
    }

    public static CompoundNBT convert(LegacyType type, CompoundNBT cmp, int sourceVer, int targetVer) {
        return ForgeDataFixer.convert(type.getDFUType(), cmp, sourceVer, targetVer);
    }

    public static CompoundNBT convert(DSL.TypeReference type, CompoundNBT cmp) {
        int i = cmp.func_150297_b("DataVersion", 99) ? cmp.func_74762_e("DataVersion") : -1;
        return ForgeDataFixer.convert(type, cmp, i);
    }

    public static CompoundNBT convert(DSL.TypeReference type, CompoundNBT cmp, int sourceVer) {
        return ForgeDataFixer.convert(type, cmp, sourceVer, DATA_VERSION);
    }

    public static CompoundNBT convert(DSL.TypeReference type, CompoundNBT cmp, int sourceVer, int targetVer) {
        if (sourceVer >= targetVer) {
            return cmp;
        }
        return (CompoundNBT)ForgeDataFixer.INSTANCE.fixer.update(type, new Dynamic((DynamicOps)OPS_NBT, (Object)cmp), sourceVer, targetVer).getValue();
    }

    private void registerInspector(LegacyType type, DataInspector inspector) {
        this.inspectors.computeIfAbsent(type, k -> new ArrayList()).add(inspector);
    }

    private void registerConverter(LegacyType type, DataConverter converter) {
        int version = converter.getDataVersion();
        List list = this.converters.computeIfAbsent(type, k -> new ArrayList());
        if (!list.isEmpty() && ((DataConverter)list.get(list.size() - 1)).getDataVersion() > version) {
            for (int j = 0; j < list.size(); ++j) {
                if (((DataConverter)list.get(j)).getDataVersion() <= version) continue;
                list.add(j, converter);
                break;
            }
        } else {
            list.add(converter);
        }
    }

    private void registerInspectors() {
        this.registerEntityItemList("EntityHorseDonkey", "SaddleItem", "Items");
        this.registerEntityItemList("EntityHorseMule", "Items");
        this.registerEntityItemList("EntityMinecartChest", "Items");
        this.registerEntityItemList("EntityMinecartHopper", "Items");
        this.registerEntityItemList("EntityVillager", "Inventory");
        this.registerEntityItemListEquipment("EntityArmorStand");
        this.registerEntityItemListEquipment("EntityBat");
        this.registerEntityItemListEquipment("EntityBlaze");
        this.registerEntityItemListEquipment("EntityCaveSpider");
        this.registerEntityItemListEquipment("EntityChicken");
        this.registerEntityItemListEquipment("EntityCow");
        this.registerEntityItemListEquipment("EntityCreeper");
        this.registerEntityItemListEquipment("EntityEnderDragon");
        this.registerEntityItemListEquipment("EntityEnderman");
        this.registerEntityItemListEquipment("EntityEndermite");
        this.registerEntityItemListEquipment("EntityEvoker");
        this.registerEntityItemListEquipment("EntityGhast");
        this.registerEntityItemListEquipment("EntityGiantZombie");
        this.registerEntityItemListEquipment("EntityGuardian");
        this.registerEntityItemListEquipment("EntityGuardianElder");
        this.registerEntityItemListEquipment("EntityHorse");
        this.registerEntityItemListEquipment("EntityHorseDonkey");
        this.registerEntityItemListEquipment("EntityHorseMule");
        this.registerEntityItemListEquipment("EntityHorseSkeleton");
        this.registerEntityItemListEquipment("EntityHorseZombie");
        this.registerEntityItemListEquipment("EntityIronGolem");
        this.registerEntityItemListEquipment("EntityMagmaCube");
        this.registerEntityItemListEquipment("EntityMushroomCow");
        this.registerEntityItemListEquipment("EntityOcelot");
        this.registerEntityItemListEquipment("EntityPig");
        this.registerEntityItemListEquipment("EntityPigZombie");
        this.registerEntityItemListEquipment("EntityRabbit");
        this.registerEntityItemListEquipment("EntitySheep");
        this.registerEntityItemListEquipment("EntityShulker");
        this.registerEntityItemListEquipment("EntitySilverfish");
        this.registerEntityItemListEquipment("EntitySkeleton");
        this.registerEntityItemListEquipment("EntitySkeletonStray");
        this.registerEntityItemListEquipment("EntitySkeletonWither");
        this.registerEntityItemListEquipment("EntitySlime");
        this.registerEntityItemListEquipment("EntitySnowman");
        this.registerEntityItemListEquipment("EntitySpider");
        this.registerEntityItemListEquipment("EntitySquid");
        this.registerEntityItemListEquipment("EntityVex");
        this.registerEntityItemListEquipment("EntityVillager");
        this.registerEntityItemListEquipment("EntityVindicator");
        this.registerEntityItemListEquipment("EntityWitch");
        this.registerEntityItemListEquipment("EntityWither");
        this.registerEntityItemListEquipment("EntityWolf");
        this.registerEntityItemListEquipment("EntityZombie");
        this.registerEntityItemListEquipment("EntityZombieHusk");
        this.registerEntityItemListEquipment("EntityZombieVillager");
        this.registerEntityItemSingle("EntityFireworks", "FireworksItem");
        this.registerEntityItemSingle("EntityHorse", "ArmorItem");
        this.registerEntityItemSingle("EntityHorse", "SaddleItem");
        this.registerEntityItemSingle("EntityHorseMule", "SaddleItem");
        this.registerEntityItemSingle("EntityHorseSkeleton", "SaddleItem");
        this.registerEntityItemSingle("EntityHorseZombie", "SaddleItem");
        this.registerEntityItemSingle("EntityItem", "Item");
        this.registerEntityItemSingle("EntityItemFrame", "Item");
        this.registerEntityItemSingle("EntityPotion", "Potion");
        this.registerInspector(LegacyType.BLOCK_ENTITY, new DataInspectorItem("TileEntityRecordPlayer", "RecordItem"));
        this.registerInspector(LegacyType.BLOCK_ENTITY, new DataInspectorItemList("TileEntityBrewingStand", "Items"));
        this.registerInspector(LegacyType.BLOCK_ENTITY, new DataInspectorItemList("TileEntityChest", "Items"));
        this.registerInspector(LegacyType.BLOCK_ENTITY, new DataInspectorItemList("TileEntityDispenser", "Items"));
        this.registerInspector(LegacyType.BLOCK_ENTITY, new DataInspectorItemList("TileEntityDropper", "Items"));
        this.registerInspector(LegacyType.BLOCK_ENTITY, new DataInspectorItemList("TileEntityFurnace", "Items"));
        this.registerInspector(LegacyType.BLOCK_ENTITY, new DataInspectorItemList("TileEntityHopper", "Items"));
        this.registerInspector(LegacyType.BLOCK_ENTITY, new DataInspectorItemList("TileEntityShulkerBox", "Items"));
        this.registerInspector(LegacyType.BLOCK_ENTITY, new DataInspectorMobSpawnerMobs());
        this.registerInspector(LegacyType.CHUNK, new DataInspectorChunks());
        this.registerInspector(LegacyType.ENTITY, new DataInspectorCommandBlock());
        this.registerInspector(LegacyType.ENTITY, new DataInspectorEntityPassengers());
        this.registerInspector(LegacyType.ENTITY, new DataInspectorMobSpawnerMinecart());
        this.registerInspector(LegacyType.ENTITY, new DataInspectorVillagers());
        this.registerInspector(LegacyType.ITEM_INSTANCE, new DataInspectorBlockEntity());
        this.registerInspector(LegacyType.ITEM_INSTANCE, new DataInspectorEntity());
        this.registerInspector(LegacyType.LEVEL, new DataInspectorLevelPlayer());
        this.registerInspector(LegacyType.PLAYER, new DataInspectorPlayer());
        this.registerInspector(LegacyType.PLAYER, new DataInspectorPlayerVehicle());
        this.registerInspector(LegacyType.STRUCTURE, new DataInspectorStructure());
    }

    private void registerConverters() {
        this.registerConverter(LegacyType.ENTITY, new DataConverterEquipment());
        this.registerConverter(LegacyType.BLOCK_ENTITY, new DataConverterSignText());
        this.registerConverter(LegacyType.ITEM_INSTANCE, new DataConverterMaterialId());
        this.registerConverter(LegacyType.ITEM_INSTANCE, new DataConverterPotionId());
        this.registerConverter(LegacyType.ITEM_INSTANCE, new DataConverterSpawnEgg());
        this.registerConverter(LegacyType.ENTITY, new DataConverterMinecart());
        this.registerConverter(LegacyType.BLOCK_ENTITY, new DataConverterMobSpawner());
        this.registerConverter(LegacyType.ENTITY, new DataConverterUUID());
        this.registerConverter(LegacyType.ENTITY, new DataConverterHealth());
        this.registerConverter(LegacyType.ENTITY, new DataConverterSaddle());
        this.registerConverter(LegacyType.ENTITY, new DataConverterHanging());
        this.registerConverter(LegacyType.ENTITY, new DataConverterDropChances());
        this.registerConverter(LegacyType.ENTITY, new DataConverterRiding());
        this.registerConverter(LegacyType.ENTITY, new DataConverterArmorStand());
        this.registerConverter(LegacyType.ITEM_INSTANCE, new DataConverterBook());
        this.registerConverter(LegacyType.ITEM_INSTANCE, new DataConverterCookedFish());
        this.registerConverter(LegacyType.ENTITY, new DataConverterZombie());
        this.registerConverter(LegacyType.OPTIONS, new DataConverterVBO());
        this.registerConverter(LegacyType.ENTITY, new DataConverterGuardian());
        this.registerConverter(LegacyType.ENTITY, new DataConverterSkeleton());
        this.registerConverter(LegacyType.ENTITY, new DataConverterZombieType());
        this.registerConverter(LegacyType.ENTITY, new DataConverterHorse());
        this.registerConverter(LegacyType.BLOCK_ENTITY, new DataConverterTileEntity());
        this.registerConverter(LegacyType.ENTITY, new DataConverterEntity());
        this.registerConverter(LegacyType.ITEM_INSTANCE, new DataConverterBanner());
        this.registerConverter(LegacyType.ITEM_INSTANCE, new DataConverterPotionWater());
        this.registerConverter(LegacyType.ENTITY, new DataConverterShulker());
        this.registerConverter(LegacyType.ITEM_INSTANCE, new DataConverterShulkerBoxItem());
        this.registerConverter(LegacyType.BLOCK_ENTITY, new DataConverterShulkerBoxBlock());
        this.registerConverter(LegacyType.OPTIONS, new DataConverterLang());
        this.registerConverter(LegacyType.ITEM_INSTANCE, new DataConverterTotem());
        this.registerConverter(LegacyType.CHUNK, new DataConverterBedBlock());
        this.registerConverter(LegacyType.ITEM_INSTANCE, new DataConverterBedItem());
    }

    private void registerEntityItemList(String type, String ... keys) {
        this.registerInspector(LegacyType.ENTITY, new DataInspectorItemList(type, keys));
    }

    private void registerEntityItemSingle(String type, String key) {
        this.registerInspector(LegacyType.ENTITY, new DataInspectorItem(type, key));
    }

    private void registerEntityItemListEquipment(String type) {
        this.registerEntityItemList(type, "ArmorItems", "HandItems");
    }

    private static ResourceLocation getKey(String type) {
        ResourceLocation key = OLD_ID_TO_KEY_MAP.get(type);
        if (key == null) {
            throw new IllegalArgumentException("Unknown mapping for " + type);
        }
        return key;
    }

    private static void convertCompound(LegacyType type, CompoundNBT cmp, String key, int sourceVer, int targetVer) {
        cmp.func_218657_a(key, (INBT)ForgeDataFixer.convert(type, cmp.func_74775_l(key), sourceVer, targetVer));
    }

    private static void convertItem(CompoundNBT nbttagcompound, String key, int sourceVer, int targetVer) {
        if (nbttagcompound.func_150297_b(key, 10)) {
            ForgeDataFixer.convertCompound(LegacyType.ITEM_INSTANCE, nbttagcompound, key, sourceVer, targetVer);
        }
    }

    private static void convertItems(CompoundNBT nbttagcompound, String key, int sourceVer, int targetVer) {
        if (nbttagcompound.func_150297_b(key, 9)) {
            ListNBT nbttaglist = nbttagcompound.func_150295_c(key, 10);
            for (int j = 0; j < nbttaglist.size(); ++j) {
                nbttaglist.add(j, (INBT)ForgeDataFixer.convert(LegacyType.ITEM_INSTANCE, nbttaglist.func_150305_b(j), sourceVer, targetVer));
            }
        }
    }

    static {
        DFU_TO_LEGACY = new HashMap<String, LegacyType>();
        Map<String, ResourceLocation> map = OLD_ID_TO_KEY_MAP = new HashMap<String, ResourceLocation>();
        map.put("EntityItem", new ResourceLocation("item"));
        map.put("EntityExperienceOrb", new ResourceLocation("xp_orb"));
        map.put("EntityAreaEffectCloud", new ResourceLocation("area_effect_cloud"));
        map.put("EntityGuardianElder", new ResourceLocation("elder_guardian"));
        map.put("EntitySkeletonWither", new ResourceLocation("wither_skeleton"));
        map.put("EntitySkeletonStray", new ResourceLocation("stray"));
        map.put("EntityEgg", new ResourceLocation("egg"));
        map.put("EntityLeash", new ResourceLocation("leash_knot"));
        map.put("EntityPainting", new ResourceLocation("painting"));
        map.put("EntityTippedArrow", new ResourceLocation("arrow"));
        map.put("EntitySnowball", new ResourceLocation("snowball"));
        map.put("EntityLargeFireball", new ResourceLocation("fireball"));
        map.put("EntitySmallFireball", new ResourceLocation("small_fireball"));
        map.put("EntityEnderPearl", new ResourceLocation("ender_pearl"));
        map.put("EntityEnderSignal", new ResourceLocation("eye_of_ender_signal"));
        map.put("EntityPotion", new ResourceLocation("potion"));
        map.put("EntityThrownExpBottle", new ResourceLocation("xp_bottle"));
        map.put("EntityItemFrame", new ResourceLocation("item_frame"));
        map.put("EntityWitherSkull", new ResourceLocation("wither_skull"));
        map.put("EntityTNTPrimed", new ResourceLocation("tnt"));
        map.put("EntityFallingBlock", new ResourceLocation("falling_block"));
        map.put("EntityFireworks", new ResourceLocation("fireworks_rocket"));
        map.put("EntityZombieHusk", new ResourceLocation("husk"));
        map.put("EntitySpectralArrow", new ResourceLocation("spectral_arrow"));
        map.put("EntityShulkerBullet", new ResourceLocation("shulker_bullet"));
        map.put("EntityDragonFireball", new ResourceLocation("dragon_fireball"));
        map.put("EntityZombieVillager", new ResourceLocation("zombie_villager"));
        map.put("EntityHorseSkeleton", new ResourceLocation("skeleton_horse"));
        map.put("EntityHorseZombie", new ResourceLocation("zombie_horse"));
        map.put("EntityArmorStand", new ResourceLocation("armor_stand"));
        map.put("EntityHorseDonkey", new ResourceLocation("donkey"));
        map.put("EntityHorseMule", new ResourceLocation("mule"));
        map.put("EntityEvokerFangs", new ResourceLocation("evocation_fangs"));
        map.put("EntityEvoker", new ResourceLocation("evocation_illager"));
        map.put("EntityVex", new ResourceLocation("vex"));
        map.put("EntityVindicator", new ResourceLocation("vindication_illager"));
        map.put("EntityIllagerIllusioner", new ResourceLocation("illusion_illager"));
        map.put("EntityMinecartCommandBlock", new ResourceLocation("commandblock_minecart"));
        map.put("EntityBoat", new ResourceLocation("boat"));
        map.put("EntityMinecartRideable", new ResourceLocation("minecart"));
        map.put("EntityMinecartChest", new ResourceLocation("chest_minecart"));
        map.put("EntityMinecartFurnace", new ResourceLocation("furnace_minecart"));
        map.put("EntityMinecartTNT", new ResourceLocation("tnt_minecart"));
        map.put("EntityMinecartHopper", new ResourceLocation("hopper_minecart"));
        map.put("EntityMinecartMobSpawner", new ResourceLocation("spawner_minecart"));
        map.put("EntityCreeper", new ResourceLocation("creeper"));
        map.put("EntitySkeleton", new ResourceLocation("skeleton"));
        map.put("EntitySpider", new ResourceLocation("spider"));
        map.put("EntityGiantZombie", new ResourceLocation("giant"));
        map.put("EntityZombie", new ResourceLocation("zombie"));
        map.put("EntitySlime", new ResourceLocation("slime"));
        map.put("EntityGhast", new ResourceLocation("ghast"));
        map.put("EntityPigZombie", new ResourceLocation("zombie_pigman"));
        map.put("EntityEnderman", new ResourceLocation("enderman"));
        map.put("EntityCaveSpider", new ResourceLocation("cave_spider"));
        map.put("EntitySilverfish", new ResourceLocation("silverfish"));
        map.put("EntityBlaze", new ResourceLocation("blaze"));
        map.put("EntityMagmaCube", new ResourceLocation("magma_cube"));
        map.put("EntityEnderDragon", new ResourceLocation("ender_dragon"));
        map.put("EntityWither", new ResourceLocation("wither"));
        map.put("EntityBat", new ResourceLocation("bat"));
        map.put("EntityWitch", new ResourceLocation("witch"));
        map.put("EntityEndermite", new ResourceLocation("endermite"));
        map.put("EntityGuardian", new ResourceLocation("guardian"));
        map.put("EntityShulker", new ResourceLocation("shulker"));
        map.put("EntityPig", new ResourceLocation("pig"));
        map.put("EntitySheep", new ResourceLocation("sheep"));
        map.put("EntityCow", new ResourceLocation("cow"));
        map.put("EntityChicken", new ResourceLocation("chicken"));
        map.put("EntitySquid", new ResourceLocation("squid"));
        map.put("EntityWolf", new ResourceLocation("wolf"));
        map.put("EntityMushroomCow", new ResourceLocation("mooshroom"));
        map.put("EntitySnowman", new ResourceLocation("snowman"));
        map.put("EntityOcelot", new ResourceLocation("ocelot"));
        map.put("EntityIronGolem", new ResourceLocation("villager_golem"));
        map.put("EntityHorse", new ResourceLocation("horse"));
        map.put("EntityRabbit", new ResourceLocation("rabbit"));
        map.put("EntityPolarBear", new ResourceLocation("polar_bear"));
        map.put("EntityLlama", new ResourceLocation("llama"));
        map.put("EntityLlamaSpit", new ResourceLocation("llama_spit"));
        map.put("EntityParrot", new ResourceLocation("parrot"));
        map.put("EntityVillager", new ResourceLocation("villager"));
        map.put("EntityEnderCrystal", new ResourceLocation("ender_crystal"));
        map.put("TileEntityFurnace", new ResourceLocation("furnace"));
        map.put("TileEntityChest", new ResourceLocation("chest"));
        map.put("TileEntityEnderChest", new ResourceLocation("ender_chest"));
        map.put("TileEntityRecordPlayer", new ResourceLocation("jukebox"));
        map.put("TileEntityDispenser", new ResourceLocation("dispenser"));
        map.put("TileEntityDropper", new ResourceLocation("dropper"));
        map.put("TileEntitySign", new ResourceLocation("sign"));
        map.put("TileEntityMobSpawner", new ResourceLocation("mob_spawner"));
        map.put("TileEntityNote", new ResourceLocation("noteblock"));
        map.put("TileEntityPiston", new ResourceLocation("piston"));
        map.put("TileEntityBrewingStand", new ResourceLocation("brewing_stand"));
        map.put("TileEntityEnchantTable", new ResourceLocation("enchanting_table"));
        map.put("TileEntityEnderPortal", new ResourceLocation("end_portal"));
        map.put("TileEntityBeacon", new ResourceLocation("beacon"));
        map.put("TileEntitySkull", new ResourceLocation("skull"));
        map.put("TileEntityLightDetector", new ResourceLocation("daylight_detector"));
        map.put("TileEntityHopper", new ResourceLocation("hopper"));
        map.put("TileEntityComparator", new ResourceLocation("comparator"));
        map.put("TileEntityFlowerPot", new ResourceLocation("flower_pot"));
        map.put("TileEntityBanner", new ResourceLocation("banner"));
        map.put("TileEntityStructure", new ResourceLocation("structure_block"));
        map.put("TileEntityEndGateway", new ResourceLocation("end_gateway"));
        map.put("TileEntityCommand", new ResourceLocation("command_block"));
        map.put("TileEntityShulkerBox", new ResourceLocation("shulker_box"));
        map.put("TileEntityBed", new ResourceLocation("bed"));
    }

    private static class DataInspectorCommandBlock
    implements DataInspector {
        ResourceLocation tileEntityCommand = ForgeDataFixer.access$1400("TileEntityCommand");

        private DataInspectorCommandBlock() {
        }

        @Override
        public CompoundNBT inspect(CompoundNBT cmp, int sourceVer, int targetVer) {
            if (this.tileEntityCommand.equals((Object)new ResourceLocation(cmp.func_74779_i("id")))) {
                cmp.func_74778_a("id", "Control");
                ForgeDataFixer.convert(LegacyType.BLOCK_ENTITY, cmp, sourceVer, targetVer);
                cmp.func_74778_a("id", "MinecartCommandBlock");
            }
            return cmp;
        }
    }

    private static class DataInspectorMobSpawnerMobs
    implements DataInspector {
        ResourceLocation tileEntityMobSpawner = ForgeDataFixer.access$1400("TileEntityMobSpawner");

        private DataInspectorMobSpawnerMobs() {
        }

        @Override
        public CompoundNBT inspect(CompoundNBT cmp, int sourceVer, int targetVer) {
            if (this.tileEntityMobSpawner.equals((Object)new ResourceLocation(cmp.func_74779_i("id")))) {
                if (cmp.func_150297_b("SpawnPotentials", 9)) {
                    ListNBT nbttaglist = cmp.func_150295_c("SpawnPotentials", 10);
                    for (int j = 0; j < nbttaglist.size(); ++j) {
                        CompoundNBT nbttagcompound1 = nbttaglist.func_150305_b(j);
                        ForgeDataFixer.convertCompound(LegacyType.ENTITY, nbttagcompound1, "Entity", sourceVer, targetVer);
                    }
                }
                ForgeDataFixer.convertCompound(LegacyType.ENTITY, cmp, "SpawnData", sourceVer, targetVer);
            }
            return cmp;
        }
    }

    private static class DataInspectorMobSpawnerMinecart
    implements DataInspector {
        ResourceLocation entityMinecartMobSpawner = ForgeDataFixer.access$1400("EntityMinecartMobSpawner");
        ResourceLocation tileEntityMobSpawner = ForgeDataFixer.access$1400("TileEntityMobSpawner");

        private DataInspectorMobSpawnerMinecart() {
        }

        @Override
        public CompoundNBT inspect(CompoundNBT cmp, int sourceVer, int targetVer) {
            String s = cmp.func_74779_i("id");
            if (this.entityMinecartMobSpawner.equals((Object)new ResourceLocation(s))) {
                cmp.func_74778_a("id", this.tileEntityMobSpawner.toString());
                ForgeDataFixer.convert(LegacyType.BLOCK_ENTITY, cmp, sourceVer, targetVer);
                cmp.func_74778_a("id", s);
            }
            return cmp;
        }
    }

    private static class DataInspectorVillagers
    implements DataInspector {
        ResourceLocation entityVillager = ForgeDataFixer.access$1400("EntityVillager");

        private DataInspectorVillagers() {
        }

        @Override
        public CompoundNBT inspect(CompoundNBT cmp, int sourceVer, int targetVer) {
            CompoundNBT nbttagcompound1;
            if (this.entityVillager.equals((Object)new ResourceLocation(cmp.func_74779_i("id"))) && cmp.func_150297_b("Offers", 10) && (nbttagcompound1 = cmp.func_74775_l("Offers")).func_150297_b("Recipes", 9)) {
                ListNBT nbttaglist = nbttagcompound1.func_150295_c("Recipes", 10);
                for (int j = 0; j < nbttaglist.size(); ++j) {
                    CompoundNBT nbttagcompound2 = nbttaglist.func_150305_b(j);
                    ForgeDataFixer.convertItem(nbttagcompound2, "buy", sourceVer, targetVer);
                    ForgeDataFixer.convertItem(nbttagcompound2, "buyB", sourceVer, targetVer);
                    ForgeDataFixer.convertItem(nbttagcompound2, "sell", sourceVer, targetVer);
                    nbttaglist.set(j, (INBT)nbttagcompound2);
                }
            }
            return cmp;
        }
    }

    private static class DataInspectorPlayer
    implements DataInspector {
        private DataInspectorPlayer() {
        }

        @Override
        public CompoundNBT inspect(CompoundNBT cmp, int sourceVer, int targetVer) {
            ForgeDataFixer.convertItems(cmp, "Inventory", sourceVer, targetVer);
            ForgeDataFixer.convertItems(cmp, "EnderItems", sourceVer, targetVer);
            if (cmp.func_150297_b("ShoulderEntityLeft", 10)) {
                ForgeDataFixer.convertCompound(LegacyType.ENTITY, cmp, "ShoulderEntityLeft", sourceVer, targetVer);
            }
            if (cmp.func_150297_b("ShoulderEntityRight", 10)) {
                ForgeDataFixer.convertCompound(LegacyType.ENTITY, cmp, "ShoulderEntityRight", sourceVer, targetVer);
            }
            return cmp;
        }
    }

    private static class DataInspectorEntityPassengers
    implements DataInspector {
        private DataInspectorEntityPassengers() {
        }

        @Override
        public CompoundNBT inspect(CompoundNBT cmp, int sourceVer, int targetVer) {
            if (cmp.func_150297_b("Passengers", 9)) {
                ListNBT nbttaglist = cmp.func_150295_c("Passengers", 10);
                for (int j = 0; j < nbttaglist.size(); ++j) {
                    nbttaglist.set(j, (INBT)ForgeDataFixer.convert(LegacyType.ENTITY, nbttaglist.func_150305_b(j), sourceVer, targetVer));
                }
            }
            return cmp;
        }
    }

    private static class DataInspectorChunks
    implements DataInspector {
        private DataInspectorChunks() {
        }

        @Override
        public CompoundNBT inspect(CompoundNBT cmp, int sourceVer, int targetVer) {
            if (cmp.func_150297_b("Level", 10)) {
                int j;
                ListNBT nbttaglist;
                CompoundNBT nbttagcompound1 = cmp.func_74775_l("Level");
                if (nbttagcompound1.func_150297_b("Entities", 9)) {
                    nbttaglist = nbttagcompound1.func_150295_c("Entities", 10);
                    for (j = 0; j < nbttaglist.size(); ++j) {
                        nbttaglist.set(j, (INBT)ForgeDataFixer.convert(LegacyType.ENTITY, (CompoundNBT)nbttaglist.get(j), sourceVer, targetVer));
                    }
                }
                if (nbttagcompound1.func_150297_b("TileEntities", 9)) {
                    nbttaglist = nbttagcompound1.func_150295_c("TileEntities", 10);
                    for (j = 0; j < nbttaglist.size(); ++j) {
                        nbttaglist.set(j, (INBT)ForgeDataFixer.convert(LegacyType.BLOCK_ENTITY, (CompoundNBT)nbttaglist.get(j), sourceVer, targetVer));
                    }
                }
            }
            return cmp;
        }
    }

    private static class DataInspectorStructure
    implements DataInspector {
        private DataInspectorStructure() {
        }

        @Override
        public CompoundNBT inspect(CompoundNBT cmp, int sourceVer, int targetVer) {
            CompoundNBT nbttagcompound1;
            int j;
            ListNBT nbttaglist;
            if (cmp.func_150297_b("entities", 9)) {
                nbttaglist = cmp.func_150295_c("entities", 10);
                for (j = 0; j < nbttaglist.size(); ++j) {
                    nbttagcompound1 = (CompoundNBT)nbttaglist.get(j);
                    if (!nbttagcompound1.func_150297_b("nbt", 10)) continue;
                    ForgeDataFixer.convertCompound(LegacyType.ENTITY, nbttagcompound1, "nbt", sourceVer, targetVer);
                }
            }
            if (cmp.func_150297_b("blocks", 9)) {
                nbttaglist = cmp.func_150295_c("blocks", 10);
                for (j = 0; j < nbttaglist.size(); ++j) {
                    nbttagcompound1 = (CompoundNBT)nbttaglist.get(j);
                    if (!nbttagcompound1.func_150297_b("nbt", 10)) continue;
                    ForgeDataFixer.convertCompound(LegacyType.BLOCK_ENTITY, nbttagcompound1, "nbt", sourceVer, targetVer);
                }
            }
            return cmp;
        }
    }

    private static class DataInspectorLevelPlayer
    implements DataInspector {
        private DataInspectorLevelPlayer() {
        }

        @Override
        public CompoundNBT inspect(CompoundNBT cmp, int sourceVer, int targetVer) {
            if (cmp.func_150297_b("Player", 10)) {
                ForgeDataFixer.convertCompound(LegacyType.PLAYER, cmp, "Player", sourceVer, targetVer);
            }
            return cmp;
        }
    }

    private static class DataInspectorPlayerVehicle
    implements DataInspector {
        private DataInspectorPlayerVehicle() {
        }

        @Override
        public CompoundNBT inspect(CompoundNBT cmp, int sourceVer, int targetVer) {
            CompoundNBT nbttagcompound1;
            if (cmp.func_150297_b("RootVehicle", 10) && (nbttagcompound1 = cmp.func_74775_l("RootVehicle")).func_150297_b("Entity", 10)) {
                ForgeDataFixer.convertCompound(LegacyType.ENTITY, nbttagcompound1, "Entity", sourceVer, targetVer);
            }
            return cmp;
        }
    }

    private static class DataConverterSignText
    implements DataConverter {
        public static final Gson a = new GsonBuilder().registerTypeAdapter(ITextComponent.class, (Object)new JsonDeserializer(){

            ITextComponent a(JsonElement jsonelement, Type type, JsonDeserializationContext jsondeserializationcontext) throws JsonParseException {
                if (jsonelement.isJsonPrimitive()) {
                    return new StringTextComponent(jsonelement.getAsString());
                }
                if (jsonelement.isJsonArray()) {
                    JsonArray jsonarray = jsonelement.getAsJsonArray();
                    ITextComponent iTextComponent = null;
                    for (JsonElement jsonelement1 : jsonarray) {
                        ITextComponent iTextComponent1 = this.a(jsonelement1, jsonelement1.getClass(), jsondeserializationcontext);
                        if (iTextComponent == null) {
                            iTextComponent = iTextComponent1;
                            continue;
                        }
                        iTextComponent.func_150257_a(iTextComponent1);
                    }
                    return iTextComponent;
                }
                throw new JsonParseException("Don't know how to turn " + jsonelement + " into a Component");
            }

            public Object deserialize(JsonElement jsonelement, Type type, JsonDeserializationContext jsondeserializationcontext) throws JsonParseException {
                return this.a(jsonelement, type, jsondeserializationcontext);
            }
        }).create();

        DataConverterSignText() {
        }

        @Override
        public int getDataVersion() {
            return 101;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            if ("Sign".equals(cmp.func_74779_i("id"))) {
                this.convert(cmp, "Text1");
                this.convert(cmp, "Text2");
                this.convert(cmp, "Text3");
                this.convert(cmp, "Text4");
            }
            return cmp;
        }

        private void convert(CompoundNBT nbttagcompound, String s) {
            String s1 = nbttagcompound.func_74779_i(s);
            Object object = null;
            if (!"null".equals(s1) && !StringUtils.func_151246_b((String)s1)) {
                if (!(s1.charAt(0) == '\"' && s1.charAt(s1.length() - 1) == '\"' || s1.charAt(0) == '{' && s1.charAt(s1.length() - 1) == '}')) {
                    object = new StringTextComponent(s1);
                } else {
                    try {
                        object = JSONUtils.func_188176_a((Gson)a, (String)s1, ITextComponent.class, (boolean)true);
                        if (object == null) {
                            object = new StringTextComponent("");
                        }
                    }
                    catch (JsonParseException jsonParseException) {
                        // empty catch block
                    }
                    if (object == null) {
                        try {
                            object = ITextComponent.Serializer.func_150699_a((String)s1);
                        }
                        catch (JsonParseException jsonParseException) {
                            // empty catch block
                        }
                    }
                    if (object == null) {
                        try {
                            object = ITextComponent.Serializer.func_186877_b((String)s1);
                        }
                        catch (JsonParseException jsonParseException) {
                            // empty catch block
                        }
                    }
                    if (object == null) {
                        object = new StringTextComponent(s1);
                    }
                }
            } else {
                object = new StringTextComponent("");
            }
            nbttagcompound.func_74778_a(s, ITextComponent.Serializer.func_150696_a((ITextComponent)((ITextComponent)object)));
        }
    }

    private static class DataConverterBedItem
    implements DataConverter {
        DataConverterBedItem() {
        }

        @Override
        public int getDataVersion() {
            return 1125;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            if ("minecraft:bed".equals(cmp.func_74779_i("id")) && cmp.func_74765_d("Damage") == 0) {
                cmp.func_74777_a("Damage", (short)DyeColor.RED.func_196059_a());
            }
            return cmp;
        }
    }

    private static class DataConverterBedBlock
    implements DataConverter {
        private static final Logger a = LogManager.getLogger(ForgeDataFixer.class);

        DataConverterBedBlock() {
        }

        @Override
        public int getDataVersion() {
            return 1125;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            boolean flag = true;
            try {
                CompoundNBT nbttagcompound1 = cmp.func_74775_l("Level");
                int i = nbttagcompound1.func_74762_e("xPos");
                int j = nbttagcompound1.func_74762_e("zPos");
                ListNBT nbttaglist = nbttagcompound1.func_150295_c("TileEntities", 10);
                ListNBT nbttaglist1 = nbttagcompound1.func_150295_c("Sections", 10);
                for (int k = 0; k < nbttaglist1.size(); ++k) {
                    CompoundNBT nbttagcompound2 = nbttaglist1.func_150305_b(k);
                    byte b0 = nbttagcompound2.func_74771_c("Y");
                    byte[] abyte = nbttagcompound2.func_74770_j("Blocks");
                    for (int l = 0; l < abyte.length; ++l) {
                        if (416 != (abyte[l] & 0xFF) << 4) continue;
                        int i1 = l & 0xF;
                        int j1 = l >> 8 & 0xF;
                        int k1 = l >> 4 & 0xF;
                        CompoundNBT nbttagcompound3 = new CompoundNBT();
                        nbttagcompound3.func_74778_a("id", "bed");
                        nbttagcompound3.func_74768_a("x", i1 + (i << 4));
                        nbttagcompound3.func_74768_a("y", j1 + (b0 << 4));
                        nbttagcompound3.func_74768_a("z", k1 + (j << 4));
                        nbttaglist.add((Object)nbttagcompound3);
                    }
                }
            }
            catch (Exception exception) {
                a.warn("Unable to datafix Bed blocks, level format may be missing tags.");
            }
            return cmp;
        }
    }

    private static class DataConverterTotem
    implements DataConverter {
        DataConverterTotem() {
        }

        @Override
        public int getDataVersion() {
            return 820;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            if ("minecraft:totem".equals(cmp.func_74779_i("id"))) {
                cmp.func_74778_a("id", "minecraft:totem_of_undying");
            }
            return cmp;
        }
    }

    private static class DataConverterLang
    implements DataConverter {
        DataConverterLang() {
        }

        @Override
        public int getDataVersion() {
            return 816;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            if (cmp.func_150297_b("lang", 8)) {
                cmp.func_74778_a("lang", cmp.func_74779_i("lang").toLowerCase(Locale.ROOT));
            }
            return cmp;
        }
    }

    private static class DataConverterShulkerBoxBlock
    implements DataConverter {
        DataConverterShulkerBoxBlock() {
        }

        @Override
        public int getDataVersion() {
            return 813;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            if ("minecraft:shulker".equals(cmp.func_74779_i("id"))) {
                cmp.func_82580_o("Color");
            }
            return cmp;
        }
    }

    private static class DataConverterShulkerBoxItem
    implements DataConverter {
        public static final String[] a = new String[]{"minecraft:white_shulker_box", "minecraft:orange_shulker_box", "minecraft:magenta_shulker_box", "minecraft:light_blue_shulker_box", "minecraft:yellow_shulker_box", "minecraft:lime_shulker_box", "minecraft:pink_shulker_box", "minecraft:gray_shulker_box", "minecraft:silver_shulker_box", "minecraft:cyan_shulker_box", "minecraft:purple_shulker_box", "minecraft:blue_shulker_box", "minecraft:brown_shulker_box", "minecraft:green_shulker_box", "minecraft:red_shulker_box", "minecraft:black_shulker_box"};

        DataConverterShulkerBoxItem() {
        }

        @Override
        public int getDataVersion() {
            return 813;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            CompoundNBT nbttagcompound1;
            if ("minecraft:shulker_box".equals(cmp.func_74779_i("id")) && cmp.func_150297_b("tag", 10) && (nbttagcompound1 = cmp.func_74775_l("tag")).func_150297_b("BlockEntityTag", 10)) {
                CompoundNBT nbttagcompound2 = nbttagcompound1.func_74775_l("BlockEntityTag");
                if (nbttagcompound2.func_150295_c("Items", 10).isEmpty()) {
                    nbttagcompound2.func_82580_o("Items");
                }
                int i = nbttagcompound2.func_74762_e("Color");
                nbttagcompound2.func_82580_o("Color");
                if (nbttagcompound2.isEmpty()) {
                    nbttagcompound1.func_82580_o("BlockEntityTag");
                }
                if (nbttagcompound1.isEmpty()) {
                    cmp.func_82580_o("tag");
                }
                cmp.func_74778_a("id", a[i % 16]);
            }
            return cmp;
        }
    }

    private static class DataConverterShulker
    implements DataConverter {
        DataConverterShulker() {
        }

        @Override
        public int getDataVersion() {
            return 808;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            if ("minecraft:shulker".equals(cmp.func_74779_i("id")) && !cmp.func_150297_b("Color", 99)) {
                cmp.func_74774_a("Color", (byte)10);
            }
            return cmp;
        }
    }

    private static class DataConverterPotionWater
    implements DataConverter {
        DataConverterPotionWater() {
        }

        @Override
        public int getDataVersion() {
            return 806;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            String s = cmp.func_74779_i("id");
            if ("minecraft:potion".equals(s) || "minecraft:splash_potion".equals(s) || "minecraft:lingering_potion".equals(s) || "minecraft:tipped_arrow".equals(s)) {
                CompoundNBT nbttagcompound1 = cmp.func_74775_l("tag");
                if (!nbttagcompound1.func_150297_b("Potion", 8)) {
                    nbttagcompound1.func_74778_a("Potion", "minecraft:water");
                }
                if (!cmp.func_150297_b("tag", 10)) {
                    cmp.func_218657_a("tag", (INBT)nbttagcompound1);
                }
            }
            return cmp;
        }
    }

    private static class DataConverterEntity
    implements DataConverter {
        private static final Map<String, String> a = Maps.newHashMap();

        DataConverterEntity() {
        }

        @Override
        public int getDataVersion() {
            return 704;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            String s = a.get(cmp.func_74779_i("id"));
            if (s != null) {
                cmp.func_74778_a("id", s);
            }
            return cmp;
        }

        static {
            a.put("AreaEffectCloud", "minecraft:area_effect_cloud");
            a.put("ArmorStand", "minecraft:armor_stand");
            a.put("Arrow", "minecraft:arrow");
            a.put("Bat", "minecraft:bat");
            a.put("Blaze", "minecraft:blaze");
            a.put("Boat", "minecraft:boat");
            a.put("CaveSpider", "minecraft:cave_spider");
            a.put("Chicken", "minecraft:chicken");
            a.put("Cow", "minecraft:cow");
            a.put("Creeper", "minecraft:creeper");
            a.put("Donkey", "minecraft:donkey");
            a.put("DragonFireball", "minecraft:dragon_fireball");
            a.put("ElderGuardian", "minecraft:elder_guardian");
            a.put("EnderCrystal", "minecraft:ender_crystal");
            a.put("EnderDragon", "minecraft:ender_dragon");
            a.put("Enderman", "minecraft:enderman");
            a.put("Endermite", "minecraft:endermite");
            a.put("EyeOfEnderSignal", "minecraft:eye_of_ender_signal");
            a.put("FallingSand", "minecraft:falling_block");
            a.put("Fireball", "minecraft:fireball");
            a.put("FireworksRocketEntity", "minecraft:fireworks_rocket");
            a.put("Ghast", "minecraft:ghast");
            a.put("Giant", "minecraft:giant");
            a.put("Guardian", "minecraft:guardian");
            a.put("Horse", "minecraft:horse");
            a.put("Husk", "minecraft:husk");
            a.put("Item", "minecraft:item");
            a.put("ItemFrame", "minecraft:item_frame");
            a.put("LavaSlime", "minecraft:magma_cube");
            a.put("LeashKnot", "minecraft:leash_knot");
            a.put("MinecartChest", "minecraft:chest_minecart");
            a.put("MinecartCommandBlock", "minecraft:commandblock_minecart");
            a.put("MinecartFurnace", "minecraft:furnace_minecart");
            a.put("MinecartHopper", "minecraft:hopper_minecart");
            a.put("MinecartRideable", "minecraft:minecart");
            a.put("MinecartSpawner", "minecraft:spawner_minecart");
            a.put("MinecartTNT", "minecraft:tnt_minecart");
            a.put("Mule", "minecraft:mule");
            a.put("MushroomCow", "minecraft:mooshroom");
            a.put("Ozelot", "minecraft:ocelot");
            a.put("Painting", "minecraft:painting");
            a.put("Pig", "minecraft:pig");
            a.put("PigZombie", "minecraft:zombie_pigman");
            a.put("PolarBear", "minecraft:polar_bear");
            a.put("PrimedTnt", "minecraft:tnt");
            a.put("Rabbit", "minecraft:rabbit");
            a.put("Sheep", "minecraft:sheep");
            a.put("Shulker", "minecraft:shulker");
            a.put("ShulkerBullet", "minecraft:shulker_bullet");
            a.put("Silverfish", "minecraft:silverfish");
            a.put("Skeleton", "minecraft:skeleton");
            a.put("SkeletonHorse", "minecraft:skeleton_horse");
            a.put("Slime", "minecraft:slime");
            a.put("SmallFireball", "minecraft:small_fireball");
            a.put("SnowMan", "minecraft:snowman");
            a.put("Snowball", "minecraft:snowball");
            a.put("SpectralArrow", "minecraft:spectral_arrow");
            a.put("Spider", "minecraft:spider");
            a.put("Squid", "minecraft:squid");
            a.put("Stray", "minecraft:stray");
            a.put("ThrownEgg", "minecraft:egg");
            a.put("ThrownEnderpearl", "minecraft:ender_pearl");
            a.put("ThrownExpBottle", "minecraft:xp_bottle");
            a.put("ThrownPotion", "minecraft:potion");
            a.put("Villager", "minecraft:villager");
            a.put("VillagerGolem", "minecraft:villager_golem");
            a.put("Witch", "minecraft:witch");
            a.put("WitherBoss", "minecraft:wither");
            a.put("WitherSkeleton", "minecraft:wither_skeleton");
            a.put("WitherSkull", "minecraft:wither_skull");
            a.put("Wolf", "minecraft:wolf");
            a.put("XPOrb", "minecraft:xp_orb");
            a.put("Zombie", "minecraft:zombie");
            a.put("ZombieHorse", "minecraft:zombie_horse");
            a.put("ZombieVillager", "minecraft:zombie_villager");
        }
    }

    private static class DataConverterTileEntity
    implements DataConverter {
        private static final Map<String, String> a = Maps.newHashMap();

        DataConverterTileEntity() {
        }

        @Override
        public int getDataVersion() {
            return 704;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            String s = a.get(cmp.func_74779_i("id"));
            if (s != null) {
                cmp.func_74778_a("id", s);
            }
            return cmp;
        }

        static {
            a.put("Airportal", "minecraft:end_portal");
            a.put("Banner", "minecraft:banner");
            a.put("Beacon", "minecraft:beacon");
            a.put("Cauldron", "minecraft:brewing_stand");
            a.put("Chest", "minecraft:chest");
            a.put("Comparator", "minecraft:comparator");
            a.put("Control", "minecraft:command_block");
            a.put("DLDetector", "minecraft:daylight_detector");
            a.put("Dropper", "minecraft:dropper");
            a.put("EnchantTable", "minecraft:enchanting_table");
            a.put("EndGateway", "minecraft:end_gateway");
            a.put("EnderChest", "minecraft:ender_chest");
            a.put("FlowerPot", "minecraft:flower_pot");
            a.put("Furnace", "minecraft:furnace");
            a.put("Hopper", "minecraft:hopper");
            a.put("MobSpawner", "minecraft:mob_spawner");
            a.put("Music", "minecraft:noteblock");
            a.put("Piston", "minecraft:piston");
            a.put("RecordPlayer", "minecraft:jukebox");
            a.put("Sign", "minecraft:sign");
            a.put("Skull", "minecraft:skull");
            a.put("Structure", "minecraft:structure_block");
            a.put("Trap", "minecraft:dispenser");
        }
    }

    private static class DataConverterHorse
    implements DataConverter {
        DataConverterHorse() {
        }

        @Override
        public int getDataVersion() {
            return 703;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            if ("EntityHorse".equals(cmp.func_74779_i("id"))) {
                int i = cmp.func_74762_e("Type");
                switch (i) {
                    case 1: {
                        cmp.func_74778_a("id", "Donkey");
                        break;
                    }
                    case 2: {
                        cmp.func_74778_a("id", "Mule");
                        break;
                    }
                    case 3: {
                        cmp.func_74778_a("id", "ZombieHorse");
                        break;
                    }
                    case 4: {
                        cmp.func_74778_a("id", "SkeletonHorse");
                        break;
                    }
                    default: {
                        cmp.func_74778_a("id", "Horse");
                    }
                }
                cmp.func_82580_o("Type");
            }
            return cmp;
        }
    }

    private static class DataConverterZombieType
    implements DataConverter {
        DataConverterZombieType() {
        }

        @Override
        public int getDataVersion() {
            return 702;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            if ("Zombie".equals(cmp.func_74779_i("id"))) {
                int i = cmp.func_74762_e("ZombieType");
                switch (i) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        cmp.func_74778_a("id", "ZombieVillager");
                        cmp.func_74768_a("Profession", i - 1);
                        break;
                    }
                    case 6: {
                        cmp.func_74778_a("id", "Husk");
                    }
                }
                cmp.func_82580_o("ZombieType");
            }
            return cmp;
        }
    }

    private static class DataConverterSkeleton
    implements DataConverter {
        DataConverterSkeleton() {
        }

        @Override
        public int getDataVersion() {
            return 701;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            String s = cmp.func_74779_i("id");
            if ("Skeleton".equals(s)) {
                int i = cmp.func_74762_e("SkeletonType");
                if (i == 1) {
                    cmp.func_74778_a("id", "WitherSkeleton");
                } else if (i == 2) {
                    cmp.func_74778_a("id", "Stray");
                }
                cmp.func_82580_o("SkeletonType");
            }
            return cmp;
        }
    }

    private static class DataConverterGuardian
    implements DataConverter {
        DataConverterGuardian() {
        }

        @Override
        public int getDataVersion() {
            return 700;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            if ("Guardian".equals(cmp.func_74779_i("id"))) {
                if (cmp.func_74767_n("Elder")) {
                    cmp.func_74778_a("id", "ElderGuardian");
                }
                cmp.func_82580_o("Elder");
            }
            return cmp;
        }
    }

    private static class DataConverterVBO
    implements DataConverter {
        DataConverterVBO() {
        }

        @Override
        public int getDataVersion() {
            return 505;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            cmp.func_74778_a("useVbo", "true");
            return cmp;
        }
    }

    private static class DataConverterZombie
    implements DataConverter {
        private static final Random a = new Random();

        DataConverterZombie() {
        }

        @Override
        public int getDataVersion() {
            return 502;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            if ("Zombie".equals(cmp.func_74779_i("id")) && cmp.func_74767_n("IsVillager")) {
                if (!cmp.func_150297_b("ZombieType", 99)) {
                    int i = -1;
                    if (cmp.func_150297_b("VillagerProfession", 99)) {
                        try {
                            i = this.convert(cmp.func_74762_e("VillagerProfession"));
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                    if (i == -1) {
                        i = this.convert(a.nextInt(6));
                    }
                    cmp.func_74768_a("ZombieType", i);
                }
                cmp.func_82580_o("IsVillager");
            }
            return cmp;
        }

        private int convert(int i) {
            return i >= 0 && i < 6 ? i : -1;
        }
    }

    private static class DataConverterCookedFish
    implements DataConverter {
        private static final ResourceLocation a = new ResourceLocation("cooked_fished");

        DataConverterCookedFish() {
        }

        @Override
        public int getDataVersion() {
            return 502;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            if (cmp.func_150297_b("id", 8) && a.equals((Object)new ResourceLocation(cmp.func_74779_i("id")))) {
                cmp.func_74778_a("id", "minecraft:cooked_fish");
            }
            return cmp;
        }
    }

    private static class DataConverterBook
    implements DataConverter {
        DataConverterBook() {
        }

        @Override
        public int getDataVersion() {
            return 165;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            CompoundNBT nbttagcompound1;
            if ("minecraft:written_book".equals(cmp.func_74779_i("id")) && (nbttagcompound1 = cmp.func_74775_l("tag")).func_150297_b("pages", 9)) {
                ListNBT nbttaglist = nbttagcompound1.func_150295_c("pages", 8);
                for (int i = 0; i < nbttaglist.size(); ++i) {
                    String s = nbttaglist.func_150307_f(i);
                    Object object = null;
                    if (!"null".equals(s) && !StringUtils.func_151246_b((String)s)) {
                        if (!(s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"' || s.charAt(0) == '{' && s.charAt(s.length() - 1) == '}')) {
                            object = new StringTextComponent(s);
                        } else {
                            try {
                                object = JSONUtils.func_188176_a((Gson)DataConverterSignText.a, (String)s, ITextComponent.class, (boolean)true);
                                if (object == null) {
                                    object = new StringTextComponent("");
                                }
                            }
                            catch (JsonParseException jsonParseException) {
                                // empty catch block
                            }
                            if (object == null) {
                                try {
                                    object = ITextComponent.Serializer.func_150699_a((String)s);
                                }
                                catch (JsonParseException jsonParseException) {
                                    // empty catch block
                                }
                            }
                            if (object == null) {
                                try {
                                    object = ITextComponent.Serializer.func_186877_b((String)s);
                                }
                                catch (JsonParseException jsonParseException) {
                                    // empty catch block
                                }
                            }
                            if (object == null) {
                                object = new StringTextComponent(s);
                            }
                        }
                    } else {
                        object = new StringTextComponent("");
                    }
                    nbttaglist.set(i, (INBT)new StringNBT(ITextComponent.Serializer.func_150696_a((ITextComponent)((ITextComponent)object))));
                }
                nbttagcompound1.func_218657_a("pages", (INBT)nbttaglist);
            }
            return cmp;
        }
    }

    private static class DataConverterRiding
    implements DataConverter {
        DataConverterRiding() {
        }

        @Override
        public int getDataVersion() {
            return 135;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            while (cmp.func_150297_b("Riding", 10)) {
                CompoundNBT nbttagcompound1 = this.b(cmp);
                this.convert(cmp, nbttagcompound1);
                cmp = nbttagcompound1;
            }
            return cmp;
        }

        protected void convert(CompoundNBT nbttagcompound, CompoundNBT nbttagcompound1) {
            ListNBT nbttaglist = new ListNBT();
            nbttaglist.add((Object)nbttagcompound);
            nbttagcompound1.func_218657_a("Passengers", (INBT)nbttaglist);
        }

        protected CompoundNBT b(CompoundNBT nbttagcompound) {
            CompoundNBT nbttagcompound1 = nbttagcompound.func_74775_l("Riding");
            nbttagcompound.func_82580_o("Riding");
            return nbttagcompound1;
        }
    }

    private static class DataConverterDropChances
    implements DataConverter {
        DataConverterDropChances() {
        }

        @Override
        public int getDataVersion() {
            return 113;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            ListNBT nbttaglist;
            if (cmp.func_150297_b("HandDropChances", 9) && (nbttaglist = cmp.func_150295_c("HandDropChances", 5)).size() == 2 && nbttaglist.func_150308_e(0) == 0.0f && nbttaglist.func_150308_e(1) == 0.0f) {
                cmp.func_82580_o("HandDropChances");
            }
            if (cmp.func_150297_b("ArmorDropChances", 9) && (nbttaglist = cmp.func_150295_c("ArmorDropChances", 5)).size() == 4 && nbttaglist.func_150308_e(0) == 0.0f && nbttaglist.func_150308_e(1) == 0.0f && nbttaglist.func_150308_e(2) == 0.0f && nbttaglist.func_150308_e(3) == 0.0f) {
                cmp.func_82580_o("ArmorDropChances");
            }
            return cmp;
        }
    }

    private static class DataConverterHanging
    implements DataConverter {
        DataConverterHanging() {
        }

        @Override
        public int getDataVersion() {
            return 111;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            String s = cmp.func_74779_i("id");
            boolean flag = "Painting".equals(s);
            boolean flag1 = "ItemFrame".equals(s);
            if ((flag || flag1) && !cmp.func_150297_b("Facing", 99)) {
                Direction enumdirection;
                if (cmp.func_150297_b("Direction", 99)) {
                    enumdirection = Direction.func_176731_b((int)cmp.func_74771_c("Direction"));
                    cmp.func_74768_a("TileX", cmp.func_74762_e("TileX") + enumdirection.func_82601_c());
                    cmp.func_74768_a("TileY", cmp.func_74762_e("TileY") + enumdirection.func_96559_d());
                    cmp.func_74768_a("TileZ", cmp.func_74762_e("TileZ") + enumdirection.func_82599_e());
                    cmp.func_82580_o("Direction");
                    if (flag1 && cmp.func_150297_b("ItemRotation", 99)) {
                        cmp.func_74774_a("ItemRotation", (byte)(cmp.func_74771_c("ItemRotation") * 2));
                    }
                } else {
                    enumdirection = Direction.func_176731_b((int)cmp.func_74771_c("Dir"));
                    cmp.func_82580_o("Dir");
                }
                cmp.func_74774_a("Facing", (byte)enumdirection.func_176736_b());
            }
            return cmp;
        }
    }

    private static class DataConverterSaddle
    implements DataConverter {
        DataConverterSaddle() {
        }

        @Override
        public int getDataVersion() {
            return 110;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            if ("EntityHorse".equals(cmp.func_74779_i("id")) && !cmp.func_150297_b("SaddleItem", 10) && cmp.func_74767_n("Saddle")) {
                CompoundNBT nbttagcompound1 = new CompoundNBT();
                nbttagcompound1.func_74778_a("id", "minecraft:saddle");
                nbttagcompound1.func_74774_a("Count", (byte)1);
                nbttagcompound1.func_74777_a("Damage", (short)0);
                cmp.func_218657_a("SaddleItem", (INBT)nbttagcompound1);
                cmp.func_82580_o("Saddle");
            }
            return cmp;
        }
    }

    private static class DataConverterHealth
    implements DataConverter {
        private static final Set<String> a = Sets.newHashSet((Object[])new String[]{"ArmorStand", "Bat", "Blaze", "CaveSpider", "Chicken", "Cow", "Creeper", "EnderDragon", "Enderman", "Endermite", "EntityHorse", "Ghast", "Giant", "Guardian", "LavaSlime", "MushroomCow", "Ozelot", "Pig", "PigZombie", "Rabbit", "Sheep", "Shulker", "Silverfish", "Skeleton", "Slime", "SnowMan", "Spider", "Squid", "Villager", "VillagerGolem", "Witch", "WitherBoss", "Wolf", "Zombie"});

        DataConverterHealth() {
        }

        @Override
        public int getDataVersion() {
            return 109;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            if (a.contains(cmp.func_74779_i("id"))) {
                float f;
                if (cmp.func_150297_b("HealF", 99)) {
                    f = cmp.func_74760_g("HealF");
                    cmp.func_82580_o("HealF");
                } else {
                    if (!cmp.func_150297_b("Health", 99)) {
                        return cmp;
                    }
                    f = cmp.func_74760_g("Health");
                }
                cmp.func_74776_a("Health", f);
            }
            return cmp;
        }
    }

    private static class DataConverterUUID
    implements DataConverter {
        DataConverterUUID() {
        }

        @Override
        public int getDataVersion() {
            return 108;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            if (cmp.func_150297_b("UUID", 8)) {
                cmp.func_186854_a("UUID", UUID.fromString(cmp.func_74779_i("UUID")));
            }
            return cmp;
        }
    }

    private static class DataConverterMobSpawner
    implements DataConverter {
        DataConverterMobSpawner() {
        }

        @Override
        public int getDataVersion() {
            return 107;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            if (!"MobSpawner".equals(cmp.func_74779_i("id"))) {
                return cmp;
            }
            if (cmp.func_150297_b("EntityId", 8)) {
                String s = cmp.func_74779_i("EntityId");
                CompoundNBT nbttagcompound1 = cmp.func_74775_l("SpawnData");
                nbttagcompound1.func_74778_a("id", s.isEmpty() ? "Pig" : s);
                cmp.func_218657_a("SpawnData", (INBT)nbttagcompound1);
                cmp.func_82580_o("EntityId");
            }
            if (cmp.func_150297_b("SpawnPotentials", 9)) {
                ListNBT nbttaglist = cmp.func_150295_c("SpawnPotentials", 10);
                for (int i = 0; i < nbttaglist.size(); ++i) {
                    CompoundNBT nbttagcompound2 = nbttaglist.func_150305_b(i);
                    if (!nbttagcompound2.func_150297_b("Type", 8)) continue;
                    CompoundNBT nbttagcompound3 = nbttagcompound2.func_74775_l("Properties");
                    nbttagcompound3.func_74778_a("id", nbttagcompound2.func_74779_i("Type"));
                    nbttagcompound2.func_218657_a("Entity", (INBT)nbttagcompound3);
                    nbttagcompound2.func_82580_o("Type");
                    nbttagcompound2.func_82580_o("Properties");
                }
            }
            return cmp;
        }
    }

    private static class DataConverterMinecart
    implements DataConverter {
        private static final List<String> a = Lists.newArrayList((Object[])new String[]{"MinecartRideable", "MinecartChest", "MinecartFurnace", "MinecartTNT", "MinecartSpawner", "MinecartHopper", "MinecartCommandBlock"});

        DataConverterMinecart() {
        }

        @Override
        public int getDataVersion() {
            return 106;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            if ("Minecart".equals(cmp.func_74779_i("id"))) {
                String s = "MinecartRideable";
                int i = cmp.func_74762_e("Type");
                if (i > 0 && i < a.size()) {
                    s = a.get(i);
                }
                cmp.func_74778_a("id", s);
                cmp.func_82580_o("Type");
            }
            return cmp;
        }
    }

    private static class DataConverterSpawnEgg
    implements DataConverter {
        private static final String[] eggs = new String[256];

        DataConverterSpawnEgg() {
        }

        @Override
        public int getDataVersion() {
            return 105;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            if ("minecraft:spawn_egg".equals(cmp.func_74779_i("id"))) {
                String s;
                CompoundNBT nbttagcompound1 = cmp.func_74775_l("tag");
                CompoundNBT nbttagcompound2 = nbttagcompound1.func_74775_l("EntityTag");
                short short0 = cmp.func_74765_d("Damage");
                if (!nbttagcompound2.func_150297_b("id", 8) && (s = eggs[short0 & 0xFF]) != null) {
                    nbttagcompound2.func_74778_a("id", s);
                    nbttagcompound1.func_218657_a("EntityTag", (INBT)nbttagcompound2);
                    cmp.func_218657_a("tag", (INBT)nbttagcompound1);
                }
                if (short0 != 0) {
                    cmp.func_74777_a("Damage", (short)0);
                }
            }
            return cmp;
        }

        static {
            DataConverterSpawnEgg.eggs[1] = "Item";
            DataConverterSpawnEgg.eggs[2] = "XPOrb";
            DataConverterSpawnEgg.eggs[7] = "ThrownEgg";
            DataConverterSpawnEgg.eggs[8] = "LeashKnot";
            DataConverterSpawnEgg.eggs[9] = "Painting";
            DataConverterSpawnEgg.eggs[10] = "Arrow";
            DataConverterSpawnEgg.eggs[11] = "Snowball";
            DataConverterSpawnEgg.eggs[12] = "Fireball";
            DataConverterSpawnEgg.eggs[13] = "SmallFireball";
            DataConverterSpawnEgg.eggs[14] = "ThrownEnderpearl";
            DataConverterSpawnEgg.eggs[15] = "EyeOfEnderSignal";
            DataConverterSpawnEgg.eggs[16] = "ThrownPotion";
            DataConverterSpawnEgg.eggs[17] = "ThrownExpBottle";
            DataConverterSpawnEgg.eggs[18] = "ItemFrame";
            DataConverterSpawnEgg.eggs[19] = "WitherSkull";
            DataConverterSpawnEgg.eggs[20] = "PrimedTnt";
            DataConverterSpawnEgg.eggs[21] = "FallingSand";
            DataConverterSpawnEgg.eggs[22] = "FireworksRocketEntity";
            DataConverterSpawnEgg.eggs[23] = "TippedArrow";
            DataConverterSpawnEgg.eggs[24] = "SpectralArrow";
            DataConverterSpawnEgg.eggs[25] = "ShulkerBullet";
            DataConverterSpawnEgg.eggs[26] = "DragonFireball";
            DataConverterSpawnEgg.eggs[30] = "ArmorStand";
            DataConverterSpawnEgg.eggs[41] = "Boat";
            DataConverterSpawnEgg.eggs[42] = "MinecartRideable";
            DataConverterSpawnEgg.eggs[43] = "MinecartChest";
            DataConverterSpawnEgg.eggs[44] = "MinecartFurnace";
            DataConverterSpawnEgg.eggs[45] = "MinecartTNT";
            DataConverterSpawnEgg.eggs[46] = "MinecartHopper";
            DataConverterSpawnEgg.eggs[47] = "MinecartSpawner";
            DataConverterSpawnEgg.eggs[40] = "MinecartCommandBlock";
            DataConverterSpawnEgg.eggs[48] = "Mob";
            DataConverterSpawnEgg.eggs[49] = "Monster";
            DataConverterSpawnEgg.eggs[50] = "Creeper";
            DataConverterSpawnEgg.eggs[51] = "Skeleton";
            DataConverterSpawnEgg.eggs[52] = "Spider";
            DataConverterSpawnEgg.eggs[53] = "Giant";
            DataConverterSpawnEgg.eggs[54] = "Zombie";
            DataConverterSpawnEgg.eggs[55] = "Slime";
            DataConverterSpawnEgg.eggs[56] = "Ghast";
            DataConverterSpawnEgg.eggs[57] = "PigZombie";
            DataConverterSpawnEgg.eggs[58] = "Enderman";
            DataConverterSpawnEgg.eggs[59] = "CaveSpider";
            DataConverterSpawnEgg.eggs[60] = "Silverfish";
            DataConverterSpawnEgg.eggs[61] = "Blaze";
            DataConverterSpawnEgg.eggs[62] = "LavaSlime";
            DataConverterSpawnEgg.eggs[63] = "EnderDragon";
            DataConverterSpawnEgg.eggs[64] = "WitherBoss";
            DataConverterSpawnEgg.eggs[65] = "Bat";
            DataConverterSpawnEgg.eggs[66] = "Witch";
            DataConverterSpawnEgg.eggs[67] = "Endermite";
            DataConverterSpawnEgg.eggs[68] = "Guardian";
            DataConverterSpawnEgg.eggs[69] = "Shulker";
            DataConverterSpawnEgg.eggs[90] = "Pig";
            DataConverterSpawnEgg.eggs[91] = "Sheep";
            DataConverterSpawnEgg.eggs[92] = "Cow";
            DataConverterSpawnEgg.eggs[93] = "Chicken";
            DataConverterSpawnEgg.eggs[94] = "Squid";
            DataConverterSpawnEgg.eggs[95] = "Wolf";
            DataConverterSpawnEgg.eggs[96] = "MushroomCow";
            DataConverterSpawnEgg.eggs[97] = "SnowMan";
            DataConverterSpawnEgg.eggs[98] = "Ozelot";
            DataConverterSpawnEgg.eggs[99] = "VillagerGolem";
            DataConverterSpawnEgg.eggs[100] = "EntityHorse";
            DataConverterSpawnEgg.eggs[101] = "Rabbit";
            DataConverterSpawnEgg.eggs[120] = "Villager";
            DataConverterSpawnEgg.eggs[200] = "EnderCrystal";
        }
    }

    private static class DataConverterPotionId
    implements DataConverter {
        private static final String[] potions = new String[128];

        DataConverterPotionId() {
        }

        @Override
        public int getDataVersion() {
            return 102;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            if ("minecraft:potion".equals(cmp.func_74779_i("id"))) {
                CompoundNBT nbttagcompound1 = cmp.func_74775_l("tag");
                short short0 = cmp.func_74765_d("Damage");
                if (!nbttagcompound1.func_150297_b("Potion", 8)) {
                    String s = potions[short0 & 0x7F];
                    nbttagcompound1.func_74778_a("Potion", s == null ? "minecraft:water" : s);
                    cmp.func_218657_a("tag", (INBT)nbttagcompound1);
                    if ((short0 & 0x4000) == 16384) {
                        cmp.func_74778_a("id", "minecraft:splash_potion");
                    }
                }
                if (short0 != 0) {
                    cmp.func_74777_a("Damage", (short)0);
                }
            }
            return cmp;
        }

        static {
            DataConverterPotionId.potions[0] = "minecraft:water";
            DataConverterPotionId.potions[1] = "minecraft:regeneration";
            DataConverterPotionId.potions[2] = "minecraft:swiftness";
            DataConverterPotionId.potions[3] = "minecraft:fire_resistance";
            DataConverterPotionId.potions[4] = "minecraft:poison";
            DataConverterPotionId.potions[5] = "minecraft:healing";
            DataConverterPotionId.potions[6] = "minecraft:night_vision";
            DataConverterPotionId.potions[7] = null;
            DataConverterPotionId.potions[8] = "minecraft:weakness";
            DataConverterPotionId.potions[9] = "minecraft:strength";
            DataConverterPotionId.potions[10] = "minecraft:slowness";
            DataConverterPotionId.potions[11] = "minecraft:leaping";
            DataConverterPotionId.potions[12] = "minecraft:harming";
            DataConverterPotionId.potions[13] = "minecraft:water_breathing";
            DataConverterPotionId.potions[14] = "minecraft:invisibility";
            DataConverterPotionId.potions[15] = null;
            DataConverterPotionId.potions[16] = "minecraft:awkward";
            DataConverterPotionId.potions[17] = "minecraft:regeneration";
            DataConverterPotionId.potions[18] = "minecraft:swiftness";
            DataConverterPotionId.potions[19] = "minecraft:fire_resistance";
            DataConverterPotionId.potions[20] = "minecraft:poison";
            DataConverterPotionId.potions[21] = "minecraft:healing";
            DataConverterPotionId.potions[22] = "minecraft:night_vision";
            DataConverterPotionId.potions[23] = null;
            DataConverterPotionId.potions[24] = "minecraft:weakness";
            DataConverterPotionId.potions[25] = "minecraft:strength";
            DataConverterPotionId.potions[26] = "minecraft:slowness";
            DataConverterPotionId.potions[27] = "minecraft:leaping";
            DataConverterPotionId.potions[28] = "minecraft:harming";
            DataConverterPotionId.potions[29] = "minecraft:water_breathing";
            DataConverterPotionId.potions[30] = "minecraft:invisibility";
            DataConverterPotionId.potions[31] = null;
            DataConverterPotionId.potions[32] = "minecraft:thick";
            DataConverterPotionId.potions[33] = "minecraft:strong_regeneration";
            DataConverterPotionId.potions[34] = "minecraft:strong_swiftness";
            DataConverterPotionId.potions[35] = "minecraft:fire_resistance";
            DataConverterPotionId.potions[36] = "minecraft:strong_poison";
            DataConverterPotionId.potions[37] = "minecraft:strong_healing";
            DataConverterPotionId.potions[38] = "minecraft:night_vision";
            DataConverterPotionId.potions[39] = null;
            DataConverterPotionId.potions[40] = "minecraft:weakness";
            DataConverterPotionId.potions[41] = "minecraft:strong_strength";
            DataConverterPotionId.potions[42] = "minecraft:slowness";
            DataConverterPotionId.potions[43] = "minecraft:strong_leaping";
            DataConverterPotionId.potions[44] = "minecraft:strong_harming";
            DataConverterPotionId.potions[45] = "minecraft:water_breathing";
            DataConverterPotionId.potions[46] = "minecraft:invisibility";
            DataConverterPotionId.potions[47] = null;
            DataConverterPotionId.potions[48] = null;
            DataConverterPotionId.potions[49] = "minecraft:strong_regeneration";
            DataConverterPotionId.potions[50] = "minecraft:strong_swiftness";
            DataConverterPotionId.potions[51] = "minecraft:fire_resistance";
            DataConverterPotionId.potions[52] = "minecraft:strong_poison";
            DataConverterPotionId.potions[53] = "minecraft:strong_healing";
            DataConverterPotionId.potions[54] = "minecraft:night_vision";
            DataConverterPotionId.potions[55] = null;
            DataConverterPotionId.potions[56] = "minecraft:weakness";
            DataConverterPotionId.potions[57] = "minecraft:strong_strength";
            DataConverterPotionId.potions[58] = "minecraft:slowness";
            DataConverterPotionId.potions[59] = "minecraft:strong_leaping";
            DataConverterPotionId.potions[60] = "minecraft:strong_harming";
            DataConverterPotionId.potions[61] = "minecraft:water_breathing";
            DataConverterPotionId.potions[62] = "minecraft:invisibility";
            DataConverterPotionId.potions[63] = null;
            DataConverterPotionId.potions[64] = "minecraft:mundane";
            DataConverterPotionId.potions[65] = "minecraft:long_regeneration";
            DataConverterPotionId.potions[66] = "minecraft:long_swiftness";
            DataConverterPotionId.potions[67] = "minecraft:long_fire_resistance";
            DataConverterPotionId.potions[68] = "minecraft:long_poison";
            DataConverterPotionId.potions[69] = "minecraft:healing";
            DataConverterPotionId.potions[70] = "minecraft:long_night_vision";
            DataConverterPotionId.potions[71] = null;
            DataConverterPotionId.potions[72] = "minecraft:long_weakness";
            DataConverterPotionId.potions[73] = "minecraft:long_strength";
            DataConverterPotionId.potions[74] = "minecraft:long_slowness";
            DataConverterPotionId.potions[75] = "minecraft:long_leaping";
            DataConverterPotionId.potions[76] = "minecraft:harming";
            DataConverterPotionId.potions[77] = "minecraft:long_water_breathing";
            DataConverterPotionId.potions[78] = "minecraft:long_invisibility";
            DataConverterPotionId.potions[79] = null;
            DataConverterPotionId.potions[80] = "minecraft:awkward";
            DataConverterPotionId.potions[81] = "minecraft:long_regeneration";
            DataConverterPotionId.potions[82] = "minecraft:long_swiftness";
            DataConverterPotionId.potions[83] = "minecraft:long_fire_resistance";
            DataConverterPotionId.potions[84] = "minecraft:long_poison";
            DataConverterPotionId.potions[85] = "minecraft:healing";
            DataConverterPotionId.potions[86] = "minecraft:long_night_vision";
            DataConverterPotionId.potions[87] = null;
            DataConverterPotionId.potions[88] = "minecraft:long_weakness";
            DataConverterPotionId.potions[89] = "minecraft:long_strength";
            DataConverterPotionId.potions[90] = "minecraft:long_slowness";
            DataConverterPotionId.potions[91] = "minecraft:long_leaping";
            DataConverterPotionId.potions[92] = "minecraft:harming";
            DataConverterPotionId.potions[93] = "minecraft:long_water_breathing";
            DataConverterPotionId.potions[94] = "minecraft:long_invisibility";
            DataConverterPotionId.potions[95] = null;
            DataConverterPotionId.potions[96] = "minecraft:thick";
            DataConverterPotionId.potions[97] = "minecraft:regeneration";
            DataConverterPotionId.potions[98] = "minecraft:swiftness";
            DataConverterPotionId.potions[99] = "minecraft:long_fire_resistance";
            DataConverterPotionId.potions[100] = "minecraft:poison";
            DataConverterPotionId.potions[101] = "minecraft:strong_healing";
            DataConverterPotionId.potions[102] = "minecraft:long_night_vision";
            DataConverterPotionId.potions[103] = null;
            DataConverterPotionId.potions[104] = "minecraft:long_weakness";
            DataConverterPotionId.potions[105] = "minecraft:strength";
            DataConverterPotionId.potions[106] = "minecraft:long_slowness";
            DataConverterPotionId.potions[107] = "minecraft:leaping";
            DataConverterPotionId.potions[108] = "minecraft:strong_harming";
            DataConverterPotionId.potions[109] = "minecraft:long_water_breathing";
            DataConverterPotionId.potions[110] = "minecraft:long_invisibility";
            DataConverterPotionId.potions[111] = null;
            DataConverterPotionId.potions[112] = null;
            DataConverterPotionId.potions[113] = "minecraft:regeneration";
            DataConverterPotionId.potions[114] = "minecraft:swiftness";
            DataConverterPotionId.potions[115] = "minecraft:long_fire_resistance";
            DataConverterPotionId.potions[116] = "minecraft:poison";
            DataConverterPotionId.potions[117] = "minecraft:strong_healing";
            DataConverterPotionId.potions[118] = "minecraft:long_night_vision";
            DataConverterPotionId.potions[119] = null;
            DataConverterPotionId.potions[120] = "minecraft:long_weakness";
            DataConverterPotionId.potions[121] = "minecraft:strength";
            DataConverterPotionId.potions[122] = "minecraft:long_slowness";
            DataConverterPotionId.potions[123] = "minecraft:leaping";
            DataConverterPotionId.potions[124] = "minecraft:strong_harming";
            DataConverterPotionId.potions[125] = "minecraft:long_water_breathing";
            DataConverterPotionId.potions[126] = "minecraft:long_invisibility";
            DataConverterPotionId.potions[127] = null;
        }
    }

    private static class DataConverterBanner
    implements DataConverter {
        DataConverterBanner() {
        }

        @Override
        public int getDataVersion() {
            return 804;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            CompoundNBT nbttagcompound2;
            CompoundNBT nbttagcompound1;
            if ("minecraft:banner".equals(cmp.func_74779_i("id")) && cmp.func_150297_b("tag", 10) && (nbttagcompound1 = cmp.func_74775_l("tag")).func_150297_b("BlockEntityTag", 10) && (nbttagcompound2 = nbttagcompound1.func_74775_l("BlockEntityTag")).func_150297_b("Base", 99)) {
                ListNBT nbttaglist;
                CompoundNBT nbttagcompound3;
                cmp.func_74777_a("Damage", (short)(nbttagcompound2.func_74765_d("Base") & 0xF));
                if (nbttagcompound1.func_150297_b("display", 10) && (nbttagcompound3 = nbttagcompound1.func_74775_l("display")).func_150297_b("Lore", 9) && (nbttaglist = nbttagcompound3.func_150295_c("Lore", 8)).size() == 1 && "(+NBT)".equals(nbttaglist.func_150307_f(0))) {
                    return cmp;
                }
                nbttagcompound2.func_82580_o("Base");
                if (nbttagcompound2.isEmpty()) {
                    nbttagcompound1.func_82580_o("BlockEntityTag");
                }
                if (nbttagcompound1.isEmpty()) {
                    cmp.func_82580_o("tag");
                }
            }
            return cmp;
        }
    }

    private static class DataConverterArmorStand
    implements DataConverter {
        DataConverterArmorStand() {
        }

        @Override
        public int getDataVersion() {
            return 147;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            if ("ArmorStand".equals(cmp.func_74779_i("id")) && cmp.func_74767_n("Silent") && !cmp.func_74767_n("Marker")) {
                cmp.func_82580_o("Silent");
            }
            return cmp;
        }
    }

    private static class DataConverterMaterialId
    implements DataConverter {
        private static final String[] materials = new String[2268];

        DataConverterMaterialId() {
        }

        @Override
        public int getDataVersion() {
            return 102;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            short short0;
            if (cmp.func_150297_b("id", 99) && (short0 = cmp.func_74765_d("id")) > 0 && short0 < materials.length && materials[short0] != null) {
                cmp.func_74778_a("id", materials[short0]);
            }
            return cmp;
        }

        static {
            DataConverterMaterialId.materials[1] = "minecraft:stone";
            DataConverterMaterialId.materials[2] = "minecraft:grass";
            DataConverterMaterialId.materials[3] = "minecraft:dirt";
            DataConverterMaterialId.materials[4] = "minecraft:cobblestone";
            DataConverterMaterialId.materials[5] = "minecraft:planks";
            DataConverterMaterialId.materials[6] = "minecraft:sapling";
            DataConverterMaterialId.materials[7] = "minecraft:bedrock";
            DataConverterMaterialId.materials[8] = "minecraft:flowing_water";
            DataConverterMaterialId.materials[9] = "minecraft:water";
            DataConverterMaterialId.materials[10] = "minecraft:flowing_lava";
            DataConverterMaterialId.materials[11] = "minecraft:lava";
            DataConverterMaterialId.materials[12] = "minecraft:sand";
            DataConverterMaterialId.materials[13] = "minecraft:gravel";
            DataConverterMaterialId.materials[14] = "minecraft:gold_ore";
            DataConverterMaterialId.materials[15] = "minecraft:iron_ore";
            DataConverterMaterialId.materials[16] = "minecraft:coal_ore";
            DataConverterMaterialId.materials[17] = "minecraft:log";
            DataConverterMaterialId.materials[18] = "minecraft:leaves";
            DataConverterMaterialId.materials[19] = "minecraft:sponge";
            DataConverterMaterialId.materials[20] = "minecraft:glass";
            DataConverterMaterialId.materials[21] = "minecraft:lapis_ore";
            DataConverterMaterialId.materials[22] = "minecraft:lapis_block";
            DataConverterMaterialId.materials[23] = "minecraft:dispenser";
            DataConverterMaterialId.materials[24] = "minecraft:sandstone";
            DataConverterMaterialId.materials[25] = "minecraft:noteblock";
            DataConverterMaterialId.materials[27] = "minecraft:golden_rail";
            DataConverterMaterialId.materials[28] = "minecraft:detector_rail";
            DataConverterMaterialId.materials[29] = "minecraft:sticky_piston";
            DataConverterMaterialId.materials[30] = "minecraft:web";
            DataConverterMaterialId.materials[31] = "minecraft:tallgrass";
            DataConverterMaterialId.materials[32] = "minecraft:deadbush";
            DataConverterMaterialId.materials[33] = "minecraft:piston";
            DataConverterMaterialId.materials[35] = "minecraft:wool";
            DataConverterMaterialId.materials[37] = "minecraft:yellow_flower";
            DataConverterMaterialId.materials[38] = "minecraft:red_flower";
            DataConverterMaterialId.materials[39] = "minecraft:brown_mushroom";
            DataConverterMaterialId.materials[40] = "minecraft:red_mushroom";
            DataConverterMaterialId.materials[41] = "minecraft:gold_block";
            DataConverterMaterialId.materials[42] = "minecraft:iron_block";
            DataConverterMaterialId.materials[43] = "minecraft:double_stone_slab";
            DataConverterMaterialId.materials[44] = "minecraft:stone_slab";
            DataConverterMaterialId.materials[45] = "minecraft:brick_block";
            DataConverterMaterialId.materials[46] = "minecraft:tnt";
            DataConverterMaterialId.materials[47] = "minecraft:bookshelf";
            DataConverterMaterialId.materials[48] = "minecraft:mossy_cobblestone";
            DataConverterMaterialId.materials[49] = "minecraft:obsidian";
            DataConverterMaterialId.materials[50] = "minecraft:torch";
            DataConverterMaterialId.materials[51] = "minecraft:fire";
            DataConverterMaterialId.materials[52] = "minecraft:mob_spawner";
            DataConverterMaterialId.materials[53] = "minecraft:oak_stairs";
            DataConverterMaterialId.materials[54] = "minecraft:chest";
            DataConverterMaterialId.materials[56] = "minecraft:diamond_ore";
            DataConverterMaterialId.materials[57] = "minecraft:diamond_block";
            DataConverterMaterialId.materials[58] = "minecraft:crafting_table";
            DataConverterMaterialId.materials[60] = "minecraft:farmland";
            DataConverterMaterialId.materials[61] = "minecraft:furnace";
            DataConverterMaterialId.materials[62] = "minecraft:lit_furnace";
            DataConverterMaterialId.materials[65] = "minecraft:ladder";
            DataConverterMaterialId.materials[66] = "minecraft:rail";
            DataConverterMaterialId.materials[67] = "minecraft:stone_stairs";
            DataConverterMaterialId.materials[69] = "minecraft:lever";
            DataConverterMaterialId.materials[70] = "minecraft:stone_pressure_plate";
            DataConverterMaterialId.materials[72] = "minecraft:wooden_pressure_plate";
            DataConverterMaterialId.materials[73] = "minecraft:redstone_ore";
            DataConverterMaterialId.materials[76] = "minecraft:redstone_torch";
            DataConverterMaterialId.materials[77] = "minecraft:stone_button";
            DataConverterMaterialId.materials[78] = "minecraft:snow_layer";
            DataConverterMaterialId.materials[79] = "minecraft:ice";
            DataConverterMaterialId.materials[80] = "minecraft:snow";
            DataConverterMaterialId.materials[81] = "minecraft:cactus";
            DataConverterMaterialId.materials[82] = "minecraft:clay";
            DataConverterMaterialId.materials[84] = "minecraft:jukebox";
            DataConverterMaterialId.materials[85] = "minecraft:fence";
            DataConverterMaterialId.materials[86] = "minecraft:pumpkin";
            DataConverterMaterialId.materials[87] = "minecraft:netherrack";
            DataConverterMaterialId.materials[88] = "minecraft:soul_sand";
            DataConverterMaterialId.materials[89] = "minecraft:glowstone";
            DataConverterMaterialId.materials[90] = "minecraft:portal";
            DataConverterMaterialId.materials[91] = "minecraft:lit_pumpkin";
            DataConverterMaterialId.materials[95] = "minecraft:stained_glass";
            DataConverterMaterialId.materials[96] = "minecraft:trapdoor";
            DataConverterMaterialId.materials[97] = "minecraft:monster_egg";
            DataConverterMaterialId.materials[98] = "minecraft:stonebrick";
            DataConverterMaterialId.materials[99] = "minecraft:brown_mushroom_block";
            DataConverterMaterialId.materials[100] = "minecraft:red_mushroom_block";
            DataConverterMaterialId.materials[101] = "minecraft:iron_bars";
            DataConverterMaterialId.materials[102] = "minecraft:glass_pane";
            DataConverterMaterialId.materials[103] = "minecraft:melon_block";
            DataConverterMaterialId.materials[106] = "minecraft:vine";
            DataConverterMaterialId.materials[107] = "minecraft:fence_gate";
            DataConverterMaterialId.materials[108] = "minecraft:brick_stairs";
            DataConverterMaterialId.materials[109] = "minecraft:stone_brick_stairs";
            DataConverterMaterialId.materials[110] = "minecraft:mycelium";
            DataConverterMaterialId.materials[111] = "minecraft:waterlily";
            DataConverterMaterialId.materials[112] = "minecraft:nether_brick";
            DataConverterMaterialId.materials[113] = "minecraft:nether_brick_fence";
            DataConverterMaterialId.materials[114] = "minecraft:nether_brick_stairs";
            DataConverterMaterialId.materials[116] = "minecraft:enchanting_table";
            DataConverterMaterialId.materials[119] = "minecraft:end_portal";
            DataConverterMaterialId.materials[120] = "minecraft:end_portal_frame";
            DataConverterMaterialId.materials[121] = "minecraft:end_stone";
            DataConverterMaterialId.materials[122] = "minecraft:dragon_egg";
            DataConverterMaterialId.materials[123] = "minecraft:redstone_lamp";
            DataConverterMaterialId.materials[125] = "minecraft:double_wooden_slab";
            DataConverterMaterialId.materials[126] = "minecraft:wooden_slab";
            DataConverterMaterialId.materials[127] = "minecraft:cocoa";
            DataConverterMaterialId.materials[128] = "minecraft:sandstone_stairs";
            DataConverterMaterialId.materials[129] = "minecraft:emerald_ore";
            DataConverterMaterialId.materials[130] = "minecraft:ender_chest";
            DataConverterMaterialId.materials[131] = "minecraft:tripwire_hook";
            DataConverterMaterialId.materials[133] = "minecraft:emerald_block";
            DataConverterMaterialId.materials[134] = "minecraft:spruce_stairs";
            DataConverterMaterialId.materials[135] = "minecraft:birch_stairs";
            DataConverterMaterialId.materials[136] = "minecraft:jungle_stairs";
            DataConverterMaterialId.materials[137] = "minecraft:command_block";
            DataConverterMaterialId.materials[138] = "minecraft:beacon";
            DataConverterMaterialId.materials[139] = "minecraft:cobblestone_wall";
            DataConverterMaterialId.materials[141] = "minecraft:carrots";
            DataConverterMaterialId.materials[142] = "minecraft:potatoes";
            DataConverterMaterialId.materials[143] = "minecraft:wooden_button";
            DataConverterMaterialId.materials[145] = "minecraft:anvil";
            DataConverterMaterialId.materials[146] = "minecraft:trapped_chest";
            DataConverterMaterialId.materials[147] = "minecraft:light_weighted_pressure_plate";
            DataConverterMaterialId.materials[148] = "minecraft:heavy_weighted_pressure_plate";
            DataConverterMaterialId.materials[151] = "minecraft:daylight_detector";
            DataConverterMaterialId.materials[152] = "minecraft:redstone_block";
            DataConverterMaterialId.materials[153] = "minecraft:quartz_ore";
            DataConverterMaterialId.materials[154] = "minecraft:hopper";
            DataConverterMaterialId.materials[155] = "minecraft:quartz_block";
            DataConverterMaterialId.materials[156] = "minecraft:quartz_stairs";
            DataConverterMaterialId.materials[157] = "minecraft:activator_rail";
            DataConverterMaterialId.materials[158] = "minecraft:dropper";
            DataConverterMaterialId.materials[159] = "minecraft:stained_hardened_clay";
            DataConverterMaterialId.materials[160] = "minecraft:stained_glass_pane";
            DataConverterMaterialId.materials[161] = "minecraft:leaves2";
            DataConverterMaterialId.materials[162] = "minecraft:log2";
            DataConverterMaterialId.materials[163] = "minecraft:acacia_stairs";
            DataConverterMaterialId.materials[164] = "minecraft:dark_oak_stairs";
            DataConverterMaterialId.materials[170] = "minecraft:hay_block";
            DataConverterMaterialId.materials[171] = "minecraft:carpet";
            DataConverterMaterialId.materials[172] = "minecraft:hardened_clay";
            DataConverterMaterialId.materials[173] = "minecraft:coal_block";
            DataConverterMaterialId.materials[174] = "minecraft:packed_ice";
            DataConverterMaterialId.materials[175] = "minecraft:double_plant";
            DataConverterMaterialId.materials[256] = "minecraft:iron_shovel";
            DataConverterMaterialId.materials[257] = "minecraft:iron_pickaxe";
            DataConverterMaterialId.materials[258] = "minecraft:iron_axe";
            DataConverterMaterialId.materials[259] = "minecraft:flint_and_steel";
            DataConverterMaterialId.materials[260] = "minecraft:apple";
            DataConverterMaterialId.materials[261] = "minecraft:bow";
            DataConverterMaterialId.materials[262] = "minecraft:arrow";
            DataConverterMaterialId.materials[263] = "minecraft:coal";
            DataConverterMaterialId.materials[264] = "minecraft:diamond";
            DataConverterMaterialId.materials[265] = "minecraft:iron_ingot";
            DataConverterMaterialId.materials[266] = "minecraft:gold_ingot";
            DataConverterMaterialId.materials[267] = "minecraft:iron_sword";
            DataConverterMaterialId.materials[268] = "minecraft:wooden_sword";
            DataConverterMaterialId.materials[269] = "minecraft:wooden_shovel";
            DataConverterMaterialId.materials[270] = "minecraft:wooden_pickaxe";
            DataConverterMaterialId.materials[271] = "minecraft:wooden_axe";
            DataConverterMaterialId.materials[272] = "minecraft:stone_sword";
            DataConverterMaterialId.materials[273] = "minecraft:stone_shovel";
            DataConverterMaterialId.materials[274] = "minecraft:stone_pickaxe";
            DataConverterMaterialId.materials[275] = "minecraft:stone_axe";
            DataConverterMaterialId.materials[276] = "minecraft:diamond_sword";
            DataConverterMaterialId.materials[277] = "minecraft:diamond_shovel";
            DataConverterMaterialId.materials[278] = "minecraft:diamond_pickaxe";
            DataConverterMaterialId.materials[279] = "minecraft:diamond_axe";
            DataConverterMaterialId.materials[280] = "minecraft:stick";
            DataConverterMaterialId.materials[281] = "minecraft:bowl";
            DataConverterMaterialId.materials[282] = "minecraft:mushroom_stew";
            DataConverterMaterialId.materials[283] = "minecraft:golden_sword";
            DataConverterMaterialId.materials[284] = "minecraft:golden_shovel";
            DataConverterMaterialId.materials[285] = "minecraft:golden_pickaxe";
            DataConverterMaterialId.materials[286] = "minecraft:golden_axe";
            DataConverterMaterialId.materials[287] = "minecraft:string";
            DataConverterMaterialId.materials[288] = "minecraft:feather";
            DataConverterMaterialId.materials[289] = "minecraft:gunpowder";
            DataConverterMaterialId.materials[290] = "minecraft:wooden_hoe";
            DataConverterMaterialId.materials[291] = "minecraft:stone_hoe";
            DataConverterMaterialId.materials[292] = "minecraft:iron_hoe";
            DataConverterMaterialId.materials[293] = "minecraft:diamond_hoe";
            DataConverterMaterialId.materials[294] = "minecraft:golden_hoe";
            DataConverterMaterialId.materials[295] = "minecraft:wheat_seeds";
            DataConverterMaterialId.materials[296] = "minecraft:wheat";
            DataConverterMaterialId.materials[297] = "minecraft:bread";
            DataConverterMaterialId.materials[298] = "minecraft:leather_helmet";
            DataConverterMaterialId.materials[299] = "minecraft:leather_chestplate";
            DataConverterMaterialId.materials[300] = "minecraft:leather_leggings";
            DataConverterMaterialId.materials[301] = "minecraft:leather_boots";
            DataConverterMaterialId.materials[302] = "minecraft:chainmail_helmet";
            DataConverterMaterialId.materials[303] = "minecraft:chainmail_chestplate";
            DataConverterMaterialId.materials[304] = "minecraft:chainmail_leggings";
            DataConverterMaterialId.materials[305] = "minecraft:chainmail_boots";
            DataConverterMaterialId.materials[306] = "minecraft:iron_helmet";
            DataConverterMaterialId.materials[307] = "minecraft:iron_chestplate";
            DataConverterMaterialId.materials[308] = "minecraft:iron_leggings";
            DataConverterMaterialId.materials[309] = "minecraft:iron_boots";
            DataConverterMaterialId.materials[310] = "minecraft:diamond_helmet";
            DataConverterMaterialId.materials[311] = "minecraft:diamond_chestplate";
            DataConverterMaterialId.materials[312] = "minecraft:diamond_leggings";
            DataConverterMaterialId.materials[313] = "minecraft:diamond_boots";
            DataConverterMaterialId.materials[314] = "minecraft:golden_helmet";
            DataConverterMaterialId.materials[315] = "minecraft:golden_chestplate";
            DataConverterMaterialId.materials[316] = "minecraft:golden_leggings";
            DataConverterMaterialId.materials[317] = "minecraft:golden_boots";
            DataConverterMaterialId.materials[318] = "minecraft:flint";
            DataConverterMaterialId.materials[319] = "minecraft:porkchop";
            DataConverterMaterialId.materials[320] = "minecraft:cooked_porkchop";
            DataConverterMaterialId.materials[321] = "minecraft:painting";
            DataConverterMaterialId.materials[322] = "minecraft:golden_apple";
            DataConverterMaterialId.materials[323] = "minecraft:sign";
            DataConverterMaterialId.materials[324] = "minecraft:wooden_door";
            DataConverterMaterialId.materials[325] = "minecraft:bucket";
            DataConverterMaterialId.materials[326] = "minecraft:water_bucket";
            DataConverterMaterialId.materials[327] = "minecraft:lava_bucket";
            DataConverterMaterialId.materials[328] = "minecraft:minecart";
            DataConverterMaterialId.materials[329] = "minecraft:saddle";
            DataConverterMaterialId.materials[330] = "minecraft:iron_door";
            DataConverterMaterialId.materials[331] = "minecraft:redstone";
            DataConverterMaterialId.materials[332] = "minecraft:snowball";
            DataConverterMaterialId.materials[333] = "minecraft:boat";
            DataConverterMaterialId.materials[334] = "minecraft:leather";
            DataConverterMaterialId.materials[335] = "minecraft:milk_bucket";
            DataConverterMaterialId.materials[336] = "minecraft:brick";
            DataConverterMaterialId.materials[337] = "minecraft:clay_ball";
            DataConverterMaterialId.materials[338] = "minecraft:reeds";
            DataConverterMaterialId.materials[339] = "minecraft:paper";
            DataConverterMaterialId.materials[340] = "minecraft:book";
            DataConverterMaterialId.materials[341] = "minecraft:slime_ball";
            DataConverterMaterialId.materials[342] = "minecraft:chest_minecart";
            DataConverterMaterialId.materials[343] = "minecraft:furnace_minecart";
            DataConverterMaterialId.materials[344] = "minecraft:egg";
            DataConverterMaterialId.materials[345] = "minecraft:compass";
            DataConverterMaterialId.materials[346] = "minecraft:fishing_rod";
            DataConverterMaterialId.materials[347] = "minecraft:clock";
            DataConverterMaterialId.materials[348] = "minecraft:glowstone_dust";
            DataConverterMaterialId.materials[349] = "minecraft:fish";
            DataConverterMaterialId.materials[350] = "minecraft:cooked_fish";
            DataConverterMaterialId.materials[351] = "minecraft:dye";
            DataConverterMaterialId.materials[352] = "minecraft:bone";
            DataConverterMaterialId.materials[353] = "minecraft:sugar";
            DataConverterMaterialId.materials[354] = "minecraft:cake";
            DataConverterMaterialId.materials[355] = "minecraft:bed";
            DataConverterMaterialId.materials[356] = "minecraft:repeater";
            DataConverterMaterialId.materials[357] = "minecraft:cookie";
            DataConverterMaterialId.materials[358] = "minecraft:filled_map";
            DataConverterMaterialId.materials[359] = "minecraft:shears";
            DataConverterMaterialId.materials[360] = "minecraft:melon";
            DataConverterMaterialId.materials[361] = "minecraft:pumpkin_seeds";
            DataConverterMaterialId.materials[362] = "minecraft:melon_seeds";
            DataConverterMaterialId.materials[363] = "minecraft:beef";
            DataConverterMaterialId.materials[364] = "minecraft:cooked_beef";
            DataConverterMaterialId.materials[365] = "minecraft:chicken";
            DataConverterMaterialId.materials[366] = "minecraft:cooked_chicken";
            DataConverterMaterialId.materials[367] = "minecraft:rotten_flesh";
            DataConverterMaterialId.materials[368] = "minecraft:ender_pearl";
            DataConverterMaterialId.materials[369] = "minecraft:blaze_rod";
            DataConverterMaterialId.materials[370] = "minecraft:ghast_tear";
            DataConverterMaterialId.materials[371] = "minecraft:gold_nugget";
            DataConverterMaterialId.materials[372] = "minecraft:nether_wart";
            DataConverterMaterialId.materials[373] = "minecraft:potion";
            DataConverterMaterialId.materials[374] = "minecraft:glass_bottle";
            DataConverterMaterialId.materials[375] = "minecraft:spider_eye";
            DataConverterMaterialId.materials[376] = "minecraft:fermented_spider_eye";
            DataConverterMaterialId.materials[377] = "minecraft:blaze_powder";
            DataConverterMaterialId.materials[378] = "minecraft:magma_cream";
            DataConverterMaterialId.materials[379] = "minecraft:brewing_stand";
            DataConverterMaterialId.materials[380] = "minecraft:cauldron";
            DataConverterMaterialId.materials[381] = "minecraft:ender_eye";
            DataConverterMaterialId.materials[382] = "minecraft:speckled_melon";
            DataConverterMaterialId.materials[383] = "minecraft:spawn_egg";
            DataConverterMaterialId.materials[384] = "minecraft:experience_bottle";
            DataConverterMaterialId.materials[385] = "minecraft:fire_charge";
            DataConverterMaterialId.materials[386] = "minecraft:writable_book";
            DataConverterMaterialId.materials[387] = "minecraft:written_book";
            DataConverterMaterialId.materials[388] = "minecraft:emerald";
            DataConverterMaterialId.materials[389] = "minecraft:item_frame";
            DataConverterMaterialId.materials[390] = "minecraft:flower_pot";
            DataConverterMaterialId.materials[391] = "minecraft:carrot";
            DataConverterMaterialId.materials[392] = "minecraft:potato";
            DataConverterMaterialId.materials[393] = "minecraft:baked_potato";
            DataConverterMaterialId.materials[394] = "minecraft:poisonous_potato";
            DataConverterMaterialId.materials[395] = "minecraft:map";
            DataConverterMaterialId.materials[396] = "minecraft:golden_carrot";
            DataConverterMaterialId.materials[397] = "minecraft:skull";
            DataConverterMaterialId.materials[398] = "minecraft:carrot_on_a_stick";
            DataConverterMaterialId.materials[399] = "minecraft:nether_star";
            DataConverterMaterialId.materials[400] = "minecraft:pumpkin_pie";
            DataConverterMaterialId.materials[401] = "minecraft:fireworks";
            DataConverterMaterialId.materials[402] = "minecraft:firework_charge";
            DataConverterMaterialId.materials[403] = "minecraft:enchanted_book";
            DataConverterMaterialId.materials[404] = "minecraft:comparator";
            DataConverterMaterialId.materials[405] = "minecraft:netherbrick";
            DataConverterMaterialId.materials[406] = "minecraft:quartz";
            DataConverterMaterialId.materials[407] = "minecraft:tnt_minecart";
            DataConverterMaterialId.materials[408] = "minecraft:hopper_minecart";
            DataConverterMaterialId.materials[417] = "minecraft:iron_horse_armor";
            DataConverterMaterialId.materials[418] = "minecraft:golden_horse_armor";
            DataConverterMaterialId.materials[419] = "minecraft:diamond_horse_armor";
            DataConverterMaterialId.materials[420] = "minecraft:lead";
            DataConverterMaterialId.materials[421] = "minecraft:name_tag";
            DataConverterMaterialId.materials[422] = "minecraft:command_block_minecart";
            DataConverterMaterialId.materials[2256] = "minecraft:record_13";
            DataConverterMaterialId.materials[2257] = "minecraft:record_cat";
            DataConverterMaterialId.materials[2258] = "minecraft:record_blocks";
            DataConverterMaterialId.materials[2259] = "minecraft:record_chirp";
            DataConverterMaterialId.materials[2260] = "minecraft:record_far";
            DataConverterMaterialId.materials[2261] = "minecraft:record_mall";
            DataConverterMaterialId.materials[2262] = "minecraft:record_mellohi";
            DataConverterMaterialId.materials[2263] = "minecraft:record_stal";
            DataConverterMaterialId.materials[2264] = "minecraft:record_strad";
            DataConverterMaterialId.materials[2265] = "minecraft:record_ward";
            DataConverterMaterialId.materials[2266] = "minecraft:record_11";
            DataConverterMaterialId.materials[2267] = "minecraft:record_wait";
        }
    }

    private static class DataInspectorItem
    extends DataInspectorTagged {
        private final String[] keys;

        DataInspectorItem(String oclass, String ... astring) {
            super(oclass);
            this.keys = astring;
        }

        @Override
        CompoundNBT inspectChecked(CompoundNBT nbttagcompound, int sourceVer, int targetVer) {
            for (String key : this.keys) {
                ForgeDataFixer.convertItem(nbttagcompound, key, sourceVer, targetVer);
            }
            return nbttagcompound;
        }
    }

    private static class DataInspectorItemList
    extends DataInspectorTagged {
        private final String[] keys;

        DataInspectorItemList(String oclass, String ... astring) {
            super(oclass);
            this.keys = astring;
        }

        @Override
        CompoundNBT inspectChecked(CompoundNBT nbttagcompound, int sourceVer, int targetVer) {
            for (String s : this.keys) {
                ForgeDataFixer.convertItems(nbttagcompound, s, sourceVer, targetVer);
            }
            return nbttagcompound;
        }
    }

    private static abstract class DataInspectorTagged
    implements DataInspector {
        private final ResourceLocation key;

        DataInspectorTagged(String type) {
            this.key = ForgeDataFixer.getKey(type);
        }

        @Override
        public CompoundNBT inspect(CompoundNBT cmp, int sourceVer, int targetVer) {
            if (this.key.equals((Object)new ResourceLocation(cmp.func_74779_i("id")))) {
                cmp = this.inspectChecked(cmp, sourceVer, targetVer);
            }
            return cmp;
        }

        abstract CompoundNBT inspectChecked(CompoundNBT var1, int var2, int var3);
    }

    private static class DataInspectorEntity
    implements DataInspector {
        private static final Logger a = LogManager.getLogger(ForgeDataFixer.class);

        DataInspectorEntity() {
        }

        @Override
        public CompoundNBT inspect(CompoundNBT cmp, int sourceVer, int targetVer) {
            CompoundNBT nbttagcompound1 = cmp.func_74775_l("tag");
            if (nbttagcompound1.func_150297_b("EntityTag", 10)) {
                boolean flag;
                String s1;
                CompoundNBT nbttagcompound2 = nbttagcompound1.func_74775_l("EntityTag");
                String s = cmp.func_74779_i("id");
                if ("minecraft:armor_stand".equals(s)) {
                    s1 = sourceVer < 515 ? "ArmorStand" : "minecraft:armor_stand";
                } else {
                    if (!"minecraft:spawn_egg".equals(s)) {
                        return cmp;
                    }
                    s1 = nbttagcompound2.func_74779_i("id");
                }
                if (s1 == null) {
                    a.warn("Unable to resolve Entity for ItemInstance: {}", (Object)s);
                    flag = false;
                } else {
                    flag = !nbttagcompound2.func_150297_b("id", 8);
                    nbttagcompound2.func_74778_a("id", s1);
                }
                ForgeDataFixer.convert(LegacyType.ENTITY, nbttagcompound2, sourceVer, targetVer);
                if (flag) {
                    nbttagcompound2.func_82580_o("id");
                }
            }
            return cmp;
        }
    }

    private static class DataInspectorBlockEntity
    implements DataInspector {
        private static final Map<String, String> b = Maps.newHashMap();
        private static final Map<String, String> c = Maps.newHashMap();

        DataInspectorBlockEntity() {
        }

        @Nullable
        private static String convertEntityId(int i, String s) {
            String key = new ResourceLocation(s).toString();
            if (i < 515 && b.containsKey(key)) {
                return b.get(key);
            }
            return c.get(key);
        }

        @Override
        public CompoundNBT inspect(CompoundNBT cmp, int sourceVer, int targetVer) {
            if (!cmp.func_150297_b("tag", 10)) {
                return cmp;
            }
            CompoundNBT nbttagcompound1 = cmp.func_74775_l("tag");
            if (nbttagcompound1.func_150297_b("BlockEntityTag", 10)) {
                boolean flag;
                CompoundNBT nbttagcompound2 = nbttagcompound1.func_74775_l("BlockEntityTag");
                String s = cmp.func_74779_i("id");
                String s1 = DataInspectorBlockEntity.convertEntityId(sourceVer, s);
                if (s1 == null) {
                    flag = false;
                } else {
                    flag = !nbttagcompound2.func_74764_b("id");
                    nbttagcompound2.func_74778_a("id", s1);
                }
                ForgeDataFixer.convert(LegacyType.BLOCK_ENTITY, nbttagcompound2, sourceVer, targetVer);
                if (flag) {
                    nbttagcompound2.func_82580_o("id");
                }
            }
            return cmp;
        }

        static {
            Map<String, String> map = b;
            map.put("minecraft:furnace", "Furnace");
            map.put("minecraft:lit_furnace", "Furnace");
            map.put("minecraft:chest", "Chest");
            map.put("minecraft:trapped_chest", "Chest");
            map.put("minecraft:ender_chest", "EnderChest");
            map.put("minecraft:jukebox", "RecordPlayer");
            map.put("minecraft:dispenser", "Trap");
            map.put("minecraft:dropper", "Dropper");
            map.put("minecraft:sign", "Sign");
            map.put("minecraft:mob_spawner", "MobSpawner");
            map.put("minecraft:noteblock", "Music");
            map.put("minecraft:brewing_stand", "Cauldron");
            map.put("minecraft:enhanting_table", "EnchantTable");
            map.put("minecraft:command_block", "CommandBlock");
            map.put("minecraft:beacon", "Beacon");
            map.put("minecraft:skull", "Skull");
            map.put("minecraft:daylight_detector", "DLDetector");
            map.put("minecraft:hopper", "Hopper");
            map.put("minecraft:banner", "Banner");
            map.put("minecraft:flower_pot", "FlowerPot");
            map.put("minecraft:repeating_command_block", "CommandBlock");
            map.put("minecraft:chain_command_block", "CommandBlock");
            map.put("minecraft:standing_sign", "Sign");
            map.put("minecraft:wall_sign", "Sign");
            map.put("minecraft:piston_head", "Piston");
            map.put("minecraft:daylight_detector_inverted", "DLDetector");
            map.put("minecraft:unpowered_comparator", "Comparator");
            map.put("minecraft:powered_comparator", "Comparator");
            map.put("minecraft:wall_banner", "Banner");
            map.put("minecraft:standing_banner", "Banner");
            map.put("minecraft:structure_block", "Structure");
            map.put("minecraft:end_portal", "Airportal");
            map.put("minecraft:end_gateway", "EndGateway");
            map.put("minecraft:shield", "Shield");
            map = c;
            map.put("minecraft:furnace", "minecraft:furnace");
            map.put("minecraft:lit_furnace", "minecraft:furnace");
            map.put("minecraft:chest", "minecraft:chest");
            map.put("minecraft:trapped_chest", "minecraft:chest");
            map.put("minecraft:ender_chest", "minecraft:enderchest");
            map.put("minecraft:jukebox", "minecraft:jukebox");
            map.put("minecraft:dispenser", "minecraft:dispenser");
            map.put("minecraft:dropper", "minecraft:dropper");
            map.put("minecraft:sign", "minecraft:sign");
            map.put("minecraft:mob_spawner", "minecraft:mob_spawner");
            map.put("minecraft:noteblock", "minecraft:noteblock");
            map.put("minecraft:brewing_stand", "minecraft:brewing_stand");
            map.put("minecraft:enhanting_table", "minecraft:enchanting_table");
            map.put("minecraft:command_block", "minecraft:command_block");
            map.put("minecraft:beacon", "minecraft:beacon");
            map.put("minecraft:skull", "minecraft:skull");
            map.put("minecraft:daylight_detector", "minecraft:daylight_detector");
            map.put("minecraft:hopper", "minecraft:hopper");
            map.put("minecraft:banner", "minecraft:banner");
            map.put("minecraft:flower_pot", "minecraft:flower_pot");
            map.put("minecraft:repeating_command_block", "minecraft:command_block");
            map.put("minecraft:chain_command_block", "minecraft:command_block");
            map.put("minecraft:shulker_box", "minecraft:shulker_box");
            map.put("minecraft:white_shulker_box", "minecraft:shulker_box");
            map.put("minecraft:orange_shulker_box", "minecraft:shulker_box");
            map.put("minecraft:magenta_shulker_box", "minecraft:shulker_box");
            map.put("minecraft:light_blue_shulker_box", "minecraft:shulker_box");
            map.put("minecraft:yellow_shulker_box", "minecraft:shulker_box");
            map.put("minecraft:lime_shulker_box", "minecraft:shulker_box");
            map.put("minecraft:pink_shulker_box", "minecraft:shulker_box");
            map.put("minecraft:gray_shulker_box", "minecraft:shulker_box");
            map.put("minecraft:silver_shulker_box", "minecraft:shulker_box");
            map.put("minecraft:cyan_shulker_box", "minecraft:shulker_box");
            map.put("minecraft:purple_shulker_box", "minecraft:shulker_box");
            map.put("minecraft:blue_shulker_box", "minecraft:shulker_box");
            map.put("minecraft:brown_shulker_box", "minecraft:shulker_box");
            map.put("minecraft:green_shulker_box", "minecraft:shulker_box");
            map.put("minecraft:red_shulker_box", "minecraft:shulker_box");
            map.put("minecraft:black_shulker_box", "minecraft:shulker_box");
            map.put("minecraft:bed", "minecraft:bed");
            map.put("minecraft:standing_sign", "minecraft:sign");
            map.put("minecraft:wall_sign", "minecraft:sign");
            map.put("minecraft:piston_head", "minecraft:piston");
            map.put("minecraft:daylight_detector_inverted", "minecraft:daylight_detector");
            map.put("minecraft:unpowered_comparator", "minecraft:comparator");
            map.put("minecraft:powered_comparator", "minecraft:comparator");
            map.put("minecraft:wall_banner", "minecraft:banner");
            map.put("minecraft:standing_banner", "minecraft:banner");
            map.put("minecraft:structure_block", "minecraft:structure_block");
            map.put("minecraft:end_portal", "minecraft:end_portal");
            map.put("minecraft:end_gateway", "minecraft:end_gateway");
            map.put("minecraft:shield", "minecraft:shield");
        }
    }

    private static class DataConverterEquipment
    implements DataConverter {
        DataConverterEquipment() {
        }

        @Override
        public int getDataVersion() {
            return 100;
        }

        @Override
        public CompoundNBT convert(CompoundNBT cmp) {
            ListNBT nbttaglist1;
            ListNBT nbttaglist = cmp.func_150295_c("Equipment", 10);
            if (!nbttaglist.isEmpty() && !cmp.func_150297_b("HandItems", 10)) {
                nbttaglist1 = new ListNBT();
                nbttaglist1.add((Object)nbttaglist.get(0));
                nbttaglist1.add((Object)new CompoundNBT());
                cmp.func_218657_a("HandItems", (INBT)nbttaglist1);
            }
            if (nbttaglist.size() > 1 && !cmp.func_150297_b("ArmorItem", 10)) {
                nbttaglist1 = new ListNBT();
                nbttaglist1.add((Object)nbttaglist.get(1));
                nbttaglist1.add((Object)nbttaglist.get(2));
                nbttaglist1.add((Object)nbttaglist.get(3));
                nbttaglist1.add((Object)nbttaglist.get(4));
                cmp.func_218657_a("ArmorItems", (INBT)nbttaglist1);
            }
            cmp.func_82580_o("Equipment");
            if (cmp.func_150297_b("DropChances", 9)) {
                ListNBT nbttaglist2;
                nbttaglist1 = cmp.func_150295_c("DropChances", 5);
                if (!cmp.func_150297_b("HandDropChances", 10)) {
                    nbttaglist2 = new ListNBT();
                    nbttaglist2.add((Object)new FloatNBT(nbttaglist1.func_150308_e(0)));
                    nbttaglist2.add((Object)new FloatNBT(0.0f));
                    cmp.func_218657_a("HandDropChances", (INBT)nbttaglist2);
                }
                if (!cmp.func_150297_b("ArmorDropChances", 10)) {
                    nbttaglist2 = new ListNBT();
                    nbttaglist2.add((Object)new FloatNBT(nbttaglist1.func_150308_e(1)));
                    nbttaglist2.add((Object)new FloatNBT(nbttaglist1.func_150308_e(2)));
                    nbttaglist2.add((Object)new FloatNBT(nbttaglist1.func_150308_e(3)));
                    nbttaglist2.add((Object)new FloatNBT(nbttaglist1.func_150308_e(4)));
                    cmp.func_218657_a("ArmorDropChances", (INBT)nbttaglist2);
                }
                cmp.func_82580_o("DropChances");
            }
            return cmp;
        }
    }

    public static interface DataConverter {
        public int getDataVersion();

        public CompoundNBT convert(CompoundNBT var1);
    }

    public static interface DataInspector {
        public CompoundNBT inspect(CompoundNBT var1, int var2, int var3);
    }

    private class WrappedDataFixer
    implements DataFixer {
        private final DataFixer realFixer;

        WrappedDataFixer(DataFixer realFixer) {
            this.realFixer = realFixer;
        }

        public <T> Dynamic<T> update(DSL.TypeReference type, Dynamic<T> dynamic, int sourceVer, int targetVer) {
            LegacyType legacyType = (LegacyType)((Object)DFU_TO_LEGACY.get(type.typeName()));
            if (sourceVer < 1343 && legacyType != null) {
                CompoundNBT cmp = (CompoundNBT)dynamic.getValue();
                int desiredVersion = Math.min(targetVer, 1343);
                cmp = this.convert(legacyType, cmp, sourceVer, desiredVersion);
                sourceVer = desiredVersion;
                dynamic = new Dynamic((DynamicOps)OPS_NBT, (Object)cmp);
            }
            return this.realFixer.update(type, dynamic, sourceVer, targetVer);
        }

        private CompoundNBT convert(LegacyType type, CompoundNBT cmp, int sourceVer, int desiredVersion) {
            List inspectors;
            List converters = (List)ForgeDataFixer.this.converters.get((Object)type);
            if (converters != null && !converters.isEmpty()) {
                for (DataConverter converter : converters) {
                    int dataVersion = converter.getDataVersion();
                    if (dataVersion <= sourceVer || dataVersion > desiredVersion) continue;
                    cmp = converter.convert(cmp);
                }
            }
            if ((inspectors = (List)ForgeDataFixer.this.inspectors.get((Object)type)) != null && !inspectors.isEmpty()) {
                for (DataInspector inspector : inspectors) {
                    cmp = inspector.inspect(cmp, sourceVer, desiredVersion);
                }
            }
            return cmp;
        }

        public Schema getSchema(int i) {
            return this.realFixer.getSchema(i);
        }
    }

    public static enum LegacyType {
        LEVEL(TypeReferences.field_211285_a),
        PLAYER(TypeReferences.field_211286_b),
        CHUNK(TypeReferences.field_211287_c),
        BLOCK_ENTITY(TypeReferences.field_211294_j),
        ENTITY(TypeReferences.field_211299_o),
        ITEM_INSTANCE(TypeReferences.field_211295_k),
        OPTIONS(TypeReferences.field_211289_e),
        STRUCTURE(TypeReferences.field_211290_f);

        private final DSL.TypeReference type;

        private LegacyType(DSL.TypeReference type) {
            this.type = type;
            DFU_TO_LEGACY.put(type.typeName(), this);
        }

        public DSL.TypeReference getDFUType() {
            return this.type;
        }
    }
}

