/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.Files;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.forge.ForgeEntity;
import com.sk89q.worldedit.forge.NBTConverter;
import com.sk89q.worldedit.forge.TileEntityUtils;
import com.sk89q.worldedit.forge.WorldEditFakePlayer;
import com.sk89q.worldedit.internal.Constants;
import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.world.AbstractWorld;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.item.ItemTypes;
import com.sk89q.worldedit.world.weather.WeatherType;
import com.sk89q.worldedit.world.weather.WeatherTypes;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IClearable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.gen.feature.BigBrownMushroomFeature;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;
import net.minecraft.world.gen.feature.BigRedMushroomFeature;
import net.minecraft.world.gen.feature.BigTreeFeature;
import net.minecraft.world.gen.feature.BirchTreeFeature;
import net.minecraft.world.gen.feature.DarkOakTreeFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.JungleTreeFeature;
import net.minecraft.world.gen.feature.MegaJungleFeature;
import net.minecraft.world.gen.feature.MegaPineTree;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.PointyTaigaTreeFeature;
import net.minecraft.world.gen.feature.SavannaTreeFeature;
import net.minecraft.world.gen.feature.ShrubFeature;
import net.minecraft.world.gen.feature.SwampTreeFeature;
import net.minecraft.world.gen.feature.TallTaigaTreeFeature;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;

public class ForgeWorld
extends AbstractWorld {
    private static final Random random = new Random();
    private static final int UPDATE = 1;
    private static final int NOTIFY = 2;
    private static final net.minecraft.block.BlockState JUNGLE_LOG = Blocks.field_196620_N.func_176223_P();
    private static final net.minecraft.block.BlockState JUNGLE_LEAF = (net.minecraft.block.BlockState)Blocks.field_196648_Z.func_176223_P().func_206870_a((IProperty)LeavesBlock.field_208495_b, (Comparable)Boolean.TRUE);
    private static final net.minecraft.block.BlockState JUNGLE_SHRUB = (net.minecraft.block.BlockState)Blocks.field_196642_W.func_176223_P().func_206870_a((IProperty)LeavesBlock.field_208495_b, (Comparable)Boolean.TRUE);
    private final WeakReference<World> worldRef;
    private static LoadingCache<ServerWorld, WorldEditFakePlayer> fakePlayers = CacheBuilder.newBuilder().weakKeys().softValues().build(CacheLoader.from(WorldEditFakePlayer::new));

    ForgeWorld(World world) {
        Preconditions.checkNotNull((Object)world);
        this.worldRef = new WeakReference<World>(world);
    }

    public World getWorldChecked() throws WorldEditException {
        World world = (World)this.worldRef.get();
        if (world != null) {
            return world;
        }
        throw new WorldReferenceLostException("The reference to the world was lost (i.e. the world may have been unloaded)");
    }

    public World getWorld() {
        World world = (World)this.worldRef.get();
        if (world != null) {
            return world;
        }
        throw new RuntimeException("The reference to the world was lost (i.e. the world may have been unloaded)");
    }

    @Override
    public String getName() {
        return this.getWorld().func_72912_H().func_76065_j();
    }

    @Override
    public Path getStoragePath() {
        World world = this.getWorld();
        if (world instanceof ServerWorld) {
            return ((ServerWorld)world).func_217485_w().func_75765_b().toPath();
        }
        return null;
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 position, B block, boolean notifyAndLight) throws WorldEditException {
        CompoundTag tag;
        boolean successful;
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull(block);
        World world = this.getWorldChecked();
        int x = position.getBlockX();
        int y = position.getBlockY();
        int z = position.getBlockZ();
        Chunk chunk = world.func_212866_a_(x >> 4, z >> 4);
        BlockPos pos = new BlockPos(x, y, z);
        net.minecraft.block.BlockState old = chunk.func_180495_p(pos);
        OptionalInt stateId = BlockStateIdAccess.getBlockStateId(block.toImmutableState());
        net.minecraft.block.BlockState newState = stateId.isPresent() ? Block.func_196257_b((int)stateId.getAsInt()) : ForgeAdapter.adapt(block.toImmutableState());
        net.minecraft.block.BlockState successState = chunk.func_177436_a(pos, newState, false);
        boolean bl = successful = successState != null;
        if ((successful || old == newState) && block instanceof BaseBlock && (tag = ((BaseBlock)block).getNbtData()) != null) {
            CompoundNBT nativeTag = NBTConverter.toNative(tag);
            nativeTag.func_74778_a("id", ((BaseBlock)block).getNbtId());
            TileEntityUtils.setTileEntity(world, position, nativeTag);
            successful = true;
        }
        if (successful && notifyAndLight) {
            world.func_72863_F().func_212863_j_().func_215568_a(pos);
            world.markAndNotifyBlock(pos, chunk, old, newState, 3);
        }
        return successful;
    }

    @Override
    public boolean notifyAndLightBlock(BlockVector3 position, BlockState previousType) throws WorldEditException {
        BlockPos pos = new BlockPos(position.getX(), position.getY(), position.getZ());
        this.getWorld().func_184138_a(pos, ForgeAdapter.adapt(previousType), this.getWorld().func_180495_p(pos), 3);
        return true;
    }

    @Override
    public int getBlockLightLevel(BlockVector3 position) {
        Preconditions.checkNotNull((Object)position);
        return this.getWorld().func_201696_r(ForgeAdapter.toBlockPos(position));
    }

    @Override
    public boolean clearContainerBlockContents(BlockVector3 position) {
        Preconditions.checkNotNull((Object)position);
        TileEntity tile = this.getWorld().func_175625_s(ForgeAdapter.toBlockPos(position));
        if (tile instanceof IClearable) {
            ((IClearable)tile).func_174888_l();
            return true;
        }
        return false;
    }

    @Override
    public BiomeType getBiome(BlockVector2 position) {
        Preconditions.checkNotNull((Object)position);
        return ForgeAdapter.adapt(this.getWorld().getBiomeBody(new BlockPos(position.getBlockX(), 0, position.getBlockZ())));
    }

    @Override
    public boolean setBiome(BlockVector2 position, BiomeType biome) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)biome);
        IChunk chunk = this.getWorld().func_217353_a(position.getBlockX() >> 4, position.getBlockZ() >> 4, ChunkStatus.field_222617_m, false);
        if (chunk == null) {
            return false;
        }
        chunk.func_201590_e()[(position.getBlockZ() & 0xF) << 4 | position.getBlockX() & 0xF] = ForgeAdapter.adapt(biome);
        chunk.func_177427_f(true);
        return true;
    }

    @Override
    public boolean useItem(BlockVector3 position, BaseItem item, Direction face) {
        WorldEditFakePlayer fakePlayer;
        ItemStack stack = ForgeAdapter.adapt(new BaseItemStack(item.getType(), item.getNbtData(), 1));
        ServerWorld world = (ServerWorld)this.getWorld();
        try {
            fakePlayer = (WorldEditFakePlayer)((Object)fakePlayers.get((Object)world));
        }
        catch (ExecutionException ignored) {
            return false;
        }
        fakePlayer.func_184611_a(Hand.MAIN_HAND, stack);
        fakePlayer.func_70012_b(position.getBlockX(), position.getBlockY(), position.getBlockZ(), (float)face.toVector().toYaw(), (float)face.toVector().toPitch());
        BlockPos blockPos = ForgeAdapter.toBlockPos(position);
        BlockRayTraceResult rayTraceResult = new BlockRayTraceResult(ForgeAdapter.toVec3(position), ForgeAdapter.adapt(face), blockPos, false);
        ItemUseContext itemUseContext = new ItemUseContext((PlayerEntity)fakePlayer, Hand.MAIN_HAND, rayTraceResult);
        ActionResultType used = stack.func_196084_a(itemUseContext);
        if (used != ActionResultType.SUCCESS) {
            used = this.getWorld().func_180495_p(blockPos).func_215687_a((World)world, (PlayerEntity)fakePlayer, Hand.MAIN_HAND, rayTraceResult) ? ActionResultType.SUCCESS : stack.func_77973_b().func_77659_a((World)world, (PlayerEntity)fakePlayer, Hand.MAIN_HAND).func_188397_a();
        }
        return used == ActionResultType.SUCCESS;
    }

    @Override
    public void dropItem(Vector3 position, BaseItemStack item) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)item);
        if (item.getType() == ItemTypes.AIR) {
            return;
        }
        ItemEntity entity = new ItemEntity(this.getWorld(), position.getX(), position.getY(), position.getZ(), ForgeAdapter.adapt(item));
        entity.func_174867_a(10);
        this.getWorld().func_217376_c((net.minecraft.entity.Entity)entity);
    }

    @Override
    public void simulateBlockMine(BlockVector3 position) {
        BlockPos pos = ForgeAdapter.toBlockPos(position);
        this.getWorld().func_175655_b(pos, true);
    }

    @Override
    public boolean regenerate(Region region, EditSession editSession) {
        AbstractChunkProvider provider = this.getWorld().func_72863_F();
        if (!(provider instanceof ServerChunkProvider)) {
            return false;
        }
        File saveFolder = Files.createTempDir();
        saveFolder.deleteOnExit();
        try {
            ServerWorld originalWorld = (ServerWorld)this.getWorld();
            MinecraftServer server = originalWorld.func_73046_m();
            SaveHandler saveHandler = new SaveHandler(saveFolder, originalWorld.func_217485_w().func_75765_b().getName(), server, server.func_195563_aC());
            try (ServerWorld freshWorld = new ServerWorld(server, server.func_213207_aT(), saveHandler, originalWorld.func_72912_H(), originalWorld.field_73011_w.func_186058_p(), originalWorld.func_217381_Z(), (IChunkStatusListener)new NoOpChunkStatusListener());){
                CuboidRegion expandedPreGen = new CuboidRegion(region.getMinimumPoint().subtract(16, 0, 16), region.getMaximumPoint().add(16, 0, 16));
                for (BlockVector2 chunk : expandedPreGen.getChunks()) {
                    freshWorld.func_212866_a_(chunk.getBlockX(), chunk.getBlockZ());
                }
                ForgeWorld from = new ForgeWorld((World)freshWorld);
                for (BlockVector3 vec : region) {
                    editSession.setBlock(vec, from.getFullBlock(vec));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (MaxChangedBlocksException e) {
            throw new RuntimeException(e);
        }
        finally {
            saveFolder.delete();
        }
        return true;
    }

    @Nullable
    private static Feature<? extends IFeatureConfig> createTreeFeatureGenerator(TreeGenerator.TreeType type) {
        switch (type) {
            case TREE: {
                return new TreeFeature(NoFeatureConfig::func_214639_a, true);
            }
            case BIG_TREE: {
                return new BigTreeFeature(NoFeatureConfig::func_214639_a, true);
            }
            case REDWOOD: {
                return new PointyTaigaTreeFeature(NoFeatureConfig::func_214639_a);
            }
            case TALL_REDWOOD: {
                return new TallTaigaTreeFeature(NoFeatureConfig::func_214639_a, true);
            }
            case BIRCH: {
                return new BirchTreeFeature(NoFeatureConfig::func_214639_a, true, false);
            }
            case JUNGLE: {
                return new MegaJungleFeature(NoFeatureConfig::func_214639_a, true, 10, 20, JUNGLE_LOG, JUNGLE_LEAF);
            }
            case SMALL_JUNGLE: {
                return new JungleTreeFeature(NoFeatureConfig::func_214639_a, true, 4 + random.nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, false);
            }
            case SHORT_JUNGLE: {
                return new JungleTreeFeature(NoFeatureConfig::func_214639_a, true, 4 + random.nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, true);
            }
            case JUNGLE_BUSH: {
                return new ShrubFeature(NoFeatureConfig::func_214639_a, JUNGLE_LOG, JUNGLE_SHRUB);
            }
            case SWAMP: {
                return new SwampTreeFeature(NoFeatureConfig::func_214639_a);
            }
            case ACACIA: {
                return new SavannaTreeFeature(NoFeatureConfig::func_214639_a, true);
            }
            case DARK_OAK: {
                return new DarkOakTreeFeature(NoFeatureConfig::func_214639_a, true);
            }
            case MEGA_REDWOOD: {
                return new MegaPineTree(NoFeatureConfig::func_214639_a, true, random.nextBoolean());
            }
            case TALL_BIRCH: {
                return new BirchTreeFeature(NoFeatureConfig::func_214639_a, true, true);
            }
            case RED_MUSHROOM: {
                return new BigRedMushroomFeature(BigMushroomFeatureConfig::func_222853_a);
            }
            case BROWN_MUSHROOM: {
                return new BigBrownMushroomFeature(BigMushroomFeatureConfig::func_222853_a);
            }
            case RANDOM: {
                return ForgeWorld.createTreeFeatureGenerator(TreeGenerator.TreeType.values()[ThreadLocalRandom.current().nextInt(TreeGenerator.TreeType.values().length)]);
            }
        }
        return null;
    }

    private IFeatureConfig createFeatureConfig(TreeGenerator.TreeType type) {
        if (type == TreeGenerator.TreeType.RED_MUSHROOM || type == TreeGenerator.TreeType.BROWN_MUSHROOM) {
            return new BigMushroomFeatureConfig(true);
        }
        return new NoFeatureConfig();
    }

    @Override
    public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, BlockVector3 position) throws MaxChangedBlocksException {
        Feature<? extends IFeatureConfig> generator = ForgeWorld.createTreeFeatureGenerator(type);
        return generator != null && generator.func_212245_a((IWorld)this.getWorld(), this.getWorld().func_72863_F().func_201711_g(), random, ForgeAdapter.toBlockPos(position), this.createFeatureConfig(type));
    }

    @Override
    public void checkLoadedChunk(BlockVector3 pt) {
        this.getWorld().func_217349_x(ForgeAdapter.toBlockPos(pt));
    }

    @Override
    public void fixAfterFastMode(Iterable<BlockVector2> chunks) {
        this.fixLighting(chunks);
    }

    @Override
    public void fixLighting(Iterable<BlockVector2> chunks) {
        World world = this.getWorld();
        for (BlockVector2 chunk : chunks) {
            world.func_72863_F().func_212863_j_().func_215571_a(new ChunkPos(chunk.getBlockX(), chunk.getBlockZ()), true);
        }
    }

    @Override
    public boolean playEffect(Vector3 position, int type, int data) {
        this.getWorld().func_217379_c(type, ForgeAdapter.toBlockPos(position.toBlockPoint()), data);
        return true;
    }

    @Override
    public WeatherType getWeather() {
        WorldInfo info = this.getWorld().func_72912_H();
        if (info.func_76061_m()) {
            return WeatherTypes.THUNDER_STORM;
        }
        if (info.func_76059_o()) {
            return WeatherTypes.RAIN;
        }
        return WeatherTypes.CLEAR;
    }

    @Override
    public long getRemainingWeatherDuration() {
        WorldInfo info = this.getWorld().func_72912_H();
        if (info.func_76061_m()) {
            return info.func_76071_n();
        }
        if (info.func_76059_o()) {
            return info.func_76083_p();
        }
        return info.func_176133_A();
    }

    @Override
    public void setWeather(WeatherType weatherType) {
        this.setWeather(weatherType, 0L);
    }

    @Override
    public void setWeather(WeatherType weatherType, long duration) {
        WorldInfo info = this.getWorld().func_72912_H();
        if (weatherType == WeatherTypes.THUNDER_STORM) {
            info.func_176142_i(0);
            info.func_76069_a(true);
            info.func_76090_f((int)duration);
        } else if (weatherType == WeatherTypes.RAIN) {
            info.func_176142_i(0);
            info.func_76084_b(true);
            info.func_76080_g((int)duration);
        } else if (weatherType == WeatherTypes.CLEAR) {
            info.func_76084_b(false);
            info.func_76069_a(false);
            info.func_176142_i((int)duration);
        }
    }

    @Override
    public int getMaxY() {
        return this.getWorld().getMaxHeight() - 1;
    }

    @Override
    public BlockVector3 getSpawnPosition() {
        return ForgeAdapter.adapt(this.getWorld().func_175694_M());
    }

    @Override
    public BlockState getBlock(BlockVector3 position) {
        net.minecraft.block.BlockState mcState = this.getWorld().func_212866_a_(position.getBlockX() >> 4, position.getBlockZ() >> 4).func_180495_p(ForgeAdapter.toBlockPos(position));
        BlockState matchingBlock = BlockStateIdAccess.getBlockStateById(Block.func_196246_j((net.minecraft.block.BlockState)mcState));
        if (matchingBlock != null) {
            return matchingBlock;
        }
        return ForgeAdapter.adapt(mcState);
    }

    @Override
    public BaseBlock getFullBlock(BlockVector3 position) {
        BlockPos pos = new BlockPos(position.getBlockX(), position.getBlockY(), position.getBlockZ());
        TileEntity tile = this.getWorld().func_217349_x(pos).func_175625_s(pos);
        if (tile != null) {
            return this.getBlock(position).toBaseBlock(NBTConverter.fromNative(TileEntityUtils.copyNbtData(tile)));
        }
        return this.getBlock(position).toBaseBlock();
    }

    @Override
    public int hashCode() {
        return this.getWorld().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof ForgeWorld) {
            ForgeWorld other = (ForgeWorld)o;
            World otherWorld = (World)other.worldRef.get();
            World thisWorld = (World)this.worldRef.get();
            return otherWorld != null && otherWorld.equals(thisWorld);
        }
        if (o instanceof com.sk89q.worldedit.world.World) {
            return ((com.sk89q.worldedit.world.World)o).getName().equals(this.getName());
        }
        return false;
    }

    @Override
    public List<? extends Entity> getEntities(Region region) {
        World world = this.getWorld();
        if (!(world instanceof ServerWorld)) {
            return Collections.emptyList();
        }
        return ((ServerWorld)world).getEntities().filter(e -> region.contains(ForgeAdapter.adapt(e.func_180425_c()))).map(ForgeEntity::new).collect(Collectors.toList());
    }

    @Override
    public List<? extends Entity> getEntities() {
        World world = this.getWorld();
        if (!(world instanceof ServerWorld)) {
            return Collections.emptyList();
        }
        return ((ServerWorld)world).getEntities().map(ForgeEntity::new).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity entity) {
        World world = this.getWorld();
        Optional entityType = EntityType.func_220327_a((String)entity.getType().getId());
        if (!entityType.isPresent()) {
            return null;
        }
        net.minecraft.entity.Entity createdEntity = ((EntityType)entityType.get()).func_200721_a(world);
        if (createdEntity != null) {
            CompoundTag nativeTag = entity.getNbtData();
            if (nativeTag != null) {
                CompoundNBT tag = NBTConverter.toNative(entity.getNbtData());
                for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
                    tag.func_82580_o(name);
                }
                createdEntity.func_70020_e(tag);
            }
            createdEntity.func_70012_b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            world.func_217376_c(createdEntity);
            return new ForgeEntity(createdEntity);
        }
        return null;
    }

    private static class NoOpChunkStatusListener
    implements IChunkStatusListener {
        private NoOpChunkStatusListener() {
        }

        public void func_219509_a(ChunkPos chunkPos) {
        }

        public void func_219508_a(ChunkPos chunkPos, @Nullable ChunkStatus chunkStatus) {
        }

        public void func_219510_b() {
        }
    }

    private static final class WorldReferenceLostException
    extends WorldEditException {
        private WorldReferenceLostException(String message) {
            super(message);
        }
    }
}

