/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.EndTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.LongTag;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.EndNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;

final class NBTConverter {
    private NBTConverter() {
    }

    public static INBT toNative(Tag tag) {
        if (tag instanceof IntArrayTag) {
            return NBTConverter.toNative((IntArrayTag)tag);
        }
        if (tag instanceof ListTag) {
            return NBTConverter.toNative((ListTag)tag);
        }
        if (tag instanceof LongTag) {
            return NBTConverter.toNative((LongTag)tag);
        }
        if (tag instanceof StringTag) {
            return NBTConverter.toNative((StringTag)tag);
        }
        if (tag instanceof IntTag) {
            return NBTConverter.toNative((IntTag)tag);
        }
        if (tag instanceof ByteTag) {
            return NBTConverter.toNative((ByteTag)tag);
        }
        if (tag instanceof ByteArrayTag) {
            return NBTConverter.toNative((ByteArrayTag)tag);
        }
        if (tag instanceof CompoundTag) {
            return NBTConverter.toNative((CompoundTag)tag);
        }
        if (tag instanceof FloatTag) {
            return NBTConverter.toNative((FloatTag)tag);
        }
        if (tag instanceof ShortTag) {
            return NBTConverter.toNative((ShortTag)tag);
        }
        if (tag instanceof DoubleTag) {
            return NBTConverter.toNative((DoubleTag)tag);
        }
        throw new IllegalArgumentException("Can't convert tag of type " + tag.getClass().getCanonicalName());
    }

    public static IntArrayNBT toNative(IntArrayTag tag) {
        int[] value = tag.getValue();
        return new IntArrayNBT(Arrays.copyOf(value, value.length));
    }

    public static ListNBT toNative(ListTag tag) {
        ListNBT list = new ListNBT();
        Iterator iterator = tag.getValue().iterator();
        while (iterator.hasNext()) {
            Tag child = (Tag)iterator.next();
            if (child instanceof EndTag) continue;
            list.add((Object)NBTConverter.toNative(child));
        }
        return list;
    }

    public static LongNBT toNative(LongTag tag) {
        return new LongNBT(tag.getValue().longValue());
    }

    public static StringNBT toNative(StringTag tag) {
        return new StringNBT(tag.getValue());
    }

    public static IntNBT toNative(IntTag tag) {
        return new IntNBT(tag.getValue().intValue());
    }

    public static ByteNBT toNative(ByteTag tag) {
        return new ByteNBT(tag.getValue().byteValue());
    }

    public static ByteArrayNBT toNative(ByteArrayTag tag) {
        byte[] value = tag.getValue();
        return new ByteArrayNBT(Arrays.copyOf(value, value.length));
    }

    public static CompoundNBT toNative(CompoundTag tag) {
        CompoundNBT compound = new CompoundNBT();
        for (Map.Entry child : tag.getValue().entrySet()) {
            compound.func_218657_a((String)child.getKey(), NBTConverter.toNative((Tag)child.getValue()));
        }
        return compound;
    }

    public static FloatNBT toNative(FloatTag tag) {
        return new FloatNBT(tag.getValue().floatValue());
    }

    public static ShortNBT toNative(ShortTag tag) {
        return new ShortNBT(tag.getValue().shortValue());
    }

    public static DoubleNBT toNative(DoubleTag tag) {
        return new DoubleNBT(tag.getValue().doubleValue());
    }

    public static Tag fromNative(INBT other) {
        if (other instanceof IntArrayNBT) {
            return NBTConverter.fromNative((IntArrayNBT)other);
        }
        if (other instanceof ListNBT) {
            return NBTConverter.fromNative((ListNBT)other);
        }
        if (other instanceof EndNBT) {
            return NBTConverter.fromNative((EndNBT)other);
        }
        if (other instanceof LongNBT) {
            return NBTConverter.fromNative((LongNBT)other);
        }
        if (other instanceof StringNBT) {
            return NBTConverter.fromNative((StringNBT)other);
        }
        if (other instanceof IntNBT) {
            return NBTConverter.fromNative((IntNBT)other);
        }
        if (other instanceof ByteNBT) {
            return NBTConverter.fromNative((ByteNBT)other);
        }
        if (other instanceof ByteArrayNBT) {
            return NBTConverter.fromNative((ByteArrayNBT)other);
        }
        if (other instanceof CompoundNBT) {
            return NBTConverter.fromNative((CompoundNBT)other);
        }
        if (other instanceof FloatNBT) {
            return NBTConverter.fromNative((FloatNBT)other);
        }
        if (other instanceof ShortNBT) {
            return NBTConverter.fromNative((ShortNBT)other);
        }
        if (other instanceof DoubleNBT) {
            return NBTConverter.fromNative((DoubleNBT)other);
        }
        throw new IllegalArgumentException("Can't convert other of type " + other.getClass().getCanonicalName());
    }

    public static IntArrayTag fromNative(IntArrayNBT other) {
        int[] value = other.func_150302_c();
        return new IntArrayTag(Arrays.copyOf(value, value.length));
    }

    public static ListTag fromNative(ListNBT other) {
        other = other.func_74737_b();
        ArrayList<Tag> list = new ArrayList<Tag>();
        Class listClass = StringTag.class;
        int tags = other.size();
        for (int i = 0; i < tags; ++i) {
            Tag child = NBTConverter.fromNative(other.remove(0));
            list.add(child);
            listClass = child.getClass();
        }
        return new ListTag(listClass, list);
    }

    public static EndTag fromNative(EndNBT other) {
        return new EndTag();
    }

    public static LongTag fromNative(LongNBT other) {
        return new LongTag(other.func_150291_c());
    }

    public static StringTag fromNative(StringNBT other) {
        return new StringTag(other.func_150285_a_());
    }

    public static IntTag fromNative(IntNBT other) {
        return new IntTag(other.func_150287_d());
    }

    public static ByteTag fromNative(ByteNBT other) {
        return new ByteTag(other.func_150290_f());
    }

    public static ByteArrayTag fromNative(ByteArrayNBT other) {
        byte[] value = other.func_150292_c();
        return new ByteArrayTag(Arrays.copyOf(value, value.length));
    }

    public static CompoundTag fromNative(CompoundNBT other) {
        Set tags = other.func_150296_c();
        HashMap<String, Tag> map = new HashMap<String, Tag>();
        for (String tagName : tags) {
            map.put(tagName, NBTConverter.fromNative(other.func_74781_a(tagName)));
        }
        return new CompoundTag(map);
    }

    public static FloatTag fromNative(FloatNBT other) {
        return new FloatTag(other.func_150288_h());
    }

    public static ShortTag fromNative(ShortNBT other) {
        return new ShortTag(other.func_150289_e());
    }

    public static DoubleTag fromNative(DoubleNBT other) {
        return new DoubleTag(other.func_150286_g());
    }
}

