/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.math.BlockVector3;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

final class TileEntityUtils {
    private TileEntityUtils() {
    }

    private static void updateForSet(CompoundNBT tag, BlockVector3 position) {
        Preconditions.checkNotNull((Object)tag);
        Preconditions.checkNotNull((Object)position);
        tag.func_218657_a("x", (INBT)new IntNBT(position.getBlockX()));
        tag.func_218657_a("y", (INBT)new IntNBT(position.getBlockY()));
        tag.func_218657_a("z", (INBT)new IntNBT(position.getBlockZ()));
    }

    static void setTileEntity(World world, BlockVector3 position, @Nullable CompoundNBT tag) {
        if (tag != null) {
            TileEntityUtils.updateForSet(tag, position);
            TileEntity tileEntity = TileEntity.func_203403_c((CompoundNBT)tag);
            if (tileEntity != null) {
                world.func_175690_a(new BlockPos(position.getBlockX(), position.getBlockY(), position.getBlockZ()), tileEntity);
            }
        }
    }

    public static CompoundNBT copyNbtData(TileEntity tile) {
        CompoundNBT tag = new CompoundNBT();
        tile.func_189515_b(tag);
        return tag;
    }
}

