/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.collection;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.LocatedBlock;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class LocatedBlockList
implements Iterable<LocatedBlock> {
    private final Map<BlockVector3, LocatedBlock> map = new LinkedHashMap<BlockVector3, LocatedBlock>();

    public LocatedBlockList() {
    }

    public LocatedBlockList(Collection<? extends LocatedBlock> collection) {
        for (LocatedBlock locatedBlock : collection) {
            this.map.put(locatedBlock.getLocation(), locatedBlock);
        }
    }

    public void add(LocatedBlock setBlockCall) {
        Preconditions.checkNotNull((Object)setBlockCall);
        this.map.put(setBlockCall.getLocation(), setBlockCall);
    }

    public <B extends BlockStateHolder<B>> void add(BlockVector3 location, B block) {
        this.add(new LocatedBlock(location, block.toBaseBlock()));
    }

    public boolean containsLocation(BlockVector3 location) {
        return this.map.containsKey(location);
    }

    @Nullable
    public BaseBlock get(BlockVector3 location) {
        return this.map.get(location).getBlock();
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    @Override
    public Iterator<LocatedBlock> iterator() {
        return this.map.values().iterator();
    }

    public Iterator<LocatedBlock> reverseIterator() {
        ArrayList<LocatedBlock> data = new ArrayList<LocatedBlock>(this.map.values());
        Collections.reverse(data);
        return data.iterator();
    }
}

