/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.internal.expression;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.SetMultimap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.antlr.ExpressionLexer;
import com.sk89q.worldedit.antlr.ExpressionParser;
import com.sk89q.worldedit.antlr4.runtime.CharStreams;
import com.sk89q.worldedit.antlr4.runtime.CodePointCharStream;
import com.sk89q.worldedit.antlr4.runtime.CommonTokenStream;
import com.sk89q.worldedit.antlr4.runtime.misc.ParseCancellationException;
import com.sk89q.worldedit.antlr4.runtime.tree.ParseTreeWalker;
import com.sk89q.worldedit.internal.expression.CompiledExpression;
import com.sk89q.worldedit.internal.expression.EvaluationException;
import com.sk89q.worldedit.internal.expression.ExecutionData;
import com.sk89q.worldedit.internal.expression.ExpressionEnvironment;
import com.sk89q.worldedit.internal.expression.ExpressionException;
import com.sk89q.worldedit.internal.expression.ExpressionTimeoutException;
import com.sk89q.worldedit.internal.expression.ExpressionValidator;
import com.sk89q.worldedit.internal.expression.Functions;
import com.sk89q.worldedit.internal.expression.LexerErrorListener;
import com.sk89q.worldedit.internal.expression.LocalSlot;
import com.sk89q.worldedit.internal.expression.ParserErrorListener;
import com.sk89q.worldedit.internal.expression.ParserException;
import com.sk89q.worldedit.internal.expression.SlotTable;
import com.sk89q.worldedit.internal.expression.invoke.ExpressionCompiler;
import com.sk89q.worldedit.session.request.Request;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Expression {
    private static final ThreadLocal<Stack<Expression>> instance = new ThreadLocal();
    private static final ExecutorService evalThread = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("worldedit-expression-eval-%d").build());
    private final SlotTable slots = new SlotTable();
    private final List<String> providedSlots;
    private final ExpressionParser.AllStatementsContext root;
    private final SetMultimap<String, MethodHandle> functions = Functions.getFunctionMap();
    private ExpressionEnvironment environment;
    private final CompiledExpression compiledExpression;

    public static Expression compile(String expression, String ... variableNames) throws ExpressionException {
        return new Expression(expression, variableNames);
    }

    private Expression(String expression, String ... variableNames) throws ExpressionException {
        this.slots.putSlot("e", new LocalSlot.Constant(Math.E));
        this.slots.putSlot("pi", new LocalSlot.Constant(Math.PI));
        this.slots.putSlot("true", new LocalSlot.Constant(1.0));
        this.slots.putSlot("false", new LocalSlot.Constant(0.0));
        for (String variableName : variableNames) {
            this.slots.initVariable(variableName).orElseThrow(() -> new ExpressionException(-1, "Tried to overwrite identifier '" + variableName + "'"));
        }
        this.providedSlots = ImmutableList.copyOf((Object[])variableNames);
        CodePointCharStream cs = CharStreams.fromString(expression, "<input>");
        ExpressionLexer lexer = new ExpressionLexer(cs);
        lexer.removeErrorListeners();
        lexer.addErrorListener(new LexerErrorListener());
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        ExpressionParser parser = new ExpressionParser(tokens);
        parser.removeErrorListeners();
        parser.addErrorListener(new ParserErrorListener());
        try {
            this.root = parser.allStatements();
            Objects.requireNonNull(this.root, "Unable to parse root, but no exceptions?");
        }
        catch (ParseCancellationException e) {
            throw new ParserException(parser.getState(), (Throwable)e);
        }
        ParseTreeWalker.DEFAULT.walk(new ExpressionValidator(this.slots.keySet(), this.functions), this.root);
        this.compiledExpression = new ExpressionCompiler().compileExpression(this.root, this.functions);
    }

    public double evaluate(double ... values) throws EvaluationException {
        return this.evaluate(values, WorldEdit.getInstance().getConfiguration().calculationTimeout);
    }

    public double evaluate(double[] values, int timeout) throws EvaluationException {
        for (int i = 0; i < values.length; ++i) {
            String slotName = this.providedSlots.get(i);
            LocalSlot.Variable slot = this.slots.getVariable(slotName).orElseThrow(() -> new EvaluationException(-1, "Tried to assign to non-variable " + slotName + "."));
            slot.setValue(values[i]);
        }
        if (timeout < 0) {
            return this.evaluateRoot();
        }
        return this.evaluateRootTimed(timeout);
    }

    private double evaluateRootTimed(int timeout) throws EvaluationException {
        CountDownLatch startLatch = new CountDownLatch(1);
        Request request = Request.request();
        Future<Double> result = evalThread.submit(() -> {
            Request local = Request.request();
            local.setSession(request.getSession());
            local.setWorld(request.getWorld());
            local.setEditSession(request.getEditSession());
            try {
                startLatch.countDown();
                Double d = this.evaluateRoot();
                return d;
            }
            finally {
                Request.reset();
            }
        });
        try {
            startLatch.await();
            return result.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            result.cancel(true);
            throw new ExpressionTimeoutException("Calculations exceeded time limit.");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Throwables.throwIfInstanceOf((Throwable)cause, EvaluationException.class);
            Throwables.throwIfUnchecked((Throwable)cause);
            throw new RuntimeException(cause);
        }
    }

    private Double evaluateRoot() throws EvaluationException {
        this.pushInstance();
        try {
            Double d = this.compiledExpression.execute(new ExecutionData(this.slots, this.functions));
            return d;
        }
        finally {
            this.popInstance();
        }
    }

    public void optimize() {
    }

    public String toString() {
        return this.root.toString();
    }

    public SlotTable getSlots() {
        return this.slots;
    }

    public static Expression getInstance() {
        return instance.get().peek();
    }

    private void pushInstance() {
        Stack<Expression> threadLocalExprStack = instance.get();
        if (threadLocalExprStack == null) {
            threadLocalExprStack = new Stack();
            instance.set(threadLocalExprStack);
        }
        threadLocalExprStack.push(this);
    }

    private void popInstance() {
        Stack<Expression> threadLocalExprStack = instance.get();
        threadLocalExprStack.pop();
        if (threadLocalExprStack.isEmpty()) {
            instance.set(null);
        }
    }

    public ExpressionEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(ExpressionEnvironment environment) {
        this.environment = environment;
    }
}

