/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.formatting.text;

import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.format.Style;
import com.sk89q.worldedit.util.formatting.text.util.ToStringer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractComponent
implements Component {
    protected static final List<Component> EMPTY_COMPONENT_LIST = Collections.emptyList();
    protected final List<Component> children;
    protected final Style style;

    protected AbstractComponent(@NonNull List<Component> children, @NonNull Style style) {
        this.children = Collections.unmodifiableList(new ArrayList<Component>(children));
        this.style = style;
    }

    @Override
    public @NonNull List<Component> children() {
        return this.children;
    }

    @Override
    public @NonNull Style style() {
        return this.style;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractComponent)) {
            return false;
        }
        return this.equals((AbstractComponent)other);
    }

    protected boolean equals(@NonNull AbstractComponent that) {
        return Objects.equals(this.children, that.children) && Objects.equals(this.style, that.style);
    }

    public int hashCode() {
        return Objects.hash(this.children, this.style);
    }

    public @NonNull String toString() {
        LinkedHashMap<String, Object> builder = new LinkedHashMap<String, Object>();
        this.populateToString(builder);
        builder.put("children", this.children);
        builder.put("style", this.style);
        return ToStringer.toString(this, builder);
    }

    protected void populateToString(@NonNull Map<String, Object> builder) {
    }
}

