/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.io.file;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.sk89q.worldedit.util.io.file.ArchiveNioSupport;
import com.sk89q.worldedit.util.io.file.ArchiveNioSupports;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import net.java.truevfs.access.TArchiveDetector;
import net.java.truevfs.access.TPath;

public final class TrueVfsArchiveNioSupport
implements ArchiveNioSupport {
    private static final TrueVfsArchiveNioSupport INSTANCE = new TrueVfsArchiveNioSupport();
    private static final Set<String> ALLOWED_EXTENSIONS = ImmutableSet.copyOf((Iterable)Splitter.on((char)'|').split((CharSequence)TArchiveDetector.ALL.getExtensions()));

    public static TrueVfsArchiveNioSupport getInstance() {
        return INSTANCE;
    }

    private TrueVfsArchiveNioSupport() {
    }

    @Override
    public Optional<Path> tryOpenAsDir(Path archive) throws IOException {
        String fileName = archive.getFileName().toString();
        int dot = fileName.indexOf(46);
        if (dot < 0 || dot >= fileName.length() || !ALLOWED_EXTENSIONS.contains(fileName.substring(dot + 1))) {
            return Optional.empty();
        }
        TPath root = new TPath(archive).getFileSystem().getPath("/", new String[0]);
        return Optional.of(ArchiveNioSupports.skipRootSameName((Path)root, fileName.substring(0, dot)));
    }
}

