/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.piston.config;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.enginehub.piston.config.ColorConfig;
import org.enginehub.piston.config.Config;
import org.enginehub.piston.config.TextConfig;

public class ConfigHolder {
    private final Map<String, Config<?>> configs = new HashMap();

    public static ConfigHolder create() {
        return new ConfigHolder(Config.defaultInstances);
    }

    private ConfigHolder(Map<String, Config<?>> configs) {
        this.configs.putAll(configs);
    }

    public Map<String, Config<?>> getConfigs() {
        return this.configs;
    }

    public <T> Config<T> getConfig(Config<T> defaultValue) {
        Config c = this.configs.computeIfAbsent(defaultValue.getKey(), k -> defaultValue);
        return c;
    }

    public void addConfig(Config<?> config) {
        this.configs.put(config.getKey(), config);
    }

    public Component replace(Component input) {
        return this.recursiveReplace(input);
    }

    private Component recursiveReplace(Component input) {
        List<Component> replacement;
        TranslatableComponent tc;
        if (input instanceof TranslatableComponent && this.configs.containsKey((tc = (TranslatableComponent)input).key())) {
            Config<?> config = this.configs.get(tc.key());
            return config.apply(this.replaceChildren(tc.args()));
        }
        List<Component> original = input.children();
        return original == (replacement = this.replaceChildren(original)) ? input : input.children(replacement);
    }

    private List<Component> replaceChildren(List<Component> input) {
        if (input.isEmpty()) {
            return input;
        }
        ImmutableList.Builder copy = ImmutableList.builder();
        boolean modified = false;
        for (Component component : input) {
            Component replacement = this.recursiveReplace(component);
            if (replacement != component) {
                modified = true;
            }
            copy.add((Object)replacement);
        }
        return modified ? copy.build() : input;
    }

    static {
        ColorConfig.mainText();
        TextConfig.commandPrefix();
    }
}

