/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.event.platform.CommandEvent;
import com.sk89q.worldedit.event.platform.PlatformReadyEvent;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.forge.CommonProxy;
import com.sk89q.worldedit.forge.ForgeBiomeRegistry;
import com.sk89q.worldedit.forge.ForgeConfiguration;
import com.sk89q.worldedit.forge.ForgePermissionsProvider;
import com.sk89q.worldedit.forge.ForgePlatform;
import com.sk89q.worldedit.forge.ForgePlayer;
import com.sk89q.worldedit.forge.ForgeWorld;
import com.sk89q.worldedit.forge.ThreadSafeCache;
import com.sk89q.worldedit.forge.WECUIPacketHandler;
import com.sk89q.worldedit.internal.LocalWorldAdapter;
import java.io.File;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="worldedit", name="WorldEdit", version="6.1.1", acceptableRemoteVersions="*", dependencies="after:sponge")
public class ForgeWorldEdit {
    public static Logger logger;
    public static final String MOD_ID = "worldedit";
    public static final String CUI_PLUGIN_CHANNEL = "WECUI";
    private ForgePermissionsProvider provider;
    @Mod.Instance(value="worldedit")
    public static ForgeWorldEdit inst;
    @SidedProxy(serverSide="com.sk89q.worldedit.forge.CommonProxy", clientSide="com.sk89q.worldedit.forge.ClientProxy")
    public static CommonProxy proxy;
    private ForgePlatform platform;
    private ForgeConfiguration config;
    private File workingDir;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        this.workingDir = new File(event.getModConfigurationDirectory() + File.separator + MOD_ID);
        this.workingDir.mkdir();
        this.config = new ForgeConfiguration(this);
        this.config.load();
        MinecraftForge.EVENT_BUS.register((Object)ThreadSafeCache.getInstance());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        WECUIPacketHandler.init();
        proxy.registerHandlers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        logger.info("WorldEdit for Forge (version " + this.getInternalVersion() + ") is loaded");
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        if (this.platform != null) {
            logger.warn("FMLServerStartingEvent occurred when FMLServerStoppingEvent hasn't");
            WorldEdit.getInstance().getPlatformManager().unregister(this.platform);
        }
        ForgeBiomeRegistry.populate();
        this.platform = new ForgePlatform(this);
        WorldEdit.getInstance().getPlatformManager().register(this.platform);
        this.provider = Loader.isModLoaded((String)"sponge") ? new ForgePermissionsProvider.SpongePermissionsProvider() : new ForgePermissionsProvider.VanillaPermissionsProvider(this.platform);
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        WorldEdit.getInstance().getPlatformManager().unregister(this.platform);
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        WorldEdit.getInstance().getEventBus().post(new PlatformReadyEvent());
    }

    @SubscribeEvent
    public void onCommandEvent(net.minecraftforge.event.CommandEvent event) {
        if (event.sender instanceof EntityPlayerMP) {
            if (((EntityPlayerMP)event.sender).field_70170_p.field_72995_K) {
                return;
            }
            Object[] split = new String[event.parameters.length + 1];
            System.arraycopy(event.parameters, 0, split, 1, event.parameters.length);
            split[0] = event.command.func_71517_b();
            CommandEvent weEvent = new CommandEvent(this.wrap((EntityPlayerMP)event.sender), Joiner.on((String)" ").join(split));
            WorldEdit.getInstance().getEventBus().post(weEvent);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (this.platform == null) {
            return;
        }
        if (!this.platform.isHookingEvents()) {
            return;
        }
        if (event.useItem == Event.Result.DENY || event.entity.field_70170_p.field_72995_K) {
            return;
        }
        WorldEdit we = WorldEdit.getInstance();
        ForgePlayer player = this.wrap((EntityPlayerMP)event.entityPlayer);
        ForgeWorld world = this.getWorld(event.entityPlayer.field_70170_p);
        PlayerInteractEvent.Action action = event.action;
        switch (action) {
            case LEFT_CLICK_BLOCK: {
                WorldVector pos = new WorldVector((LocalWorld)LocalWorldAdapter.adapt(world), event.pos.func_177958_n(), event.pos.func_177956_o(), event.pos.func_177952_p());
                if (we.handleBlockLeftClick(player, pos)) {
                    event.setCanceled(true);
                }
                if (!we.handleArmSwing(player)) break;
                event.setCanceled(true);
                break;
            }
            case RIGHT_CLICK_BLOCK: {
                WorldVector pos = new WorldVector((LocalWorld)LocalWorldAdapter.adapt(world), event.pos.func_177958_n(), event.pos.func_177956_o(), event.pos.func_177952_p());
                if (we.handleBlockRightClick(player, pos)) {
                    event.setCanceled(true);
                }
                if (!we.handleRightClick(player)) break;
                event.setCanceled(true);
                break;
            }
            case RIGHT_CLICK_AIR: {
                if (!we.handleRightClick(player)) break;
                event.setCanceled(true);
            }
        }
    }

    public static ItemStack toForgeItemStack(BaseItemStack item) {
        ItemStack ret = new ItemStack(Item.func_150899_d((int)item.getType()), item.getAmount(), (int)item.getData());
        for (Map.Entry<Integer, Integer> entry : item.getEnchantments().entrySet()) {
            ret.func_77966_a(Enchantment.func_180306_c((int)entry.getKey()), entry.getValue().intValue());
        }
        return ret;
    }

    ForgeConfiguration getConfig() {
        return this.config;
    }

    public ForgePlayer wrap(EntityPlayerMP player) {
        Preconditions.checkNotNull((Object)player);
        return new ForgePlayer(this.platform, player);
    }

    public LocalSession getSession(EntityPlayerMP player) {
        Preconditions.checkNotNull((Object)player);
        return WorldEdit.getInstance().getSessionManager().get(this.wrap(player));
    }

    public ForgeWorld getWorld(World world) {
        Preconditions.checkNotNull((Object)world);
        return new ForgeWorld(world);
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    String getInternalVersion() {
        return ForgeWorldEdit.class.getAnnotation(Mod.class).version();
    }

    public void setPermissionsProvider(ForgePermissionsProvider provider) {
        this.provider = provider;
    }

    public ForgePermissionsProvider getPermissionsProvider() {
        return this.provider;
    }
}

