/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler;

import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.ICommandBuilderSyntax;
import exopandora.worldhandler.command.CommandWH;
import exopandora.worldhandler.command.CommandWorldHandler;
import exopandora.worldhandler.config.ConfigButcher;
import exopandora.worldhandler.config.ConfigSettings;
import exopandora.worldhandler.config.ConfigSkin;
import exopandora.worldhandler.config.ConfigSliders;
import exopandora.worldhandler.event.EventListener;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.helper.BlockHelper;
import exopandora.worldhandler.proxy.CommonProxy;
import exopandora.worldhandler.util.UtilKeyBinding;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLModDisabledEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
@Mod(modid="worldhandler", name="World Handler", acceptedMinecraftVersions="[1.12,)", version="2.2.2", canBeDeactivated=true, guiFactory="exopandora.worldhandler.gui.config.GuiFactoryWorldHandler", updateJSON="https://raw.githubusercontent.com/Exopandora/worldhandler/master/version.json", clientSideOnly=true, certificateFingerprint="d6261bb645f41db84c74f98e512c2bb43f188af2")
public class WorldHandler {
    @Mod.Instance(value="worldhandler")
    private static WorldHandler INSTANCE;
    public static KeyBinding KEY_WORLD_HANDLER;
    public static KeyBinding KEY_WORLD_HANDLER_POS1;
    public static KeyBinding KEY_WORLD_HANDLER_POS2;
    public static final ICommand COMMAND_WORLD_HANDLER;
    public static final ICommand COMMAND_WH;
    public static Configuration CONFIG;
    public static Logger LOGGER;
    public static String USERNAME;
    @SidedProxy(clientSide="exopandora.worldhandler.proxy.ClientProxy", serverSide="exopandora.worldhandler.proxy.CommonProxy")
    private static CommonProxy PROXY;
    private EventListener eventListener = new EventListener();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER = event.getModLog();
        LOGGER.info("Pre-Initialization");
        LOGGER.info("First Release on March 28 2013 - 02:29 PM CET by Exopandora");
        LOGGER.info("Latest Version: https://minecraft.curseforge.com/projects/world-handler-command-gui");
        CONFIG = new Configuration(event.getSuggestedConfigurationFile());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        LOGGER.info("Initialization");
        USERNAME = Minecraft.func_71410_x().func_110432_I().func_111285_a();
        MinecraftForge.EVENT_BUS.register((Object)this.eventListener);
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_WORLD_HANDLER);
        UtilKeyBinding.updatePosKeys();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        LOGGER.info("Post-Initialization");
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        LOGGER.info("Load-Complete");
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"World Handler", (int)2);
        bar.step("Loading Configuration Files");
        ConfigSettings.load(CONFIG);
        ConfigSkin.load(CONFIG);
        ConfigSliders.load(CONFIG);
        ConfigButcher.load(CONFIG);
        bar.step("Initializing User Interface");
        Content.registerContents();
        Category.registerCategories();
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand(COMMAND_WORLD_HANDLER);
        event.registerServerCommand(COMMAND_WH);
    }

    @Mod.EventHandler
    public void disable(FMLModDisabledEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this.eventListener);
        Minecraft.func_71410_x().field_71474_y.field_74324_K = (KeyBinding[])ArrayUtils.removeElement((Object[])Minecraft.func_71410_x().field_71474_y.field_74324_K, (Object)KEY_WORLD_HANDLER);
        if (UtilKeyBinding.arePosKeysRegistered() && ConfigSettings.arePosShortcutsEnabled()) {
            UtilKeyBinding.removePosKeys();
        }
    }

    public static void updateConfig() {
        ConfigSettings.load(CONFIG);
        ConfigSkin.load(CONFIG);
        ConfigButcher.load(CONFIG);
        ConfigSliders.load(CONFIG);
        UtilKeyBinding.updatePosKeys();
    }

    public static void sendCommand(ICommandBuilder builder) {
        WorldHandler.sendCommand(builder, false);
    }

    public static void sendCommand(ICommandBuilder builder, boolean special) {
        if (builder != null) {
            String command = builder instanceof ICommandBuilderSyntax ? ((ICommandBuilderSyntax)builder).toActualCommand() : builder.toCommand();
            LOGGER.info("Command: " + command);
            if (builder.needsCommandBlock() || special) {
                BlockHelper.setCommandBlockNearPlayer(command);
            } else {
                Minecraft.func_71410_x().field_71439_g.func_71165_d(command);
            }
        }
    }

    public static void throwError(Exception exception) {
        if (!Minecraft.func_71410_x().field_71415_G) {
            Minecraft.func_71410_x().func_147108_a(null);
            Minecraft.func_71410_x().func_71381_h();
        }
        TextComponentString name = new TextComponentString("World Handler");
        name.func_150255_a(new Style().func_150228_d(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://minecraft.curseforge.com/projects/world-handler-command-gui")));
        TextComponentTranslation message = new TextComponentTranslation("worldhandler.error.gui", new Object[]{name});
        message.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
        Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.SYSTEM, (ITextComponent)message);
        exception.printStackTrace();
    }

    static {
        KEY_WORLD_HANDLER = new KeyBinding("World Handler", 47, "key.categories.misc");
        KEY_WORLD_HANDLER_POS1 = new KeyBinding("World Handler Pos1", 24, "key.categories.misc");
        KEY_WORLD_HANDLER_POS2 = new KeyBinding("World Handler Pos2", 25, "key.categories.misc");
        COMMAND_WORLD_HANDLER = new CommandWorldHandler();
        COMMAND_WH = new CommandWH();
        USERNAME = null;
    }
}

