/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.builder;

import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.builder.CommandString;
import exopandora.worldhandler.builder.ICommandBuilderSyntax;
import exopandora.worldhandler.builder.Syntax;
import exopandora.worldhandler.builder.types.Coordinate;
import exopandora.worldhandler.builder.types.Level;
import exopandora.worldhandler.builder.types.TargetSelector;
import exopandora.worldhandler.builder.types.Type;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class CommandBuilder
implements ICommandBuilderSyntax {
    private List<Map.Entry<Syntax.SyntaxEntry, String>> command;

    public CommandBuilder() {
        this.updateSyntax(this.getSyntax());
    }

    protected void setNode(int index, String node) {
        this.set(index, node != null ? (node.isEmpty() ? null : node) : null, Type.STRING);
    }

    protected void setNode(int index, boolean node) {
        this.set(index, node, Type.BOOLEAN);
    }

    protected void setNode(int index, short node) {
        this.set(index, node, Type.SHORT);
    }

    protected void setNode(int index, byte node) {
        this.set(index, node, Type.BYTE);
    }

    protected void setNode(int index, int node) {
        this.set(index, node, Type.INT);
    }

    protected void setNode(int index, float node) {
        this.set(index, Float.valueOf(node), Type.FLOAT);
    }

    protected void setNode(int index, double node) {
        this.set(index, node, Type.DOUBLE);
    }

    protected void setNode(int index, long node) {
        this.set(index, node, Type.LONG);
    }

    protected void setNode(int index, ResourceLocation node) {
        this.set(index, node, Type.RESOURCE_LOCATION);
    }

    protected void setNode(int index, NBTTagCompound nbt) {
        this.set(index, nbt, Type.NBT);
    }

    protected void setNode(int index, Coordinate coordinate) {
        this.set(index, coordinate, Type.COORDINATE);
    }

    protected void setNode(int index, TargetSelector target) {
        this.set(index, target, Type.TARGET_SELECTOR);
    }

    protected void setNode(int index, Level level) {
        this.set(index, level, Type.LEVEL);
    }

    private void set(int index, Object value, Type type) {
        if (index < this.command.size()) {
            Syntax.SyntaxEntry entry = this.command.get(index).getKey();
            Type expected = entry.getType();
            boolean flag = expected.equals((Object)type);
            if (value != null && flag) {
                this.command.get(index).setValue(value.toString());
            } else {
                this.command.get(index).setValue(entry.toString());
                if (!flag) {
                    this.warn("set", expected, type, index);
                }
            }
        } else {
            WorldHandler.LOGGER.warn("Tried to set invalid index \"" + index + "\" for command \"" + this.getCommandName() + "\"");
        }
    }

    @Nullable
    protected String getNodeAsString(int index) {
        return (String)this.get(index, Type.STRING);
    }

    protected boolean getNodeAsBoolean(int index) {
        return (Boolean)this.get(index, Type.BOOLEAN);
    }

    protected short getNodeAsShort(int index) {
        return (Short)this.get(index, Type.SHORT);
    }

    protected byte getNodeAsByte(int index) {
        return (Byte)this.get(index, Type.BYTE);
    }

    protected int getNodeAsInt(int index) {
        return (Integer)this.get(index, Type.INT);
    }

    protected float getNodeAsFloat(int index) {
        return ((Float)this.get(index, Type.FLOAT)).floatValue();
    }

    protected double getNodeAsDouble(int index) {
        return (Double)this.get(index, Type.DOUBLE);
    }

    protected long getNodeAsLong(int index) {
        return (Long)this.get(index, Type.LONG);
    }

    protected Coordinate getNodeAsCoordinate(int index) {
        return (Coordinate)this.get(index, Type.COORDINATE);
    }

    @Nullable
    protected ResourceLocation getNodeAsResourceLocation(int index) {
        return (ResourceLocation)this.get(index, Type.RESOURCE_LOCATION);
    }

    protected TargetSelector getNodeAsTargetSelector(int index) {
        return (TargetSelector)this.get(index, Type.TARGET_SELECTOR);
    }

    @Nullable
    protected Level getNodeAsLevel(int index) {
        return (Level)this.get(index, Type.LEVEL);
    }

    @Nullable
    protected NBTTagCompound getNodeAsNBT(int index) {
        return (NBTTagCompound)this.get(index, Type.NBT);
    }

    @Nullable
    private <T> T get(int index, Type type) {
        if (index < this.command.size()) {
            Map.Entry<Syntax.SyntaxEntry, String> entry = this.command.get(index);
            Type expected = entry.getKey().getType();
            String value = entry.getValue();
            if (expected.equals((Object)type)) {
                if (value.equals(entry.getKey().toString())) {
                    return null;
                }
                return expected.parse(value);
            }
            this.warn("get", expected, type, index);
            return type.parse(value);
        }
        return null;
    }

    private void warn(String function, Type expected, Type type, int index) {
        WorldHandler.LOGGER.warn("[" + function.toUpperCase() + "] Expected \"" + (Object)((Object)expected) + "\" instead of \"" + (Object)((Object)type) + "\" at index \"" + index + "\" for command \"" + this.getCommandName() + "\"");
    }

    private boolean isDefaultEntry(Map.Entry<Syntax.SyntaxEntry, String> entry) {
        return entry.getKey().getDefault() != null ? entry.getValue().equals(entry.getKey().getDefault().toString()) : false;
    }

    protected void updateSyntax(Syntax syntax) {
        if (syntax != null) {
            this.command = syntax.getSyntaxEntries().stream().map(entry -> new AbstractMap.SimpleEntry<Syntax.SyntaxEntry, String>((Syntax.SyntaxEntry)entry, entry.toString())).collect(Collectors.toList());
        }
    }

    @Override
    public String toCommand() {
        CommandString command = new CommandString(this.getCommandName());
        for (Map.Entry<Syntax.SyntaxEntry, String> entry : this.command) {
            if (this.isDefaultEntry(entry)) {
                command.append(entry.getKey().toString());
                continue;
            }
            command.append(entry.getValue());
        }
        return command.toString();
    }

    @Override
    public String toActualCommand() {
        CommandString command = new CommandString(this.getCommandName());
        for (Map.Entry<Syntax.SyntaxEntry, String> entry : this.command) {
            if (!entry.getKey().isRequired() && (entry.getKey().toString().equals(entry.getValue()) || this.isDefaultEntry(entry))) break;
            command.append(entry.getValue());
        }
        return command.toString();
    }
}

