/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.builder.component.impl;

import exopandora.worldhandler.builder.component.IBuilderComponent;
import exopandora.worldhandler.helper.EntityHelper;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.item.EntityMinecartCommandBlock;
import net.minecraft.entity.item.EntityMinecartFurnace;
import net.minecraft.entity.item.EntityMinecartHopper;
import net.minecraft.entity.item.EntityMinecartMobSpawner;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

@SideOnly(value=Side.CLIENT)
public class ComponentSummon
implements IBuilderComponent {
    private final Random random = new Random();
    private String tag;
    private String name;
    private ResourceLocation entity;
    private boolean hasPassenger;

    public void setEntity(ResourceLocation entityName) {
        this.entity = entityName;
    }

    public ResourceLocation getEntity() {
        return this.entity;
    }

    public void setHasPassenger(boolean hasPassenger) {
        this.hasPassenger = hasPassenger;
    }

    public boolean hasPassenger() {
        return this.hasPassenger;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public NBTBase serialize() {
        if (this.name != null) {
            if (this.name.equalsIgnoreCase("Cat")) {
                this.tag = "CatType";
                return new NBTTagInt(this.random.nextInt(3) + 1);
            }
            if (this.name.equalsIgnoreCase("Farmer") || this.name.equalsIgnoreCase("Fisherman") || this.name.equalsIgnoreCase("Shepherd") || this.name.equalsIgnoreCase("Fletcher")) {
                this.tag = "Profession";
                return new NBTTagInt(0);
            }
            if (this.name.equalsIgnoreCase("Librarian") || this.name.equalsIgnoreCase("Carthographer")) {
                this.tag = "Profession";
                return new NBTTagInt(1);
            }
            if (this.name.equalsIgnoreCase("Cleric") || this.name.equalsIgnoreCase("Priest")) {
                this.tag = "Profession";
                return new NBTTagInt(2);
            }
            if (this.name.equalsIgnoreCase("Armorer") || this.name.equalsIgnoreCase("Blacksmith") || this.name.equalsIgnoreCase("WeaponSmith") || this.name.equalsIgnoreCase("ToolSmith")) {
                this.tag = "Profession";
                return new NBTTagInt(3);
            }
            if (this.name.equalsIgnoreCase("Butcher") || this.name.equalsIgnoreCase("Leatherworker")) {
                this.tag = "Profession";
                return new NBTTagInt(4);
            }
            if (this.name.equalsIgnoreCase("Nitwit")) {
                this.tag = "Profession";
                return new NBTTagInt(5);
            }
            if (this.entity != null) {
                if (this.entity.equals((Object)EntityHelper.getResourceLocation(EntityZombie.class))) {
                    if (StringUtils.containsIgnoreCase((CharSequence)this.name, (CharSequence)"Baby")) {
                        this.tag = "IsBaby";
                        return new NBTTagByte(1);
                    }
                } else if (this.entity.equals((Object)EntityHelper.getResourceLocation(EntityChicken.class))) {
                    if (StringUtils.containsIgnoreCase((CharSequence)this.name, (CharSequence)"Jockey") && !this.hasPassenger) {
                        NBTTagCompound passenger = new NBTTagCompound();
                        NBTTagList list = new NBTTagList();
                        passenger.func_74778_a("id", EntityHelper.getResourceLocation(EntityZombie.class).toString());
                        passenger.func_74757_a("IsBaby", true);
                        list.func_74742_a((NBTBase)passenger);
                        this.tag = "Passengers";
                        return list;
                    }
                } else if (this.entity.equals((Object)EntityHelper.getResourceLocation(EntitySpider.class)) && StringUtils.containsIgnoreCase((CharSequence)this.name, (CharSequence)"Jockey") && !this.hasPassenger) {
                    NBTTagCompound passenger = new NBTTagCompound();
                    NBTTagList list = new NBTTagList();
                    passenger.func_74778_a("id", EntityHelper.getResourceLocation(EntitySkeleton.class).toString());
                    list.func_74742_a((NBTBase)passenger);
                    this.tag = "Passengers";
                    return list;
                }
            }
        }
        return null;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Nullable
    public static ResourceLocation resolve(String entityName) {
        String entity = entityName.replaceAll("_| ", "");
        for (ResourceLocation location : EntityList.field_75627_a.keySet()) {
            if (!entityName.equalsIgnoreCase(I18n.func_135052_a((String)("entity." + EntityHelper.getEntityName(location) + ".name"), (Object[])new Object[0]))) continue;
            entity = location.func_110623_a();
            break;
        }
        if (entity.equalsIgnoreCase("RedCow")) {
            return EntityHelper.getResourceLocation(EntityMooshroom.class);
        }
        if (entity.equalsIgnoreCase("ChickenJockey")) {
            return EntityHelper.getResourceLocation(EntityChicken.class);
        }
        if (entity.equalsIgnoreCase("Pigman") || entity.equalsIgnoreCase("ZombiePig") || entity.equalsIgnoreCase("ZombiePigman")) {
            return EntityHelper.getResourceLocation(EntityPigZombie.class);
        }
        if (entity.equalsIgnoreCase("Wither")) {
            return EntityHelper.getResourceLocation(EntityWither.class);
        }
        if (entity.equalsIgnoreCase("Dog")) {
            return EntityHelper.getResourceLocation(EntityWolf.class);
        }
        if (entity.equalsIgnoreCase("Dragon")) {
            return EntityHelper.getResourceLocation(EntityDragon.class);
        }
        if (entity.equalsIgnoreCase("minecraft:SnowGolem")) {
            return EntityHelper.getResourceLocation(EntitySnowman.class);
        }
        if (entity.equalsIgnoreCase("Horse") || entity.equalsIgnoreCase("ZombieHorse") || entity.equalsIgnoreCase("SkeletonHorse")) {
            return EntityHelper.getResourceLocation(EntityHorse.class);
        }
        if (entity.equalsIgnoreCase("LavaCube") || entity.equalsIgnoreCase("MagmaSlime") || entity.equalsIgnoreCase("MagmaCube")) {
            return EntityHelper.getResourceLocation(EntityMagmaCube.class);
        }
        if (entity.equalsIgnoreCase("SpiderJockey")) {
            return EntityHelper.getResourceLocation(EntitySpider.class);
        }
        if (entity.equalsIgnoreCase("IronGolem")) {
            return EntityHelper.getResourceLocation(EntityIronGolem.class);
        }
        if (entity.equalsIgnoreCase("Ozelot") || entity.equals("Ocelot") || entity.equalsIgnoreCase("Cat") || entity.equalsIgnoreCase("Kitty") || entity.equalsIgnoreCase("Kitten")) {
            return EntityHelper.getResourceLocation(EntityOcelot.class);
        }
        if (entity.equalsIgnoreCase("TESTIFICATE") || entity.equalsIgnoreCase("Blacksmith") || entity.equalsIgnoreCase("Farmer") || entity.equalsIgnoreCase("Fisherman") || entity.equalsIgnoreCase("Shepherd") || entity.equalsIgnoreCase("Fletcher") || entity.equalsIgnoreCase("Librarian") || entity.equalsIgnoreCase("Cleric") || entity.equalsIgnoreCase("Priest") || entity.equalsIgnoreCase("Armorer") || entity.equalsIgnoreCase("WeaponSmith") || entity.equalsIgnoreCase("ToolSmith") || entity.equalsIgnoreCase("Butcher") || entity.equalsIgnoreCase("Leatherworker") || entity.equalsIgnoreCase("Carthographer") || entity.equalsIgnoreCase("Nitwit")) {
            return EntityHelper.getResourceLocation(EntityVillager.class);
        }
        if (entity.equalsIgnoreCase("Octopus") || entity.equalsIgnoreCase("Kraken")) {
            return EntityHelper.getResourceLocation(EntitySquid.class);
        }
        if (entity.equalsIgnoreCase("Exwife")) {
            return EntityHelper.getResourceLocation(EntityGhast.class);
        }
        if (entity.equalsIgnoreCase("TNTMinecart")) {
            return EntityHelper.getResourceLocation(EntityMinecartTNT.class);
        }
        if (entity.equalsIgnoreCase("Minecart")) {
            return EntityHelper.getResourceLocation(EntityMinecart.class);
        }
        if (entity.equalsIgnoreCase("HopperMinecart")) {
            return EntityHelper.getResourceLocation(EntityMinecartHopper.class);
        }
        if (entity.equalsIgnoreCase("ChestMinecart")) {
            return EntityHelper.getResourceLocation(EntityMinecartChest.class);
        }
        if (entity.equalsIgnoreCase("SpawnerMinecart")) {
            return EntityHelper.getResourceLocation(EntityMinecartMobSpawner.class);
        }
        if (entity.equalsIgnoreCase("FurnaceMinecart")) {
            return EntityHelper.getResourceLocation(EntityMinecartFurnace.class);
        }
        if (entity.equalsIgnoreCase("CommandBlockMinecart") || entity.equalsIgnoreCase("MinecartCommand") || entity.equalsIgnoreCase("CommandMinecart")) {
            return EntityHelper.getResourceLocation(EntityMinecartCommandBlock.class);
        }
        if (entity.equalsIgnoreCase("Wizard")) {
            return EntityHelper.getResourceLocation(EntityEvoker.class);
        }
        if (entity.equalsIgnoreCase("Johnny")) {
            return EntityHelper.getResourceLocation(EntityVindicator.class);
        }
        if (entity.equalsIgnoreCase("BabyZombie")) {
            return EntityHelper.getResourceLocation(EntityZombie.class);
        }
        if (entity == null || entity.isEmpty()) {
            return null;
        }
        return new ResourceLocation(entity);
    }
}

