/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.builder.types;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TargetSelector {
    private final Map<String, Object> values = new HashMap<String, Object>();
    private static final String REGEX = "@e\\[(.*)\\]";

    public void set(String id, Object value) {
        this.values.put(id.toLowerCase(), value);
    }

    @Nullable
    public <T> T get(String id) {
        return (T)this.values.get(id);
    }

    public Object remove(String id) {
        return this.values.remove(id.toLowerCase());
    }

    @Nonnull
    public static TargetSelector valueOf(String input) {
        if (input.matches(REGEX)) {
            // empty if block
        }
        TargetSelector result = new TargetSelector();
        for (String keys : input.replaceFirst(REGEX, "$1").split(",")) {
            String[] pair = keys.split("=");
            if (pair.length <= 1) continue;
            result.set(pair[0], pair[1]);
        }
        return new TargetSelector();
    }

    public String toString() {
        return "@e[" + String.join((CharSequence)",", this.values.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue().toString()).collect(Collectors.toList())) + "]";
    }
}

