/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.event;

import com.mojang.realmsclient.gui.ChatFormatting;
import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.command.FakeCommandHandler;
import exopandora.worldhandler.config.ConfigSettings;
import exopandora.worldhandler.gui.container.impl.GuiWorldHandlerContainer;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.helper.BlockHelper;
import exopandora.worldhandler.hud.BiomeIndicator;
import exopandora.worldhandler.util.UtilPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EventListener {
    private final FakeCommandHandler commandHandler = new FakeCommandHandler();
    private final BiomeIndicator biomeIndicator = new BiomeIndicator();

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        if (ConfigSettings.isHighlightBlocksEnabled() && Minecraft.func_71410_x().field_71441_e != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            double constant = 0.002f;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            double playerX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)Minecraft.func_71410_x().func_184121_ak();
            double playerY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)Minecraft.func_71410_x().func_184121_ak();
            double playerZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)Minecraft.func_71410_x().func_184121_ak();
            double minX = (double)Math.min(BlockHelper.getPos1().func_177958_n(), BlockHelper.getPos2().func_177958_n()) - (double)0.002f - playerX;
            double minY = (double)Math.min(BlockHelper.getPos1().func_177956_o(), BlockHelper.getPos2().func_177956_o()) - (double)0.002f - playerY;
            double minZ = (double)Math.min(BlockHelper.getPos1().func_177952_p(), BlockHelper.getPos2().func_177952_p()) - (double)0.002f - playerZ;
            double maxX = (double)Math.max(BlockHelper.getPos1().func_177958_n(), BlockHelper.getPos2().func_177958_n()) + (double)0.002f - playerX + 1.0;
            double maxY = (double)Math.max(BlockHelper.getPos1().func_177956_o(), BlockHelper.getPos2().func_177956_o()) + (double)0.002f - playerY + 1.0;
            double maxZ = (double)Math.max(BlockHelper.getPos1().func_177952_p(), BlockHelper.getPos2().func_177952_p()) + (double)0.002f - playerZ + 1.0;
            float opacity = 0.2f;
            int x = 1;
            while ((double)x < maxX - minX) {
                RenderGlobal.func_189694_a((double)minX, (double)minY, (double)minZ, (double)(minX + (double)x + (double)0.004f), (double)maxY, (double)maxZ, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2f);
                ++x;
            }
            int y = 1;
            while ((double)y < maxY - minY) {
                RenderGlobal.func_189694_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)(minY + (double)y + (double)0.004f), (double)maxZ, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2f);
                ++y;
            }
            int z = 1;
            while ((double)z < maxZ - minZ) {
                RenderGlobal.func_189694_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)(minZ + (double)z + (double)0.004f), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2f);
                ++z;
            }
            RenderGlobal.func_189695_b((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1f);
            RenderGlobal.func_189695_b((double)maxX, (double)maxY, (double)maxZ, (double)minX, (double)minY, (double)minZ, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1f);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public void clientTickEvent(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71415_G && event.phase.equals((Object)TickEvent.Phase.START) && ConfigSettings.isBiomeIndicatorEnabled()) {
            this.biomeIndicator.tick();
        }
    }

    @SubscribeEvent
    public void keyInputEvent(InputEvent.KeyInputEvent event) {
        if (WorldHandler.KEY_WORLD_HANDLER.func_151468_f()) {
            EventListener.displayGui();
        } else if (WorldHandler.KEY_WORLD_HANDLER_POS1.func_151468_f() && ConfigSettings.arePosShortcutsEnabled()) {
            BlockHelper.setPos1(BlockHelper.getFocusedBlockPos());
        } else if (WorldHandler.KEY_WORLD_HANDLER_POS2.func_151468_f() && ConfigSettings.arePosShortcutsEnabled()) {
            BlockHelper.setPos2(BlockHelper.getFocusedBlockPos());
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("worldhandler")) {
            WorldHandler.updateConfig();
        }
    }

    @SubscribeEvent
    public void clientChatEvent(ClientChatEvent event) {
        if (!Minecraft.func_71410_x().func_71356_B()) {
            this.commandHandler.tryCommand(WorldHandler.COMMAND_WORLD_HANDLER, event);
            this.commandHandler.tryCommand(WorldHandler.COMMAND_WH, event);
        }
    }

    public static void displayGui() {
        if (!UtilPlayer.canIssueCommand() && ConfigSettings.isPermissionQueryEnabled()) {
            Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)new TextComponentString(ChatFormatting.RED + I18n.func_135052_a((String)"worldhandler.permission.refused", (Object[])new Object[0])));
            Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.GAME_INFO, (ITextComponent)new TextComponentString(ChatFormatting.RED + I18n.func_135052_a((String)"worldhandler.permission.refused.change", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.config.key.settings.permission_query", (Object[])new Object[0])})));
        } else {
            try {
                if (BlockHelper.isFocusedBlockEqualTo(Blocks.field_150472_an) || BlockHelper.isFocusedBlockEqualTo(Blocks.field_150444_as)) {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWorldHandlerContainer(Contents.SIGN_EDITOR));
                } else if (BlockHelper.isFocusedBlockEqualTo(Blocks.field_150323_B)) {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWorldHandlerContainer(Contents.NOTE_EDITOR));
                } else {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWorldHandlerContainer(Contents.MAIN));
                }
            }
            catch (Exception e) {
                WorldHandler.throwError(e);
            }
        }
    }
}

