/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.format.text;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import exopandora.worldhandler.format.text.ColoredString;
import exopandora.worldhandler.format.text.FormattedString;
import exopandora.worldhandler.format.text.JsonClickEvent;
import exopandora.worldhandler.format.text.JsonSignLine;
import exopandora.worldhandler.format.text.JsonSignLineSerializer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SignText {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(JsonSignLine.class, (Object)new JsonSignLineSerializer()).create();
    private ColoredString text = new ColoredString();
    private String command;
    private final int line;

    public SignText(int line) {
        this.line = line;
    }

    public int getLine() {
        return this.line;
    }

    public ColoredString getColoredString() {
        return this.text;
    }

    public void setColoredString(ColoredString coloredString) {
        this.text = coloredString;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public boolean hasCommand() {
        return this.command != null && !this.command.isEmpty();
    }

    public String toString() {
        if (!this.text.isSpecial() && !this.hasCommand()) {
            return this.text.getText();
        }
        JsonSignLine line = new JsonSignLine(this.text);
        if (this.hasCommand()) {
            line.setClickEvent(new JsonClickEvent("run_command", FormattedString.getPreformattedString(this.command)));
        }
        return GSON.toJson((Object)line);
    }
}

