/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.button;

import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.config.ConfigSkin;
import exopandora.worldhandler.gui.button.GuiButtonWorldHandler;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiButtonKeyboard
extends GuiButtonWorldHandler {
    private static final ResourceLocation NOTE = new ResourceLocation("worldhandler", "textures/misc/note.png");
    private final Orientation orientation;
    private final float pitch;
    private boolean lastMousePressed;
    private final BlockPos pos;
    private final SoundEvent sound;
    private final Content content;
    private final Container container;

    public GuiButtonKeyboard(int id, int x, int y, int width, int height, String displayString, Orientation orientation, float pitch, Container container, Content content, BlockPos pos, SoundEvent sound) {
        super(id, x, y, width, height, displayString);
        this.orientation = orientation;
        this.pitch = pitch;
        this.pos = pos;
        this.sound = sound;
        this.content = content;
        this.container = container;
    }

    @Override
    public void func_191745_a(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.field_146125_m) {
            FontRenderer fontRenderer = minecraft.field_71466_p;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)ConfigSkin.getButtonAlpha() / 255.0f));
            minecraft.field_71446_o.func_110577_a(NOTE);
            switch (this.orientation) {
                case LEFT: {
                    this.field_146123_n = this.isHoveringLeft(mouseX, mouseY);
                    break;
                }
                case NORMAL: {
                    this.field_146123_n = this.isHoveringNormal(mouseX, mouseY);
                    break;
                }
                case RIGHT: {
                    this.field_146123_n = this.isHoveringRight(mouseX, mouseY);
                    break;
                }
                case BLACK: {
                    this.field_146123_n = this.isHoveringBlack(mouseX, mouseY);
                    break;
                }
            }
            int hoverstate = this.func_146114_a(this.field_146123_n);
            switch (this.orientation) {
                case BLACK: {
                    this.func_73729_b(this.field_146128_h, this.field_146129_i, 55 + hoverstate * -9 + 18, 0, 9, 58);
                    break;
                }
                default: {
                    int textColor = 0;
                    if (!this.field_146124_l) {
                        textColor = 0xA0A0A0;
                    } else if (this.field_146123_n) {
                        textColor = 0x8B8B8B;
                    }
                    this.func_73729_b(this.field_146128_h, this.field_146129_i, 25 + hoverstate * 15 - 15, 0, 15, 92);
                    fontRenderer.func_78276_b(this.field_146126_j, this.field_146128_h + this.field_146120_f / 2 - fontRenderer.func_78256_a(this.field_146126_j) / 2, this.field_146129_i + (this.field_146121_g - 8) / 2 + 36, textColor);
                }
            }
        }
        this.func_146119_b(minecraft, mouseX, mouseY);
    }

    private boolean isHoveringBlack(int mouseX, int mouseY) {
        return mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
    }

    private boolean isHoveringLeft(int mouseX, int mouseY) {
        return mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + 10 && mouseY < this.field_146129_i + 60 || mouseX >= this.field_146128_h && mouseY >= this.field_146129_i + 58 && mouseX < this.field_146128_h + 14 && mouseY < this.field_146129_i + 93;
    }

    private boolean isHoveringNormal(int mouseX, int mouseY) {
        return mouseX >= this.field_146128_h + 4 && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + 10 && mouseY < this.field_146129_i + 60 || mouseX >= this.field_146128_h && mouseY >= this.field_146129_i + 58 && mouseX < this.field_146128_h + 14 && mouseY < this.field_146129_i + 93;
    }

    private boolean isHoveringRight(int mouseX, int mouseY) {
        return mouseX >= this.field_146128_h + 4 && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + 14 && mouseY < this.field_146129_i + 60 || mouseX >= this.field_146128_h && mouseY >= this.field_146129_i + 58 && mouseX < this.field_146128_h + 14 && mouseY < this.field_146129_i + 93;
    }

    @Override
    public boolean func_146116_c(Minecraft minecraft, int mouseX, int mouseY) {
        switch (this.orientation) {
            case LEFT: {
                return this.field_146124_l && this.field_146125_m && this.isHoveringLeft(mouseX, mouseY);
            }
            case NORMAL: {
                return this.field_146124_l && this.field_146125_m && this.isHoveringNormal(mouseX, mouseY);
            }
            case RIGHT: {
                return this.field_146124_l && this.field_146125_m && this.isHoveringRight(mouseX, mouseY);
            }
            case BLACK: {
                return this.field_146124_l && this.field_146125_m && this.isHoveringBlack(mouseX, mouseY);
            }
        }
        return false;
    }

    protected void func_146119_b(Minecraft minecraft, int mouseX, int mouseY) {
        if (this.field_146125_m && this.lastMousePressed != this.func_146116_c(minecraft, mouseX, mouseY)) {
            if (this.func_146116_c(minecraft, mouseX, mouseY) && Mouse.isButtonDown((int)0)) {
                this.func_146113_a(minecraft.func_147118_V());
                try {
                    this.content.actionPerformed(this.container, this);
                }
                catch (Exception e) {
                    WorldHandler.throwError(e);
                }
            }
            this.lastMousePressed = this.func_146116_c(minecraft, mouseX, mouseY);
        }
    }

    public void func_146113_a(SoundHandler soundHandlerIn) {
        soundHandlerIn.func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)this.sound, (float)this.pitch));
    }

    public static enum Orientation {
        LEFT,
        NORMAL,
        RIGHT,
        BLACK;

    }
}

