/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.button;

import com.mojang.realmsclient.gui.ChatFormatting;
import exopandora.worldhandler.format.TextFormatting;
import exopandora.worldhandler.gui.button.EnumTooltip;
import exopandora.worldhandler.gui.button.GuiButtonWorldHandler;
import exopandora.worldhandler.gui.button.logic.IListButtonLogic;
import exopandora.worldhandler.gui.button.persistence.ButtonValue;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiButtonList<T>
extends GuiButtonWorldHandler {
    private final IListButtonLogic<T> logic;
    private final ButtonValue<T> persistence;
    private int mouseX;
    private int mouseY;

    public GuiButtonList(int id, int x, int y, int width, int height, Content content, IListButtonLogic<T> logic) {
        this(id, x, y, width, height, null, content, logic);
    }

    public GuiButtonList(int id, int x, int y, int width, int height, EnumTooltip tooltipType, Content content, IListButtonLogic<T> logic) {
        super(id, x, y, width, height, null, null, tooltipType);
        this.logic = logic;
        this.persistence = content.getPersistence(this.logic.getId());
        this.updatePersistenceObject();
    }

    @Override
    public void func_191745_a(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(minecraft, mouseX, mouseY);
        if (this.field_146125_m) {
            FontRenderer fontRenderer = minecraft.field_71466_p;
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.field_146126_j = this.logic.getDisplayString(this.persistence);
            if (this.field_146126_j != null && !this.field_146126_j.isEmpty()) {
                String leftArrow = this.isHoveringLeft(mouseX, mouseY) ? ChatFormatting.BOLD + "<" + ChatFormatting.RESET : "<";
                String rightArrow = this.isHoveringRight(mouseX, mouseY) ? ChatFormatting.BOLD + ">" + ChatFormatting.RESET : ">";
                int leftArrowWidth = fontRenderer.func_78256_a(leftArrow);
                int rightArrowWidth = fontRenderer.func_78256_a(rightArrow);
                int maxWidth = Math.max(0, this.field_146120_f - fontRenderer.func_78256_a("<   >"));
                int spaceWidth = fontRenderer.func_78263_a(' ');
                String display = TextFormatting.shortenString(this.field_146126_j, maxWidth, fontRenderer);
                int displayWidth = fontRenderer.func_78256_a(display);
                int yPos = this.field_146129_i + (this.field_146121_g - 8) / 2;
                this.func_73732_a(fontRenderer, display, this.field_146128_h + this.field_146120_f / 2, yPos, this.getTextColor());
                this.func_73732_a(fontRenderer, leftArrow, this.field_146128_h + this.field_146120_f / 2 - maxWidth / 2 - spaceWidth, yPos, this.getTextColor());
                this.func_73732_a(fontRenderer, rightArrow, this.field_146128_h + this.field_146120_f / 2 + maxWidth / 2 + spaceWidth, yPos, this.getTextColor());
            }
            this.isActive = true;
        }
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY, int width, int height) {
        if (this.tooltipType != null) {
            this.displayTooltip = this.logic.getTooltipString(this.persistence);
        }
        super.drawTooltip(mouseX, mouseY, width, height);
    }

    private boolean isHoveringLeft(int mouseX, int mouseY) {
        return this.isHoveringVertical(mouseY) && mouseX >= this.field_146128_h && (double)mouseX < (double)this.field_146128_h + Math.ceil(this.field_146120_f / 2);
    }

    private boolean isHoveringRight(int mouseX, int mouseY) {
        return this.isHoveringVertical(mouseY) && (double)mouseX >= (double)this.field_146128_h + Math.ceil(this.field_146120_f / 2) && mouseX < this.field_146128_h + this.field_146120_f;
    }

    private boolean isHoveringVertical(int mouseY) {
        return mouseY >= this.field_146129_i && mouseY < this.field_146129_i + this.field_146121_g;
    }

    public void actionPerformed(Container container, GuiButton button) {
        int max = this.logic.getMax() - 1;
        int index = this.persistence.getIndex();
        if (this.isHoveringLeft(this.mouseX, this.mouseY)) {
            if (GuiScreen.func_146272_n()) {
                if (index < 10) {
                    this.persistence.setIndex(max - (9 - index));
                } else {
                    this.persistence.decrementIndex(10);
                }
            } else if (index > 0) {
                this.persistence.decrementIndex();
            } else {
                this.persistence.setIndex(max);
            }
        } else if (this.isHoveringRight(this.mouseX, this.mouseY)) {
            if (GuiScreen.func_146272_n()) {
                if (index > max - 10) {
                    this.persistence.setIndex(9 - (max - index));
                } else {
                    this.persistence.incrementIndex(10);
                }
            } else if (index < max) {
                this.persistence.incrementIndex();
            } else {
                this.persistence.setIndex(0);
            }
        }
        this.updatePersistenceObject();
        this.logic.actionPerformed(container, button, this.persistence);
    }

    private void updatePersistenceObject() {
        this.persistence.setObject(this.logic.getObject(this.persistence.getIndex()));
    }

    public IListButtonLogic<T> getLogic() {
        return this.logic;
    }
}

