/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.button;

import exopandora.worldhandler.config.ConfigSkin;
import exopandora.worldhandler.gui.button.EnumIcon;
import exopandora.worldhandler.gui.button.EnumTooltip;
import exopandora.worldhandler.helper.ResourceHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiButtonWorldHandler
extends GuiButton {
    protected String displayTooltip;
    protected EnumTooltip tooltipType;
    protected EnumIcon icon;
    protected boolean isActive;

    public GuiButtonWorldHandler(int id, int x, int y, int width, int height, String displayString) {
        this(id, x, y, width, height, displayString, null, null);
    }

    public GuiButtonWorldHandler(int id, int x, int y, int width, int height, String displayString, String tooltip, EnumTooltip tooltipType) {
        this(id, x, y, width, height, displayString, tooltip, tooltipType, null);
    }

    public GuiButtonWorldHandler(int id, int x, int y, int width, int height, String displayString, EnumIcon icon) {
        this(id, x, y, width, height, displayString, null, null, icon);
    }

    public GuiButtonWorldHandler(int id, int x, int y, int width, int height, String displayString, String tooltip, EnumTooltip tooltipType, EnumIcon icon) {
        super(id, x, y, width, height, displayString);
        this.displayTooltip = tooltip;
        this.tooltipType = tooltipType;
        this.icon = icon;
    }

    public void func_191745_a(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.field_146125_m) {
            this.drawBackground(minecraft, mouseX, mouseY);
            this.func_73732_a(minecraft.field_71466_p, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, this.getTextColor());
            if (this.icon != null) {
                this.drawIcons();
            }
            this.isActive = true;
        }
    }

    protected int getTextColor() {
        int textColor = 0xE0E0E0;
        if (!this.field_146124_l) {
            textColor = 0xA0A0A0;
        } else if (this.field_146123_n) {
            textColor = 0xFFFFA0;
        }
        return textColor;
    }

    protected void drawBackground(Minecraft minecraft, int mouseX, int mouseY) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)((float)ConfigSkin.getButtonRed() / 255.0f), (float)((float)ConfigSkin.getButtonGreen() / 255.0f), (float)((float)ConfigSkin.getButtonBlue() / 255.0f), (float)((float)ConfigSkin.getButtonAlpha() / 255.0f));
        this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
        int hovered = this.func_146114_a(this.field_146123_n);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceHelper.getButtonTexture());
        if (ConfigSkin.getTextureType().equals("resourcepack")) {
            this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 46 + hovered * 20, this.field_146120_f / 2, this.field_146121_g);
            this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, 200 - this.field_146120_f / 2, 46 + hovered * 20, this.field_146120_f / 2, this.field_146121_g);
        } else {
            this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, hovered * 20, this.field_146120_f / 2, this.field_146121_g);
            this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, 200 - this.field_146120_f / 2, hovered * 20, this.field_146120_f / 2, this.field_146121_g);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawTooltip(int mouseX, int mouseY, int width, int height) {
        if (this.field_146123_n && this.displayTooltip != null) {
            int tooltipWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.displayTooltip) + 9;
            int xOffset = 12;
            int yOffset = 12;
            boolean right = mouseX + xOffset + tooltipWidth > width;
            boolean left = mouseX > tooltipWidth + xOffset;
            switch (this.tooltipType) {
                case TOP_RIGHT: {
                    this.renderTooltip(mouseX, mouseY, xOffset, -yOffset, right);
                    break;
                }
                case TOP_LEFT: {
                    this.renderTooltip(mouseX, mouseY, xOffset, -yOffset, left);
                    break;
                }
                case BOTTOM_RIGHT: {
                    this.renderTooltip(mouseX, mouseY, xOffset, yOffset, right);
                    break;
                }
                case BOTTOM_LEFT: {
                    this.renderTooltip(mouseX, mouseY, xOffset, yOffset, left);
                    break;
                }
                case RIGHT: {
                    this.renderTooltip(mouseX, mouseY, xOffset, 0, right);
                    break;
                }
                case LEFT: {
                    this.renderTooltip(mouseX, mouseY, xOffset, 0, left);
                    break;
                }
            }
        }
    }

    protected void renderTooltip(int mouseX, int mouseY, int xOffset, int yOffset, boolean left) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        GlStateManager.func_179097_i();
        String[] text = this.displayTooltip.split("\n");
        int tooltipTextWidth = 0;
        int tooltipX = mouseX + xOffset;
        int tooltipY = mouseY + yOffset;
        for (String line : text) {
            int length = fontRenderer.func_78256_a(line) + 1;
            if (length <= tooltipTextWidth) continue;
            tooltipTextWidth = length;
        }
        if (left) {
            tooltipX = mouseX - xOffset - tooltipTextWidth;
        }
        int tooltipHeight = fontRenderer.field_78288_b * text.length;
        int backgroundColor = -267386864;
        int borderColorStart = 0x505000FF;
        int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
        int zLevel = 300;
        GuiUtils.drawGradientRect((int)zLevel, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)zLevel, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)zLevel, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)zLevel, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)zLevel, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)zLevel, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((int)zLevel, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((int)zLevel, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
        GuiUtils.drawGradientRect((int)zLevel, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)borderColorEnd, (int)borderColorEnd);
        for (int x = 0; x < text.length; ++x) {
            fontRenderer.func_175063_a(text[x], (float)(tooltipX + 1), (float)(tooltipY + 1 + fontRenderer.field_78288_b * x), -1);
        }
        GlStateManager.func_179126_j();
    }

    protected void drawIcons() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceHelper.getIconTexture());
        if (this.field_146124_l) {
            if (this.field_146123_n) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)0.6f, (float)1.0f);
            } else {
                GlStateManager.func_179131_c((float)0.95f, (float)0.95f, (float)0.95f, (float)1.0f);
            }
        } else {
            GlStateManager.func_179131_c((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
        }
        this.func_73729_b(this.field_146128_h + this.field_146120_f / 2 - 4, this.field_146129_i + 6, this.icon.getX() * 8, this.icon.getY() * 8, 8, 8);
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        return super.func_146116_c(mc, mouseX, mouseY) && this.isActive;
    }
}

