/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.button;

import exopandora.worldhandler.config.ConfigSkin;
import exopandora.worldhandler.gui.button.logic.ISliderResponder;
import exopandora.worldhandler.gui.button.persistence.ButtonValue;
import exopandora.worldhandler.gui.button.persistence.SliderValue;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.helper.ResourceHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiSlider<T>
extends GuiButton {
    private boolean isMouseDown;
    private boolean isActive;
    private final Object key;
    private final String name;
    private final ISliderResponder responder;
    private final Container frame;
    private final ButtonValue<SliderValue> persistence;

    public GuiSlider(Content content, Container frame, Object key, int x, int y, int width, int height, String name, double min, double max, double start, ISliderResponder responder) {
        super(Integer.MAX_VALUE, x, y, width, height, null);
        this.frame = frame;
        this.key = key;
        this.name = name;
        this.responder = responder;
        this.persistence = content.getPersistence(key);
        this.initValues(Math.round(min), Math.round(max), Math.round(start));
        this.field_146126_j = this.getDisplayString();
    }

    private void initValues(double min, double max, double start) {
        if (this.persistence.getObject() == null) {
            if (min == max) {
                this.persistence.setObject(new SliderValue(min, max, 0.0));
            } else {
                this.persistence.setObject(new SliderValue(min, max, (start - min) / (max - min)));
            }
        } else if (this.persistence.getObject().getMin() != min || this.persistence.getObject().getMax() != max) {
            this.persistence.setObject(new SliderValue(min, max, (int)MathHelper.func_151237_a((double)this.getValue(), (double)min, (double)max)));
        }
    }

    private void setPosition(double position) {
        this.persistence.getObject().setPosition(position);
    }

    private double getPosition() {
        return this.persistence.getObject().getPosition();
    }

    private void setValue(int value) {
        this.persistence.getObject().setValue(value);
    }

    private int getValue() {
        return this.persistence.getObject().getValue();
    }

    private String getDisplayString() {
        return this.responder.getText(this.key, I18n.func_135052_a((String)this.name, (Object[])new Object[0]), this.getValue());
    }

    protected int func_146114_a(boolean mouseOver) {
        return 0;
    }

    public void func_191745_a(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)((float)ConfigSkin.getButtonRed() / 255.0f), (float)((float)ConfigSkin.getButtonGreen() / 255.0f), (float)((float)ConfigSkin.getButtonBlue() / 255.0f), (float)((float)ConfigSkin.getButtonAlpha() / 255.0f));
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceHelper.getButtonTexture());
        if (ConfigSkin.getTextureType().equals("resourcepack")) {
            this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 46, this.field_146120_f / 2, this.field_146121_g);
            this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, 200 - this.field_146120_f / 2, 46, this.field_146120_f / 2, this.field_146121_g);
        } else {
            this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 0, this.field_146120_f / 2, this.field_146121_g);
            this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, 200 - this.field_146120_f / 2, 0, this.field_146120_f / 2, this.field_146121_g);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        this.func_146119_b(minecraft, mouseX, mouseY);
    }

    private void update(int mouseX, int mouseY) {
        float sliderValue = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
        if (sliderValue < 0.0f) {
            sliderValue = 0.0f;
        }
        if (sliderValue > 1.0f) {
            sliderValue = 1.0f;
        }
        this.setPosition(sliderValue);
        this.field_146126_j = this.getDisplayString();
        this.responder.setValue(this.key, this.getValue());
    }

    public void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146125_m) {
            if (this.isMouseDown) {
                this.update(mouseX, mouseY);
            }
            int textureXOffset = ConfigSkin.getTextureType().equals("resourcepack") ? 0 : -46;
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)((float)ConfigSkin.getButtonRed() / 255.0f), (float)((float)ConfigSkin.getButtonGreen() / 255.0f), (float)((float)ConfigSkin.getButtonBlue() / 255.0f), (float)((float)ConfigSkin.getButtonAlpha() / 255.0f));
            this.func_73729_b(this.field_146128_h + (int)(this.getPosition() * (double)(this.field_146120_f - 8)), this.field_146129_i, 0, 66 + textureXOffset, 4, 20);
            this.func_73729_b(this.field_146128_h + (int)(this.getPosition() * (double)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66 + textureXOffset, 4, 20);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
            int color = 0xE0E0E0;
            if (!this.field_146124_l) {
                color = 0xA0A0A0;
            } else if (this.field_146123_n) {
                color = 0xFFFFA0;
            }
            this.func_73732_a(mc.field_71466_p, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, color);
        }
        this.isActive = true;
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (super.func_146116_c(mc, mouseX, mouseY) && this.isActive) {
            this.update(mouseX, mouseY);
            this.isMouseDown = true;
            return true;
        }
        return false;
    }

    public void func_146118_a(int mouseX, int mouseY) {
        this.isMouseDown = false;
        if (this.frame != null) {
            this.frame.func_73866_w_();
        }
    }
}

