/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.button;

import com.google.common.base.Predicate;
import com.mojang.realmsclient.gui.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiTextFieldTooltip {
    private GuiTextField textfield;
    private String display;

    public GuiTextFieldTooltip(int x, int y, int width, int height, String display) {
        this.textfield = new GuiTextField(0, Minecraft.func_71410_x().field_71466_p, x, y, width, height);
        this.textfield.func_146203_f(Integer.MAX_VALUE);
        this.display = display;
    }

    public GuiTextFieldTooltip(int x, int y, int width, int height) {
        this(x, y, width, height, null);
    }

    public void setGuiResponder(GuiPageButtonList.GuiResponder responder) {
        this.textfield.func_175207_a(responder);
    }

    public void updateCursorCounter() {
        this.textfield.func_146178_a();
    }

    public void setText(String text) {
        this.textfield.func_146180_a(text);
    }

    public String getText() {
        return this.textfield.func_146179_b();
    }

    public boolean isEmpty() {
        if (this.textfield.func_146179_b() != null) {
            return this.textfield.func_146179_b().matches("(\u00a7[a-f0-9k-or])+");
        }
        return true;
    }

    public boolean canType(char charTyped) {
        return (!this.isEmpty() || charTyped != '\b') && this.textfield.func_146206_l();
    }

    public String getSelectedText() {
        return this.textfield.func_146207_c();
    }

    public void setValidator(Predicate<String> validator) {
        this.textfield.func_175205_a(validator);
    }

    public void writeText(String text) {
        this.textfield.func_146191_b(text);
    }

    public void deleteWords(int num) {
        this.textfield.func_146177_a(num);
    }

    public void deleteFromCursor(int num) {
        this.textfield.func_146175_b(num);
    }

    public int getId() {
        return this.textfield.func_175206_d();
    }

    public int getNthWordFromCursor(int numWords) {
        return this.textfield.func_146187_c(numWords);
    }

    public int getNthWordFromPos(int n, int pos) {
        return this.textfield.func_146183_a(n, pos);
    }

    public int getNthWordFromPosWS(int n, int pos, boolean skipWs) {
        return this.textfield.func_146197_a(n, pos, skipWs);
    }

    public void moveCursorBy(int num) {
        this.textfield.func_146182_d(num);
    }

    public void setCursorPosition(int pos) {
        this.textfield.func_146190_e(pos);
    }

    public void setCursorPositionZero() {
        this.textfield.func_146196_d();
    }

    public void setCursorPositionEnd() {
        this.textfield.func_146202_e();
    }

    public boolean textboxKeyTyped(char typedChar, int keyCode) {
        return this.textfield.func_146201_a(typedChar, keyCode);
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        this.textfield.func_146192_a(mouseX, mouseY, mouseButton);
    }

    public void drawTextBox() {
        this.textfield.func_146194_f();
        if (this.textfield.func_146176_q()) {
            int y;
            int x = this.textfield.func_146181_i() ? this.textfield.field_146209_f + 4 : this.textfield.field_146209_f;
            int n = y = this.textfield.func_146181_i() ? this.textfield.field_146210_g + (this.textfield.field_146219_i - 8) / 2 : this.textfield.field_146210_g;
            if (ChatFormatting.stripFormatting((String)this.textfield.func_146179_b()).isEmpty() && !this.textfield.func_146206_l() && this.display != null) {
                Minecraft.func_71410_x().field_71466_p.func_175063_a(this.display, (float)x, (float)y, 0x7F7F7F);
            }
        }
    }

    public void setMaxStringLength(int length) {
        this.textfield.func_146203_f(length);
    }

    public int getMaxStringLength() {
        return this.textfield.func_146208_g();
    }

    public int getCursorPosition() {
        return this.textfield.func_146198_h();
    }

    public boolean getEnableBackgroundDrawing() {
        return this.textfield.func_146181_i();
    }

    public void setEnableBackgroundDrawing(boolean enableBackgroundDrawing) {
        this.textfield.func_146185_a(enableBackgroundDrawing);
    }

    public void setTextColor(int color) {
        this.textfield.func_146193_g(color);
    }

    public void setDisabledTextColour(int color) {
        this.textfield.func_146204_h(color);
    }

    public void setFocused(boolean focused) {
        this.textfield.func_146195_b(focused);
    }

    public boolean isFocused() {
        return this.textfield.func_146206_l();
    }

    public void setEnabled(boolean enabled) {
        this.textfield.func_146184_c(enabled);
    }

    public int getSelectionEnd() {
        return this.textfield.func_146186_n();
    }

    public int getWidth() {
        return this.textfield.func_146200_o();
    }

    public void setSelectionPos(int position) {
        this.textfield.func_146199_i(position);
    }

    public void setCanLoseFocus(boolean canLoseFocus) {
        this.textfield.func_146205_d(canLoseFocus);
    }

    public boolean getVisible() {
        return this.textfield.func_146176_q();
    }

    public void setVisible(boolean visible) {
        this.textfield.func_146189_e(visible);
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setPosition(int x, int y) {
        this.textfield.field_146209_f = x;
        this.textfield.field_146210_g = y;
    }

    public void setWidth(int width) {
        this.textfield.field_146218_h = width;
    }

    public void setHeight(int height) {
        this.textfield.field_146219_i = height;
    }
}

