/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.container.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.mojang.realmsclient.gui.ChatFormatting;
import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.builder.impl.BuilderDifficulty;
import exopandora.worldhandler.builder.impl.BuilderGamemode;
import exopandora.worldhandler.builder.impl.BuilderTime;
import exopandora.worldhandler.builder.impl.BuilderWeather;
import exopandora.worldhandler.builder.impl.BuilderWorldHandler;
import exopandora.worldhandler.config.ConfigSettings;
import exopandora.worldhandler.config.ConfigSkin;
import exopandora.worldhandler.format.TextFormatting;
import exopandora.worldhandler.gui.button.EnumIcon;
import exopandora.worldhandler.gui.button.EnumTooltip;
import exopandora.worldhandler.gui.button.GuiButtonTab;
import exopandora.worldhandler.gui.button.GuiButtonWorldHandler;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.element.IElement;
import exopandora.worldhandler.helper.ResourceHelper;
import exopandora.worldhandler.util.UtilRender;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiWorldHandlerContainer
extends Container {
    private final Content content;
    private final int tabSize;
    private final int bgTextureWidth = 248;
    private final int bgTextureHeight = 166;
    private final int tabDistance = 2;
    private final int tabDistanceTotal;
    private final double tabWidth;
    private final double tabHalf;
    private final double tabEpsilon;
    private final String splash = this.getSplash();
    private final List<GuiButton> finalButtons = new ArrayList<GuiButton>();
    private GuiTextFieldTooltip syntaxField;
    private GuiTextFieldTooltip nameField;
    private static final BuilderWorldHandler BUILDER_WORLD_HANDLER = new BuilderWorldHandler();

    public GuiWorldHandlerContainer(Content content) throws Exception {
        this.content = content;
        this.tabSize = this.content.getCategory().getSize();
        this.tabDistanceTotal = Math.max(this.tabSize - 1, 1) * this.tabDistance;
        this.tabWidth = (this.bgTextureWidth - this.tabDistanceTotal) / Math.max(this.tabSize, 2);
        this.tabHalf = this.tabWidth / 2.0;
        this.tabEpsilon = (double)this.bgTextureWidth - ((double)this.tabDistanceTotal + this.tabHalf * (double)Math.max(this.tabSize, 2) * 2.0);
        this.content.init(this);
    }

    public void func_73866_w_() {
        try {
            this.finalButtons.clear();
            this.elements.clear();
            this.content.onPlayerNameChanged(this.getPlayer());
            this.content.initGui(this, this.getContentX(), this.getContentY());
            for (IElement element : this.elements) {
                element.initGui(this);
            }
            int x = this.field_146294_l / 2 - 10;
            int delta = 21;
            if (ConfigSettings.areShortcutsEnabled()) {
                this.finalButtons.add(new GuiButtonWorldHandler(-1, x - 147, 0, 20, 20, null, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.time", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.time.dawn", (Object[])new Object[]{ConfigSettings.getDawn()})}), EnumTooltip.RIGHT, EnumIcon.TIME_DAWN));
                this.finalButtons.add(new GuiButtonWorldHandler(-2, x - 126, 0, 20, 20, null, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.time", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.time.noon", (Object[])new Object[]{ConfigSettings.getNoon()})}), EnumTooltip.RIGHT, EnumIcon.TIME_NOON));
                this.finalButtons.add(new GuiButtonWorldHandler(-3, x - 105, 0, 20, 20, null, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.time", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.time.sunset", (Object[])new Object[]{ConfigSettings.getSunset()})}), EnumTooltip.RIGHT, EnumIcon.TIME_SUNSET));
                this.finalButtons.add(new GuiButtonWorldHandler(-4, x - 84, 0, 20, 20, null, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.time", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.time.midnight", (Object[])new Object[]{ConfigSettings.getMidnight()})}), EnumTooltip.RIGHT, EnumIcon.TIME_MIDNIGHT));
                this.finalButtons.add(new GuiButtonWorldHandler(-5, x - 63, 0, 20, 20, null, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.weather", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.weather.clear", (Object[])new Object[0])}), EnumTooltip.RIGHT, EnumIcon.WEATHER_SUN));
                this.finalButtons.add(new GuiButtonWorldHandler(-6, x - 42, 0, 20, 20, null, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.weather", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.weather.rainy", (Object[])new Object[0])}), EnumTooltip.RIGHT, EnumIcon.WEATHER_RAIN));
                this.finalButtons.add(new GuiButtonWorldHandler(-7, x - 21, 0, 20, 20, null, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.weather", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.weather.thunder", (Object[])new Object[0])}), EnumTooltip.RIGHT, EnumIcon.WEATHER_STORM));
                this.finalButtons.add(new GuiButtonWorldHandler(-8, x - 0, 0, 20, 20, null, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.difficulty", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.difficulty.peaceful", (Object[])new Object[0])}), EnumTooltip.RIGHT, EnumIcon.DIFFICULTY_PEACEFUL));
                this.finalButtons.add(new GuiButtonWorldHandler(-9, x + 21, 0, 20, 20, null, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.difficulty", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.difficulty.easy", (Object[])new Object[0])}), EnumTooltip.RIGHT, EnumIcon.DIFFICULTY_EASY));
                this.finalButtons.add(new GuiButtonWorldHandler(-10, x + 42, 0, 20, 20, null, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.difficulty", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.difficulty.normal", (Object[])new Object[0])}), EnumTooltip.RIGHT, EnumIcon.DIFFICULTY_NORMAL));
                this.finalButtons.add(new GuiButtonWorldHandler(-11, x + 63, 0, 20, 20, null, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.difficulty", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.difficulty.hard", (Object[])new Object[0])}), EnumTooltip.RIGHT, EnumIcon.DIFFICULTY_HARD));
                this.finalButtons.add(new GuiButtonWorldHandler(-12, x + 84, 0, 20, 20, null, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.gamemode", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.gamemode.survival", (Object[])new Object[0])}), EnumTooltip.RIGHT, EnumIcon.GAMEMODE_SURVIVAL));
                this.finalButtons.add(new GuiButtonWorldHandler(-13, x + 105, 0, 20, 20, null, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.gamemode", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.gamemode.creative", (Object[])new Object[0])}), EnumTooltip.RIGHT, EnumIcon.GAMEMODE_CREATIVE));
                this.finalButtons.add(new GuiButtonWorldHandler(-14, x + 126, 0, 20, 20, null, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.gamemode", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.gamemode.adventure", (Object[])new Object[0])}), EnumTooltip.RIGHT, EnumIcon.GAMEMODE_ADVENTURE));
                this.finalButtons.add(new GuiButtonWorldHandler(-15, x + 147, 0, 20, 20, null, I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.gamemode", (Object[])new Object[]{I18n.func_135052_a((String)"gui.worldhandler.shortcuts.tooltip.gamemode.spectator", (Object[])new Object[0])}), EnumTooltip.RIGHT, EnumIcon.GAMEMODE_SPECTATOR));
            }
            if (ConfigSettings.isCommandSyntaxEnabled()) {
                this.syntaxField = new GuiTextFieldTooltip(x - 147 + 1, this.field_146295_m - 22, 312, 20);
                this.updateSyntax();
            }
            this.nameField = new GuiTextFieldTooltip(0, 0, 0, 11);
            this.nameField.setMaxStringLength(16);
            this.nameField.setText(this.getPlayer());
            this.updateNameField();
            int backgroundX = this.getBackgroundX();
            int backgroundY = this.getBackgroundY();
            this.forEachTab((index, xOffset) -> {
                Content tab = this.content.getCategory().getContent((int)index);
                if (!this.content.getActiveContent().equals(tab)) {
                    this.finalButtons.add(new GuiButtonTab(-16, (int)((double)backgroundX + xOffset), backgroundY - 20, (int)this.tabWidth + (int)Math.ceil(this.tabEpsilon / (double)this.tabSize), 21, (int)index));
                }
            });
            this.initButtons();
        }
        catch (Exception e) {
            WorldHandler.throwError(e);
        }
    }

    @Override
    public void initButtons() {
        this.field_146292_n.clear();
        this.content.initButtons(this, this.getContentX(), this.getContentY());
        if (this.finalButtons != null && !this.finalButtons.isEmpty()) {
            this.field_146292_n.addAll(this.finalButtons);
        }
        for (IElement element : this.elements) {
            element.initButtons(this);
        }
    }

    private int getContentX() {
        return (this.field_146294_l - this.bgTextureWidth) / 2 + 8 + this.getXOffset();
    }

    private int getContentY() {
        return this.field_146295_m / 2 - 50 + this.getYOffset();
    }

    private int getXOffset() {
        return 0;
    }

    private int getYOffset() {
        return ConfigSettings.areShortcutsEnabled() ? 11 : 8;
    }

    public void func_73876_c() {
        try {
            this.content.updateScreen(this);
            this.updateSyntax();
        }
        catch (Exception e) {
            WorldHandler.throwError(e);
        }
    }

    private int getBackgroundX() {
        return (this.field_146294_l - this.bgTextureWidth) / 2 + this.getXOffset();
    }

    private int getBackgroundY() {
        return (this.field_146295_m - this.bgTextureHeight) / 2 + this.getYOffset();
    }

    private int getWatchOffset() {
        return ConfigSettings.isWatchEnabled() ? 9 : 0;
    }

    private void forEachTab(BiConsumer<Integer, Double> consumer) {
        double xOffset = 0.0;
        for (int index = 0; index < this.tabSize; ++index) {
            consumer.accept(index, xOffset);
            xOffset += this.tabWidth + (double)this.tabDistance + this.tabEpsilon / (double)this.tabSize;
        }
    }

    private void updateSyntax() {
        if (ConfigSettings.isCommandSyntaxEnabled() && this.syntaxField != null && !this.syntaxField.isFocused()) {
            this.syntaxField.setValidator((Predicate<String>)Predicates.alwaysTrue());
            if (this.content.getCommandBuilder() != null) {
                this.syntaxField.setText(this.content.getCommandBuilder().toCommand());
            } else {
                this.syntaxField.setText(BUILDER_WORLD_HANDLER.toCommand());
            }
            this.syntaxField.setValidator((Predicate<String>)((Predicate)string -> string.equals(this.syntaxField.getText())));
            this.syntaxField.setCursorPositionZero();
        }
    }

    private void updateNameField() {
        int backgroundX = this.getBackgroundX();
        int backgroundY = this.getBackgroundY();
        if (WorldHandler.USERNAME.isEmpty()) {
            int width = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"gui.worldhandler.generic.edit_username", (Object[])new Object[0])) + 2;
            this.nameField.setWidth(width);
            this.nameField.setPosition(backgroundX + this.bgTextureWidth - this.getWatchOffset() - 7 - (this.field_146289_q.func_78256_a(this.content.getTitle()) + 2), backgroundY + 6);
        } else {
            int width = this.field_146289_q.func_78256_a(WorldHandler.USERNAME) + 2;
            this.nameField.setWidth(width);
            this.nameField.setPosition(backgroundX + this.bgTextureWidth - this.getWatchOffset() - 7 - width, backgroundY + 6);
            this.content.onPlayerNameChanged(WorldHandler.USERNAME);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        try {
            block1 : switch (button.field_146127_k) {
                case 1: {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)null);
                    Minecraft.func_71410_x().func_71381_h();
                    break;
                }
                case 0: {
                    if (this.content.getBackContent() != null) {
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWorldHandlerContainer(this.content.getBackContent()));
                    }
                    break;
                }
                case -1: {
                    WorldHandler.sendCommand(new BuilderTime(BuilderTime.EnumMode.SET, ConfigSettings.getDawn()));
                    break;
                }
                case -2: {
                    WorldHandler.sendCommand(new BuilderTime(BuilderTime.EnumMode.SET, ConfigSettings.getNoon()));
                    break;
                }
                case -3: {
                    WorldHandler.sendCommand(new BuilderTime(BuilderTime.EnumMode.SET, ConfigSettings.getSunset()));
                    break;
                }
                case -4: {
                    WorldHandler.sendCommand(new BuilderTime(BuilderTime.EnumMode.SET, ConfigSettings.getMidnight()));
                    break;
                }
                case -5: {
                    WorldHandler.sendCommand(new BuilderWeather(BuilderWeather.EnumWeather.CLEAR));
                    break;
                }
                case -6: {
                    WorldHandler.sendCommand(new BuilderWeather(BuilderWeather.EnumWeather.RAIN));
                    break;
                }
                case -7: {
                    WorldHandler.sendCommand(new BuilderWeather(BuilderWeather.EnumWeather.THUNDER));
                    break;
                }
                case -8: {
                    WorldHandler.sendCommand(new BuilderDifficulty(BuilderDifficulty.EnumDifficulty.PEACEFUL));
                    break;
                }
                case -9: {
                    WorldHandler.sendCommand(new BuilderDifficulty(BuilderDifficulty.EnumDifficulty.EASY));
                    break;
                }
                case -10: {
                    WorldHandler.sendCommand(new BuilderDifficulty(BuilderDifficulty.EnumDifficulty.NORMAL));
                    break;
                }
                case -11: {
                    WorldHandler.sendCommand(new BuilderDifficulty(BuilderDifficulty.EnumDifficulty.HARD));
                    break;
                }
                case -12: {
                    WorldHandler.sendCommand(new BuilderGamemode(BuilderGamemode.EnumGamemode.SURVIVAL));
                    break;
                }
                case -13: {
                    WorldHandler.sendCommand(new BuilderGamemode(BuilderGamemode.EnumGamemode.CREATIVE));
                    break;
                }
                case -14: {
                    WorldHandler.sendCommand(new BuilderGamemode(BuilderGamemode.EnumGamemode.ADVENTURE));
                    break;
                }
                case -15: {
                    WorldHandler.sendCommand(new BuilderGamemode(BuilderGamemode.EnumGamemode.SPECTATOR));
                    break;
                }
                case -16: {
                    if (button instanceof GuiButtonTab) {
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWorldHandlerContainer(this.content.getCategory().getContent(((GuiButtonTab)button).getIndex())));
                    }
                    break;
                }
                default: {
                    for (IElement element : this.elements) {
                        if (!element.actionPerformed(this, button)) continue;
                        break block1;
                    }
                    this.content.actionPerformed(this, button);
                    break;
                }
            }
        }
        catch (Exception e) {
            WorldHandler.throwError(e);
        }
    }

    private void defaultColor() {
        this.defaultColor(1.0f);
    }

    private void defaultColor(float alpha) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)((float)ConfigSkin.getBackgroundRed() / 255.0f), (float)((float)ConfigSkin.getBackgroundGreen() / 255.0f), (float)((float)ConfigSkin.getBackgroundBlue() / 255.0f), (float)(alpha * (float)ConfigSkin.getBackgroundAlpha() / 255.0f));
    }

    private void darkColor() {
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)((float)ConfigSkin.getBackgroundRed() / 255.0f - 0.3f), (float)((float)ConfigSkin.getBackgroundGreen() / 255.0f - 0.3f), (float)((float)ConfigSkin.getBackgroundBlue() / 255.0f - 0.3f), (float)((float)ConfigSkin.getBackgroundAlpha() / 255.0f));
    }

    private void bindBackground() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceHelper.getBackgroundTexture());
    }

    @Nullable
    protected String getSplash() {
        Calendar calendar = Calendar.getInstance();
        int day = calendar.get(5);
        int month = calendar.get(2) + 1;
        if (day == 12 && month == 24) {
            return "Merry X-mas!";
        }
        if (day == 1 && month == 1) {
            return "Happy new year!";
        }
        if (day == 10 && month == 31) {
            return "OOoooOOOoooo! Spooky!";
        }
        if (day == 3 && month == 28) {
            return calendar.get(1) - 2013 + " Years of World Handler!";
        }
        return null;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        try {
            int x;
            int backgroundX = this.getBackgroundX();
            int backgroundY = this.getBackgroundY();
            if (ConfigSkin.isBackgroundDrawingEnabled()) {
                super.func_146276_q_();
            }
            this.defaultColor();
            this.bindBackground();
            this.func_73729_b(backgroundX, backgroundY, 0, 0, this.bgTextureWidth, this.bgTextureHeight);
            this.forEachTab((index, xOffset) -> {
                int color;
                int fHeight;
                int yOffset;
                Content tab = this.content.getCategory().getContent((int)index);
                if (this.content.getActiveContent().equals(tab)) {
                    yOffset = -22;
                    fHeight = 25;
                    color = 0xFFFFFF;
                    this.defaultColor();
                } else {
                    yOffset = -20;
                    fHeight = 20;
                    color = 0xE0E0E0;
                    this.darkColor();
                }
                this.bindBackground();
                this.func_73729_b((int)((double)backgroundX + xOffset), backgroundY + yOffset, 0, 0, (int)Math.ceil(this.tabHalf), fHeight);
                this.func_73729_b((int)((double)backgroundX + this.tabHalf + xOffset), backgroundY + yOffset, this.bgTextureWidth - (int)Math.ceil(this.tabHalf), 0, (int)Math.ceil(this.tabHalf), fHeight);
                if (!ConfigSkin.areSharpEdgesEnabled()) {
                    if (this.content.getActiveContent().equals(tab)) {
                        int x;
                        int factor;
                        if (index < this.tabSize - 1 || this.tabSize == 1) {
                            factor = 2;
                            for (x = 0; x < factor; ++x) {
                                this.func_73729_b((int)((double)backgroundX + this.tabWidth + xOffset - (double)x - 1.0), backgroundY + x + 1, (int)(this.tabWidth - (double)x - 1.0), x + 1, x + 1, 1);
                            }
                        }
                        if (index > 0) {
                            factor = 2;
                            for (x = 0; x < factor; ++x) {
                                this.func_73729_b((int)((double)backgroundX + xOffset), backgroundY + x + 1, xOffset.intValue(), x + 1, x + 1, 1);
                            }
                        }
                        int width = (int)(this.tabWidth - 3.0);
                        int interval = 5;
                        if (index == 0) {
                            for (int x2 = 0; x2 < width; x2 += interval) {
                                this.defaultColor(1.0f - (float)x2 / ((float)width + 5.0f * (float)interval));
                                this.func_73729_b((int)((double)backgroundX + xOffset), backgroundY + yOffset + fHeight + x2 / interval, 0, fHeight, width - x2, 1);
                            }
                        }
                        if (index == this.tabSize - 1 && this.tabSize > 1) {
                            int offset = 3;
                            for (int x3 = 0; x3 < width; x3 += interval) {
                                this.defaultColor(1.0f - (float)x3 / ((float)width + 5.0f * (float)interval));
                                this.func_73729_b((int)((double)backgroundX + Math.ceil(xOffset) + (double)x3 + (double)offset), backgroundY + yOffset + fHeight + x3 / interval, this.bgTextureWidth - width + x3, fHeight, width - x3, 1);
                            }
                        }
                    } else {
                        int x;
                        int factor;
                        if (index == 0) {
                            factor = 2;
                            for (x = 0; x < factor; ++x) {
                                this.func_73729_b(backgroundX, backgroundY + x, 0, fHeight, factor - x, 1);
                            }
                        }
                        if (index == this.tabSize - 1) {
                            factor = 3;
                            for (x = 0; x < factor + 1; ++x) {
                                this.func_73729_b(backgroundX + this.bgTextureWidth - x, backgroundY + factor - x, this.bgTextureWidth - x, fHeight, x, 1);
                            }
                        }
                    }
                }
                this.func_73732_a(this.field_146289_q, ChatFormatting.UNDERLINE + tab.getTabTitle(), (int)((double)backgroundX + this.tabHalf + xOffset), backgroundY - 13, color);
            });
            this.defaultColor();
            String label = "1.12.2-2.2.2";
            int hexAlpha = 0x33000000;
            int color = ConfigSkin.getLabelColor() + 0x33000000;
            int versionWidth = this.field_146294_l - this.field_146289_q.func_78256_a("1.12.2-2.2.2") - 2;
            int versionHeight = this.field_146295_m - 10;
            this.field_146289_q.func_78276_b("1.12.2-2.2.2", versionWidth, versionHeight, color);
            int maxWidth = this.bgTextureWidth - 7 - 2 - this.field_146289_q.func_78256_a(WorldHandler.USERNAME) - 2 - this.getWatchOffset() - 7;
            this.field_146289_q.func_78276_b(TextFormatting.shortenString(this.content.getTitle(), maxWidth, this.field_146289_q), backgroundX + 7, backgroundY + 7, ConfigSkin.getLabelColor());
            if (this.content.getHeadline() != null) {
                if (this.content.getHeadline().length > 0) {
                    this.field_146289_q.func_78276_b(this.content.getHeadline()[0], backgroundX + 8, backgroundY + 22, ConfigSkin.getHeadlineColor());
                }
                if (this.content.getHeadline().length > 1) {
                    this.field_146289_q.func_78276_b(this.content.getHeadline()[1], backgroundX + 126, backgroundY + 22, ConfigSkin.getHeadlineColor());
                }
            }
            String username = WorldHandler.USERNAME.isEmpty() && !this.nameField.isFocused() ? I18n.func_135052_a((String)"gui.worldhandler.generic.edit_username", (Object[])new Object[0]) : WorldHandler.USERNAME;
            this.field_146289_q.func_78276_b(username, backgroundX + 232 - this.field_146289_q.func_78256_a(username), backgroundY + 7, ConfigSkin.getLabelColor());
            if (ConfigSettings.isWatchEnabled()) {
                int watchX = backgroundX + 233;
                int watchY = backgroundY + 5;
                UtilRender.drawWatchIntoGui((Gui)this, watchX, watchY, Minecraft.func_71410_x().field_71441_e.func_72912_H().func_76073_f(), ConfigSettings.isSmoothWatchEnabled());
                if (ConfigSettings.areTooltipsEnabled() && mouseX >= watchX && mouseX <= watchX + 9 && mouseY >= watchY && mouseY <= watchY + 9) {
                    GuiUtils.drawHoveringText(Arrays.asList(TextFormatting.getWorldTime(Minecraft.func_71410_x().field_71441_e.func_72820_D())), (int)mouseX, (int)(mouseY + 9), (int)this.field_146294_l, (int)this.field_146295_m, (int)this.field_146294_l, (FontRenderer)this.field_146289_q);
                    GlStateManager.func_179140_f();
                }
            }
            for (x = 0; x < this.field_146292_n.size(); ++x) {
                ((GuiButton)this.field_146292_n.get(x)).func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            }
            for (x = 0; x < this.field_146293_o.size(); ++x) {
                ((GuiLabel)this.field_146293_o.get(x)).func_146159_a(this.field_146297_k, mouseX, mouseY);
            }
            this.content.drawScreen(this, this.getContentX(), this.getContentY(), mouseX, mouseY, partialTicks);
            for (IElement element : this.elements) {
                element.draw();
            }
            if (ConfigSettings.isCommandSyntaxEnabled() && this.syntaxField != null) {
                this.syntaxField.drawTextBox();
            }
            if (this.splash != null) {
                GlStateManager.func_179094_E();
                RenderHelper.func_74520_c();
                GlStateManager.func_179140_f();
                GlStateManager.func_179109_b((float)(backgroundX + 212), (float)(backgroundY + 15), (float)0.0f);
                GlStateManager.func_179114_b((float)17.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                float scale = 1.1f - MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)((float)(Minecraft.func_71386_F() % 1000L) / 1000.0f * (float)Math.PI * 2.0f)) * 0.1f));
                scale = scale * 100.0f / (float)this.field_146289_q.func_78256_a(this.splash);
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                this.func_73732_a(this.field_146289_q, this.splash, 0, (int)scale, 0xFFFF00);
                GlStateManager.func_179121_F();
            }
            if (ConfigSettings.areTooltipsEnabled()) {
                for (int x2 = 0; x2 < this.field_146292_n.size(); ++x2) {
                    if (!(this.field_146292_n.get(x2) instanceof GuiButtonWorldHandler)) continue;
                    ((GuiButtonWorldHandler)((Object)this.field_146292_n.get(x2))).drawTooltip(mouseX, mouseY, this.field_146294_l, this.field_146295_m);
                }
            }
            if (mouseX >= versionWidth && mouseY >= versionHeight) {
                GuiUtils.drawHoveringText(Arrays.asList("1.12.2-2.2.2"), (int)(versionWidth - 12), (int)(versionHeight + 12), (int)(this.field_146294_l + this.field_146289_q.func_78256_a("1.12.2-2.2.2")), (int)(this.field_146295_m + 10), (int)this.field_146294_l, (FontRenderer)this.field_146289_q);
            }
        }
        catch (Exception e) {
            WorldHandler.throwError(e);
        }
    }

    protected void func_73869_a(char charTyped, int keyCode) throws IOException {
        try {
            super.func_73869_a(charTyped, keyCode);
            this.content.keyTyped(this, charTyped, keyCode);
            if (this.nameField.isFocused()) {
                this.nameField.textboxKeyTyped(charTyped, keyCode);
                WorldHandler.USERNAME = this.nameField.getText();
                this.updateNameField();
            }
            if (ConfigSettings.isCommandSyntaxEnabled() && this.syntaxField != null) {
                this.syntaxField.textboxKeyTyped(charTyped, keyCode);
            }
            for (IElement element : this.elements) {
                element.keyTyped(this, charTyped, keyCode);
            }
        }
        catch (Exception e) {
            WorldHandler.throwError(e);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        try {
            super.func_73864_a(mouseX, mouseY, mouseButton);
            this.content.mouseClicked(mouseX, mouseY, mouseButton);
            this.nameField.mouseClicked(mouseX, mouseY, mouseButton);
            if (this.nameField.isFocused()) {
                this.nameField.setCursorPositionEnd();
            }
            if (ConfigSettings.isCommandSyntaxEnabled() && this.syntaxField != null) {
                this.syntaxField.mouseClicked(mouseX, mouseY, mouseButton);
            }
            for (IElement element : this.elements) {
                element.mouseClicked(mouseX, mouseY, mouseButton);
            }
        }
        catch (Exception e) {
            WorldHandler.throwError(e);
        }
    }

    public void func_146281_b() {
        try {
            this.content.onGuiClosed();
        }
        catch (Exception e) {
            WorldHandler.throwError(e);
        }
    }

    public boolean func_73868_f() {
        return ConfigSettings.isPauseEnabled();
    }

    @Override
    public String getPlayer() {
        return WorldHandler.USERNAME;
    }
}

