/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.collect.Lists;
import com.mojang.realmsclient.gui.ChatFormatting;
import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderAdvancement;
import exopandora.worldhandler.builder.types.Type;
import exopandora.worldhandler.gui.button.EnumTooltip;
import exopandora.worldhandler.gui.button.GuiButtonList;
import exopandora.worldhandler.gui.button.GuiButtonWorldHandler;
import exopandora.worldhandler.gui.button.logic.IListButtonLogic;
import exopandora.worldhandler.gui.button.persistence.ButtonValue;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.container.impl.GuiWorldHandlerContainer;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.element.impl.ElementPageList;
import exopandora.worldhandler.gui.content.element.logic.ILogicPageList;
import exopandora.worldhandler.helper.AdvancementHelper;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ContentAdvancements
extends Content {
    private final AdvancementHelper helper = new AdvancementHelper();
    private final BuilderAdvancement builderAdvancement = new BuilderAdvancement(BuilderAdvancement.EnumMode.values()[0]);
    private GuiButtonList modeButton;
    private final List<Advancement> advancements = Lists.newArrayList((Iterable)new AdvancementManager(null).func_192780_b()).parallelStream().filter(advancement -> advancement.func_192068_c() != null).collect(Collectors.toList());

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderAdvancement;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        ElementPageList<Advancement, String> list = new ElementPageList<Advancement, String>(x, y, this.advancements, null, 114, 20, 3, this, new int[]{6, 7, 8}, new ILogicPageList<Advancement, String>(){

            @Override
            public String translate(Advancement key) {
                return I18n.func_135052_a((String)key.func_192068_c().func_192297_a().func_150260_c(), (Object[])new Object[0]);
            }

            @Override
            public void onClick(Advancement clicked) {
                ContentAdvancements.this.builderAdvancement.setAdvancement(clicked.func_192067_g());
            }

            @Override
            public String getRegistryName(Advancement key) {
                return key.func_192067_g().toString();
            }

            @Override
            public void onRegister(int id, int x, int y, int width, int height, String display, String registry, boolean enabled, Advancement value, Container container) {
                GuiButtonWorldHandler button = new GuiButtonWorldHandler(id, x, y, width, height, display, value.func_192067_g().toString(), EnumTooltip.TOP_RIGHT);
                container.add(button);
                button.field_146124_l = enabled;
            }

            @Override
            public Advancement getObject(String object) {
                ContentAdvancements.this.helper;
                return AdvancementHelper.ADVANCEMENT_MANAGER.func_192778_a(Type.parseResourceLocation(object));
            }

            @Override
            public String getId() {
                return "advancements";
            }
        });
        container.add(list);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonWorldHandler(0, x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0])));
        container.add(new GuiButtonWorldHandler(1, x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0])));
        this.modeButton = new GuiButtonList<BuilderAdvancement.EnumMode>(2, x + 118, y, 114, 20, EnumTooltip.TOP_RIGHT, this, new IListButtonLogic<BuilderAdvancement.EnumMode>(){
            private final BuilderAdvancement.EnumMode[] values = (BuilderAdvancement.EnumMode[])Arrays.stream(BuilderAdvancement.EnumMode.values()).filter(mode -> !mode.equals((Object)BuilderAdvancement.EnumMode.EVERYTHING)).toArray(BuilderAdvancement.EnumMode[]::new);

            @Override
            public void actionPerformed(Container container, GuiButton button, ButtonValue<BuilderAdvancement.EnumMode> values) {
                ContentAdvancements.this.builderAdvancement.setMode(values.getObject());
            }

            @Override
            public int getMax() {
                return this.values.length;
            }

            @Override
            public BuilderAdvancement.EnumMode getObject(int index) {
                return this.values[index];
            }

            @Override
            public String getDisplayString(ButtonValue<BuilderAdvancement.EnumMode> values) {
                return I18n.func_135052_a((String)("gui.worldhandler.advancements." + values.getObject().toString()), (Object[])new Object[0]);
            }

            @Override
            public String getId() {
                return "mode";
            }
        });
        container.add(this.modeButton);
        container.add(new GuiButtonWorldHandler(3, x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.advancements.grant", (Object[])new Object[0])));
        container.add(new GuiButtonWorldHandler(4, x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.advancements.revoke", (Object[])new Object[0])));
        container.add(new GuiButtonWorldHandler(5, x + 118, y + 72, 114, 20, ChatFormatting.RED + I18n.func_135052_a((String)"gui.worldhandler.actions.reset", (Object[])new Object[0])));
    }

    @Override
    public void actionPerformed(Container container, GuiButton button) throws Exception {
        switch (button.field_146127_k) {
            case 2: {
                this.modeButton.actionPerformed(container, button);
                container.func_73866_w_();
                break;
            }
            case 3: {
                WorldHandler.sendCommand(this.builderAdvancement.getBuilderForAction(BuilderAdvancement.EnumActionType.GRANT));
                break;
            }
            case 4: {
                WorldHandler.sendCommand(this.builderAdvancement.getBuilderForAction(BuilderAdvancement.EnumActionType.REVOKE));
                break;
            }
            case 5: {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWorldHandlerContainer(Contents.CONTINUE.withBuilder(this.builderAdvancement.getBuilder(BuilderAdvancement.EnumActionType.REVOKE, BuilderAdvancement.EnumMode.EVERYTHING)).withParent(Contents.ADVANCEMENTS)));
                break;
            }
        }
    }

    @Override
    public Category getCategory() {
        return Categories.PLAYER;
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.player.advancements", (Object[])new Object[0]);
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.player.advancements", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.ADVANCEMENTS;
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderAdvancement.setPlayer(username);
    }
}

