/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicate;
import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderButcher;
import exopandora.worldhandler.config.ConfigButcher;
import exopandora.worldhandler.gui.button.GuiButtonWorldHandler;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.config.GuiConfigWorldHandler;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.impl.abstr.ContentChild;
import exopandora.worldhandler.helper.EntityHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ContentButcher
extends ContentChild {
    private GuiTextFieldTooltip radiusField;
    private String radius;
    private final BuilderButcher builderButcher = new BuilderButcher();

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderButcher;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.radiusField = new GuiTextFieldTooltip(x + 58, y + 12, 116, 20, I18n.func_135052_a((String)"gui.worldhandler.butcher.radius", (Object[])new Object[0]));
        this.radiusField.setValidator((Predicate<String>)((Predicate)string -> string != null && string.matches("[0-9]{0,8}")));
        this.radiusField.setText(this.radius);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonWorldHandler(0, x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0])));
        container.add(new GuiButtonWorldHandler(1, x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0])));
        container.add(new GuiButtonWorldHandler(3, x + 58, y + 36, 116, 20, I18n.func_135052_a((String)"gui.worldhandler.butcher.configure", (Object[])new Object[0])));
        GuiButtonWorldHandler slaughter = new GuiButtonWorldHandler(2, x + 58, y + 60, 116, 20, I18n.func_135052_a((String)"gui.worldhandler.butcher.slaughter", (Object[])new Object[0]));
        container.add(slaughter);
        slaughter.field_146124_l = this.radius != null && !this.radius.isEmpty();
    }

    @Override
    public void actionPerformed(Container container, GuiButton button) throws Exception {
        switch (button.field_146127_k) {
            case 2: {
                for (ResourceLocation entity : EntityList.field_75627_a.keySet()) {
                    if (!ConfigButcher.getEntitiyMap().get(EntityHelper.getEntityName(entity)).booleanValue()) continue;
                    WorldHandler.sendCommand(new BuilderButcher(entity, Integer.valueOf(this.radius)));
                }
                break;
            }
            case 3: {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiConfigWorldHandler((GuiScreen)container, "butcher"));
                break;
            }
        }
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.radiusField.drawTextBox();
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.butcher", (Object[])new Object[0]);
    }

    @Override
    public void keyTyped(Container container, char typedChar, int keyCode) {
        if (this.radiusField.textboxKeyTyped(typedChar, keyCode)) {
            this.radius = this.radiusField.getText();
            if (this.radius.length() > 0) {
                this.builderButcher.setRadius(Integer.valueOf(this.radius));
            } else {
                this.builderButcher.setRadius(0);
            }
            container.initButtons();
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        this.radiusField.mouseClicked(mouseX, mouseY, mouseButton);
    }
}

