/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderClone;
import exopandora.worldhandler.builder.impl.BuilderFill;
import exopandora.worldhandler.builder.impl.BuilderWH;
import exopandora.worldhandler.gui.button.EnumTooltip;
import exopandora.worldhandler.gui.button.GuiButtonList;
import exopandora.worldhandler.gui.button.GuiButtonWorldHandler;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.button.logic.IListButtonLogic;
import exopandora.worldhandler.gui.button.persistence.ButtonValue;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.helper.BlockHelper;
import exopandora.worldhandler.helper.ResourceHelper;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ContentEditBlocks
extends Content {
    private GuiTextFieldTooltip x1Field;
    private GuiTextFieldTooltip y1Field;
    private GuiTextFieldTooltip z1Field;
    private GuiTextFieldTooltip x2Field;
    private GuiTextFieldTooltip y2Field;
    private GuiTextFieldTooltip z2Field;
    private GuiTextFieldTooltip block1Field;
    private GuiTextFieldTooltip block2Field;
    private final BuilderFill builderFill = (BuilderFill)new BuilderFill().addPositionObservers();
    private final BuilderClone builderClone = (BuilderClone)new BuilderClone().addPositionObservers();
    private final BuilderWH builderWH = new BuilderWH();
    private String block1;
    private String block2;
    private GuiButtonList cloneButton;
    private String selectedPage = "coordinates";

    @Override
    public ICommandBuilder getCommandBuilder() {
        if (this.selectedPage.equals("coordinates")) {
            return this.builderWH;
        }
        if (this.selectedPage.equals("fill") || this.selectedPage.equals("replace")) {
            return this.builderFill;
        }
        if (this.selectedPage.equals("clone")) {
            return this.builderClone;
        }
        return null;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.x1Field = new GuiTextFieldTooltip(x + 118, y, 55, 20);
        this.x1Field.setValidator(this.getCoordinatePredicate("X1"));
        this.x1Field.setText("X1: " + BlockHelper.getPos1().func_177958_n());
        this.y1Field = new GuiTextFieldTooltip(x + 118, y + 24, 55, 20);
        this.y1Field.setValidator(this.getCoordinatePredicate("Y1"));
        this.y1Field.setText("Y1: " + BlockHelper.getPos1().func_177956_o());
        this.z1Field = new GuiTextFieldTooltip(x + 118, y + 48, 55, 20);
        this.z1Field.setValidator(this.getCoordinatePredicate("Z1"));
        this.z1Field.setText("Z1: " + BlockHelper.getPos1().func_177952_p());
        this.x2Field = new GuiTextFieldTooltip(x + 118 + 59, y, 55, 20);
        this.x2Field.setValidator(this.getCoordinatePredicate("X2"));
        this.x2Field.setText("X2: " + BlockHelper.getPos2().func_177958_n());
        this.y2Field = new GuiTextFieldTooltip(x + 118 + 59, y + 24, 55, 20);
        this.y2Field.setValidator(this.getCoordinatePredicate("Y2"));
        this.y2Field.setText("Y2: " + BlockHelper.getPos2().func_177956_o());
        this.z2Field = new GuiTextFieldTooltip(x + 118 + 59, y + 48, 55, 20);
        this.z2Field.setValidator(this.getCoordinatePredicate("Z2"));
        this.z2Field.setText("Z2: " + BlockHelper.getPos2().func_177952_p());
        this.block1Field = new GuiTextFieldTooltip(x + 118, y, 114, 20, this.selectedPage.equals("fill") ? I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.fill.block_id_to_fill", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.replace.block_id_replace", (Object[])new Object[0]));
        this.block1Field.setValidator((Predicate<String>)Predicates.notNull());
        this.block1Field.setText(this.block1);
        this.block2Field = new GuiTextFieldTooltip(x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.replace.block_id_place", (Object[])new Object[0]));
        this.block2Field.setValidator((Predicate<String>)Predicates.notNull());
        this.block2Field.setText(this.block2);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonWorldHandler(0, x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0])));
        container.add(new GuiButtonWorldHandler(1, x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0])));
        GuiButtonWorldHandler button3 = new GuiButtonWorldHandler(2, x, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.coordinates", (Object[])new Object[0]));
        container.add(button3);
        GuiButtonWorldHandler button4 = new GuiButtonWorldHandler(3, x, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.fill", (Object[])new Object[0]));
        container.add(button4);
        GuiButtonWorldHandler button5 = new GuiButtonWorldHandler(4, x, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.replace", (Object[])new Object[0]));
        container.add(button5);
        GuiButtonWorldHandler button6 = new GuiButtonWorldHandler(5, x, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.clone", (Object[])new Object[0]));
        container.add(button6);
        int yOffset1 = 0;
        int yOffset2 = 0;
        int xOffset2 = 0;
        int width1 = 0;
        int width2 = 0;
        if (this.selectedPage.equals("coordinates")) {
            button3.field_146124_l = false;
            yOffset1 = 72;
            yOffset2 = 72;
            width1 = 56;
            width2 = 56;
            xOffset2 = 58;
        } else if (this.selectedPage.equals("fill")) {
            button4.field_146124_l = false;
            yOffset1 = 24;
            yOffset2 = 48;
            width1 = 114;
            width2 = 114;
            xOffset2 = 0;
            button3 = new GuiButtonWorldHandler(10, x + 118, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.fill", (Object[])new Object[0]));
            container.add(button3);
            button3.field_146124_l = ResourceHelper.isRegisteredBlock(this.builderFill.getBlock1String());
        } else if (this.selectedPage.equals("replace")) {
            button5.field_146124_l = false;
            yOffset1 = 48;
            yOffset2 = 48;
            width1 = 56;
            width2 = 56;
            xOffset2 = 58;
            button3 = new GuiButtonWorldHandler(8, x + 118, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.replace", (Object[])new Object[0]));
            container.add(button3);
            button3.field_146124_l = ResourceHelper.isRegisteredBlock(this.builderFill.getBlock1String()) && ResourceHelper.isRegisteredBlock(this.builderFill.getBlock2String());
        } else if (this.selectedPage.equals("clone")) {
            button6.field_146124_l = false;
            yOffset1 = 24;
            yOffset2 = 48;
            width1 = 114;
            width2 = 114;
            xOffset2 = 0;
            this.cloneButton = new GuiButtonList<BuilderClone.EnumMask>(9, x + 118, y, 114, 20, EnumTooltip.TOP_RIGHT, this, new IListButtonLogic<BuilderClone.EnumMask>(){

                @Override
                public void actionPerformed(Container container, GuiButton button, ButtonValue<BuilderClone.EnumMask> values) {
                    ContentEditBlocks.this.builderClone.setMask(values.getObject());
                }

                @Override
                public int getMax() {
                    return BuilderClone.EnumMask.values().length;
                }

                @Override
                public BuilderClone.EnumMask getObject(int index) {
                    return BuilderClone.EnumMask.values()[index];
                }

                @Override
                public String getDisplayString(ButtonValue<BuilderClone.EnumMask> values) {
                    return I18n.func_135052_a((String)("gui.worldhandler.edit_blocks.clone.mode." + values.getObject().toString()), (Object[])new Object[0]);
                }

                @Override
                public String getId() {
                    return "mask";
                }
            });
            container.add(this.cloneButton);
            container.add(new GuiButtonWorldHandler(11, x + 118, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.clone", (Object[])new Object[0])));
        }
        container.add(new GuiButtonWorldHandler(6, x + 118, y + yOffset1, width1, 20, I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.pos.set_pos_1", (Object[])new Object[0])));
        container.add(new GuiButtonWorldHandler(7, x + 118 + xOffset2, y + yOffset2, width2, 20, I18n.func_135052_a((String)"gui.worldhandler.edit_blocks.pos.set_pos_2", (Object[])new Object[0])));
    }

    @Override
    public void actionPerformed(Container container, GuiButton button) throws Exception {
        switch (button.field_146127_k) {
            case 2: {
                this.selectedPage = "coordinates";
                container.func_73866_w_();
                break;
            }
            case 3: {
                this.selectedPage = "fill";
                container.func_73866_w_();
                break;
            }
            case 4: {
                this.selectedPage = "replace";
                container.func_73866_w_();
                break;
            }
            case 5: {
                this.selectedPage = "clone";
                container.func_73866_w_();
                break;
            }
            case 6: {
                BlockHelper.setPos1(BlockHelper.getFocusedBlockPos());
                container.func_73866_w_();
                break;
            }
            case 7: {
                BlockHelper.setPos2(BlockHelper.getFocusedBlockPos());
                container.func_73866_w_();
                break;
            }
            case 8: {
                WorldHandler.sendCommand(this.builderFill.getBuilderForReplace());
                break;
            }
            case 9: {
                this.cloneButton.actionPerformed(container, button);
                break;
            }
            case 10: {
                WorldHandler.sendCommand(this.builderFill.getBuilderForFill());
                break;
            }
            case 11: {
                WorldHandler.sendCommand(this.builderClone);
                break;
            }
        }
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.selectedPage.equals("coordinates")) {
            this.x1Field.drawTextBox();
            this.y1Field.drawTextBox();
            this.z1Field.drawTextBox();
            this.x2Field.drawTextBox();
            this.y2Field.drawTextBox();
            this.z2Field.drawTextBox();
        } else if (this.selectedPage.equals("fill")) {
            this.block1Field.drawTextBox();
        } else if (this.selectedPage.equals("replace")) {
            this.block1Field.drawTextBox();
            this.block2Field.drawTextBox();
        }
    }

    @Override
    public void keyTyped(Container container, char typedChar, int keyCode) {
        if (this.x1Field.textboxKeyTyped(typedChar, keyCode)) {
            BlockHelper.setPos1(BlockHelper.setX(BlockHelper.getPos1(), this.filterCoordinateText(this.x1Field.getText())));
        }
        if (this.y1Field.textboxKeyTyped(typedChar, keyCode)) {
            BlockHelper.setPos1(BlockHelper.setY(BlockHelper.getPos1(), this.filterCoordinateText(this.y1Field.getText())));
        }
        if (this.z1Field.textboxKeyTyped(typedChar, keyCode)) {
            BlockHelper.setPos1(BlockHelper.setZ(BlockHelper.getPos1(), this.filterCoordinateText(this.z1Field.getText())));
        }
        if (this.x2Field.textboxKeyTyped(typedChar, keyCode)) {
            BlockHelper.setPos2(BlockHelper.setX(BlockHelper.getPos2(), this.filterCoordinateText(this.x2Field.getText())));
        }
        if (this.y2Field.textboxKeyTyped(typedChar, keyCode)) {
            BlockHelper.setPos2(BlockHelper.setY(BlockHelper.getPos2(), this.filterCoordinateText(this.y2Field.getText())));
        }
        if (this.z2Field.textboxKeyTyped(typedChar, keyCode)) {
            BlockHelper.setPos2(BlockHelper.setZ(BlockHelper.getPos2(), this.filterCoordinateText(this.z2Field.getText())));
        }
        if (this.block1Field.textboxKeyTyped(typedChar, keyCode)) {
            this.block1 = this.block1Field.getText();
            this.builderFill.setBlock1(this.block1);
            container.initButtons();
        }
        if (this.block2Field.textboxKeyTyped(typedChar, keyCode)) {
            this.block2 = this.block2Field.getText();
            this.builderFill.setBlock2(this.block2);
            container.initButtons();
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.selectedPage.equals("coordinates")) {
            this.x1Field.mouseClicked(mouseX, mouseY, mouseButton);
            this.y1Field.mouseClicked(mouseX, mouseY, mouseButton);
            this.z1Field.mouseClicked(mouseX, mouseY, mouseButton);
            this.x2Field.mouseClicked(mouseX, mouseY, mouseButton);
            this.y2Field.mouseClicked(mouseX, mouseY, mouseButton);
            this.z2Field.mouseClicked(mouseX, mouseY, mouseButton);
        } else if (this.selectedPage.equals("fill")) {
            this.block1Field.mouseClicked(mouseX, mouseY, mouseButton);
        } else if (this.selectedPage.equals("replace")) {
            this.block1Field.mouseClicked(mouseX, mouseY, mouseButton);
            this.block2Field.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    private Predicate<String> getCoordinatePredicate(String coordinate) {
        return string -> string.matches(coordinate + ": [-]?[0-9]*");
    }

    private int filterCoordinateText(String input) {
        String[] split;
        if (input != null && (split = input.split(": ", 2))[1].matches("[-]?[0-9]+")) {
            return Integer.parseInt(split[1]);
        }
        return 0;
    }

    @Override
    public Category getCategory() {
        return Categories.BLOCKS;
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.blocks.edit_blocks", (Object[])new Object[0]);
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.blocks.edit_blocks", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.EDIT_BLOCKS;
    }
}

