/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderEnchantment;
import exopandora.worldhandler.builder.types.Type;
import exopandora.worldhandler.gui.button.EnumTooltip;
import exopandora.worldhandler.gui.button.GuiButtonWorldHandler;
import exopandora.worldhandler.gui.button.GuiSlider;
import exopandora.worldhandler.gui.button.responder.SimpleResponder;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.element.impl.ElementPageList;
import exopandora.worldhandler.gui.content.element.logic.ILogicPageList;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ContentEnchantment
extends Content {
    private final BuilderEnchantment builderEnchantment = new BuilderEnchantment();

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderEnchantment;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        ElementPageList<ResourceLocation, String> enchantments = new ElementPageList<ResourceLocation, String>(x, y, new ArrayList(Enchantment.field_185264_b.func_148742_b()), null, 114, 20, 3, this, new int[]{3, 4, 5}, new ILogicPageList<ResourceLocation, String>(){

            @Override
            public String translate(ResourceLocation key) {
                return I18n.func_135052_a((String)((Enchantment)Enchantment.field_185264_b.func_82594_a((Object)key)).func_77320_a(), (Object[])new Object[0]);
            }

            @Override
            public String getRegistryName(ResourceLocation key) {
                return key.toString();
            }

            @Override
            public void onClick(ResourceLocation clicked) {
                ContentEnchantment.this.builderEnchantment.setEnchantment(clicked);
                ContentEnchantment.this.builderEnchantment.setLevel(1);
            }

            @Override
            public void onRegister(int id, int x, int y, int width, int height, String display, String registry, boolean enabled, ResourceLocation value, Container container) {
                GuiButtonWorldHandler button = new GuiButtonWorldHandler(id, x, y, width, height, display, registry, EnumTooltip.TOP_RIGHT);
                button.field_146124_l = enabled;
                container.add(button);
            }

            @Override
            public ResourceLocation getObject(String object) {
                return Type.parseResourceLocation(object);
            }

            @Override
            public String getId() {
                return "enchantments";
            }
        });
        container.add(enchantments);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonWorldHandler(0, x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0])));
        container.add(new GuiButtonWorldHandler(1, x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0])));
        container.add(new GuiSlider(this, container, "enchantment", x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.items.enchantment.level", (Object[])new Object[0]), 1.0, ((Enchantment)Enchantment.field_185264_b.func_82594_a((Object)this.builderEnchantment.getEnchantment())).func_77325_b(), 1.0, new SimpleResponder(value -> this.builderEnchantment.setLevel((int)value))));
        container.add(new GuiButtonWorldHandler(2, x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.items.enchantment.enchant", (Object[])new Object[0])));
    }

    @Override
    public void actionPerformed(Container container, GuiButton button) throws Exception {
        switch (button.field_146127_k) {
            case 2: {
                WorldHandler.sendCommand(this.builderEnchantment);
                container.func_73866_w_();
                break;
            }
        }
    }

    @Override
    public Category getCategory() {
        return Categories.ITEMS;
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.items.enchantment", (Object[])new Object[0]);
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.items.enchantment", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.ENCHANTMENT;
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderEnchantment.setPlayer(username);
    }
}

