/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderExperience;
import exopandora.worldhandler.config.ConfigSliders;
import exopandora.worldhandler.gui.button.EnumTooltip;
import exopandora.worldhandler.gui.button.GuiButtonWorldHandler;
import exopandora.worldhandler.gui.button.GuiSlider;
import exopandora.worldhandler.gui.button.responder.SimpleResponder;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ContentExperience
extends Content {
    private final BuilderExperience builderExperience = new BuilderExperience();
    private GuiButtonWorldHandler addButton;
    private GuiButtonWorldHandler removeButton;

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderExperience;
    }

    @Override
    public void init(Container container) {
        if ((double)this.builderExperience.getLevel() > ConfigSliders.getMaxExperience()) {
            this.builderExperience.setLevel((int)ConfigSliders.getMaxExperience());
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        boolean enabled;
        container.add(new GuiButtonWorldHandler(0, x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0])));
        container.add(new GuiButtonWorldHandler(1, x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0])));
        container.add(new GuiSlider(this, container, "experience", x + 58, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.title.player.experience", (Object[])new Object[0]), 0.0, ConfigSliders.getMaxExperience(), 0.0, new SimpleResponder(value -> this.builderExperience.setLevel((int)value))));
        this.addButton = new GuiButtonWorldHandler(3, x + 58, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.add", (Object[])new Object[0]));
        container.add(this.addButton);
        this.removeButton = new GuiButtonWorldHandler(4, x + 58, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.remove", (Object[])new Object[0]));
        container.add(this.removeButton);
        container.add(new GuiButtonWorldHandler(5, x + 58, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.reset", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.worldhandler.actions.set_to_0", (Object[])new Object[0]), EnumTooltip.TOP_RIGHT));
        this.addButton.field_146124_l = enabled = this.builderExperience.getLevel() > 0;
        this.removeButton.field_146124_l = enabled;
    }

    @Override
    public void updateScreen(Container container) {
        boolean enabled;
        this.addButton.field_146124_l = enabled = this.builderExperience.getLevel() > 0;
        this.removeButton.field_146124_l = enabled;
    }

    @Override
    public void actionPerformed(Container container, GuiButton button) throws Exception {
        switch (button.field_146127_k) {
            case 3: {
                WorldHandler.sendCommand(this.builderExperience);
                container.func_73866_w_();
                break;
            }
            case 4: {
                if (Minecraft.func_71410_x().field_71439_g.field_71068_ca >= this.builderExperience.getLevel()) {
                    WorldHandler.sendCommand(new BuilderExperience(-this.builderExperience.getLevel(), this.builderExperience.getPlayer()));
                    break;
                }
            }
            case 5: {
                WorldHandler.sendCommand(new BuilderExperience(-Minecraft.func_71410_x().field_71439_g.field_71068_ca, this.builderExperience.getPlayer()));
                container.func_73866_w_();
                break;
            }
        }
    }

    @Override
    public Category getCategory() {
        return Categories.PLAYER;
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.player.experience", (Object[])new Object[0]);
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.player.experience", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.EXPERIENCE;
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderExperience.setPlayer(username);
    }
}

