/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderGamerule;
import exopandora.worldhandler.gui.button.EnumTooltip;
import exopandora.worldhandler.gui.button.GuiButtonWorldHandler;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.element.impl.ElementPageList;
import exopandora.worldhandler.gui.content.element.logic.ILogicPageList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.GameRules;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ContentGamerules
extends Content {
    private GuiTextFieldTooltip valueField;
    private boolean booleanValue;
    private String value;
    private final BuilderGamerule builderGamerule = new BuilderGamerule();

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderGamerule;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.valueField = new GuiTextFieldTooltip(x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.value", (Object[])new Object[0]));
        this.valueField.setValidator((Predicate<String>)Predicates.notNull());
        this.valueField.setText(this.value);
        this.valueField.setCursorPositionEnd();
        ElementPageList<String, String> rules = new ElementPageList<String, String>(x, y, Arrays.asList(Minecraft.func_71410_x().field_71441_e.func_82736_K().func_82763_b()), null, 114, 20, 3, this, new int[]{5, 6, 7}, new ILogicPageList<String, String>(){

            @Override
            public String translate(String key) {
                String translated = I18n.func_135052_a((String)key, (Object[])new Object[0]);
                if (!translated.equals(key)) {
                    return translated;
                }
                return I18n.func_135052_a((String)("gui.worldhandler.gamerules.rule." + key), (Object[])new Object[0]);
            }

            @Override
            public void onClick(String clicked) {
                ContentGamerules.this.builderGamerule.setRule(clicked);
                ContentGamerules.this.booleanValue = Minecraft.func_71410_x().field_71441_e.func_82736_K().func_180264_a(clicked, GameRules.ValueType.BOOLEAN_VALUE);
                if (ContentGamerules.this.booleanValue) {
                    ContentGamerules.this.builderGamerule.setValue(null);
                } else {
                    ContentGamerules.this.builderGamerule.setValue(ContentGamerules.this.value);
                }
            }

            @Override
            public String getRegistryName(String key) {
                return key;
            }

            @Override
            public void onRegister(int id, int x, int y, int width, int height, String display, String registryKey, boolean enabled, String value, Container container) {
                GuiButtonWorldHandler button = new GuiButtonWorldHandler(id, x, y, width, height, display, registryKey, EnumTooltip.TOP_RIGHT);
                button.field_146124_l = enabled;
                container.add(button);
            }

            @Override
            public String getObject(String object) {
                return object;
            }

            @Override
            public String getId() {
                return "gamerules";
            }
        });
        container.add(rules);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonWorldHandler(0, x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0])));
        container.add(new GuiButtonWorldHandler(1, x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0])));
        if (this.booleanValue) {
            container.add(new GuiButtonWorldHandler(2, x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.enable", (Object[])new Object[0])));
            container.add(new GuiButtonWorldHandler(3, x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.disable", (Object[])new Object[0])));
        } else {
            container.add(new GuiButtonWorldHandler(4, x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.perform", (Object[])new Object[0])));
        }
    }

    @Override
    public void actionPerformed(Container container, GuiButton button) throws Exception {
        switch (button.field_146127_k) {
            case 2: {
                WorldHandler.sendCommand(this.builderGamerule.getBuilderForValue(String.valueOf(true)));
                break;
            }
            case 3: {
                WorldHandler.sendCommand(this.builderGamerule.getBuilderForValue(String.valueOf(false)));
                break;
            }
            case 4: {
                WorldHandler.sendCommand(this.builderGamerule);
                break;
            }
        }
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (!this.booleanValue) {
            this.valueField.drawTextBox();
        }
    }

    @Override
    public void keyTyped(Container container, char typedChar, int keyCode) {
        if (this.valueField.textboxKeyTyped(typedChar, keyCode)) {
            this.value = this.valueField.getText();
            this.builderGamerule.setValue(this.value);
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (!this.booleanValue) {
            this.valueField.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public Category getCategory() {
        return Categories.WORLD;
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.world.gamerules", (Object[])new Object[0]);
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.world.gamerules", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.GAMERULES;
    }
}

