/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderMultiCommand;
import exopandora.worldhandler.builder.impl.BuilderPotionEffect;
import exopandora.worldhandler.builder.impl.BuilderPotionItem;
import exopandora.worldhandler.config.ConfigSliders;
import exopandora.worldhandler.gui.button.EnumTooltip;
import exopandora.worldhandler.gui.button.GuiButtonWorldHandler;
import exopandora.worldhandler.gui.button.GuiSlider;
import exopandora.worldhandler.gui.button.responder.SimpleResponder;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.element.impl.ElementPageList;
import exopandora.worldhandler.gui.content.element.logic.ILogicPageList;
import exopandora.worldhandler.gui.content.impl.abstr.ContentChild;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ContentPotions
extends ContentChild {
    private int potionPage;
    private final BuilderPotionEffect builderPotion = new BuilderPotionEffect();
    private final BuilderPotionItem builderPotionItem = new BuilderPotionItem();

    @Override
    public ICommandBuilder getCommandBuilder() {
        return new BuilderMultiCommand(this.builderPotion, this.builderPotionItem);
    }

    @Override
    public void init(Container container) {
        if ((double)this.builderPotion.getAmplifier() > ConfigSliders.getMaxPotionAmplifier()) {
            this.builderPotion.setAmplifier((byte)ConfigSliders.getMaxPotionAmplifier());
        }
        for (Potion potion : this.builderPotionItem.getPotions()) {
            byte amplifier = this.builderPotionItem.getAmplifier(potion);
            if (!((double)amplifier > ConfigSliders.getMaxPotionAmplifier())) continue;
            this.builderPotionItem.setAmplifier(potion, (byte)ConfigSliders.getMaxPotionAmplifier());
        }
    }

    @Override
    public void initGui(Container container, int x, int y) {
        ElementPageList<ResourceLocation, Potion> potions = new ElementPageList<ResourceLocation, Potion>(x, y, new ArrayList(Potion.field_188414_b.func_148742_b()), null, 114, 20, 3, this, new int[]{15, 16, 17}, new ILogicPageList<ResourceLocation, Potion>(){

            @Override
            public String translate(ResourceLocation key) {
                return I18n.func_135052_a((String)((Potion)Potion.field_188414_b.func_82594_a((Object)key)).func_76393_a(), (Object[])new Object[0]);
            }

            @Override
            public void onClick(ResourceLocation clicked) {
                ContentPotions.this.builderPotion.setEffect(clicked);
            }

            @Override
            public String getRegistryName(ResourceLocation key) {
                return key.toString();
            }

            @Override
            public void onRegister(int id, int x, int y, int width, int height, String display, String registryKey, boolean enabled, ResourceLocation value, Container container) {
                GuiButtonWorldHandler button = new GuiButtonWorldHandler(id, x, y, width, height, display, registryKey, EnumTooltip.TOP_RIGHT);
                button.field_146124_l = enabled;
                container.add(button);
            }

            @Override
            public ResourceLocation getObject(Potion object) {
                if (object != null) {
                    return object.getRegistryName();
                }
                return null;
            }

            @Override
            public String getId() {
                return "potions";
            }
        });
        container.add(potions);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        GuiButtonWorldHandler button6;
        container.add(new GuiButtonWorldHandler(1, x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0])));
        container.add(new GuiButtonWorldHandler(0, x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0])));
        if (this.potionPage == 0) {
            container.add(new GuiButtonWorldHandler(5, x + 118, y + 12, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.potions.effect.give", (Object[])new Object[0])));
            container.add(new GuiButtonWorldHandler(6, x + 118, y + 36, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.potions.effect.remove", (Object[])new Object[0])));
            container.add(new GuiButtonWorldHandler(7, x + 118, y + 60, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.potions.effect.remove_all", (Object[])new Object[0])));
        } else if (this.potionPage == 1) {
            Potion potion = this.builderPotion.getEffectAsPotion();
            container.add(new GuiButtonWorldHandler(8, x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.potions.effect.ambient", (Object[])new Object[]{this.builderPotionItem.getAmbient(potion) ? I18n.func_135052_a((String)"gui.worldhandler.generic.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.worldhandler.generic.off", (Object[])new Object[0])})));
            container.add(new GuiButtonWorldHandler(9, x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.potions.effect.particles", (Object[])new Object[]{this.builderPotion.getHideParticles() ? I18n.func_135052_a((String)"gui.worldhandler.generic.off", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.worldhandler.generic.on", (Object[])new Object[0])})));
            container.add(new GuiSlider(this, container, "potions_amplifier" + potion.getRegistryName(), x + 118, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.potions.effect.amplifier", (Object[])new Object[0]), 0.0, ConfigSliders.getMaxPotionAmplifier(), 0.0, new SimpleResponder(value -> {
                this.builderPotion.setAmplifier(value.byteValue());
                this.builderPotionItem.setAmplifier(potion, value.byteValue());
            })));
        } else if (this.potionPage == 2) {
            Potion potion = this.builderPotion.getEffectAsPotion();
            container.add(new GuiSlider(this, container, "seconds" + potion.getRegistryName(), x + 118, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.potion.time.seconds", (Object[])new Object[0]), 0.0, 59.0, 0.0, new SimpleResponder(value -> {
                this.builderPotion.setSeconds((int)value);
                this.builderPotionItem.setSeconds(potion, (int)value);
            })));
            container.add(new GuiSlider(this, container, "minutes" + potion.getRegistryName(), x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.potion.time.minutes", (Object[])new Object[0]), 0.0, 59.0, 0.0, new SimpleResponder(value -> {
                this.builderPotion.setMinutes((int)value);
                this.builderPotionItem.setMinutes(potion, (int)value);
            })));
            container.add(new GuiSlider(this, container, "hours" + potion.getRegistryName(), x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.potion.time.hours", (Object[])new Object[0]), 0.0, 99.0, 0.0, new SimpleResponder(value -> {
                this.builderPotion.setHours((int)value);
                this.builderPotionItem.setHours(potion, (int)value);
            })));
        } else if (this.potionPage == 3) {
            boolean enabled;
            button6 = new GuiButtonWorldHandler(10, x + 118, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.potions.effect", (Object[])new Object[0]));
            container.add(button6);
            GuiButtonWorldHandler button7 = new GuiButtonWorldHandler(14, x + 118, y + 24, 56, 20, I18n.func_135052_a((String)"gui.worldhandler.potions.effect.tipped_arrow", (Object[])new Object[0]));
            container.add(button7);
            GuiButtonWorldHandler button8 = new GuiButtonWorldHandler(11, x + 178, y + 24, 55, 20, I18n.func_135052_a((String)"gui.worldhandler.potions.effect.bottle", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.worldhandler.actions.place_command_block", (Object[])new Object[0]), EnumTooltip.TOP_RIGHT);
            container.add(button8);
            GuiButtonWorldHandler button9 = new GuiButtonWorldHandler(13, x + 118, y + 48, 56, 20, I18n.func_135052_a((String)"gui.worldhandler.potions.effect.splash", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.worldhandler.actions.place_command_block", (Object[])new Object[0]), EnumTooltip.TOP_RIGHT);
            container.add(button9);
            GuiButtonWorldHandler button10 = new GuiButtonWorldHandler(12, x + 178, y + 48, 55, 20, I18n.func_135052_a((String)"gui.worldhandler.potions.effect.lingering", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.worldhandler.actions.place_command_block", (Object[])new Object[0]), EnumTooltip.TOP_RIGHT);
            container.add(button10);
            button6.field_146124_l = enabled = this.builderPotion.getAmplifier() >= 0;
            button7.field_146124_l = enabled;
            button8.field_146124_l = enabled;
            button9.field_146124_l = enabled;
            button10.field_146124_l = enabled;
        }
        if (this.potionPage > 0) {
            container.add(new GuiButtonWorldHandler(4, x + 118, y + 72, 56, 20, "<"));
            button6 = new GuiButtonWorldHandler(5, x + 118 + 60, y + 72, 55, 20, ">");
            container.add(button6);
            button6.field_146124_l = this.potionPage < 3;
        }
    }

    @Override
    public void actionPerformed(Container container, GuiButton button) throws Exception {
        Potion potion = this.builderPotion.getEffectAsPotion();
        switch (button.field_146127_k) {
            case 4: {
                --this.potionPage;
                container.func_73866_w_();
                break;
            }
            case 5: {
                ++this.potionPage;
                container.func_73866_w_();
                break;
            }
            case 6: {
                WorldHandler.sendCommand(this.builderPotion.getRemoveCommand());
                container.func_73866_w_();
                break;
            }
            case 7: {
                WorldHandler.sendCommand(this.builderPotion.getClearCommand());
                container.func_73866_w_();
                break;
            }
            case 8: {
                this.builderPotionItem.setAmbient(potion, !this.builderPotionItem.getAmbient(potion));
                container.func_73866_w_();
                break;
            }
            case 9: {
                this.builderPotion.setHideParticles(!this.builderPotion.getHideParticles());
                this.builderPotionItem.setShowParticles(potion, !this.builderPotionItem.getShowParticles(potion));
                container.func_73866_w_();
                break;
            }
            case 10: {
                WorldHandler.sendCommand(this.builderPotion);
                this.potionPage = 0;
                container.func_73866_w_();
                break;
            }
            case 11: {
                WorldHandler.sendCommand(this.builderPotionItem.getBuilderForPotion((Item)Items.field_151068_bn));
                this.potionPage = 0;
                container.func_73866_w_();
                break;
            }
            case 12: {
                WorldHandler.sendCommand(this.builderPotionItem.getBuilderForPotion((Item)Items.field_185156_bI));
                this.potionPage = 0;
                container.func_73866_w_();
                break;
            }
            case 13: {
                WorldHandler.sendCommand(this.builderPotionItem.getBuilderForPotion((Item)Items.field_185155_bH));
                this.potionPage = 0;
                container.func_73866_w_();
                break;
            }
            case 14: {
                WorldHandler.sendCommand(this.builderPotionItem.getBuilderForPotion(Items.field_185167_i));
                this.potionPage = 0;
                container.func_73866_w_();
                break;
            }
        }
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.potions", (Object[])new Object[0]);
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderPotion.setPlayer(username);
        this.builderPotionItem.setPlayer(username);
    }
}

