/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderRecipe;
import exopandora.worldhandler.builder.types.Type;
import exopandora.worldhandler.gui.button.EnumTooltip;
import exopandora.worldhandler.gui.button.GuiButtonWorldHandler;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.element.impl.ElementPageList;
import exopandora.worldhandler.gui.content.element.logic.ILogicPageList;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ContentRecipes
extends Content {
    private final BuilderRecipe builderRecipe = new BuilderRecipe();

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderRecipe;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        ArrayList<IRecipe> recipes = new ArrayList<IRecipe>();
        for (IRecipe recipe : CraftingManager.field_193380_a) {
            if (recipe.func_192399_d()) continue;
            recipes.add(recipe);
        }
        ElementPageList<IRecipe, String> list = new ElementPageList<IRecipe, String>(x, y, recipes, null, 114, 20, 3, this, new int[]{4, 5, 6}, new ILogicPageList<IRecipe, String>(){

            @Override
            public String translate(IRecipe key) {
                if (!key.func_77571_b().equals(ItemStack.field_190927_a)) {
                    return key.func_77571_b().func_82833_r();
                }
                return key.getRegistryName().toString();
            }

            @Override
            public void onClick(IRecipe clicked) {
                ContentRecipes.this.builderRecipe.setRecipe(clicked.getRegistryName());
            }

            @Override
            public String getRegistryName(IRecipe key) {
                return key.getRegistryName().toString();
            }

            @Override
            public void onRegister(int id, int x, int y, int width, int height, String display, String registry, boolean enabled, IRecipe value, Container container) {
                GuiButtonWorldHandler button = new GuiButtonWorldHandler(id, x, y, width, height, display, value.getRegistryName().toString(), EnumTooltip.TOP_RIGHT);
                container.add(button);
                button.field_146124_l = enabled;
            }

            @Override
            public IRecipe getObject(String object) {
                return (IRecipe)CraftingManager.field_193380_a.func_82594_a((Object)Type.parseResourceLocation(object));
            }

            @Override
            public String getId() {
                return "recipe";
            }
        });
        container.add(list);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonWorldHandler(0, x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0])));
        container.add(new GuiButtonWorldHandler(1, x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0])));
        container.add(new GuiButtonWorldHandler(2, x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.recipes.give", (Object[])new Object[0])));
        container.add(new GuiButtonWorldHandler(3, x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.recipes.take", (Object[])new Object[0])));
    }

    @Override
    public void actionPerformed(Container container, GuiButton button) throws Exception {
        switch (button.field_146127_k) {
            case 2: {
                WorldHandler.sendCommand(this.builderRecipe.getBuilderForMode(BuilderRecipe.EnumMode.GIVE));
                container.initButtons();
                break;
            }
            case 3: {
                WorldHandler.sendCommand(this.builderRecipe.getBuilderForMode(BuilderRecipe.EnumMode.TAKE));
                container.initButtons();
                break;
            }
        }
    }

    @Override
    public Category getCategory() {
        return Categories.ITEMS;
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.items.recipes", (Object[])new Object[0]);
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.items.recipes", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.RECIPES;
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderRecipe.setPlayer(username);
    }
}

