/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicates;
import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderScoreboardObjectives;
import exopandora.worldhandler.format.EnumColor;
import exopandora.worldhandler.gui.button.GuiButtonWorldHandler;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.element.impl.ElementClickList;
import exopandora.worldhandler.gui.content.element.logic.ILogicClickList;
import exopandora.worldhandler.gui.content.impl.abstr.ContentScoreboard;
import exopandora.worldhandler.helper.EntityHelper;
import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ContentScoreboardObjectives
extends ContentScoreboard {
    private GuiTextFieldTooltip objectField;
    private String selectedObjective = "create";
    private final BuilderScoreboardObjectives builderObjectives = new BuilderScoreboardObjectives();

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderObjectives;
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.objectField = new GuiTextFieldTooltip(x + 118, y + (this.selectedObjective.equals("remove") ? 24 : 0), 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.objective", (Object[])new Object[0]));
        this.objectField.setValidator((com.google.common.base.Predicate<String>)Predicates.notNull());
        this.objectField.setText(objective);
        if (this.selectedObjective.equals("create")) {
            ElementClickList objectives = new ElementClickList(x + 118, y + 24, HELPER.getObjectives(), new int[]{7, 8}, this, new ILogicClickList(){

                @Override
                public void consumeKey(String ... keys) {
                    if (keys.length > 1) {
                        this.consumeKeyImpl(keys);
                    } else {
                        ContentScoreboardObjectives.this.builderObjectives.setCriteria(keys[0]);
                    }
                }

                @Override
                public String translate(String ... keys) {
                    if (keys.length > 1) {
                        return this.translate(keys[1]);
                    }
                    String format = "gui.worldhandler.scoreboard.objectives.criteria." + keys[0];
                    String result = I18n.func_135052_a((String)format, (Object[])new Object[0]);
                    if (result.equals(format)) {
                        ResourceLocation location = new ResourceLocation(keys[0]);
                        result = Item.field_150901_e.func_148741_d((Object)location) ? I18n.func_135052_a((String)(((Item)Item.field_150901_e.func_82594_a((Object)location)).func_77658_a() + ".name"), (Object[])new Object[0]) : (Block.field_149771_c.func_148741_d((Object)location) ? ((Block)Block.field_149771_c.func_82594_a((Object)location)).func_149732_F() : (EntityHelper.doesExist(keys[0]) ? I18n.func_135052_a((String)("entity." + keys[0] + ".name"), (Object[])new Object[0]) : (Arrays.stream(EnumColor.values()).map(EnumColor::getFormat).anyMatch((Predicate<String>)Predicates.equalTo((Object)keys[0])) ? I18n.func_135052_a((String)("gui.worldhandler.color." + keys[0]), (Object[])new Object[0]) : I18n.func_135052_a((String)keys[0], (Object[])new Object[0]))));
                    }
                    return result;
                }

                @Override
                public String getId() {
                    return "objectives";
                }
            });
            container.add(objectives);
        } else if (this.selectedObjective.equals("display") || this.selectedObjective.equals("undisplay")) {
            ElementClickList slots = new ElementClickList(x + 118, y + 24 + (this.selectedObjective.equals("undisplay") ? -12 : 0), HELPER.getSlots(), new int[]{9, 10}, this, new ILogicClickList(){

                @Override
                public String translate(String ... keys) {
                    if (keys.length > 1) {
                        return I18n.func_135052_a((String)("gui.worldhandler.color." + keys[1]), (Object[])new Object[0]);
                    }
                    return I18n.func_135052_a((String)("gui.worldhandler.scoreboard.slot." + keys[0]), (Object[])new Object[0]);
                }

                @Override
                public void consumeKey(String ... keys) {
                    if (keys.length > 1) {
                        this.consumeKeyImpl(keys);
                    } else {
                        ContentScoreboardObjectives.this.builderObjectives.setSlot(keys[0]);
                    }
                }

                @Override
                public String getId() {
                    return "slots";
                }
            });
            container.add(slots);
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        int yOffset;
        boolean enabled;
        container.add(new GuiButtonWorldHandler(0, x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0])));
        container.add(new GuiButtonWorldHandler(1, x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0])));
        GuiButtonWorldHandler button3 = new GuiButtonWorldHandler(2, x, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.create", (Object[])new Object[0]));
        container.add(button3);
        GuiButtonWorldHandler button4 = new GuiButtonWorldHandler(3, x, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.display", (Object[])new Object[0]));
        container.add(button4);
        GuiButtonWorldHandler button5 = new GuiButtonWorldHandler(4, x, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.undisplay", (Object[])new Object[0]));
        container.add(button5);
        GuiButtonWorldHandler button6 = new GuiButtonWorldHandler(5, x, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.remove", (Object[])new Object[0]));
        container.add(button6);
        button3.field_146124_l = !this.selectedObjective.equals("create");
        button4.field_146124_l = !this.selectedObjective.equals("display");
        button5.field_146124_l = !this.selectedObjective.equals("undisplay");
        button6.field_146124_l = !this.selectedObjective.equals("remove");
        boolean bl = enabled = this.builderObjectives.getObjective() != null && this.builderObjectives.getObjective().length() > 0;
        int n = this.selectedObjective.equals("undisplay") ? -12 : (yOffset = this.selectedObjective.equals("remove") ? -24 : 0);
        if (this.selectedObjective.equals("undisplay")) {
            this.builderObjectives.setObjective(null);
            enabled = true;
        } else if (this.selectedObjective.equals("remove")) {
            this.builderObjectives.setMode("remove");
        }
        if (!this.selectedObjective.equals("undisplay")) {
            this.builderObjectives.setObjective(objective);
        }
        button3 = new GuiButtonWorldHandler(6, x + 118, y + 72 + yOffset, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.perform", (Object[])new Object[0]));
        container.add(button3);
        button3.field_146124_l = enabled;
    }

    @Override
    public void actionPerformed(Container container, GuiButton button) throws Exception {
        switch (button.field_146127_k) {
            case 2: {
                this.selectedObjective = "create";
                container.func_73866_w_();
                break;
            }
            case 3: {
                this.selectedObjective = "display";
                container.func_73866_w_();
                break;
            }
            case 4: {
                this.selectedObjective = "undisplay";
                container.func_73866_w_();
                break;
            }
            case 5: {
                this.selectedObjective = "remove";
                container.func_73866_w_();
                break;
            }
            case 6: {
                WorldHandler.sendCommand(this.builderObjectives);
                container.func_73866_w_();
                break;
            }
        }
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (!this.selectedObjective.equals("undisplay")) {
            this.objectField.drawTextBox();
        }
    }

    @Override
    public void keyTyped(Container container, char typedChar, int keyCode) {
        if (this.objectField.textboxKeyTyped(typedChar, keyCode)) {
            objective = this.objectField.getText();
            this.builderObjectives.setObjective(objective);
            container.initButtons();
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (!this.selectedObjective.equals("undisplay")) {
            this.objectField.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.scoreboard.objectives", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.SCOREBOARD_OBJECTIVES;
    }
}

