/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicate;
import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderScoreboardPlayers;
import exopandora.worldhandler.config.ConfigSliders;
import exopandora.worldhandler.gui.button.EnumTooltip;
import exopandora.worldhandler.gui.button.GuiButtonWorldHandler;
import exopandora.worldhandler.gui.button.GuiSlider;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.button.responder.SimpleResponder;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.impl.abstr.ContentScoreboard;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ContentScoreboardPlayers
extends ContentScoreboard {
    private GuiTextFieldTooltip objectField;
    private GuiTextFieldTooltip tagField;
    private final BuilderScoreboardPlayers builderPlayers = new BuilderScoreboardPlayers();
    private final Predicate<String> nonNullNoSpace = string -> string != null && !string.matches("(.* .*)+");
    private String selectedPlayer = "add|set|remove";
    private String tag;
    private GuiButtonWorldHandler addButton;
    private GuiButtonWorldHandler removeButton;

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderPlayers;
    }

    @Override
    public void init(Container container) {
        if ((double)this.builderPlayers.getPoints() > ConfigSliders.getMaxPlayerPoints()) {
            this.builderPlayers.setPoints((int)ConfigSliders.getMaxPlayerPoints());
        }
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.objectField = new GuiTextFieldTooltip(x + 118, y + (this.selectedPlayer.equals("enable") ? 24 : 0), 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.objectives.objective", (Object[])new Object[0]));
        this.objectField.setValidator(this.nonNullNoSpace);
        this.objectField.setText(objective);
        this.tagField = new GuiTextFieldTooltip(x + 118, y + 12, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.players.tag", (Object[])new Object[0]));
        this.tagField.setValidator(this.nonNullNoSpace);
        this.tagField.setText(this.tag);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        boolean objective;
        container.add(new GuiButtonWorldHandler(0, x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0])));
        container.add(new GuiButtonWorldHandler(1, x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0])));
        GuiButtonWorldHandler button3 = new GuiButtonWorldHandler(2, x, y + 12, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.players.points", (Object[])new Object[0]));
        container.add(button3);
        GuiButtonWorldHandler button4 = new GuiButtonWorldHandler(3, x, y + 36, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.players.tag", (Object[])new Object[0]));
        container.add(button4);
        GuiButtonWorldHandler button5 = new GuiButtonWorldHandler(4, x, y + 60, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.players.trigger", (Object[])new Object[0]));
        container.add(button5);
        button3.field_146124_l = !this.selectedPlayer.equals("add|set|remove");
        button4.field_146124_l = !this.selectedPlayer.equals("tag");
        button5.field_146124_l = !this.selectedPlayer.equals("enable");
        this.builderPlayers.setMode(this.selectedPlayer);
        boolean bl = objective = this.builderPlayers.getObjective() != null && !this.builderPlayers.getObjective().isEmpty();
        if (this.selectedPlayer.equals("add|set|remove")) {
            boolean enabled;
            container.add(new GuiSlider(this, container, "points", x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.scoreboard.players.points", (Object[])new Object[0]), 0.0, ConfigSliders.getMaxPlayerPoints(), 0.0, new SimpleResponder(value -> this.builderPlayers.setPoints((int)value))));
            this.addButton = new GuiButtonWorldHandler(5, x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.add", (Object[])new Object[0]));
            container.add(this.addButton);
            this.removeButton = new GuiButtonWorldHandler(6, x + 118, y + 72, 56, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.remove", (Object[])new Object[0]));
            container.add(this.removeButton);
            button5 = new GuiButtonWorldHandler(7, x + 118 + 57 + 1, y + 72, 56, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.reset", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.worldhandler.actions.set_to_0", (Object[])new Object[0]), EnumTooltip.TOP_RIGHT);
            container.add(button5);
            this.addButton.field_146124_l = enabled = objective && this.builderPlayers.getPoints() > 0;
            this.removeButton.field_146124_l = enabled;
            button5.field_146124_l = objective;
        } else if (this.selectedPlayer.equals("tag")) {
            boolean enabled;
            button3 = new GuiButtonWorldHandler(8, x + 118, y + 36, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.add", (Object[])new Object[0]));
            container.add(button3);
            button4 = new GuiButtonWorldHandler(9, x + 118, y + 60, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.remove", (Object[])new Object[0]));
            container.add(button4);
            button3.field_146124_l = enabled = this.tag != null && !this.tag.isEmpty();
            button4.field_146124_l = enabled;
        } else if (this.selectedPlayer.equals("enable")) {
            button3 = new GuiButtonWorldHandler(10, x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.enable", (Object[])new Object[0]));
            container.add(button3);
            button3.field_146124_l = objective;
        }
        if (this.selectedPlayer.equals("tag")) {
            this.builderPlayers.setTag(this.tag);
        } else {
            this.builderPlayers.setObjective(ContentScoreboardPlayers.objective);
        }
    }

    @Override
    public void updateScreen(Container container) {
        if (this.selectedPlayer.equals("add|set|remove")) {
            boolean enabled;
            boolean objective = this.builderPlayers.getObjective() != null && !this.builderPlayers.getObjective().isEmpty();
            this.addButton.field_146124_l = enabled = objective && this.builderPlayers.getPoints() > 0;
            this.removeButton.field_146124_l = enabled;
        }
    }

    @Override
    public void actionPerformed(Container container, GuiButton button) throws Exception {
        switch (button.field_146127_k) {
            case 2: {
                this.selectedPlayer = "add|set|remove";
                container.func_73866_w_();
                break;
            }
            case 3: {
                this.selectedPlayer = "tag";
                container.func_73866_w_();
                break;
            }
            case 4: {
                this.selectedPlayer = "enable";
                container.func_73866_w_();
                break;
            }
            case 5: {
                WorldHandler.sendCommand(this.builderPlayers.getBuilderForPoints(BuilderScoreboardPlayers.EnumPoints.ADD));
                container.func_73866_w_();
                break;
            }
            case 6: {
                WorldHandler.sendCommand(this.builderPlayers.getBuilderForPoints(BuilderScoreboardPlayers.EnumPoints.REMOVE));
                container.func_73866_w_();
                break;
            }
            case 7: {
                WorldHandler.sendCommand(this.builderPlayers.getBuilderForPoints(BuilderScoreboardPlayers.EnumPoints.SET, 0));
                container.func_73866_w_();
                break;
            }
            case 8: {
                WorldHandler.sendCommand(this.builderPlayers.getBuilderForTag(BuilderScoreboardPlayers.EnumTag.ADD));
                container.func_73866_w_();
                break;
            }
            case 9: {
                WorldHandler.sendCommand(this.builderPlayers.getBuilderForTag(BuilderScoreboardPlayers.EnumTag.REMOVE));
                container.func_73866_w_();
                break;
            }
            case 10: {
                WorldHandler.sendCommand(this.builderPlayers);
                container.func_73866_w_();
                break;
            }
        }
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.selectedPlayer.equals("tag")) {
            this.tagField.drawTextBox();
        } else {
            this.objectField.drawTextBox();
        }
    }

    @Override
    public void keyTyped(Container container, char typedChar, int keyCode) {
        if (this.objectField.textboxKeyTyped(typedChar, keyCode)) {
            objective = this.objectField.getText();
            this.builderPlayers.setObjective(objective);
            container.initButtons();
        }
        if (this.tagField.textboxKeyTyped(typedChar, keyCode)) {
            this.tag = this.tagField.getText();
            this.builderPlayers.setTag(this.tag);
            container.initButtons();
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.selectedPlayer.equals("tag")) {
            this.tagField.mouseClicked(mouseX, mouseY, mouseButton);
        } else {
            this.objectField.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.scoreboard.players", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.SCOREBOARD_PLAYERS;
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderPlayers.setPlayer(username);
    }
}

