/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderSignEditor;
import exopandora.worldhandler.config.ConfigSkin;
import exopandora.worldhandler.gui.button.GuiButtonWorldHandler;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.element.impl.ElementColorMenu;
import exopandora.worldhandler.gui.content.element.logic.ILogicColorMenu;
import exopandora.worldhandler.helper.BlockHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class ContentSignEditor
extends Content {
    private static final ResourceLocation LOGO = new ResourceLocation("worldhandler", "textures/logo.png");
    private int selectedLine = 0;
    private boolean editColor;
    private GuiTextFieldTooltip commandField;
    private GuiTextFieldTooltip textlineField;
    private final BuilderSignEditor builderSignEditor = new BuilderSignEditor();
    private boolean isActive;

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.isActive ? this.builderSignEditor : null;
    }

    @Override
    public void init(Container container) {
        this.isActive = BlockHelper.isFocusedBlockEqualTo(Blocks.field_150472_an) || BlockHelper.isFocusedBlockEqualTo(Blocks.field_150444_as);
        this.builderSignEditor.setPosition(BlockHelper.getFocusedBlockPos());
    }

    @Override
    public void initGui(Container container, int x, int y) {
        if (this.isActive) {
            this.commandField = new GuiTextFieldTooltip(x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.blocks.sign_editor.commmand", (Object[])new Object[0]));
            this.commandField.setValidator((Predicate<String>)Predicates.notNull());
            this.commandField.setText(this.builderSignEditor.getCommand(this.selectedLine));
            this.commandField.setCursorPositionEnd();
            ElementColorMenu colors = new ElementColorMenu(this, x, y, "gui.worldhandler.blocks.sign_editor.text_line_" + (this.selectedLine + 1), this.builderSignEditor.getColoredString(this.selectedLine), new int[]{8, 9, 10, 11, 12, 13}, new ILogicColorMenu(){

                @Override
                public Predicate<String> getValidator() {
                    return string -> Minecraft.func_71410_x().field_71466_p.func_78256_a(string) <= 90;
                }

                @Override
                public boolean drawButtons() {
                    return ContentSignEditor.this.editColor;
                }

                @Override
                public String getId() {
                    return "color" + ContentSignEditor.this.selectedLine;
                }
            });
            container.add(colors);
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonWorldHandler(0, x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0])));
        container.add(new GuiButtonWorldHandler(1, x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0])));
        if (this.isActive) {
            GuiButtonWorldHandler button3 = new GuiButtonWorldHandler(3, x, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.blocks.sign_editor.text_line_1", (Object[])new Object[0]));
            container.add(button3);
            GuiButtonWorldHandler button4 = new GuiButtonWorldHandler(4, x, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.blocks.sign_editor.text_line_2", (Object[])new Object[0]));
            container.add(button4);
            GuiButtonWorldHandler button5 = new GuiButtonWorldHandler(5, x, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.blocks.sign_editor.text_line_3", (Object[])new Object[0]));
            container.add(button5);
            GuiButtonWorldHandler button6 = new GuiButtonWorldHandler(6, x, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.blocks.sign_editor.text_line_4", (Object[])new Object[0]));
            container.add(button6);
            if (this.editColor) {
                container.add(new GuiButtonWorldHandler(7, x + 118, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.blocks.sign_editor.done", (Object[])new Object[0])));
            } else {
                container.add(new GuiButtonWorldHandler(7, x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.blocks.sign_editor.format_text_line", (Object[])new Object[0])));
                container.add(new GuiButtonWorldHandler(2, x + 118, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.place_command_block", (Object[])new Object[0])));
            }
            button3.field_146124_l = this.selectedLine != 0;
            button4.field_146124_l = this.selectedLine != 1;
            button5.field_146124_l = this.selectedLine != 2;
            button6.field_146124_l = this.selectedLine != 3;
        }
    }

    @Override
    public void actionPerformed(Container container, GuiButton button) throws Exception {
        switch (button.field_146127_k) {
            case 2: {
                WorldHandler.sendCommand(this.builderSignEditor, this.builderSignEditor.isSpecial());
                break;
            }
            case 3: {
                this.selectedLine = 0;
                container.func_73866_w_();
                break;
            }
            case 4: {
                this.selectedLine = 1;
                container.func_73866_w_();
                break;
            }
            case 5: {
                this.selectedLine = 2;
                container.func_73866_w_();
                break;
            }
            case 6: {
                this.selectedLine = 3;
                container.func_73866_w_();
                break;
            }
            case 7: {
                this.editColor = !this.editColor;
                container.func_73866_w_();
                break;
            }
        }
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.isActive) {
            if (!this.editColor) {
                this.commandField.drawTextBox();
            }
        } else {
            float scale = 4.0f;
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            RenderHelper.func_74520_c();
            GlStateManager.func_179109_b((float)((float)(container.field_146294_l / 2) - 8.5f * scale), (float)((float)(container.field_146295_m / 2 - 15) - 8.5f * scale), (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            Minecraft.func_71410_x().func_175599_af().func_175042_a(new ItemStack(Items.field_151155_ap), 0, 0);
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
            String displayString = I18n.func_135052_a((String)"gui.worldhandler.blocks.sign_editor.look_at_sign", (Object[])new Object[]{Keyboard.getKeyName((int)WorldHandler.KEY_WORLD_HANDLER.func_151463_i())});
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            fontRenderer.func_78276_b(displayString, x + 116 - fontRenderer.func_78256_a(displayString) / 2, y + 70, ConfigSkin.getLabelColor());
        }
    }

    @Override
    public void keyTyped(Container container, char charTyped, int keyCode) {
        if (this.isActive && this.commandField.textboxKeyTyped(charTyped, keyCode)) {
            this.builderSignEditor.setCommand(this.selectedLine, this.commandField.getText());
            container.initButtons();
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.isActive) {
            this.commandField.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public Category getCategory() {
        return Categories.BLOCKS;
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.blocks.sign_editor", (Object[])new Object[0]);
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.blocks.sign_editor", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.SIGN_EDITOR;
    }
}

