/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderSummon;
import exopandora.worldhandler.builder.impl.abstr.EnumAttributes;
import exopandora.worldhandler.config.ConfigSliders;
import exopandora.worldhandler.gui.button.GuiButtonItem;
import exopandora.worldhandler.gui.button.GuiButtonWorldHandler;
import exopandora.worldhandler.gui.button.GuiSlider;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.button.responder.AttributeResponder;
import exopandora.worldhandler.gui.button.responder.SimpleResponder;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.content.element.impl.ElementPageList;
import exopandora.worldhandler.gui.content.element.logic.ILogicPageList;
import exopandora.worldhandler.util.UtilPlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ContentSummon
extends Content {
    private GuiTextFieldTooltip mobField;
    private GuiTextFieldTooltip customNameField;
    private GuiTextFieldTooltip passengerField;
    private int potionPage = 0;
    private int equipmentPage = 0;
    private String page = "main";
    private String mob;
    private String name;
    private String passenger;
    private final BuilderSummon builderSummon = new BuilderSummon();
    private final List<EnumAttributes> attributes = Stream.concat(EnumAttributes.getAttributesFor(EnumAttributes.Applyable.BOTH).stream(), EnumAttributes.getAttributesFor(EnumAttributes.Applyable.MOB).stream()).collect(Collectors.toList());

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderSummon;
    }

    @Override
    public void init(Container container) {
        for (EnumAttributes attribute : this.builderSummon.getAttributes()) {
            double ammount = this.builderSummon.getAttributeAmmount(attribute);
            if (!(ammount > ConfigSliders.getMaxSummonAttributes())) continue;
            this.builderSummon.setAttribute(attribute, ConfigSliders.getMaxSummonAttributes());
        }
        for (Potion potion : this.builderSummon.getPotions()) {
            int minutes;
            byte amplifier = this.builderSummon.getAmplifier(potion);
            if ((double)amplifier > ConfigSliders.getMaxSummonPotionAmplifier()) {
                this.builderSummon.setAmplifier(potion, (byte)ConfigSliders.getMaxSummonPotionAmplifier());
            }
            if (!((double)(minutes = this.builderSummon.getMinutes(potion)) > ConfigSliders.getMaxSummonPotionMinutes())) continue;
            this.builderSummon.setMinutes(potion, (int)ConfigSliders.getMaxSummonPotionMinutes());
        }
    }

    @Override
    public void initGui(Container container, int x, int y) {
        this.builderSummon.setDirection(UtilPlayer.getPlayerDirection());
        this.mobField = new GuiTextFieldTooltip(x + 118, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.entities.summon.start.mob_id", (Object[])new Object[0]) + " (" + I18n.func_135052_a((String)"gui.worldhandler.generic.name", (Object[])new Object[0]) + ")");
        this.mobField.setValidator((Predicate<String>)Predicates.notNull());
        this.mobField.setText(this.mob);
        this.customNameField = new GuiTextFieldTooltip(x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.entities.summon.start.custom_name", (Object[])new Object[0]));
        this.customNameField.setValidator((Predicate<String>)Predicates.notNull());
        this.customNameField.setText(this.name);
        this.passengerField = new GuiTextFieldTooltip(x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.entities.summon.start.passenger_mob_id", (Object[])new Object[0]));
        this.passengerField.setValidator((Predicate<String>)Predicates.notNull());
        this.passengerField.setText(this.passenger);
        if (this.page.equals("attributes")) {
            ElementPageList<EnumAttributes, Object> attributes = new ElementPageList<EnumAttributes, Object>(x + 118, y, this.attributes, null, 114, 20, 3, this, new int[]{6, 7, 8}, new ILogicPageList<EnumAttributes, Object>(){

                @Override
                public String translate(EnumAttributes key) {
                    return key.getTranslation();
                }

                @Override
                public void onClick(EnumAttributes clicked) {
                }

                @Override
                public String getRegistryName(EnumAttributes key) {
                    return key.getAttribute();
                }

                @Override
                public void onRegister(int id, int x, int y, int width, int height, String display, String registry, boolean enabled, EnumAttributes value, Container container) {
                    container.add(new GuiSlider(Contents.SUMMON, container, (Object)value, x, y, width, height, display, -ConfigSliders.getMaxSummonAttributes(), ConfigSliders.getMaxSummonAttributes(), 0.0, new AttributeResponder(response -> ContentSummon.this.builderSummon.setAttribute(value, response.intValue()))));
                }

                @Override
                public EnumAttributes getObject(Object object) {
                    return null;
                }

                @Override
                public String getId() {
                    return "attributes";
                }
            });
            container.add(attributes);
        }
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonWorldHandler(0, x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0])));
        container.add(new GuiButtonWorldHandler(1, x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0])));
        GuiButtonWorldHandler button7 = new GuiButtonWorldHandler(12, x, y, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.entities.summon.start", (Object[])new Object[0]));
        container.add(button7);
        GuiButtonWorldHandler button8 = new GuiButtonWorldHandler(3, x, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.entities.summon.potion_effects", (Object[])new Object[0]));
        container.add(button8);
        GuiButtonWorldHandler button9 = new GuiButtonWorldHandler(4, x, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.entities.summon.attributes", (Object[])new Object[0]));
        container.add(button9);
        GuiButtonWorldHandler button10 = new GuiButtonWorldHandler(5, x, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.entities.summon.equipment", (Object[])new Object[0]));
        container.add(button10);
        if (this.page.equals("main")) {
            GuiButtonWorldHandler button5;
            button7.field_146124_l = false;
            if (!this.builderSummon.needsCommandBlock() && !this.builderSummon.getCustomName().isSpecial()) {
                button5 = new GuiButtonWorldHandler(9, x + 118, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.title.entities.summon", (Object[])new Object[0]));
                container.add(button5);
            } else {
                button5 = new GuiButtonWorldHandler(9, x + 118, y + 72, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.actions.place_command_block", (Object[])new Object[0]));
                container.add(button5);
            }
            button5.field_146124_l = EntityList.func_180125_b((ResourceLocation)this.builderSummon.getEntity());
        } else if (this.page.equals("potionEffects")) {
            button8.field_146124_l = false;
            GuiButtonWorldHandler button3 = new GuiButtonWorldHandler(14, x + 118, y + 72, 56, 20, "<");
            container.add(button3);
            GuiButtonWorldHandler button4 = new GuiButtonWorldHandler(15, x + 118 + 60, y + 72, 55, 20, ">");
            container.add(button4);
            int count = 0;
            for (ResourceLocation location : this.getSortedPotionList()) {
                Potion potion = (Potion)Potion.field_188414_b.func_82594_a((Object)location);
                if (potion.equals(MobEffects.field_76433_i) || potion.equals(MobEffects.field_76432_h)) continue;
                if (this.potionPage == 0) {
                    button3.field_146124_l = false;
                }
                if (this.potionPage == Potion.field_188414_b.func_148742_b().size() - 3) {
                    button4.field_146124_l = false;
                }
                if (count == this.potionPage) {
                    container.add(new GuiSlider(this, container, "amplifier" + potion.getRegistryName(), x + 118, y, 114, 20, I18n.func_135052_a((String)potion.func_76393_a(), (Object[])new Object[0]), 0.0, ConfigSliders.getMaxSummonPotionAmplifier(), 0.0, new SimpleResponder(value -> this.builderSummon.setAmplifier(potion, value.byteValue()))));
                    container.add(new GuiSlider(this, container, "duration" + potion.getRegistryName(), x + 118, y + 24, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.potion.time.minutes", (Object[])new Object[0]), 0.0, ConfigSliders.getMaxSummonPotionMinutes(), 0.0, new SimpleResponder(value -> this.builderSummon.setMinutes(potion, (int)value))));
                    container.add(new GuiButtonWorldHandler(54, x + 118, y + 48, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.potions.effect.particles", (Object[])new Object[]{this.builderSummon.getShowParticles(potion) ? I18n.func_135052_a((String)"gui.worldhandler.generic.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.worldhandler.generic.off", (Object[])new Object[0])})));
                    break;
                }
                ++count;
            }
        } else if (this.page.equals("attributes")) {
            button9.field_146124_l = false;
        } else if (this.page.equals("equipment")) {
            GuiButtonWorldHandler button3 = new GuiButtonWorldHandler(16, x + 118, y + 72, 56, 20, "<");
            container.add(button3);
            GuiButtonWorldHandler button4 = new GuiButtonWorldHandler(17, x + 118 + 60, y + 72, 54, 20, ">");
            container.add(button4);
            if (this.equipmentPage == 0) {
                button3.field_146124_l = false;
                GuiButtonItem button11 = new GuiButtonItem(18, x + 118, y, 18, 20, (Item)Items.field_151024_Q);
                container.add(button11);
                GuiButtonItem button12 = new GuiButtonItem(19, x + 118 + 20 - 1, y, 18, 20, (Item)Items.field_151028_Y);
                container.add(button12);
                GuiButtonItem button13 = new GuiButtonItem(20, x + 118 + 40 - 2, y, 18, 20, (Item)Items.field_151020_U);
                container.add(button13);
                GuiButtonItem button14 = new GuiButtonItem(21, x + 118 + 60 - 3, y, 18, 20, (Item)Items.field_151169_ag);
                container.add(button14);
                GuiButtonItem button15 = new GuiButtonItem(22, x + 118 + 80 - 4, y, 18, 20, (Item)Items.field_151161_ac);
                container.add(button15);
                GuiButtonWorldHandler button16 = new GuiButtonWorldHandler(23, x + 118 + 100 - 5, y, 20, 20, null);
                container.add(button16);
                GuiButtonItem button17 = new GuiButtonItem(24, x + 118, y + 24, 18, 20, (Item)Items.field_151027_R);
                container.add(button17);
                GuiButtonItem button18 = new GuiButtonItem(25, x + 118 + 20 - 1, y + 24, 18, 20, (Item)Items.field_151030_Z);
                container.add(button18);
                GuiButtonItem button19 = new GuiButtonItem(26, x + 118 + 40 - 2, y + 24, 18, 20, (Item)Items.field_151023_V);
                container.add(button19);
                GuiButtonItem button20 = new GuiButtonItem(27, x + 118 + 60 - 3, y + 24, 18, 20, (Item)Items.field_151171_ah);
                container.add(button20);
                GuiButtonItem button21 = new GuiButtonItem(28, x + 118 + 80 - 4, y + 24, 18, 20, (Item)Items.field_151163_ad);
                container.add(button21);
                GuiButtonWorldHandler button22 = new GuiButtonWorldHandler(29, x + 118 + 100 - 5, y + 24, 20, 20, null);
                container.add(button22);
                GuiButtonItem button23 = new GuiButtonItem(30, x + 118, y + 48, 18, 20, (Item)Items.field_151026_S);
                container.add(button23);
                GuiButtonItem button24 = new GuiButtonItem(31, x + 118 + 20 - 1, y + 48, 18, 20, (Item)Items.field_151165_aa);
                container.add(button24);
                GuiButtonItem button25 = new GuiButtonItem(32, x + 118 + 40 - 2, y + 48, 18, 20, (Item)Items.field_151022_W);
                container.add(button25);
                GuiButtonItem button26 = new GuiButtonItem(33, x + 118 + 60 - 3, y + 48, 18, 20, (Item)Items.field_151149_ai);
                container.add(button26);
                GuiButtonItem button27 = new GuiButtonItem(34, x + 118 + 80 - 4, y + 48, 18, 20, (Item)Items.field_151173_ae);
                container.add(button27);
                GuiButtonWorldHandler button28 = new GuiButtonWorldHandler(35, x + 118 + 100 - 5, y + 48, 20, 20, null);
                container.add(button28);
                button11.field_146124_l = !this.builderSummon.getArmorItem(3).equals((Object)Items.field_151024_Q.getRegistryName());
                button12.field_146124_l = !this.builderSummon.getArmorItem(3).equals((Object)Items.field_151028_Y.getRegistryName());
                button13.field_146124_l = !this.builderSummon.getArmorItem(3).equals((Object)Items.field_151020_U.getRegistryName());
                button14.field_146124_l = !this.builderSummon.getArmorItem(3).equals((Object)Items.field_151169_ag.getRegistryName());
                button15.field_146124_l = !this.builderSummon.getArmorItem(3).equals((Object)Items.field_151161_ac.getRegistryName());
                button16.field_146124_l = !this.builderSummon.getArmorItem(3).equals((Object)Blocks.field_150350_a.getRegistryName());
                button17.field_146124_l = !this.builderSummon.getArmorItem(2).equals((Object)Items.field_151027_R.getRegistryName());
                button18.field_146124_l = !this.builderSummon.getArmorItem(2).equals((Object)Items.field_151030_Z.getRegistryName());
                button19.field_146124_l = !this.builderSummon.getArmorItem(2).equals((Object)Items.field_151023_V.getRegistryName());
                button20.field_146124_l = !this.builderSummon.getArmorItem(2).equals((Object)Items.field_151171_ah.getRegistryName());
                button21.field_146124_l = !this.builderSummon.getArmorItem(2).equals((Object)Items.field_151163_ad.getRegistryName());
                button22.field_146124_l = !this.builderSummon.getArmorItem(2).equals((Object)Blocks.field_150350_a.getRegistryName());
                button23.field_146124_l = !this.builderSummon.getArmorItem(1).equals((Object)Items.field_151026_S.getRegistryName());
                button24.field_146124_l = !this.builderSummon.getArmorItem(1).equals((Object)Items.field_151165_aa.getRegistryName());
                button25.field_146124_l = !this.builderSummon.getArmorItem(1).equals((Object)Items.field_151022_W.getRegistryName());
                button26.field_146124_l = !this.builderSummon.getArmorItem(1).equals((Object)Items.field_151149_ai.getRegistryName());
                button27.field_146124_l = !this.builderSummon.getArmorItem(1).equals((Object)Items.field_151173_ae.getRegistryName());
                button28.field_146124_l = !this.builderSummon.getArmorItem(1).equals((Object)Blocks.field_150350_a.getRegistryName());
            } else if (this.equipmentPage == 1) {
                button4.field_146124_l = false;
                GuiButtonItem button11 = new GuiButtonItem(36, x + 118, y, 18, 20, (Item)Items.field_151021_T);
                container.add(button11);
                GuiButtonItem button12 = new GuiButtonItem(37, x + 118 + 20 - 1, y, 18, 20, (Item)Items.field_151167_ab);
                container.add(button12);
                GuiButtonItem button13 = new GuiButtonItem(38, x + 118 + 40 - 2, y, 18, 20, (Item)Items.field_151029_X);
                container.add(button13);
                GuiButtonItem button14 = new GuiButtonItem(39, x + 118 + 60 - 3, y, 18, 20, (Item)Items.field_151151_aj);
                container.add(button14);
                GuiButtonItem button15 = new GuiButtonItem(40, x + 118 + 80 - 4, y, 18, 20, (Item)Items.field_151175_af);
                container.add(button15);
                GuiButtonWorldHandler button16 = new GuiButtonWorldHandler(41, x + 118 + 100 - 5, y, 20, 20, null);
                container.add(button16);
                GuiButtonItem button17 = new GuiButtonItem(42, x + 118, y + 24, 18, 20, Items.field_151041_m);
                container.add(button17);
                GuiButtonItem button18 = new GuiButtonItem(43, x + 118 + 20 - 1, y + 24, 18, 20, Items.field_151052_q);
                container.add(button18);
                GuiButtonItem button19 = new GuiButtonItem(44, x + 118 + 40 - 2, y + 24, 18, 20, Items.field_151040_l);
                container.add(button19);
                GuiButtonItem button20 = new GuiButtonItem(45, x + 118 + 60 - 3, y + 24, 18, 20, Items.field_151010_B);
                container.add(button20);
                GuiButtonItem button21 = new GuiButtonItem(46, x + 118 + 80 - 4, y + 24, 18, 20, Items.field_151048_u);
                container.add(button21);
                GuiButtonWorldHandler button22 = new GuiButtonWorldHandler(47, x + 118 + 100 - 5, y + 24, 20, 20, null);
                container.add(button22);
                GuiButtonItem button23 = new GuiButtonItem(48, x + 118, y + 48, 18, 20, Items.field_151041_m);
                container.add(button23);
                GuiButtonItem button24 = new GuiButtonItem(49, x + 118 + 20 - 1, y + 48, 18, 20, Items.field_151052_q);
                container.add(button24);
                GuiButtonItem button25 = new GuiButtonItem(50, x + 118 + 40 - 2, y + 48, 18, 20, Items.field_151040_l);
                container.add(button25);
                GuiButtonItem button26 = new GuiButtonItem(51, x + 118 + 60 - 3, y + 48, 18, 20, Items.field_151010_B);
                container.add(button26);
                GuiButtonItem button27 = new GuiButtonItem(52, x + 118 + 80 - 4, y + 48, 18, 20, Items.field_151048_u);
                container.add(button27);
                GuiButtonWorldHandler button28 = new GuiButtonWorldHandler(53, x + 118 + 100 - 5, y + 48, 20, 20, null);
                container.add(button28);
                button11.field_146124_l = !this.builderSummon.getArmorItem(0).equals((Object)Items.field_151021_T.getRegistryName());
                button12.field_146124_l = !this.builderSummon.getArmorItem(0).equals((Object)Items.field_151167_ab.getRegistryName());
                button13.field_146124_l = !this.builderSummon.getArmorItem(0).equals((Object)Items.field_151029_X.getRegistryName());
                button14.field_146124_l = !this.builderSummon.getArmorItem(0).equals((Object)Items.field_151151_aj.getRegistryName());
                button15.field_146124_l = !this.builderSummon.getArmorItem(0).equals((Object)Items.field_151175_af.getRegistryName());
                button16.field_146124_l = !this.builderSummon.getArmorItem(0).equals((Object)Blocks.field_150350_a.getRegistryName());
                button17.field_146124_l = !this.builderSummon.getHandItem(0).equals((Object)Items.field_151041_m.getRegistryName());
                button18.field_146124_l = !this.builderSummon.getHandItem(0).equals((Object)Items.field_151052_q.getRegistryName());
                button19.field_146124_l = !this.builderSummon.getHandItem(0).equals((Object)Items.field_151040_l.getRegistryName());
                button20.field_146124_l = !this.builderSummon.getHandItem(0).equals((Object)Items.field_151010_B.getRegistryName());
                button21.field_146124_l = !this.builderSummon.getHandItem(0).equals((Object)Items.field_151048_u.getRegistryName());
                button22.field_146124_l = !this.builderSummon.getHandItem(0).equals((Object)Blocks.field_150350_a.getRegistryName());
                button23.field_146124_l = !this.builderSummon.getHandItem(1).equals((Object)Items.field_151041_m.getRegistryName());
                button24.field_146124_l = !this.builderSummon.getHandItem(1).equals((Object)Items.field_151052_q.getRegistryName());
                button25.field_146124_l = !this.builderSummon.getHandItem(1).equals((Object)Items.field_151040_l.getRegistryName());
                button26.field_146124_l = !this.builderSummon.getHandItem(1).equals((Object)Items.field_151010_B.getRegistryName());
                button27.field_146124_l = !this.builderSummon.getHandItem(1).equals((Object)Items.field_151048_u.getRegistryName());
                button28.field_146124_l = !this.builderSummon.getHandItem(1).equals((Object)Blocks.field_150350_a.getRegistryName());
            }
            button10.field_146124_l = false;
        }
    }

    @Override
    public void actionPerformed(Container container, GuiButton button) throws Exception {
        switch (button.field_146127_k) {
            case 3: {
                this.page = "potionEffects";
                container.func_73866_w_();
                break;
            }
            case 4: {
                this.page = "attributes";
                container.func_73866_w_();
                break;
            }
            case 5: {
                this.page = "equipment";
                container.func_73866_w_();
                break;
            }
            case 9: {
                WorldHandler.sendCommand(this.builderSummon, this.builderSummon.getCustomName().isSpecial());
                break;
            }
            case 12: {
                this.page = "main";
                container.func_73866_w_();
                break;
            }
            case 14: {
                --this.potionPage;
                container.func_73866_w_();
                break;
            }
            case 15: {
                ++this.potionPage;
                container.func_73866_w_();
                break;
            }
            case 16: {
                --this.equipmentPage;
                container.func_73866_w_();
                break;
            }
            case 17: {
                ++this.equipmentPage;
                container.func_73866_w_();
                break;
            }
            case 18: {
                this.builderSummon.setArmorItem(3, (Item)Items.field_151024_Q);
                container.func_73866_w_();
                break;
            }
            case 19: {
                this.builderSummon.setArmorItem(3, (Item)Items.field_151028_Y);
                container.func_73866_w_();
                break;
            }
            case 20: {
                this.builderSummon.setArmorItem(3, (Item)Items.field_151020_U);
                container.func_73866_w_();
                break;
            }
            case 21: {
                this.builderSummon.setArmorItem(3, (Item)Items.field_151169_ag);
                container.func_73866_w_();
                break;
            }
            case 22: {
                this.builderSummon.setArmorItem(3, (Item)Items.field_151161_ac);
                container.func_73866_w_();
                break;
            }
            case 23: {
                this.builderSummon.setArmorItem(3, Blocks.field_150350_a);
                container.func_73866_w_();
                break;
            }
            case 24: {
                this.builderSummon.setArmorItem(2, (Item)Items.field_151027_R);
                container.func_73866_w_();
                break;
            }
            case 25: {
                this.builderSummon.setArmorItem(2, (Item)Items.field_151030_Z);
                container.func_73866_w_();
                break;
            }
            case 26: {
                this.builderSummon.setArmorItem(2, (Item)Items.field_151023_V);
                container.func_73866_w_();
                break;
            }
            case 27: {
                this.builderSummon.setArmorItem(2, (Item)Items.field_151171_ah);
                container.func_73866_w_();
                break;
            }
            case 28: {
                this.builderSummon.setArmorItem(2, (Item)Items.field_151163_ad);
                container.func_73866_w_();
                break;
            }
            case 29: {
                this.builderSummon.setArmorItem(2, Blocks.field_150350_a);
                container.func_73866_w_();
                break;
            }
            case 30: {
                this.builderSummon.setArmorItem(1, (Item)Items.field_151026_S);
                container.func_73866_w_();
                break;
            }
            case 31: {
                this.builderSummon.setArmorItem(1, (Item)Items.field_151165_aa);
                container.func_73866_w_();
                break;
            }
            case 32: {
                this.builderSummon.setArmorItem(1, (Item)Items.field_151022_W);
                container.func_73866_w_();
                break;
            }
            case 33: {
                this.builderSummon.setArmorItem(1, (Item)Items.field_151149_ai);
                container.func_73866_w_();
                break;
            }
            case 34: {
                this.builderSummon.setArmorItem(1, (Item)Items.field_151173_ae);
                container.func_73866_w_();
                break;
            }
            case 35: {
                this.builderSummon.setArmorItem(1, Blocks.field_150350_a);
                container.func_73866_w_();
                break;
            }
            case 36: {
                this.builderSummon.setArmorItem(0, (Item)Items.field_151021_T);
                container.func_73866_w_();
                break;
            }
            case 37: {
                this.builderSummon.setArmorItem(0, (Item)Items.field_151167_ab);
                container.func_73866_w_();
                break;
            }
            case 38: {
                this.builderSummon.setArmorItem(0, (Item)Items.field_151029_X);
                container.func_73866_w_();
                break;
            }
            case 39: {
                this.builderSummon.setArmorItem(0, (Item)Items.field_151151_aj);
                container.func_73866_w_();
                break;
            }
            case 40: {
                this.builderSummon.setArmorItem(0, (Item)Items.field_151175_af);
                container.func_73866_w_();
                break;
            }
            case 41: {
                this.builderSummon.setArmorItem(0, Blocks.field_150350_a);
                container.func_73866_w_();
                break;
            }
            case 42: {
                this.builderSummon.setHandItem(0, Items.field_151041_m);
                container.func_73866_w_();
                break;
            }
            case 43: {
                this.builderSummon.setHandItem(0, Items.field_151052_q);
                container.func_73866_w_();
                break;
            }
            case 44: {
                this.builderSummon.setHandItem(0, Items.field_151040_l);
                container.func_73866_w_();
                break;
            }
            case 45: {
                this.builderSummon.setHandItem(0, Items.field_151010_B);
                container.func_73866_w_();
                break;
            }
            case 46: {
                this.builderSummon.setHandItem(0, Items.field_151048_u);
                container.func_73866_w_();
                break;
            }
            case 47: {
                this.builderSummon.setHandItem(0, Blocks.field_150350_a);
                container.func_73866_w_();
                break;
            }
            case 48: {
                this.builderSummon.setHandItem(1, Items.field_151041_m);
                container.func_73866_w_();
                break;
            }
            case 49: {
                this.builderSummon.setHandItem(1, Items.field_151052_q);
                container.func_73866_w_();
                break;
            }
            case 50: {
                this.builderSummon.setHandItem(1, Items.field_151040_l);
                container.func_73866_w_();
                break;
            }
            case 51: {
                this.builderSummon.setHandItem(1, Items.field_151010_B);
                container.func_73866_w_();
                break;
            }
            case 52: {
                this.builderSummon.setHandItem(1, Items.field_151048_u);
                container.func_73866_w_();
                break;
            }
            case 53: {
                this.builderSummon.setHandItem(1, Blocks.field_150350_a);
                container.func_73866_w_();
                break;
            }
            case 54: {
                int count = 0;
                for (ResourceLocation value : this.getSortedPotionList()) {
                    Potion potion = Potion.func_180142_b((String)value.toString());
                    if (potion.equals(MobEffects.field_76433_i) || potion.equals(MobEffects.field_76432_h)) continue;
                    if (count == this.potionPage) {
                        this.builderSummon.setShowParticles(potion, !this.builderSummon.getShowParticles(potion));
                        break;
                    }
                    ++count;
                }
                container.func_73866_w_();
                break;
            }
        }
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.page.equals("main")) {
            this.mobField.drawTextBox();
            this.customNameField.drawTextBox();
            this.passengerField.drawTextBox();
        } else if (this.page.equals("equipment")) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("textures/gui/container/beacon.png"));
            for (int row = 0; row < 3; ++row) {
                container.func_73729_b(x + 116 + 99, y + 2 + 24 * row, 112, 221, 16, 16);
            }
        }
    }

    @Override
    public void keyTyped(Container container, char charTyped, int keyCode) {
        if (this.mobField.textboxKeyTyped(charTyped, keyCode)) {
            this.mob = this.mobField.getText();
            this.builderSummon.setEntity(this.mob);
            container.initButtons();
        }
        if (this.customNameField.textboxKeyTyped(charTyped, keyCode)) {
            this.name = this.customNameField.getText();
            this.builderSummon.setCustomName(this.name);
            container.initButtons();
        }
        if (this.passengerField.textboxKeyTyped(charTyped, keyCode)) {
            this.passenger = this.passengerField.getText();
            this.builderSummon.setPassenger(this.passenger);
            container.initButtons();
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.page.equals("main")) {
            this.mobField.mouseClicked(mouseX, mouseY, mouseButton);
            this.customNameField.mouseClicked(mouseX, mouseY, mouseButton);
            this.passengerField.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    private List<ResourceLocation> getSortedPotionList() {
        ArrayList<ResourceLocation> potions = new ArrayList<ResourceLocation>(Potion.field_188414_b.func_148742_b());
        potions.sort((a, b) -> I18n.func_135052_a((String)((Potion)Potion.field_188414_b.func_82594_a(a)).func_76393_a(), (Object[])new Object[0]).compareTo(I18n.func_135052_a((String)((Potion)Potion.field_188414_b.func_82594_a(b)).func_76393_a(), (Object[])new Object[0])));
        return potions;
    }

    @Override
    public Category getCategory() {
        return Categories.ENTITIES;
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.entities.summon", (Object[])new Object[0]);
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.entities.summon", (Object[])new Object[0]);
    }

    @Override
    public String[] getHeadline() {
        String[] headline = new String[2];
        if (this.page.equals("potionEffects")) {
            headline[1] = this.potionPage + 1 + "/" + (Potion.field_188414_b.func_148742_b().size() - 2);
        } else if (this.page.equals("equipment")) {
            headline[1] = this.equipmentPage + 1 + "/2";
        }
        return headline;
    }

    @Override
    public Content getActiveContent() {
        return Contents.SUMMON;
    }
}

