/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import com.google.common.base.Predicate;
import exopandora.worldhandler.format.TextFormatting;
import exopandora.worldhandler.gui.button.GuiButtonWorldHandler;
import exopandora.worldhandler.gui.button.GuiTextFieldTooltip;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ContentWorldInfo
extends Content {
    private String selectedMain = "start";
    private GuiTextFieldTooltip posXField;
    private GuiTextFieldTooltip posYField;
    private GuiTextFieldTooltip posZField;
    private GuiTextFieldTooltip worldField;
    private GuiTextFieldTooltip seedField;
    private GuiTextFieldTooltip terrainField;
    private GuiTextFieldTooltip totalTimeField;
    private GuiTextFieldTooltip currentTimeField;

    @Override
    public void initGui(Container container, int x, int y) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (Minecraft.func_71410_x().func_71401_C() != null) {
            world = Minecraft.func_71410_x().func_71401_C().func_130014_f_();
        }
        this.posXField = new GuiTextFieldTooltip(x + 118, y + 12, 114, 20);
        this.posXField.setText(I18n.func_135052_a((String)"gui.worldhandler.world_info.start.spawn", (Object[])new Object[0]) + " X: " + this.getWorldInfo(WorldInfo::func_76079_c, (World)world));
        this.posYField = new GuiTextFieldTooltip(x + 118, y + 36, 114, 20);
        this.posYField.setText(I18n.func_135052_a((String)"gui.worldhandler.world_info.start.spawn", (Object[])new Object[0]) + " Y: " + this.getWorldInfo(WorldInfo::func_76075_d, (World)world));
        this.posZField = new GuiTextFieldTooltip(x + 118, y + 60, 114, 20);
        this.posZField.setText(I18n.func_135052_a((String)"gui.worldhandler.world_info.start.spawn", (Object[])new Object[0]) + " Z: " + this.getWorldInfo(WorldInfo::func_76074_e, (World)world));
        this.worldField = new GuiTextFieldTooltip(x + 118, y + 12, 114, 20);
        this.worldField.setText(I18n.func_135052_a((String)"gui.worldhandler.world_info.world.name", (Object[])new Object[0]) + ": " + this.getWorldInfo(WorldInfo::func_76065_j, (World)world));
        this.terrainField = new GuiTextFieldTooltip(x + 118, y + 36, 114, 20);
        this.terrainField.setText(I18n.func_135052_a((String)"gui.worldhandler.world_info.world.world_type", (Object[])new Object[0]) + ": " + this.getWorldInfo(info -> I18n.func_135052_a((String)info.func_76067_t().func_77128_b(), (Object[])new Object[0]), (World)world));
        this.seedField = new GuiTextFieldTooltip(x + 118, y + 60, 114, 20);
        this.seedField.setText(I18n.func_135052_a((String)"gui.worldhandler.world_info.world.seed", (Object[])new Object[0]) + ": " + (Minecraft.func_71410_x().func_71401_C() != null ? Long.valueOf(world.func_72912_H().func_76063_b()) : I18n.func_135052_a((String)"gui.worldhandler.world_info.n_a", (Object[])new Object[0])));
        this.seedField.setValidator((Predicate<String>)((Predicate)string -> string.equals(this.seedField.getText())));
        this.seedField.setCursorPositionZero();
        this.updateCursorPosition();
        this.currentTimeField = new GuiTextFieldTooltip(x + 118, y + 24, 114, 20);
        this.updateCurrentTime();
        this.totalTimeField = new GuiTextFieldTooltip(x + 118, y + 48, 114, 20);
        this.updateTotalTime();
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonWorldHandler(0, x, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.back", (Object[])new Object[0])));
        container.add(new GuiButtonWorldHandler(1, x + 118, y + 96, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.generic.backToGame", (Object[])new Object[0])));
        GuiButtonWorldHandler start = new GuiButtonWorldHandler(2, x, y + 12, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.world_info.start", (Object[])new Object[0]));
        container.add(start);
        GuiButtonWorldHandler world = new GuiButtonWorldHandler(3, x, y + 36, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.world_info.world", (Object[])new Object[0]));
        container.add(world);
        GuiButtonWorldHandler stats = new GuiButtonWorldHandler(4, x, y + 60, 114, 20, I18n.func_135052_a((String)"gui.worldhandler.world_info.statistics", (Object[])new Object[0]));
        container.add(stats);
        if (this.selectedMain.equals("start")) {
            start.field_146124_l = false;
        } else if (this.selectedMain.equals("world")) {
            world.field_146124_l = false;
        } else if (this.selectedMain.equals("stats")) {
            stats.field_146124_l = false;
        }
    }

    @Override
    public void updateScreen(Container container) {
        this.updateCurrentTime();
        this.updateTotalTime();
    }

    @Override
    public void actionPerformed(Container container, GuiButton button) throws Exception {
        switch (button.field_146127_k) {
            case 2: {
                this.selectedMain = "start";
                container.func_73866_w_();
                break;
            }
            case 3: {
                this.selectedMain = "world";
                container.func_73866_w_();
                break;
            }
            case 4: {
                this.selectedMain = "stats";
                container.func_73866_w_();
                break;
            }
        }
    }

    @Override
    public void drawScreen(Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.selectedMain.equals("start")) {
            this.posXField.drawTextBox();
            this.posYField.drawTextBox();
            this.posZField.drawTextBox();
        } else if (this.selectedMain.equals("world")) {
            this.worldField.drawTextBox();
            this.terrainField.drawTextBox();
            this.seedField.drawTextBox();
        } else if (this.selectedMain.equals("stats")) {
            this.totalTimeField.drawTextBox();
            this.currentTimeField.drawTextBox();
        }
    }

    private void updateCurrentTime() {
        this.currentTimeField.setText(I18n.func_135052_a((String)"gui.worldhandler.world_info.statistics.world_time", (Object[])new Object[0]) + ": " + TextFormatting.getWorldTime(Minecraft.func_71410_x().field_71441_e.func_72912_H().func_76073_f()));
    }

    private void updateTotalTime() {
        this.totalTimeField.setText(I18n.func_135052_a((String)"gui.worldhandler.world_info.statistics.played", (Object[])new Object[0]) + ": " + TextFormatting.getTotalTimePlayed(Minecraft.func_71410_x().field_71441_e.func_72912_H().func_82573_f()));
    }

    @Override
    public void keyTyped(Container container, char typedChar, int keyCode) {
        if (this.selectedMain.equals("world")) {
            this.seedField.textboxKeyTyped(typedChar, keyCode);
            this.updateCursorPosition();
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.selectedMain.equals("world")) {
            this.seedField.mouseClicked(mouseX, mouseY, mouseButton);
            this.updateCursorPosition();
        }
    }

    private <T> String getWorldInfo(Function<WorldInfo, T> function, World world) {
        if (world != null) {
            return String.valueOf(function.apply(world.func_72912_H()));
        }
        return I18n.func_135052_a((String)"gui.worldhandler.world_info.n_a", (Object[])new Object[0]);
    }

    private void updateCursorPosition() {
        int length = I18n.func_135052_a((String)"gui.worldhandler.world_info.start.spawn", (Object[])new Object[0]).length();
        if (this.seedField.getCursorPosition() < length + 2) {
            this.seedField.setCursorPosition(length + 1);
        }
    }

    @Override
    public Category getCategory() {
        return Categories.WORLD;
    }

    @Override
    public String getTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.title.world.world", (Object[])new Object[0]);
    }

    @Override
    public String getTabTitle() {
        return I18n.func_135052_a((String)"gui.worldhandler.tab.world.world", (Object[])new Object[0]);
    }

    @Override
    public Content getActiveContent() {
        return Contents.WORLD_INFO;
    }
}

