/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.helper;

import exopandora.worldhandler.WorldHandler;
import exopandora.worldhandler.builder.impl.BuilderSetblock;
import exopandora.worldhandler.builder.types.Coordinate;
import exopandora.worldhandler.config.ConfigSettings;
import exopandora.worldhandler.util.UtilPlayer;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

@SideOnly(value=Side.CLIENT)
public class BlockHelper {
    private static BlockPos POS_1 = BlockPos.field_177992_a;
    private static BlockPos POS_2 = BlockPos.field_177992_a;
    private static final List<Consumer<BlockPos>> POS_1_OBSERVERS = new ArrayList<Consumer<BlockPos>>();
    private static final List<Consumer<BlockPos>> POS_2_OBSERVERS = new ArrayList<Consumer<BlockPos>>();
    private static final Block[] BLACKLIST = new Block[]{Blocks.field_150350_a, Blocks.field_150355_j, Blocks.field_150353_l};

    public static BlockPos getFocusedBlockPos() {
        BlockPos position;
        RayTraceResult rayTrace = Minecraft.func_71410_x().field_71476_x;
        if (rayTrace != null && rayTrace.field_72313_a.equals((Object)RayTraceResult.Type.BLOCK) && !ArrayUtils.contains((Object[])BLACKLIST, (Object)Minecraft.func_71410_x().field_71441_e.func_180495_p(position = rayTrace.func_178782_a()).func_177230_c())) {
            return position;
        }
        return Minecraft.func_71410_x().field_71439_g.func_180425_c();
    }

    public static boolean isFocusedBlockEqualTo(Block block) {
        return Block.func_149680_a((Block)BlockHelper.getFocusedBlock(), (Block)block);
    }

    public static Block getFocusedBlock() {
        return Minecraft.func_71410_x().field_71441_e.func_180495_p(BlockHelper.getFocusedBlockPos()).func_177230_c();
    }

    public static BlockPos setX(BlockPos pos, double x) {
        return new BlockPos(x, (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public static BlockPos setY(BlockPos pos, double y) {
        return new BlockPos((double)pos.func_177958_n(), y, (double)pos.func_177952_p());
    }

    public static BlockPos setZ(BlockPos pos, double z) {
        return new BlockPos((double)pos.func_177958_n(), (double)pos.func_177956_o(), z);
    }

    @Nonnull
    public static BlockPos getPos1() {
        return POS_1;
    }

    public static void setPos1(BlockPos pos1) {
        if (POS_1 != null && !POS_1.equals((Object)pos1)) {
            POS_1 = pos1;
            for (Consumer<BlockPos> observer : POS_1_OBSERVERS) {
                observer.accept(POS_1);
            }
        }
    }

    @Nonnull
    public static BlockPos getPos2() {
        return POS_2;
    }

    public static void setPos2(BlockPos pos2) {
        if (POS_2 != null && !POS_2.equals((Object)pos2)) {
            POS_2 = pos2;
            for (Consumer<BlockPos> observer : POS_2_OBSERVERS) {
                observer.accept(POS_2);
            }
        }
    }

    public static void addPos1Observer(Consumer<BlockPos> observer) {
        POS_1_OBSERVERS.add(observer);
    }

    public static void removePos1Observer(Consumer<BlockPos> observer) {
        POS_1_OBSERVERS.remove(observer);
    }

    public static void addPos2Observer(Consumer<BlockPos> observer) {
        POS_2_OBSERVERS.add(observer);
    }

    public static void removePos2Observer(Consumer<BlockPos> observer) {
        POS_2_OBSERVERS.add(observer);
    }

    public static boolean setCommandBlockNearPlayer(String command) {
        if (UtilPlayer.canIssueCommand()) {
            BlockPos player;
            BlockPos block = player = new BlockPos(Minecraft.func_71410_x().field_71439_g.field_70165_t, Minecraft.func_71410_x().field_71439_g.field_70163_u, Minecraft.func_71410_x().field_71439_g.field_70161_v);
            BlockPos button = player;
            int meta = 0;
            switch (UtilPlayer.getPlayerDirection()) {
                case 0: {
                    block = block.func_177982_a(0, 0, 2);
                    button = button.func_177982_a(0, 0, 1);
                    meta = 4;
                    break;
                }
                case 1: {
                    block = block.func_177982_a(-2, 0, 0);
                    button = button.func_177982_a(-1, 0, 0);
                    meta = 1;
                    break;
                }
                case 2: {
                    block = block.func_177982_a(0, 0, -2);
                    button = button.func_177982_a(0, 0, -1);
                    meta = 3;
                    break;
                }
                case 3: {
                    block = block.func_177982_a(2, 0, 0);
                    button = button.func_177982_a(1, 0, 0);
                    meta = 2;
                }
            }
            boolean flag = false;
            if (Minecraft.func_71410_x().field_71441_e.func_175623_d(block)) {
                Minecraft.func_71410_x().field_71439_g.func_71165_d(new BuilderSetblock(block, Blocks.field_150483_bI.getRegistryName(), 0, ConfigSettings.getMode()).toActualCommand());
                Minecraft.func_71410_x().field_71439_g.func_71165_d(new BuilderSetblock(button, Blocks.field_150471_bO.getRegistryName(), meta, ConfigSettings.getMode()).toActualCommand());
                flag = true;
            }
            if ((Minecraft.func_71410_x().field_71441_e.func_180495_p(block).func_177230_c().equals(Blocks.field_150483_bI) || flag) && Minecraft.func_71410_x().func_147114_u() != null) {
                PacketBuffer packetbuffer = new PacketBuffer(Unpooled.buffer());
                packetbuffer.writeInt(block.func_177958_n());
                packetbuffer.writeInt(block.func_177956_o());
                packetbuffer.writeInt(block.func_177952_p());
                packetbuffer.func_180714_a(command);
                packetbuffer.writeBoolean(true);
                packetbuffer.func_180714_a(TileEntityCommandBlock.Mode.REDSTONE.name());
                packetbuffer.writeBoolean(false);
                packetbuffer.writeBoolean(false);
                Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketCustomPayload("MC|AutoCmd", packetbuffer));
                return true;
            }
        }
        return false;
    }

    public static void setBlockNearPlayer(Block block, byte southMeta, byte westMeta, byte northMeta, byte eastMeta) {
        int direction = UtilPlayer.getPlayerDirection();
        switch (direction) {
            case 0: {
                WorldHandler.sendCommand(new BuilderSetblock(new Coordinate(), new Coordinate(), new Coordinate(2.0, true), block.getRegistryName(), southMeta, ConfigSettings.getMode()));
                break;
            }
            case 1: {
                WorldHandler.sendCommand(new BuilderSetblock(new Coordinate(-2.0, true), new Coordinate(), new Coordinate(), block.getRegistryName(), westMeta, ConfigSettings.getMode()));
                break;
            }
            case 2: {
                WorldHandler.sendCommand(new BuilderSetblock(new Coordinate(), new Coordinate(), new Coordinate(-2.0, true), block.getRegistryName(), northMeta, ConfigSettings.getMode()));
                break;
            }
            case 3: {
                WorldHandler.sendCommand(new BuilderSetblock(new Coordinate(2.0, true), new Coordinate(), new Coordinate(), block.getRegistryName(), eastMeta, ConfigSettings.getMode()));
            }
        }
    }
}

