/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.helper;

import exopandora.worldhandler.config.ConfigSkin;
import exopandora.worldhandler.helper.AdvancementHelper;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ResourceHelper {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("textures/gui/demo_background.png");
    private static final ResourceLocation BACKGROUND_VANILLA = new ResourceLocation("worldhandler", "textures/skins/vanilla/vanilla.png");
    private static final ResourceLocation BUTTON = new ResourceLocation("textures/gui/widgets.png");

    public static ResourceLocation stringToResourceLocation(String resource) {
        if (resource != null) {
            return new ResourceLocation(resource.replaceAll(" ", "_"));
        }
        return null;
    }

    public static boolean isRegisteredItem(String item) {
        return Item.field_150901_e.func_148742_b().contains(ResourceHelper.stringToResourceLocation(item));
    }

    public static boolean isRegisteredBlock(String block) {
        return Block.field_149771_c.func_148742_b().contains(ResourceHelper.stringToResourceLocation(block));
    }

    public static boolean isRegisteredMob(String mob) {
        return EntityList.func_180125_b((ResourceLocation)ResourceHelper.stringToResourceLocation(mob));
    }

    public static boolean isRegisteredAdvancement(String advancement) {
        return AdvancementHelper.ADVANCEMENT_MANAGER.func_192778_a(ResourceHelper.stringToResourceLocation(advancement)) != null;
    }

    @Nullable
    public static ResourceLocation stringToResourceLocationNullable(String resource, Predicate<String> predicate) {
        if (predicate.test(resource)) {
            return ResourceHelper.stringToResourceLocation(resource);
        }
        return null;
    }

    public static ResourceLocation getBackgroundTexture() {
        if (ConfigSkin.getTextureType().equals("resourcepack")) {
            return BACKGROUND;
        }
        return BACKGROUND_VANILLA;
    }

    public static ResourceLocation getIconTexture() {
        return new ResourceLocation("worldhandler", "textures/icons/icons" + ConfigSkin.getIconSize() + ".png");
    }

    public static ResourceLocation getButtonTexture() {
        if (ConfigSkin.getTextureType().equals("resourcepack")) {
            return BUTTON;
        }
        return new ResourceLocation("worldhandler", "textures/skins/" + ConfigSkin.getTextureType() + "/" + ConfigSkin.getTextureType() + "_buttons.png");
    }
}

