/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.hud;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BiomeIndicator {
    private final Set<String> biomes = new HashSet<String>();
    private String currentBiome;
    private int ticksRemaining;

    public BiomeIndicator() {
        this.init();
    }

    private void init() {
        HashSet<String> biomes = new HashSet<String>();
        for (ResourceLocation location : Biome.field_185377_q.func_148742_b()) {
            biomes.add(this.filterName(((Biome)Biome.field_185377_q.func_82594_a((Object)location)).func_185359_l()));
        }
        this.biomes.addAll(biomes);
        for (String biome : biomes) {
            for (String index : biomes) {
                if (!index.matches(biome + "([A-Za-z ])+") && !index.matches("([A-Za-z ])+ " + biome)) continue;
                this.biomes.remove(index);
            }
        }
        this.biomes.remove("River");
        this.biomes.remove("Beach");
    }

    public void tick() {
        int posX = MathHelper.func_76128_c((double)Minecraft.func_71410_x().field_71439_g.field_70165_t);
        int posY = MathHelper.func_76128_c((double)Minecraft.func_71410_x().field_71439_g.field_70163_u);
        int posZ = MathHelper.func_76128_c((double)Minecraft.func_71410_x().field_71439_g.field_70161_v);
        BlockPos pos = new BlockPos(posX, posY, posZ);
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.func_175667_e(pos)) {
            Chunk chunk = Minecraft.func_71410_x().field_71441_e.func_175726_f(pos);
            String biome = this.getBaseBiome(this.filterName(chunk.func_177411_a(pos, Minecraft.func_71410_x().field_71441_e.func_72959_q()).func_185359_l()));
            if (this.ticksRemaining == 0 && biome != null) {
                if (this.currentBiome == null || !this.currentBiome.equals(biome)) {
                    Minecraft.func_71410_x().field_71456_v.func_175178_a(biome, null, 20, 60, 20);
                    this.ticksRemaining = 100;
                    this.currentBiome = biome;
                }
            } else if (this.ticksRemaining > 0) {
                --this.ticksRemaining;
            }
        }
    }

    private String filterName(String biome) {
        return biome.replaceAll("([a-z])([A-Z])", "$1 $2").replaceAll("[^A-Za-z ]", "").replaceAll("( [A-Z])$", "");
    }

    @Nullable
    private String getBaseBiome(String input) {
        for (String biome : this.biomes) {
            if (!input.matches("([A-Za-z ])*" + biome + "([A-Za-z ])*")) continue;
            return biome;
        }
        return null;
    }
}

