/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler;

import com.google.common.base.Predicates;
import com.mojang.brigadier.CommandDispatcher;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.helper.CommandHelper;
import exopandora.worldhandler.proxy.ClientProxy;
import exopandora.worldhandler.proxy.CommonProxy;
import exopandora.worldhandler.util.UtilKeyBinding;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.CommandSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="worldhandler")
public class WorldHandler {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final KeyBinding KEY_WORLD_HANDLER = new KeyBinding("World Handler", 86, "key.categories.misc");
    public static final KeyBinding KEY_WORLD_HANDLER_POS1 = new KeyBinding("World Handler Pos1", 79, "key.categories.misc");
    public static final KeyBinding KEY_WORLD_HANDLER_POS2 = new KeyBinding("World Handler Pos2", 80, "key.categories.misc");
    public static String USERNAME = null;
    private static CommonProxy SIDEPROXY;

    public WorldHandler() {
        SIDEPROXY = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::loadComplete);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_SPEC, "worldhandler.toml");
        modEventBus.register(Config.class);
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        SIDEPROXY.setup();
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent event) {
        USERNAME = Minecraft.func_71410_x().func_110432_I().func_111285_a();
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_WORLD_HANDLER);
        UtilKeyBinding.updatePosKeys();
    }

    @SubscribeEvent
    public void loadComplete(FMLLoadCompleteEvent event) {
        Content.registerContents();
        Category.registerCategories();
        InterModComms.getMessages((String)"worldhandler", (Predicate)Predicates.equalTo((Object)"register")).map(imc -> (Runnable)imc.getMessageSupplier().get()).forEach(Runnable::run);
    }

    @SubscribeEvent
    public void serverStarting(FMLServerStartingEvent event) {
        CommandHelper.registerCommands((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    public static void registerIMC(Runnable registrationEvent) {
        Objects.requireNonNull(registrationEvent);
        InterModComms.sendTo((String)"worldhandler", (String)"register", () -> registrationEvent);
    }
}

