/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.builder.component.impl;

import exopandora.worldhandler.builder.component.IBuilderComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@OnlyIn(value=Dist.CLIENT)
public class ComponentEnchantment
implements IBuilderComponent {
    private Map<Enchantment, Short> enchantments = new HashMap<Enchantment, Short>();

    @Override
    @Nullable
    public INBTBase serialize() {
        NBTTagList enchantments = new NBTTagList();
        for (Map.Entry<Enchantment, Short> entry : this.enchantments.entrySet()) {
            if (entry.getValue() <= 0) continue;
            NBTTagCompound enchantment = new NBTTagCompound();
            enchantment.func_74778_a("id", ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)entry.getKey()).toString());
            enchantment.func_74777_a("lvl", entry.getValue().shortValue());
            enchantments.add((INBTBase)enchantment);
        }
        if (enchantments.isEmpty()) {
            return null;
        }
        return enchantments;
    }

    public void setLevel(Enchantment enchantment, short level) {
        if (level == 0) {
            this.enchantments.remove(enchantment);
        } else {
            this.enchantments.put(enchantment, level);
        }
    }

    public short getLevel(Enchantment enchantment) {
        return this.enchantments.get(enchantment);
    }

    public Set<Enchantment> getEnchantments() {
        return this.enchantments.keySet();
    }

    @Override
    public String getTag() {
        return "Enchantments";
    }
}

