/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.builder.component.impl;

import exopandora.worldhandler.builder.component.IBuilderComponent;
import exopandora.worldhandler.helper.ResourceHelper;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public class ComponentSummon
implements IBuilderComponent {
    private final Random random = new Random();
    private String tag;
    private String name;
    private ResourceLocation entity;
    private boolean hasPassenger;

    public void setEntity(ResourceLocation entityName) {
        this.entity = entityName;
    }

    public ResourceLocation getEntity() {
        return this.entity;
    }

    public void setHasPassenger(boolean hasPassenger) {
        this.hasPassenger = hasPassenger;
    }

    public boolean hasPassenger() {
        return this.hasPassenger;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public INBTBase serialize() {
        if (this.name != null) {
            if (this.name.equalsIgnoreCase("Cat")) {
                this.tag = "CatType";
                return new NBTTagInt(this.random.nextInt(3) + 1);
            }
            if (this.name.equalsIgnoreCase("Farmer") || this.name.equalsIgnoreCase("Fisherman") || this.name.equalsIgnoreCase("Shepherd") || this.name.equalsIgnoreCase("Fletcher")) {
                this.tag = "Profession";
                return new NBTTagInt(0);
            }
            if (this.name.equalsIgnoreCase("Librarian") || this.name.equalsIgnoreCase("Carthographer")) {
                this.tag = "Profession";
                return new NBTTagInt(1);
            }
            if (this.name.equalsIgnoreCase("Cleric") || this.name.equalsIgnoreCase("Priest")) {
                this.tag = "Profession";
                return new NBTTagInt(2);
            }
            if (this.name.equalsIgnoreCase("Armorer") || this.name.equalsIgnoreCase("Blacksmith") || this.name.equalsIgnoreCase("WeaponSmith") || this.name.equalsIgnoreCase("ToolSmith")) {
                this.tag = "Profession";
                return new NBTTagInt(3);
            }
            if (this.name.equalsIgnoreCase("Butcher") || this.name.equalsIgnoreCase("Leatherworker")) {
                this.tag = "Profession";
                return new NBTTagInt(4);
            }
            if (this.name.equalsIgnoreCase("Nitwit")) {
                this.tag = "Profession";
                return new NBTTagInt(5);
            }
            if (this.entity != null) {
                if (this.entity.equals((Object)EntityType.field_200725_aD.getRegistryName())) {
                    if (StringUtils.containsIgnoreCase((CharSequence)this.name, (CharSequence)"Baby")) {
                        this.tag = "IsBaby";
                        return new NBTTagByte(1);
                    }
                } else if (this.entity.equals((Object)EntityType.field_200795_i.getRegistryName())) {
                    if (StringUtils.containsIgnoreCase((CharSequence)this.name, (CharSequence)"Jockey") && !this.hasPassenger) {
                        NBTTagCompound passenger = new NBTTagCompound();
                        NBTTagList list = new NBTTagList();
                        passenger.func_74778_a("id", EntityType.field_200725_aD.getRegistryName().toString());
                        passenger.func_74757_a("IsBaby", true);
                        list.add((INBTBase)passenger);
                        this.tag = "Passengers";
                        return list;
                    }
                } else if (this.entity.equals((Object)EntityType.field_200748_an.getRegistryName()) && StringUtils.containsIgnoreCase((CharSequence)this.name, (CharSequence)"Jockey") && !this.hasPassenger) {
                    NBTTagCompound passenger = new NBTTagCompound();
                    NBTTagList list = new NBTTagList();
                    passenger.func_74778_a("id", EntityType.field_200741_ag.getRegistryName().toString());
                    list.add((INBTBase)passenger);
                    this.tag = "Passengers";
                    return list;
                }
            }
        }
        return null;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Nullable
    public static ResourceLocation resolve(String entityName) {
        String name = ResourceHelper.stripToResourceLocation(entityName);
        for (EntityType type : ForgeRegistries.ENTITIES.getValues()) {
            if (!type.func_200720_b() || !entityName.equalsIgnoreCase(I18n.func_135052_a((String)type.func_210760_d(), (Object[])new Object[0]))) continue;
            return type.getRegistryName();
        }
        String entity = name.replaceAll("_", "");
        if (entity.equalsIgnoreCase("RedCow")) {
            return EntityType.field_200780_T.getRegistryName();
        }
        if (entity.equalsIgnoreCase("ChickenJockey")) {
            return EntityType.field_200795_i.getRegistryName();
        }
        if (entity.equalsIgnoreCase("Pigman") || entity.equalsIgnoreCase("ZombiePig") || entity.equalsIgnoreCase("ZombiePigman")) {
            return EntityType.field_200785_Y.getRegistryName();
        }
        if (entity.equalsIgnoreCase("Wither")) {
            return EntityType.field_200760_az.getRegistryName();
        }
        if (entity.equalsIgnoreCase("Dog")) {
            return EntityType.field_200724_aC.getRegistryName();
        }
        if (entity.equalsIgnoreCase("Dragon")) {
            return EntityType.field_200802_p.getRegistryName();
        }
        if (entity.equalsIgnoreCase("minecraft:SnowGolem")) {
            return EntityType.field_200745_ak.getRegistryName();
        }
        if (entity.equalsIgnoreCase("Horse") || entity.equalsIgnoreCase("ZombieHorse") || entity.equalsIgnoreCase("SkeletonHorse")) {
            return EntityType.field_200762_B.getRegistryName();
        }
        if (entity.equalsIgnoreCase("LavaCube") || entity.equalsIgnoreCase("MagmaSlime") || entity.equalsIgnoreCase("MagmaCube")) {
            return EntityType.field_200771_K.getRegistryName();
        }
        if (entity.equalsIgnoreCase("SpiderJockey")) {
            return EntityType.field_200748_an.getRegistryName();
        }
        if (entity.equalsIgnoreCase("IronGolem")) {
            return EntityType.field_200757_aw.getRegistryName();
        }
        if (entity.equalsIgnoreCase("Ozelot") || entity.equals("Ocelot") || entity.equalsIgnoreCase("Cat") || entity.equalsIgnoreCase("Kitty") || entity.equalsIgnoreCase("Kitten")) {
            return EntityType.field_200781_U.getRegistryName();
        }
        if (entity.equalsIgnoreCase("TESTIFICATE") || entity.equalsIgnoreCase("Blacksmith") || entity.equalsIgnoreCase("Farmer") || entity.equalsIgnoreCase("Fisherman") || entity.equalsIgnoreCase("Shepherd") || entity.equalsIgnoreCase("Fletcher") || entity.equalsIgnoreCase("Librarian") || entity.equalsIgnoreCase("Cleric") || entity.equalsIgnoreCase("Priest") || entity.equalsIgnoreCase("Armorer") || entity.equalsIgnoreCase("WeaponSmith") || entity.equalsIgnoreCase("ToolSmith") || entity.equalsIgnoreCase("Butcher") || entity.equalsIgnoreCase("Leatherworker") || entity.equalsIgnoreCase("Carthographer") || entity.equalsIgnoreCase("Nitwit")) {
            return EntityType.field_200756_av.getRegistryName();
        }
        if (entity.equalsIgnoreCase("Octopus") || entity.equalsIgnoreCase("Kraken")) {
            return EntityType.field_200749_ao.getRegistryName();
        }
        if (entity.equalsIgnoreCase("Exwife")) {
            return EntityType.field_200811_y.getRegistryName();
        }
        if (entity.equalsIgnoreCase("TNTMinecart")) {
            return EntityType.field_200778_R.getRegistryName();
        }
        if (entity.equalsIgnoreCase("Minecart")) {
            return EntityType.field_200772_L.getRegistryName();
        }
        if (entity.equalsIgnoreCase("HopperMinecart")) {
            return EntityType.field_200776_P.getRegistryName();
        }
        if (entity.equalsIgnoreCase("ChestMinecart")) {
            return EntityType.field_200773_M.getRegistryName();
        }
        if (entity.equalsIgnoreCase("SpawnerMinecart")) {
            return EntityType.field_200777_Q.getRegistryName();
        }
        if (entity.equalsIgnoreCase("FurnaceMinecart")) {
            return EntityType.field_200775_O.getRegistryName();
        }
        if (entity.equalsIgnoreCase("CommandBlockMinecart") || entity.equalsIgnoreCase("MinecartCommand") || entity.equalsIgnoreCase("CommandMinecart")) {
            return EntityType.field_200774_N.getRegistryName();
        }
        if (entity.equalsIgnoreCase("Wizard")) {
            return EntityType.field_200806_t.getRegistryName();
        }
        if (entity.equalsIgnoreCase("Johnny")) {
            return EntityType.field_200758_ax.getRegistryName();
        }
        if (entity.equalsIgnoreCase("BabyZombie")) {
            return EntityType.field_200725_aD.getRegistryName();
        }
        if (entity == null || entity.isEmpty()) {
            return null;
        }
        return ResourceHelper.stringToResourceLocation(name);
    }
}

