/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.config;

import exopandora.worldhandler.config.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class ConfigCategoryButcher {
    private final List<String> entities = new ArrayList<String>();
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> valueEntities;

    public ConfigCategoryButcher(ForgeConfigSpec.Builder builder) {
        builder.push("butcher");
        this.valueEntities = builder.defineList("entities", Collections.emptyList(), this::isValid);
        builder.pop();
    }

    public void read() {
        this.entities.clear();
        this.entities.addAll((Collection)this.valueEntities.get());
    }

    private void write() {
        Config.set(this.valueEntities, this.entities);
    }

    public List<ResourceLocation> getEntities() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (String entity : this.entities) {
            ResourceLocation resource = ResourceLocation.func_208304_a((String)entity);
            if (resource == null) continue;
            list.add(resource);
        }
        return list;
    }

    public boolean containsEntity(ResourceLocation entity) {
        return this.entities.contains(entity.toString());
    }

    public void addEntity(ResourceLocation entity) {
        if (this.isValid(entity)) {
            this.entities.add(entity.toString());
            this.write();
        }
    }

    public boolean removeEntity(ResourceLocation entity) {
        boolean removed = this.entities.remove(entity.toString());
        if (removed) {
            this.write();
        }
        return removed;
    }

    private boolean isValid(Object string) {
        if (string != null) {
            return ForgeRegistries.ENTITIES.containsKey(ResourceLocation.func_208304_a((String)string.toString()));
        }
        return false;
    }
}

