/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.config;

import exopandora.worldhandler.config.Config;
import java.util.Arrays;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

@OnlyIn(value=Dist.CLIENT)
public class ConfigCategorySettings {
    private boolean commandSyntax;
    private boolean shortcuts;
    private boolean shortcutKeys;
    private boolean tooltips;
    private boolean watch;
    private boolean smoothWatch;
    private boolean pause;
    private boolean customTimes;
    private boolean permissionQuery;
    private boolean highlightBlocks;
    private int dawn;
    private int noon;
    private int sunset;
    private int midnight;
    private String blockPlacingMode;
    private final ForgeConfigSpec.BooleanValue valueCommandSyntax;
    private final ForgeConfigSpec.BooleanValue valueShortcuts;
    private final ForgeConfigSpec.BooleanValue valueShortcutKeys;
    private final ForgeConfigSpec.BooleanValue valueTooltips;
    private final ForgeConfigSpec.BooleanValue valueWatch;
    private final ForgeConfigSpec.BooleanValue valueSmoothWatch;
    private final ForgeConfigSpec.BooleanValue valuePause;
    private final ForgeConfigSpec.BooleanValue valueCustomTimes;
    private final ForgeConfigSpec.BooleanValue valuePermissionQuery;
    private final ForgeConfigSpec.BooleanValue valueHighlightBlocks;
    private final ForgeConfigSpec.IntValue valueDawn;
    private final ForgeConfigSpec.IntValue valueNoon;
    private final ForgeConfigSpec.IntValue valueSunset;
    private final ForgeConfigSpec.IntValue valueMidnight;
    private final ForgeConfigSpec.ConfigValue<String> valueBlockPlacingMode;

    public ConfigCategorySettings(ForgeConfigSpec.Builder builder) {
        builder.push("settings");
        this.valueCommandSyntax = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.settings.command_syntax", (Object[])new Object[0])).translation("gui.worldhandler.config.key.settings.command_syntax").define("command_syntax", false);
        this.valueShortcuts = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.settings.shortcuts", (Object[])new Object[0])).translation("gui.worldhandler.config.key.settings.shortcuts").define("shortcuts", false);
        this.valueShortcutKeys = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.settings.key_shortcuts", (Object[])new Object[0])).translation("gui.worldhandler.config.key.settings.key_shortcuts").define("key_shortcuts", false);
        this.valueTooltips = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.settings.tooltips", (Object[])new Object[0])).translation("gui.worldhandler.config.key.settings.tooltips").define("tooltips", true);
        this.valueWatch = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.settings.watch", (Object[])new Object[0])).translation("gui.worldhandler.config.key.settings.watch").define("watch", true);
        this.valueSmoothWatch = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.settings.smooth_watch", (Object[])new Object[0])).translation("gui.worldhandler.config.key.settings.smooth_watch").define("smooth_watch", true);
        this.valuePause = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.settings.pause_game", (Object[])new Object[0])).translation("gui.worldhandler.config.key.settings.pause_game").define("pause_game", false);
        this.valueCustomTimes = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.settings.custom_times", (Object[])new Object[0])).translation("gui.worldhandler.config.key.settings.custom_times").define("custom_times", false);
        this.valuePermissionQuery = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.settings.permission_query", (Object[])new Object[0])).translation("gui.worldhandler.config.key.settings.permission_query").define("permission_query", true);
        this.valueHighlightBlocks = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.settings.highlight_blocks", (Object[])new Object[0])).translation("gui.worldhandler.config.key.settings.highlight_blocks").define("highlight_blocks", true);
        this.valueDawn = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.settings.custom_time_dawn", (Object[])new Object[0])).translation("gui.worldhandler.config.key.settings.custom_time_dawn").defineInRange("custom_time_dawn", 1000, 0, 24000);
        this.valueNoon = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.settings.custom_time_noon", (Object[])new Object[0])).translation("gui.worldhandler.config.key.settings.custom_time_noon").defineInRange("custom_time_noon", 6000, 0, 24000);
        this.valueSunset = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.settings.custom_time_sunset", (Object[])new Object[0])).translation("gui.worldhandler.config.key.settings.custom_time_sunset").defineInRange("custom_time_sunset", 12500, 0, 24000);
        this.valueMidnight = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.settings.custom_time_midnight", (Object[])new Object[0])).translation("gui.worldhandler.config.key.settings.custom_time_midnight").defineInRange("custom_time_midnight", 18000, 0, 24000);
        this.valueBlockPlacingMode = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.settings.block_placing_mode", (Object[])new Object[0])).translation("gui.worldhandler.config.key.settings.block_placing_mode").defineInList("block_placing_mode", (Object)"keep", Arrays.asList("keep", "replace", "destroy"));
        builder.pop();
    }

    public void read() {
        this.commandSyntax = (Boolean)this.valueCommandSyntax.get();
        this.shortcuts = (Boolean)this.valueShortcuts.get();
        this.shortcutKeys = (Boolean)this.valueShortcutKeys.get();
        this.tooltips = (Boolean)this.valueTooltips.get();
        this.watch = (Boolean)this.valueWatch.get();
        this.smoothWatch = (Boolean)this.valueSmoothWatch.get();
        this.pause = (Boolean)this.valuePause.get();
        this.customTimes = (Boolean)this.valueCustomTimes.get();
        this.permissionQuery = (Boolean)this.valuePermissionQuery.get();
        this.highlightBlocks = (Boolean)this.valueHighlightBlocks.get();
        this.dawn = (Integer)this.valueDawn.get();
        this.noon = (Integer)this.valueNoon.get();
        this.sunset = (Integer)this.valueSunset.get();
        this.midnight = (Integer)this.valueMidnight.get();
        this.blockPlacingMode = (String)this.valueBlockPlacingMode.get();
    }

    private void write() {
        Config.set(this.valueCommandSyntax, this.commandSyntax);
        Config.set(this.valueShortcuts, this.shortcuts);
        Config.set(this.valueShortcutKeys, this.shortcutKeys);
        Config.set(this.valueTooltips, this.tooltips);
        Config.set(this.valueWatch, this.watch);
        Config.set(this.valueSmoothWatch, this.smoothWatch);
        Config.set(this.valuePause, this.pause);
        Config.set(this.valueCustomTimes, this.customTimes);
        Config.set(this.valuePermissionQuery, this.permissionQuery);
        Config.set(this.valueHighlightBlocks, this.highlightBlocks);
        Config.set(this.valueDawn, this.dawn);
        Config.set(this.valueNoon, this.noon);
        Config.set(this.valueSunset, this.sunset);
        Config.set(this.valueMidnight, this.midnight);
        Config.set(this.valueBlockPlacingMode, this.blockPlacingMode);
    }

    public boolean commandSyntax() {
        return this.commandSyntax;
    }

    public void setCommandSyntax(boolean enabled) {
        this.commandSyntax = enabled;
        this.write();
    }

    public boolean shortcuts() {
        return this.shortcuts;
    }

    public void setShortcuts(boolean enabled) {
        this.shortcuts = enabled;
        this.write();
    }

    public boolean shortcutKeys() {
        return this.shortcutKeys;
    }

    public void setShortcutKeys(boolean enabled) {
        this.shortcutKeys = enabled;
        this.write();
    }

    public boolean tooltips() {
        return this.tooltips;
    }

    public void setTooltips(boolean enabled) {
        this.tooltips = enabled;
        this.write();
    }

    public boolean watch() {
        return this.watch;
    }

    public void setWatch(boolean enabled) {
        this.watch = enabled;
        this.write();
    }

    public boolean smoothWatch() {
        return this.smoothWatch;
    }

    public void setSmoothWatch(boolean enabled) {
        this.smoothWatch = enabled;
        this.write();
    }

    public boolean pause() {
        return this.pause;
    }

    public void setPause(boolean enabled) {
        this.pause = enabled;
        this.write();
    }

    public boolean customTimes() {
        return this.customTimes;
    }

    public void setCustomTimes(boolean enabled) {
        this.customTimes = enabled;
        this.write();
    }

    public boolean permissionQuery() {
        return this.permissionQuery;
    }

    public void setPermissionQuery(boolean enabled) {
        this.permissionQuery = enabled;
        this.write();
    }

    public boolean highlightBlocks() {
        return this.highlightBlocks;
    }

    public void setHighlightBlocks(boolean enabled) {
        this.highlightBlocks = enabled;
        this.write();
    }

    public int getDawn() {
        return this.dawn;
    }

    public void setDawn(int ticks) {
        this.dawn = ticks;
        this.write();
    }

    public int getNoon() {
        return this.noon;
    }

    public void setNoon(int ticks) {
        this.noon = ticks;
        this.write();
    }

    public int getSunset() {
        return this.sunset;
    }

    public void setSunset(int ticks) {
        this.sunset = ticks;
        this.write();
    }

    public int getMidnight() {
        return this.midnight;
    }

    public void setMidnight(int ticks) {
        this.midnight = ticks;
        this.write();
    }

    public String getBlockPlacingMode() {
        return this.blockPlacingMode;
    }

    public void setBlockPlacingMode(String mode) {
        this.blockPlacingMode = mode;
        this.write();
    }
}

