/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.config;

import exopandora.worldhandler.config.Config;
import java.util.Arrays;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

@OnlyIn(value=Dist.CLIENT)
public class ConfigCategorySkin {
    private int iconSize;
    private int labelColor;
    private int headlineColor;
    private int backgroundRed;
    private int backgroundGreen;
    private int backgroundBlue;
    private int backgroundAlpha;
    private int buttonRed;
    private int buttonGreen;
    private int buttonBlue;
    private int buttonAlpha;
    private String type;
    private boolean sharpEdges;
    private boolean drawBackground;
    private final ForgeConfigSpec.ConfigValue<Integer> valueIconSize;
    private final ForgeConfigSpec.IntValue valueLabelColor;
    private final ForgeConfigSpec.IntValue valueHeadlineColor;
    private final ForgeConfigSpec.IntValue valueBackgroundRed;
    private final ForgeConfigSpec.IntValue valueBackgroundGreen;
    private final ForgeConfigSpec.IntValue valueBackgroundBlue;
    private final ForgeConfigSpec.IntValue valueBackgroundAlpha;
    private final ForgeConfigSpec.IntValue valueButtonRed;
    private final ForgeConfigSpec.IntValue valueButtonGreen;
    private final ForgeConfigSpec.IntValue valueButtonBlue;
    private final ForgeConfigSpec.IntValue valueButtonAlpha;
    private final ForgeConfigSpec.ConfigValue<String> valueType;
    private final ForgeConfigSpec.BooleanValue valueSharpEdges;
    private final ForgeConfigSpec.BooleanValue valueDrawBackground;

    public ConfigCategorySkin(ForgeConfigSpec.Builder builder) {
        builder.push("skin");
        this.valueIconSize = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.skin.icon_size", (Object[])new Object[0])).translation("gui.worldhandler.config.key.skin.icon_size").defineInList("icon_size", (Object)16, Arrays.asList(16, 32, 64));
        this.valueLabelColor = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.skin.label_color", (Object[])new Object[0])).translation("gui.worldhandler.config.key.skin.label_color").defineInRange("label_color", 0x1F1F1F, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.valueHeadlineColor = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.skin.headline_color", (Object[])new Object[0])).translation("gui.worldhandler.config.key.skin.headline_color").defineInRange("headline_color", 0x4F4F4F, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.valueBackgroundRed = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.skin.background_red", (Object[])new Object[0])).translation("gui.worldhandler.config.key.skin.background_red").defineInRange("background_red", 255, 0, 255);
        this.valueBackgroundGreen = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.skin.background_green", (Object[])new Object[0])).translation("gui.worldhandler.config.key.skin.background_green").defineInRange("background_green", 255, 0, 255);
        this.valueBackgroundBlue = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.skin.background_blue", (Object[])new Object[0])).translation("gui.worldhandler.config.key.skin.background_blue").defineInRange("background_blue", 255, 0, 255);
        this.valueBackgroundAlpha = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.skin.background_alpha", (Object[])new Object[0])).translation("gui.worldhandler.config.key.skin.background_alpha").defineInRange("background_alpha", 255, 0, 255);
        this.valueButtonRed = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.skin.button_red", (Object[])new Object[0])).translation("gui.worldhandler.config.key.skin.button_red").defineInRange("button_red", 255, 0, 255);
        this.valueButtonGreen = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.skin.button_green", (Object[])new Object[0])).translation("gui.worldhandler.config.key.skin.button_green").defineInRange("button_green", 255, 0, 255);
        this.valueButtonBlue = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.skin.button_blue", (Object[])new Object[0])).translation("gui.worldhandler.config.key.skin.button_blue").defineInRange("button_blue", 255, 0, 255);
        this.valueButtonAlpha = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.skin.button_alpha", (Object[])new Object[0])).translation("gui.worldhandler.config.key.skin.button_alpha").defineInRange("button_alpha", 255, 0, 255);
        this.valueType = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.skin.textures", (Object[])new Object[0])).translation("gui.worldhandler.config.key.skin.textures").defineInList("textures", (Object)"resourcepack", Arrays.asList("resourcepack", "vanilla"));
        this.valueSharpEdges = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.settings.sharp_tab_edges", (Object[])new Object[0])).translation("gui.worldhandler.config.key.settings.sharp_tab_edges").define("sharp_tab_edges", false);
        this.valueDrawBackground = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.settings.draw_background", (Object[])new Object[0])).translation("gui.worldhandler.config.key.settings.draw_background").define("draw_background", true);
        builder.pop();
    }

    public void read() {
        this.iconSize = (Integer)this.valueIconSize.get();
        this.labelColor = (Integer)this.valueLabelColor.get();
        this.headlineColor = (Integer)this.valueHeadlineColor.get();
        this.backgroundRed = (Integer)this.valueBackgroundRed.get();
        this.backgroundGreen = (Integer)this.valueBackgroundGreen.get();
        this.backgroundBlue = (Integer)this.valueBackgroundBlue.get();
        this.backgroundAlpha = (Integer)this.valueBackgroundAlpha.get();
        this.buttonRed = (Integer)this.valueButtonRed.get();
        this.buttonGreen = (Integer)this.valueButtonGreen.get();
        this.buttonBlue = (Integer)this.valueButtonBlue.get();
        this.buttonAlpha = (Integer)this.valueButtonAlpha.get();
        this.type = (String)this.valueType.get();
        this.sharpEdges = (Boolean)this.valueSharpEdges.get();
        this.drawBackground = (Boolean)this.valueDrawBackground.get();
    }

    private void write() {
        Config.set(this.valueIconSize, this.iconSize);
        Config.set(this.valueLabelColor, this.labelColor);
        Config.set(this.valueHeadlineColor, this.headlineColor);
        Config.set(this.valueBackgroundRed, this.backgroundRed);
        Config.set(this.valueBackgroundGreen, this.backgroundGreen);
        Config.set(this.valueBackgroundBlue, this.backgroundBlue);
        Config.set(this.valueBackgroundAlpha, this.backgroundAlpha);
        Config.set(this.valueButtonRed, this.buttonRed);
        Config.set(this.valueButtonGreen, this.buttonGreen);
        Config.set(this.valueButtonBlue, this.buttonBlue);
        Config.set(this.valueButtonAlpha, this.buttonAlpha);
        Config.set(this.valueType, this.type);
        Config.set(this.valueSharpEdges, this.sharpEdges);
        Config.set(this.valueDrawBackground, this.drawBackground);
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(int size) {
        this.iconSize = size;
        this.write();
    }

    public int getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(int color) {
        this.labelColor = color;
        this.write();
    }

    public int getHeadlineColor() {
        return this.headlineColor;
    }

    public void setHeadlineColor(int color) {
        this.headlineColor = color;
        this.write();
    }

    private int getBackgroundRed() {
        return this.backgroundRed;
    }

    public float getBackgroundRedF() {
        return (float)this.getBackgroundRed() / 255.0f;
    }

    public void setBackgroundRed(int red) {
        this.backgroundRed = red;
        this.write();
    }

    private int getBackgroundGreen() {
        return this.backgroundGreen;
    }

    public float getBackgroundGreenF() {
        return (float)this.getBackgroundGreen() / 255.0f;
    }

    public void setBackgroundGreen(int green) {
        this.backgroundGreen = green;
        this.write();
    }

    private int getBackgroundBlue() {
        return this.backgroundBlue;
    }

    public float getBackgroundBlueF() {
        return (float)this.getBackgroundBlue() / 255.0f;
    }

    public void setBackgroundBlue(int blue) {
        this.backgroundBlue = blue;
        this.write();
    }

    private int getButtonRed() {
        return this.buttonRed;
    }

    public float getButtonRedF() {
        return (float)this.getButtonRed() / 255.0f;
    }

    public void setButtonRed(int red) {
        this.backgroundRed = red;
        this.write();
    }

    private int getButtonGreen() {
        return this.buttonGreen;
    }

    public float getButtonGreenF() {
        return (float)this.getButtonGreen() / 255.0f;
    }

    public void setButtonGreen(int green) {
        this.buttonGreen = green;
        this.write();
    }

    private int getButtonBlue() {
        return this.buttonBlue;
    }

    public float getButtonBlueF() {
        return (float)this.getButtonBlue() / 255.0f;
    }

    public void setButtonBlue(int blue) {
        this.buttonBlue = blue;
        this.write();
    }

    public String getTextureType() {
        return this.type;
    }

    public void setTextureType(String type) {
        this.type = type;
        this.write();
    }

    public boolean sharpEdges() {
        return this.sharpEdges;
    }

    public void setSharpEdges(boolean enabled) {
        this.sharpEdges = enabled;
        this.write();
    }

    public boolean drawBackground() {
        return this.drawBackground;
    }

    public void setDrawBackground(boolean enabled) {
        this.drawBackground = enabled;
        this.write();
    }

    private int getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public float getBackgroundAlphaF() {
        return (float)this.getBackgroundAlpha() / 255.0f;
    }

    public void setBackgroundAlpha(int alpha) {
        this.backgroundAlpha = alpha;
        this.write();
    }

    private int getButtonAlpha() {
        return this.buttonAlpha;
    }

    public float getButtonAlphaF() {
        return (float)this.getButtonAlpha() / 255.0f;
    }

    public void setButtonAlpha(int alpha) {
        this.buttonAlpha = alpha;
        this.write();
    }
}

