/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.config;

import exopandora.worldhandler.config.Config;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

@OnlyIn(value=Dist.CLIENT)
public class ConfigCategorySliders {
    private double maxPotionAmplifier;
    private double maxItemEnchantment;
    private double maxItemAttributes;
    private double maxSummonPotionAmplifier;
    private double maxSummonPotionMinutes;
    private double maxSummonAttributes;
    private double maxExperience;
    private double maxPlayerPoints;
    private double maxTriggerValue;
    private final ForgeConfigSpec.DoubleValue valueMaxPotionAmplifier;
    private final ForgeConfigSpec.DoubleValue valueMaxItemEnchantment;
    private final ForgeConfigSpec.DoubleValue valueMaxItemAttributes;
    private final ForgeConfigSpec.DoubleValue valueMaxSummonPotionAmplifier;
    private final ForgeConfigSpec.DoubleValue valueMaxSummonPotionMinutes;
    private final ForgeConfigSpec.DoubleValue valueMaxSummonAttributes;
    private final ForgeConfigSpec.DoubleValue valueMaxExperience;
    private final ForgeConfigSpec.DoubleValue valueMaxPlayerPoints;
    private final ForgeConfigSpec.DoubleValue valueMaxTriggerValue;

    public ConfigCategorySliders(ForgeConfigSpec.Builder builder) {
        builder.push("sliders");
        this.valueMaxPotionAmplifier = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.sliders.max_potion_amplifier", (Object[])new Object[0])).translation("gui.worldhandler.config.key.sliders.max_potion_amplifier").defineInRange("max_potion_amplifier", 100.0, 0.0, 127.0);
        this.valueMaxItemEnchantment = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.sliders.max_item_enchantment", (Object[])new Object[0])).translation("gui.worldhandler.config.key.sliders.max_item_enchantment").defineInRange("max_item_enchantment", 100.0, 0.0, 2.147483647E9);
        this.valueMaxItemAttributes = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.sliders.max_item_attributes", (Object[])new Object[0])).translation("gui.worldhandler.config.key.sliders.max_item_attributes").defineInRange("max_item_attributes", 100.0, 0.0, Double.MAX_VALUE);
        this.valueMaxSummonPotionAmplifier = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.sliders.max_summon_potion_amplifier", (Object[])new Object[0])).translation("gui.worldhandler.config.key.sliders.max_summon_potion_amplifier").defineInRange("max_summon_potion_amplifier", 100.0, 0.0, 127.0);
        this.valueMaxSummonPotionMinutes = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.sliders.max_summon_potion_minutes", (Object[])new Object[0])).translation("gui.worldhandler.config.key.sliders.max_summon_potion_minutes").defineInRange("max_summon_potion_minutes", 100.0, 0.0, 16000.0);
        this.valueMaxSummonAttributes = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.sliders.max_summon_attributes", (Object[])new Object[0])).translation("gui.worldhandler.config.key.sliders.max_summon_attributes").defineInRange("max_summon_attributes", 100.0, 0.0, Double.MAX_VALUE);
        this.valueMaxExperience = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.sliders.max_experience", (Object[])new Object[0])).translation("gui.worldhandler.config.key.sliders.max_experience").defineInRange("max_experience", 100.0, 0.0, 100000.0);
        this.valueMaxPlayerPoints = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.sliders.max_player_points", (Object[])new Object[0])).translation("gui.worldhandler.config.key.sliders.max_player_points").defineInRange("max_player_points", 100.0, 0.0, 100000.0);
        this.valueMaxTriggerValue = builder.comment(I18n.func_135052_a((String)"gui.worldhandler.config.comment.sliders.max_trigger_value", (Object[])new Object[0])).translation("gui.worldhandler.config.key.sliders.max_trigger_value").defineInRange("max_trigger_value", 100.0, 0.0, 100000.0);
        builder.pop();
    }

    public void read() {
        this.maxPotionAmplifier = (Double)this.valueMaxPotionAmplifier.get();
        this.maxItemEnchantment = (Double)this.valueMaxItemEnchantment.get();
        this.maxItemAttributes = (Double)this.valueMaxItemAttributes.get();
        this.maxSummonPotionAmplifier = (Double)this.valueMaxSummonPotionAmplifier.get();
        this.maxSummonPotionMinutes = (Double)this.valueMaxSummonPotionMinutes.get();
        this.maxSummonAttributes = (Double)this.valueMaxSummonAttributes.get();
        this.maxExperience = (Double)this.valueMaxExperience.get();
        this.maxPlayerPoints = (Double)this.valueMaxPlayerPoints.get();
        this.maxTriggerValue = (Double)this.valueMaxTriggerValue.get();
    }

    private void write() {
        Config.set(this.valueMaxPotionAmplifier, this.maxPotionAmplifier);
        Config.set(this.valueMaxItemEnchantment, this.maxItemEnchantment);
        Config.set(this.valueMaxItemAttributes, this.maxItemAttributes);
        Config.set(this.valueMaxSummonPotionAmplifier, this.maxSummonPotionAmplifier);
        Config.set(this.valueMaxSummonPotionMinutes, this.maxSummonPotionMinutes);
        Config.set(this.valueMaxSummonAttributes, this.maxSummonAttributes);
        Config.set(this.valueMaxExperience, this.maxExperience);
        Config.set(this.valueMaxPlayerPoints, this.maxPlayerPoints);
        Config.set(this.valueMaxTriggerValue, this.maxTriggerValue);
    }

    public double getMaxPotionAmplifier() {
        return this.maxPotionAmplifier;
    }

    public void setMaxPotionAmplifier(double max) {
        this.maxPotionAmplifier = max;
        this.write();
    }

    public double getMaxItemEnchantment() {
        return this.maxItemEnchantment;
    }

    public void setMaxItemEnchantment(double max) {
        this.maxItemEnchantment = max;
        this.write();
    }

    public double getMaxItemAttributes() {
        return this.maxItemAttributes;
    }

    public void setMaxItemAttributes(double max) {
        this.maxItemAttributes = max;
        this.write();
    }

    public double getMaxSummonPotionAmplifier() {
        return this.maxSummonPotionAmplifier;
    }

    public void setMaxSummonPotionAmplifier(double max) {
        this.maxSummonPotionAmplifier = max;
        this.write();
    }

    public double getMaxSummonPotionMinutes() {
        return this.maxSummonPotionMinutes;
    }

    public void setMaxSummonPotionMinutes(double max) {
        this.maxSummonPotionMinutes = max;
        this.write();
    }

    public double getMaxSummonAttributes() {
        return this.maxSummonAttributes;
    }

    public void setMaxSummonAttributes(double max) {
        this.maxSummonAttributes = max;
        this.write();
    }

    public double getMaxExperience() {
        return this.maxExperience;
    }

    public void setMaxExperience(double max) {
        this.maxExperience = max;
        this.write();
    }

    public double getMaxPlayerPoints() {
        return this.maxPlayerPoints;
    }

    public void setMaxPlayerPoints(double max) {
        this.maxPlayerPoints = max;
        this.write();
    }

    public double getMaxTriggerValue() {
        return this.maxTriggerValue;
    }

    public void setMaxTriggerValue(double max) {
        this.maxTriggerValue = max;
        this.write();
    }
}

