/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.format;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextFormatting {
    public static String shortenString(String str, int maxWidth, FontRenderer fontRenderer) {
        return TextFormatting.shortenString(str, "", maxWidth, fontRenderer);
    }

    public static String shortenString(String str, String prefix, int maxWidth, FontRenderer fontRenderer) {
        String display = prefix;
        if (fontRenderer.func_78256_a(prefix + str) > maxWidth - fontRenderer.func_78256_a(prefix)) {
            for (int x = 0; x < str.length(); ++x) {
                if (fontRenderer.func_78256_a(display + str.charAt(x) + "...") >= maxWidth) {
                    display = display + "...";
                    break;
                }
                display = display + str.charAt(x);
            }
        } else {
            display = display + str;
        }
        return display;
    }

    public static String getTotalTimePlayed(long tick) {
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        seconds = (int)(tick / 20L);
        if (seconds > 60) {
            int min = MathHelper.func_76141_d((float)(seconds / 60));
            seconds %= 60;
            minutes = min;
        }
        if (minutes > 60) {
            int hrs = MathHelper.func_76141_d((float)(minutes / 60));
            minutes %= 60;
            hours = hrs;
        }
        if (hours > 24) {
            int day = MathHelper.func_76141_d((float)(hours / 24));
            hours %= 24;
            days = day;
        }
        return String.format("%d:%02d:%02d:%02d", days, hours, minutes, seconds);
    }

    public static int getHour(long tick) {
        int hour = MathHelper.func_76141_d((float)((float)(tick + 6000L) / 1000.0f)) % 24;
        return hour;
    }

    public static int getMinute(long tick) {
        int hour = MathHelper.func_76141_d((float)(((float)tick + 6000.0f) / 1000.0f));
        int minute = MathHelper.func_76141_d((float)(((float)tick + 6000.0f - (float)(hour * 1000)) * 6.0f / 100.0f));
        return minute;
    }

    public static String formatWorldTime(long tick) {
        int hour = TextFormatting.getHour(tick);
        int minute = TextFormatting.getMinute(tick);
        return String.format("%02d:%02d", hour, minute);
    }
}

