/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.button;

import com.mojang.realmsclient.gui.ChatFormatting;
import exopandora.worldhandler.format.TextFormatting;
import exopandora.worldhandler.gui.button.GuiButtonTooltip;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.logic.ILogicMapped;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiButtonList<T>
extends GuiButtonTooltip {
    private final ILogicMapped<T> logic;
    private final Persistence persistence;
    private final List<T> items;

    public GuiButtonList(int x, int y, List<T> items, int widthIn, int heightIn, Container container, ILogicMapped<T> logic) {
        this(0, x, y, items, widthIn, heightIn, container, logic);
    }

    public GuiButtonList(int id, int x, int y, List<T> items, int widthIn, int heightIn, Container container, ILogicMapped<T> logic) {
        super(id, x, y, widthIn, heightIn, null, null, null);
        this.items = items;
        this.logic = logic;
        this.persistence = container.getContent().getPersistence(this.logic.getId(), Persistence::new);
    }

    @Override
    public void func_194828_a(int mouseX, int mouseY, float partialTicks) {
        if (this.field_146125_m) {
            this.drawBackground(mouseX, mouseY);
            String displayString = this.logic.translate(this.items.get(this.persistence.getIndex()));
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            if (displayString != null && !displayString.isEmpty()) {
                String leftArrow = this.isHoveringLeft(mouseX, mouseY) ? ChatFormatting.BOLD + "<" + ChatFormatting.RESET : "<";
                String rightArrow = this.isHoveringRight(mouseX, mouseY) ? ChatFormatting.BOLD + ">" + ChatFormatting.RESET : ">";
                int maxWidth = Math.max(0, this.field_146120_f - fontRenderer.func_78256_a("<   >"));
                int spaceWidth = fontRenderer.func_78256_a(" ");
                String display = TextFormatting.shortenString(displayString, maxWidth, fontRenderer);
                int yPos = this.field_146129_i + (this.field_146121_g - 8) / 2;
                this.func_73732_a(fontRenderer, display, this.field_146128_h + this.field_146120_f / 2, yPos, this.getTextColor());
                this.func_73732_a(fontRenderer, leftArrow, this.field_146128_h + this.field_146120_f / 2 - maxWidth / 2 - spaceWidth, yPos, this.getTextColor());
                this.func_73732_a(fontRenderer, rightArrow, this.field_146128_h + this.field_146120_f / 2 + maxWidth / 2 + spaceWidth, yPos, this.getTextColor());
            }
        }
    }

    @Override
    public void renderTooltip(int mouseX, int mouseY) {
        this.tooltip = this.logic.formatTooltip(this.items.get(this.persistence.getIndex()), this.persistence.getIndex() + 1, this.items.size());
        super.renderTooltip(mouseX, mouseY);
    }

    @Override
    public void func_194829_a(double mouseX, double mouseY) {
        int max = this.items.size() - 1;
        int index = this.persistence.getIndex();
        if (this.isHoveringLeft(mouseX, mouseY)) {
            if (GuiScreen.func_146272_n()) {
                if (index < 10) {
                    this.persistence.setIndex(max - (9 - index));
                } else {
                    this.persistence.decrementIndex(10);
                }
            } else if (index > 0) {
                this.persistence.decrementIndex();
            } else {
                this.persistence.setIndex(max);
            }
        } else if (this.isHoveringRight(mouseX, mouseY)) {
            if (GuiScreen.func_146272_n()) {
                if (index > max - 10) {
                    this.persistence.setIndex(9 - (max - index));
                } else {
                    this.persistence.incrementIndex(10);
                }
            } else if (index < max) {
                this.persistence.incrementIndex();
            } else {
                this.persistence.setIndex(0);
            }
        }
        this.logic.onClick(this.items.get(this.persistence.getIndex()));
    }

    private boolean isHoveringLeft(double mouseX, double mouseY) {
        return this.isHoveringVertical(mouseY) && mouseX >= (double)this.field_146128_h && mouseX < (double)this.field_146128_h + Math.ceil(this.field_146120_f / 2);
    }

    private boolean isHoveringRight(double mouseX, double mouseY) {
        return this.isHoveringVertical(mouseY) && mouseX >= (double)this.field_146128_h + Math.ceil(this.field_146120_f / 2) && mouseX < (double)(this.field_146128_h + this.field_146120_f);
    }

    private boolean isHoveringVertical(double mouseY) {
        return mouseY >= (double)this.field_146129_i && mouseY < (double)(this.field_146129_i + this.field_146121_g);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Persistence {
        private int index;

        public Persistence() {
            this(0);
        }

        public Persistence(int index) {
            this.index = index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public void incrementIndex() {
            ++this.index;
        }

        public void incrementIndex(int amount) {
            this.index += amount;
        }

        public void decrementIndex() {
            --this.index;
        }

        public void decrementIndex(int amount) {
            this.index -= amount;
        }
    }
}

