/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.button;

import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.util.ActionHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiButtonPiano
extends GuiButtonBase {
    private static final ResourceLocation NOTE = new ResourceLocation("worldhandler", "textures/misc/note.png");
    private final Type type;
    private final SoundEvent sound;
    private final float pitch;

    public GuiButtonPiano(int x, int y, int widthIn, int heightIn, String buttonText, SoundEvent sound, float pitch, Type type, ActionHandler actionHandler) {
        this(0, x, y, widthIn, heightIn, buttonText, sound, pitch, type, actionHandler);
    }

    public GuiButtonPiano(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, SoundEvent sound, float pitch, Type type, ActionHandler actionHandler) {
        super(buttonId, x, y, widthIn, heightIn, buttonText, actionHandler);
        this.sound = sound;
        this.pitch = pitch;
        this.type = type;
    }

    @Override
    public void func_194828_a(int mouseX, int mouseY, float partialTicks) {
        if (this.field_146125_m) {
            switch (this.type) {
                case LEFT: {
                    this.field_146123_n = this.isHoveringLeft(mouseX, mouseY);
                    break;
                }
                case NORMAL: {
                    this.field_146123_n = this.isHoveringNormal(mouseX, mouseY);
                    break;
                }
                case RIGHT: {
                    this.field_146123_n = this.isHoveringRight(mouseX, mouseY);
                    break;
                }
                case BLACK: {
                    this.field_146123_n = this.isHoveringBlack(mouseX, mouseY);
                    break;
                }
            }
            int hoverstate = this.func_146114_a(this.field_146123_n);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)Config.getSkin().getButtonAlphaF());
            Minecraft.func_71410_x().func_110434_K().func_110577_a(NOTE);
            switch (this.type) {
                case LEFT: 
                case NORMAL: 
                case RIGHT: {
                    this.drawWhiteKey(hoverstate);
                    break;
                }
                case BLACK: {
                    this.drawBlackKey(hoverstate);
                    break;
                }
            }
        }
    }

    protected void drawWhiteKey(int hoverstate) {
        int textColor = this.getTextColor();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.func_73729_b(this.field_146128_h, this.field_146129_i, 25 + hoverstate * 15 - 15, 0, 15, 92);
        fontRenderer.func_211126_b(this.field_146126_j, (float)(this.field_146128_h + this.field_146120_f / 2 - fontRenderer.func_78256_a(this.field_146126_j) / 2), (float)(this.field_146129_i + (this.field_146121_g - 8) / 2 + 36), textColor);
    }

    protected void drawBlackKey(int hoverstate) {
        this.func_73729_b(this.field_146128_h, this.field_146129_i, 55 + hoverstate * -9 + 18, 0, 9, 58);
    }

    @Override
    protected int getTextColor() {
        int textColor = 0;
        if (!this.field_146124_l) {
            textColor = 0xA0A0A0;
        } else if (this.field_146123_n) {
            textColor = 0x8B8B8B;
        }
        return textColor;
    }

    public void func_146113_a(SoundHandler soundHandler) {
        soundHandler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)this.sound, (float)this.pitch));
    }

    private boolean isHoveringBlack(double mouseX, double mouseY) {
        return mouseX >= (double)this.field_146128_h && mouseY >= (double)this.field_146129_i && mouseX < (double)(this.field_146128_h + this.field_146120_f) && mouseY < (double)(this.field_146129_i + this.field_146121_g);
    }

    private boolean isHoveringLeft(double mouseX, double mouseY) {
        return mouseX >= (double)this.field_146128_h && mouseY >= (double)this.field_146129_i && mouseX < (double)(this.field_146128_h + 10) && mouseY < (double)(this.field_146129_i + 60) || mouseX >= (double)this.field_146128_h && mouseY >= (double)(this.field_146129_i + 58) && mouseX < (double)(this.field_146128_h + 14) && mouseY < (double)(this.field_146129_i + 93);
    }

    private boolean isHoveringNormal(double mouseX, double mouseY) {
        return mouseX >= (double)(this.field_146128_h + 4) && mouseY >= (double)this.field_146129_i && mouseX < (double)(this.field_146128_h + 10) && mouseY < (double)(this.field_146129_i + 60) || mouseX >= (double)this.field_146128_h && mouseY >= (double)(this.field_146129_i + 58) && mouseX < (double)(this.field_146128_h + 14) && mouseY < (double)(this.field_146129_i + 93);
    }

    private boolean isHoveringRight(double mouseX, double mouseY) {
        return mouseX >= (double)(this.field_146128_h + 4) && mouseY >= (double)this.field_146129_i && mouseX < (double)(this.field_146128_h + 14) && mouseY < (double)(this.field_146129_i + 60) || mouseX >= (double)this.field_146128_h && mouseY >= (double)(this.field_146129_i + 58) && mouseX < (double)(this.field_146128_h + 14) && mouseY < (double)(this.field_146129_i + 93);
    }

    protected boolean func_199400_c(double mouseX, double mouseY) {
        switch (this.type) {
            case LEFT: {
                return this.field_146124_l && this.field_146125_m && this.isHoveringLeft(mouseX, mouseY);
            }
            case NORMAL: {
                return this.field_146124_l && this.field_146125_m && this.isHoveringNormal(mouseX, mouseY);
            }
            case RIGHT: {
                return this.field_146124_l && this.field_146125_m && this.isHoveringRight(mouseX, mouseY);
            }
            case BLACK: {
                return this.field_146124_l && this.field_146125_m && this.isHoveringBlack(mouseX, mouseY);
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Type {
        LEFT,
        NORMAL,
        RIGHT,
        BLACK;

    }
}

