/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.button;

import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.format.TextFormatting;
import exopandora.worldhandler.gui.button.GuiButtonBase;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.logic.ILogic;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiSlider
extends GuiButtonBase {
    private final Persistence persistence;
    private final ILogicSlider logic;
    private final Container container;
    private boolean dragging;

    public GuiSlider(int x, int y, int widthIn, int heightIn, double min, double max, double start, Container container, ILogicSlider logic) {
        this(0, x, y, widthIn, heightIn, min, max, start, container, logic);
    }

    public GuiSlider(int id, int x, int y, int widthIn, int heightIn, double min, double max, double start, Container container, ILogicSlider logic) {
        super(id, x, y, widthIn, heightIn, null, null);
        this.logic = Objects.requireNonNull(logic);
        this.container = Objects.requireNonNull(container);
        this.persistence = this.container.getContent().getPersistence(this.logic.getId(), () -> new Persistence(min, max, min == max ? 0.0 : (start - min) / (max - min)));
        this.persistence.validate(min, max);
        this.logic.onChangeSliderValue(this.persistence.getValueInt());
        this.updateDisplayString();
    }

    protected void func_146119_b(Minecraft minecraft, int mouseX, int mouseY) {
        if (this.field_146125_m) {
            if (this.dragging) {
                this.persistence.setValue((float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8));
                this.updateSlider();
            }
            int xOffset = Config.getSkin().getTextureType().equals("resourcepack") ? 0 : -46;
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)Config.getSkin().getButtonRedF(), (float)Config.getSkin().getButtonGreenF(), (float)Config.getSkin().getButtonBlueF(), (float)Config.getSkin().getButtonAlphaF());
            this.func_73729_b(this.field_146128_h + (int)(this.persistence.getValue() * (double)(this.field_146120_f - 8)), this.field_146129_i, 0, 66 + xOffset, 4, 20);
            this.func_73729_b(this.field_146128_h + (int)(this.persistence.getValue() * (double)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66 + xOffset, 4, 20);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void func_194829_a(double mouseX, double mouseY) {
        this.persistence.setValue((mouseX - (double)(this.field_146128_h + 4)) / (double)(this.field_146120_f - 8));
        this.updateSlider();
        this.dragging = true;
    }

    public void func_194831_b(double mouseX, double mouseY) {
        super.func_194831_b(mouseX, mouseY);
        this.dragging = false;
    }

    protected int func_146114_a(boolean mouseOver) {
        return 0;
    }

    private void updateSlider() {
        if (this.persistence.getValue() < 0.0) {
            this.persistence.setValue(0.0);
        }
        if (this.persistence.getValue() > 1.0) {
            this.persistence.setValue(1.0);
        }
        this.updateDisplayString();
        this.logic.onChangeSliderValue(this.persistence.getValueInt());
    }

    private void updateDisplayString() {
        int value = this.persistence.getValueInt();
        String suffix = this.logic.formatValue(value) + this.logic.formatSuffix(value);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.field_146126_j = TextFormatting.shortenString(this.logic.formatPrefix(value), this.field_146120_f - fontRenderer.func_78256_a(suffix), fontRenderer) + suffix;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class Persistence {
        private double min;
        private double max;
        private double value;

        private Persistence(double min, double max) {
            this.min = min;
            this.max = max;
        }

        public Persistence(double min, double max, double value) {
            this(min, max);
            this.value = value;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public int getValueInt() {
            return (int)Math.round(this.min + (this.max - this.min) * this.value);
        }

        public void setValueInt(int value) {
            this.value = this.intToValue(value);
        }

        public void validate(double min, double max) {
            if (this.getMin() != min || this.getMax() != max) {
                this.min = min;
                this.max = max;
            }
        }

        private double intToValue(int value) {
            if (this.min == this.max) {
                return 0.0;
            }
            return ((double)value - this.min) / (this.max - this.min);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface ILogicSlider
    extends ILogic {
        public String formatPrefix(int var1);

        public String formatSuffix(int var1);

        public String formatValue(int var1);

        public void onChangeSliderValue(int var1);
    }
}

