/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.category;

import com.google.common.collect.Lists;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.registry.RegistryNamespacedDefaultedByKey;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistryEntry;

@OnlyIn(value=Dist.CLIENT)
public class Category
extends ForgeRegistryEntry<Category> {
    public static final String NAMESPACE = String.join((CharSequence)"_", "worldhandler", "category");
    public static final IRegistry<Category> REGISTRY = IRegistry.func_212610_a((String)NAMESPACE, (IRegistry)new RegistryNamespacedDefaultedByKey(new ResourceLocation(NAMESPACE, "main")));
    private final List<Content> contents;

    public Category() {
        this.contents = new ArrayList<Content>();
    }

    public Category(List<Content> contents) {
        this.contents = contents;
    }

    public Category(Content ... contents) {
        this.contents = Lists.newArrayList((Object[])contents);
    }

    public Category add(Content content) {
        this.contents.add(content);
        return this;
    }

    public List<Content> getContents() {
        return this.contents;
    }

    public int getSize() {
        return this.contents.size();
    }

    @Nullable
    public Content getContent(int index) {
        return this.contents.get(index);
    }

    public static void registerCategories() {
        Category.registerCategory(0, "main", new Category(Contents.MAIN, Contents.CONTAINERS, Contents.MULTIPLAYER));
        Category.registerCategory(1, "entities", new Category(Contents.SUMMON));
        Category.registerCategory(2, "items", new Category(Contents.CUSTOM_ITEM, Contents.ENCHANTMENT, Contents.RECIPES));
        Category.registerCategory(3, "blocks", new Category(Contents.EDIT_BLOCKS, Contents.SIGN_EDITOR, Contents.NOTE_EDITOR));
        Category.registerCategory(4, "world", new Category(Contents.WORLD_INFO, Contents.GAMERULES));
        Category.registerCategory(5, "player", new Category(Contents.PLAYER, Contents.EXPERIENCE, Contents.ADVANCEMENTS));
        Category.registerCategory(6, "scoreboard", new Category(Contents.SCOREBOARD_OBJECTIVES, Contents.SCOREBOARD_TEAMS, Contents.SCOREBOARD_PLAYERS));
    }

    private static void registerCategory(int id, String textualID, Category category) {
        Category.registerCategory(id, new ResourceLocation("worldhandler", textualID), category);
    }

    private static void registerCategory(int id, ResourceLocation textualID, Category category) {
        REGISTRY.func_177775_a(id, textualID, (Object)category);
    }
}

